/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.swing.laf.flatlaf.ui.Utils;

public class FlatToolbarDragger
extends JPanel {
    private static final int DOT_COUNT = 4;
    private static final int DOT_SIZE = 2;
    private static final int GRIP_WIDTH = 6;
    private final Dimension min;
    private final Dimension max;
    protected final Color gripColor = UIManager.getColor("ToolBar.gripColor");

    public FlatToolbarDragger() {
        this.min = new Dimension(6, 6);
        this.max = new Dimension(6, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            int dotSize;
            Utils.setRenderingHints(g2);
            g2.setColor(this.gripColor);
            int gapSize = dotSize = UIScale.scale((int)2);
            int gripSize = dotSize * 4 + gapSize * 3;
            int y = Math.round((float)(this.getHeight() - gripSize) / 2.0f);
            for (int i = 0; i < 4; ++i) {
                g2.fillOval(dotSize, y, dotSize, dotSize);
                y += dotSize + gapSize;
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return UIScale.scale((Dimension)this.min);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return UIScale.scale((Dimension)this.max);
    }
}

