/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPdbConversionHistoryEntryRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String pdbConversionHistoryEntryId;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getPdbConversionHistoryEntryId() {
        return this.pdbConversionHistoryEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).pdbConversionHistoryEntryId(this.pdbConversionHistoryEntryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",pdbConversionHistoryEntryId=").append(String.valueOf(this.pdbConversionHistoryEntryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPdbConversionHistoryEntryRequest)) {
            return false;
        }
        GetPdbConversionHistoryEntryRequest other = (GetPdbConversionHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.pdbConversionHistoryEntryId, other.pdbConversionHistoryEntryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.pdbConversionHistoryEntryId == null ? 43 : this.pdbConversionHistoryEntryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPdbConversionHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String pdbConversionHistoryEntryId = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder pdbConversionHistoryEntryId(String pdbConversionHistoryEntryId) {
            this.pdbConversionHistoryEntryId = pdbConversionHistoryEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPdbConversionHistoryEntryRequest o) {
            this.databaseId(o.getDatabaseId());
            this.pdbConversionHistoryEntryId(o.getPdbConversionHistoryEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPdbConversionHistoryEntryRequest build() {
            GetPdbConversionHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPdbConversionHistoryEntryRequest buildWithoutInvocationCallback() {
            GetPdbConversionHistoryEntryRequest request = new GetPdbConversionHistoryEntryRequest();
            request.databaseId = this.databaseId;
            request.pdbConversionHistoryEntryId = this.pdbConversionHistoryEntryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

