/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.osgi.impl.bundle.obr.resource.StringSet;

public class FilterImpl {
    final char WILDCARD = (char)65535;
    final int EQ = 0;
    final int LE = 1;
    final int GE = 2;
    final int APPROX = 3;
    final int LESS = 4;
    final int GREATER = 5;
    final int SUBSET = 6;
    final int SUPERSET = 7;
    private String filter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public FilterImpl(String filter) throws IllegalArgumentException {
        this.filter = filter;
        if (filter == null || filter.length() == 0) {
            throw new IllegalArgumentException("Null query");
        }
    }

    public boolean match(Map dict) {
        try {
            return new DictQuery(dict).match();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof FilterImpl && this.filter.equals(((FilterImpl)obj).filter);
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    boolean compareString(String s1, int op, String s2) {
        switch (op) {
            case 0: {
                return this.patSubstr(s1, s2);
            }
            case 3: {
                return this.patSubstr(this.fixupString(s1), this.fixupString(s2));
            }
        }
        return this.compareSign(op, s2.compareTo(s1));
    }

    boolean compareSign(int op, int cmp) {
        switch (op) {
            case 1: {
                return cmp >= 0;
            }
            case 2: {
                return cmp <= 0;
            }
            case 0: {
                return cmp == 0;
            }
        }
        return cmp == 0;
    }

    String fixupString(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        boolean isStart = true;
        boolean isWhite = false;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                isWhite = true;
            } else {
                if (!isStart && isWhite) {
                    sb.append(' ');
                }
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                }
                sb.append(c);
                isStart = false;
                isWhite = false;
            }
            ++i;
        }
        return sb.toString();
    }

    boolean patSubstr(String s, String pat) {
        if (s == null) {
            return false;
        }
        if (pat.length() == 0) {
            return s.length() == 0;
        }
        if (pat.charAt(0) == '\uffff') {
            pat = pat.substring(1);
            while (true) {
                if (this.patSubstr(s, pat)) {
                    return true;
                }
                if (s.length() == 0) {
                    return false;
                }
                s = s.substring(1);
            }
        }
        if (s.length() == 0 || s.charAt(0) != pat.charAt(0)) {
            return false;
        }
        return this.patSubstr(s.substring(1), pat.substring(1));
    }

    class DictQuery
    extends Query {
        private Map dict;

        DictQuery(Map dict) {
            this.dict = dict;
        }

        Object getProp(String key) {
            return this.dict.get(key);
        }
    }

    abstract class Query {
        static final String GARBAGE = "Trailing garbage";
        static final String MALFORMED = "Malformed query";
        static final String EMPTY = "Empty list";
        static final String SUBEXPR = "No subexpression";
        static final String OPERATOR = "Undefined operator";
        static final String TRUNCATED = "Truncated expression";
        static final String EQUALITY = "Only equality supported";
        private String tail;

        Query() {
        }

        boolean match() throws IllegalArgumentException {
            this.tail = FilterImpl.this.filter;
            boolean val = this.doQuery();
            if (this.tail.length() > 0) {
                this.error(GARBAGE);
            }
            return val;
        }

        private boolean doQuery() throws IllegalArgumentException {
            boolean val;
            if (this.tail.length() < 3 || !this.prefix("(")) {
                this.error(MALFORMED);
            }
            switch (this.tail.charAt(0)) {
                case '&': {
                    val = this.doAnd();
                    break;
                }
                case '|': {
                    val = this.doOr();
                    break;
                }
                case '!': {
                    val = this.doNot();
                    break;
                }
                default: {
                    val = this.doSimple();
                }
            }
            if (!this.prefix(")")) {
                this.error(MALFORMED);
            }
            return val;
        }

        private boolean doAnd() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            boolean val = true;
            if (!this.tail.startsWith("(")) {
                this.error(EMPTY);
            }
            do {
                if (this.doQuery()) continue;
                val = false;
            } while (this.tail.startsWith("("));
            return val;
        }

        private boolean doOr() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            boolean val = false;
            if (!this.tail.startsWith("(")) {
                this.error(EMPTY);
            }
            do {
                if (!this.doQuery()) continue;
                val = true;
            } while (this.tail.startsWith("("));
            return val;
        }

        private boolean doNot() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            if (!this.tail.startsWith("(")) {
                this.error(SUBEXPR);
            }
            return !this.doQuery();
        }

        private boolean doSimple() throws IllegalArgumentException {
            int op = 0;
            Object attr = this.getAttr();
            if (this.prefix("=")) {
                op = 0;
            } else if (this.prefix("<=")) {
                op = 1;
            } else if (this.prefix(">=")) {
                op = 2;
            } else if (this.prefix("~=")) {
                op = 3;
            } else if (this.prefix("*>")) {
                op = 7;
            } else if (this.prefix("<*")) {
                op = 6;
            } else if (this.prefix("<")) {
                op = 4;
            } else if (this.prefix(">")) {
                op = 5;
            } else {
                this.error(OPERATOR);
            }
            return this.compare(attr, op, this.getValue());
        }

        private boolean prefix(String pre) {
            if (!this.tail.startsWith(pre)) {
                return false;
            }
            this.tail = this.tail.substring(pre.length());
            return true;
        }

        private Object getAttr() {
            int len = this.tail.length();
            int ix = 0;
            block3: while (ix < len) {
                switch (this.tail.charAt(ix)) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': 
                    case '{': 
                    case '}': 
                    case '~': {
                        break block3;
                    }
                    default: {
                        ++ix;
                    }
                }
            }
            String attr = this.tail.substring(0, ix).toLowerCase();
            this.tail = this.tail.substring(ix);
            return this.getProp(attr);
        }

        abstract Object getProp(String var1);

        private String getValue() {
            StringBuffer sb = new StringBuffer();
            int len = this.tail.length();
            int ix = 0;
            block5: while (ix < len) {
                char c = this.tail.charAt(ix);
                switch (c) {
                    case '(': 
                    case ')': {
                        break block5;
                    }
                    case '*': {
                        sb.append('\uffff');
                        break;
                    }
                    case '\\': {
                        if (ix == len - 1) break block5;
                        sb.append(this.tail.charAt(++ix));
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++ix;
            }
            this.tail = this.tail.substring(ix);
            return sb.toString();
        }

        private void error(String m) throws IllegalArgumentException {
            throw new IllegalArgumentException(String.valueOf(m) + " " + this.tail);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean compare(Object obj, int op, String s) {
            if (obj == null) {
                if (op == 6) {
                    return true;
                }
                if (op != 7) return false;
                if (s.trim().length() != 0) return false;
                return true;
            }
            try {
                Class<?> numClass = obj.getClass();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if (numClass == clazz) {
                    return FilterImpl.this.compareString((String)obj, op, s);
                }
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz3 = class$1 = clazz4;
                }
                if (numClass == clazz3) {
                    return FilterImpl.this.compareString(obj.toString(), op, s);
                }
                Class<?> clazz5 = class$2;
                if (clazz5 == null) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz5 = class$2 = clazz6;
                }
                if (numClass == clazz5) {
                    return FilterImpl.this.compareSign(op, Long.valueOf(s).compareTo((Long)obj));
                }
                Class<?> clazz7 = class$3;
                if (clazz7 == null) {
                    Class<?> clazz8;
                    try {
                        clazz8 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz7 = class$3 = clazz8;
                }
                if (numClass == clazz7) {
                    return FilterImpl.this.compareSign(op, Integer.valueOf(s).compareTo((Integer)obj));
                }
                Class<?> clazz9 = class$4;
                if (clazz9 == null) {
                    Class<?> clazz10;
                    try {
                        clazz10 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz9 = class$4 = clazz10;
                }
                if (numClass == clazz9) {
                    return FilterImpl.this.compareSign(op, Short.valueOf(s).compareTo((Short)obj));
                }
                Class<?> clazz11 = class$5;
                if (clazz11 == null) {
                    Class<?> clazz12;
                    try {
                        clazz12 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz11 = class$5 = clazz12;
                }
                if (numClass == clazz11) {
                    return FilterImpl.this.compareSign(op, Byte.valueOf(s).compareTo((Byte)obj));
                }
                Class<?> clazz13 = class$6;
                if (clazz13 == null) {
                    Class<?> clazz14;
                    try {
                        clazz14 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz13 = class$6 = clazz14;
                }
                if (numClass == clazz13) {
                    return FilterImpl.this.compareSign(op, Double.valueOf(s).compareTo((Double)obj));
                }
                Class<?> clazz15 = class$7;
                if (clazz15 == null) {
                    Class<?> clazz16;
                    try {
                        clazz16 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz15 = class$7 = clazz16;
                }
                if (numClass == clazz15) {
                    return FilterImpl.this.compareSign(op, Float.valueOf(s).compareTo((Float)obj));
                }
                Class<?> clazz17 = class$8;
                if (clazz17 == null) {
                    Class<?> clazz18;
                    try {
                        clazz18 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz17 = class$8 = clazz18;
                }
                if (numClass == clazz17) {
                    if (op != 0) {
                        return false;
                    }
                    int a = Boolean.valueOf(s) != false ? 1 : 0;
                    int b = (Boolean)obj != false ? 1 : 0;
                    return FilterImpl.this.compareSign(op, a - b);
                }
                Class<?> clazz19 = class$9;
                if (clazz19 == null) {
                    Class<?> clazz20;
                    try {
                        clazz20 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz19 = class$9 = clazz20;
                }
                if (numClass == clazz19) {
                    return FilterImpl.this.compareSign(op, new BigInteger(s).compareTo((BigInteger)obj));
                }
                if (obj instanceof Collection) {
                    Object element;
                    if (op == 6 || op == 7) {
                        StringSet set = new StringSet(s);
                        if (op != 6) return ((Collection)obj).containsAll(set);
                        return set.containsAll((Collection)obj);
                    }
                    Iterator i = ((Collection)obj).iterator();
                    do {
                        if (i.hasNext()) continue;
                        return false;
                    } while (!this.compare(element = i.next(), op, s));
                    return true;
                }
                if (numClass.isArray()) {
                    int len = Array.getLength(obj);
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            return false;
                        }
                        if (this.compare(Array.get(obj, i), op, s)) {
                            return true;
                        }
                        ++i;
                    }
                }
                try {
                    if (op == 7 || op == 6) {
                        StringSet set = new StringSet(s);
                        if (op == 7) {
                            return set.contains(obj);
                        }
                        if (set.size() == 0) return true;
                        if (set.size() != 1) return false;
                        if (set.iterator().next().equals(obj)) return true;
                        return false;
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz21 = class$0;
                    if (clazz21 == null) {
                        Class<?> clazz22;
                        try {
                            clazz22 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz21 = class$0 = clazz22;
                    }
                    classArray[0] = clazz21;
                    Constructor<?> constructor = numClass.getConstructor(classArray);
                    Object instance = constructor.newInstance(s);
                    switch (op) {
                        case 0: {
                            return obj.equals(instance);
                        }
                        case 4: {
                            if (((Comparable)obj).compareTo(instance) >= 0) return false;
                            return true;
                        }
                        case 5: {
                            if (((Comparable)obj).compareTo(instance) <= 0) return false;
                            return true;
                        }
                        case 1: {
                            if (((Comparable)obj).compareTo(instance) > 0) return false;
                            return true;
                        }
                        case 2: {
                            if (((Comparable)obj).compareTo(instance) < 0) return false;
                            return true;
                        }
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

