/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.awt.Image;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.spi.ProjectIconProvider;
import org.openide.util.ImageUtilities;

public class DefaultProjectIconProvider
implements ProjectIconProvider {
    private static final String GRADLE_ICON = "org/netbeans/modules/gradle/resources/gradle.png";
    private static final String GRADLE_JAVASE_ICON = "org/netbeans/modules/gradle/resources/javaseProjectIcon.png";
    private static final String GRADLE_WEB_ICON = "org/netbeans/modules/gradle/resources/webProjectIcon.png";
    private static final String APPLICATION_BADGE = "org/netbeans/modules/gradle/resources/application-badge.png";
    final Project project;

    public DefaultProjectIconProvider(Project project) {
        this.project = project;
    }

    @Override
    public Image getIcon() {
        Set<String> plugins = GradleBaseProject.get(this.project).getPlugins();
        String iconResource = plugins.contains("java") ? GRADLE_JAVASE_ICON : GRADLE_ICON;
        iconResource = plugins.contains("war") ? GRADLE_WEB_ICON : iconResource;
        Image ret = ImageUtilities.loadImage((String)iconResource);
        if (plugins.contains("application")) {
            Image badge = ImageUtilities.loadImage((String)APPLICATION_BADGE);
            ret = ImageUtilities.mergeImages((Image)ret, (Image)badge, (int)8, (int)8);
        }
        return ret;
    }

    @Override
    public boolean isGradleBadgeRequested() {
        return false;
    }
}

