/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.GradleProjectCache;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;

public class GradleAuxiliaryPropertiesImpl
implements AuxiliaryProperties {
    private static final String PROP_PREFIX = "nb-config.";
    final NbGradleProjectImpl project;

    public GradleAuxiliaryPropertiesImpl(NbGradleProjectImpl project) {
        this.project = project;
    }

    public String get(final String key, final boolean shared) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                return GradleAuxiliaryPropertiesImpl.this.getProperties(shared).get((Object)(GradleAuxiliaryPropertiesImpl.PROP_PREFIX + key));
            }
        });
    }

    public void put(String key, String value, boolean shared) {
        ProjectManager.mutex().writeAccess(() -> {
            EditableProperties props = this.getProperties(shared);
            if (value != null) {
                props.put(PROP_PREFIX + key, value);
            } else {
                props.remove((Object)(PROP_PREFIX + key));
            }
            this.putProperties(props, shared);
        });
    }

    public Iterable<String> listKeys(boolean shared) {
        LinkedList<String> ret = new LinkedList<String>();
        EditableProperties props = this.getProperties(shared);
        for (String key : props.keySet()) {
            if (!key.startsWith(PROP_PREFIX)) continue;
            ret.add(key.substring(PROP_PREFIX.length()));
        }
        return ret;
    }

    private EditableProperties getProperties(boolean shared) {
        EditableProperties ret = new EditableProperties(false);
        File input = this.getPropFile(shared);
        if (input.canRead()) {
            try (FileInputStream is = new FileInputStream(input);){
                ret.load((InputStream)is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    private void putProperties(EditableProperties props, boolean shared) {
        File output = this.getPropFile(shared);
        if (!props.isEmpty()) {
            if (!output.exists()) {
                output.getParentFile().mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(output);){
                props.store((OutputStream)os);
            }
            catch (IOException iOException) {}
        } else if (output.exists()) {
            output.delete();
        }
    }

    private File getPropFile(boolean shared) {
        GradleFiles gf = this.project.getGradleFiles();
        return new File(shared ? gf.getProjectDir() : GradleProjectCache.getCacheDir(gf), "gradle.properties");
    }
}

