/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCSetupDataSourceTab3b.h"

MYODBCSetupDataSourceTab3b::MYODBCSetupDataSourceTab3b( QWidget *pwidgetParent )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab3b" )
{
    QVBoxLayout *playoutFields = new QVBoxLayout( this );
    playoutFields->setMargin( 20 );
    playoutFields->setSpacing( 5 );

    playoutFields->addStretch( 10 );

    pcheckboxDontPromptOnConnect = new MYODBCSetupCheckBox( "Don't Prompt Upon Connect", this );
    QToolTip::add( pcheckboxDontPromptOnConnect, "Don't prompt for questions even if driver would like to prompt." );
    pcheckboxDontPromptOnConnect->setAssistText( "Don't prompt for questions even if driver would like to prompt." );
    playoutFields->addWidget( pcheckboxDontPromptOnConnect );

    pcheckboxEnableDynamicCursor = new MYODBCSetupCheckBox( "Enable Dynamic Cursor", this );
    QToolTip::add( pcheckboxEnableDynamicCursor, "Enable or disable the dynamic cursor support. (Not allowed in MyODBC 2.50.)" );
    pcheckboxEnableDynamicCursor->setAssistText( "Enable or disable the dynamic cursor support. (Not allowed in MyODBC 2.50.)" );
    playoutFields->addWidget( pcheckboxEnableDynamicCursor );

    pcheckboxIgnorePoundInTable = new MYODBCSetupCheckBox( "Ignore # In Table Name", this );
    QToolTip::add( pcheckboxIgnorePoundInTable, "Ignore use of database name in db_name.tbl_name.col_name." );
    pcheckboxIgnorePoundInTable->setAssistText( "Ignore use of database name in db_name.tbl_name.col_name." );
    playoutFields->addWidget( pcheckboxIgnorePoundInTable );

    pcheckboxUseManagerCursors = new MYODBCSetupCheckBox( "User Manager Cursors", this );
    QToolTip::add( pcheckboxUseManagerCursors, "Force use of ODBC manager cursors (experimental)." );
    pcheckboxUseManagerCursors->setAssistText( "Force use of ODBC manager cursors (experimental)." );
    playoutFields->addWidget( pcheckboxUseManagerCursors );

    pcheckboxDontUseSetLocale = new MYODBCSetupCheckBox( "Don't Use Set Locale", this );
    QToolTip::add( pcheckboxDontUseSetLocale, "Disable the use of extended fetch (experimental)." );
    pcheckboxDontUseSetLocale->setAssistText( "Disable the use of extended fetch (experimental)." );
    playoutFields->addWidget( pcheckboxDontUseSetLocale );

    pcheckboxPadCharToFullLen = new MYODBCSetupCheckBox( "Pad Char To Full Length", this );
    QToolTip::add( pcheckboxPadCharToFullLen, "Pad CHAR columns to full column length." );
    pcheckboxPadCharToFullLen->setAssistText( "Pad CHAR columns to full column length." );
    playoutFields->addWidget( pcheckboxPadCharToFullLen );

    pcheckboxDontCacheResults = new MYODBCSetupCheckBox( "Don't Cache Result (forward only cursors)", this );
    QToolTip::add( pcheckboxDontCacheResults, "Do not cache the results locally in the driver, instead read from server (mysql_use_result()). This works only for forward-only cursors. This option is very important in dealing with large tables when you don't want the driver to cache the entire result set." );
    pcheckboxDontCacheResults->setAssistText( "Do not cache the results locally in the driver, instead read from server (mysql_use_result()). This works only for forward-only cursors. This option is very important in dealing with large tables when you don't want the driver to cache the entire result set." );
    playoutFields->addWidget( pcheckboxDontCacheResults );

    playoutFields->addStretch( 10 );
}


