/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCSetupDataSourceTab1.h"

MYODBCSetupDataSourceTab1::MYODBCSetupDataSourceTab1( QWidget *pwidgetParent,
                                                      QString stringDataSourceName,
                                                      QString stringDescription,
                                                      QString stringServer,
                                                      QString stringUser,
                                                      QString stringPassword,
                                                      QString stringDatabase )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab1" )
{
    doInit();
    plineeditDataSourceName->setText( stringDataSourceName );
    plineeditDescription->setText( stringDescription );
    plineeditServer->setText( stringServer );
    plineeditUser->setText( stringUser );
    plineeditPassword->setText( stringPassword );
    pcomboboxDatabase->lineEdit()->setText( stringDatabase );
}

MYODBCSetupDataSourceTab1::MYODBCSetupDataSourceTab1( QWidget *pwidgetParent )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab1" )
{
    doInit();
}

void MYODBCSetupDataSourceTab1::setDataSourceName( const QString &stringDataSourceName )
{
    plineeditDataSourceName->setText( stringDataSourceName );
}

void MYODBCSetupDataSourceTab1::setDescription( const QString &stringDescription )
{
    plineeditDescription->setText( stringDescription );
}

void MYODBCSetupDataSourceTab1::setServer( const QString &stringServer )
{
    plineeditServer->setText( stringServer );
}

void MYODBCSetupDataSourceTab1::setUser( const QString &stringUser )
{
    plineeditUser->setText( stringUser );
}

void MYODBCSetupDataSourceTab1::setPassword( const QString &stringPassword )
{
    plineeditPassword->setText( stringPassword );
}

void MYODBCSetupDataSourceTab1::setDatabase( const QString &stringDatabase )
{
    pcomboboxDatabase->lineEdit()->setText( stringDatabase );
}

QString MYODBCSetupDataSourceTab1::getDataSourceName()
{
    return plineeditDataSourceName->text();
}

QString MYODBCSetupDataSourceTab1::getDescription()
{
    return plineeditDescription->text();
}

QString MYODBCSetupDataSourceTab1::getServer()
{
    return plineeditServer->text();
}

QString MYODBCSetupDataSourceTab1::getUser()
{
    return plineeditUser->text();
}

QString MYODBCSetupDataSourceTab1::getPassword()
{
    return plineeditPassword->text();
}

QString MYODBCSetupDataSourceTab1::getDatabase()
{
    return pcomboboxDatabase->lineEdit()->text();
}

void MYODBCSetupDataSourceTab1::doInit()
{
    QGridLayout *playoutFields = new QGridLayout( this, 7, 5 );
    playoutFields->setMargin( 20 );
    playoutFields->setSpacing( 5 );

    int nRow = 0;
    int nColLabel = 1;
    int nColField = 3;

    plabelDataSourceName = new QLabel( "Data Source Name", this );
    plineeditDataSourceName = new MYODBCSetupLineEdit( this );
    plineeditDataSourceName->setAssistText( "A unique name for this data source.\nOptional: No\nDefault: myodbc" );
    QToolTip::add( plineeditDataSourceName, "A unique name for this data source.\nOptional: No\nDefault: myodbc" );
    playoutFields->addWidget( plabelDataSourceName, nRow, nColLabel );
    playoutFields->addWidget( plineeditDataSourceName, nRow, nColField );
    nRow++;

    plabelDescription = new QLabel( "Description", this );
    plineeditDescription = new MYODBCSetupLineEdit( this );
    plineeditDescription->setAssistText( "A brief description of this data source.\nOptional: Yes\nDefault: <empty>" );
    QToolTip::add( plineeditDescription, "A brief description of this data source.\nOptional: Yes\nDefault: <empty>" );
    playoutFields->addWidget( plabelDescription, nRow, nColLabel );
    playoutFields->addWidget( plineeditDescription, nRow, nColField );
    nRow++;

    plabelServer = new QLabel( "Server", this );
    plineeditServer = new MYODBCSetupLineEdit( this );
    plineeditServer->setText( "localhost" );
    plineeditServer->setAssistText( "The hostname of the MySQL server.\nOptional: Yes (silently uses default)\nDefault: localhost" );
    QToolTip::add( plineeditServer, "The hostname of the MySQL server.\nOptional: Yes (silently uses default)\nDefault: localhost" );
    playoutFields->addWidget( plabelServer, nRow, nColLabel );
    playoutFields->addWidget( plineeditServer, nRow, nColField );
    nRow++;

    plabelUser = new QLabel( "User", this );
    plineeditUser = new MYODBCSetupLineEdit( this );
    plineeditUser->setAssistText( "The username used to connect to MySQL.\nOptional: Yes (silently uses default)\nDefault (Windows only): ODBC" );
    QToolTip::add( plineeditUser, "The username used to connect to MySQL.\nOptional: Yes (silently uses default)\nDefault (Windows only): ODBC" );
    playoutFields->addWidget( plabelUser, nRow, nColLabel );
    playoutFields->addWidget( plineeditUser, nRow, nColField );
    nRow++;

    plabelPassword = new QLabel( "Password", this );
    plineeditPassword = new MYODBCSetupLineEdit( this );
    plineeditPassword->setEchoMode( QLineEdit::Password );
    plineeditPassword->setAssistText( "The password for the server user combination.\nOptional: Yes\nDefault: <empty>" );
    QToolTip::add( plineeditPassword, "The password for the server user combination.\nOptional: Yes\nDefault: <empty>" );
    playoutFields->addWidget( plabelPassword, nRow, nColLabel );
    playoutFields->addWidget( plineeditPassword, nRow, nColField );
    nRow++;

    plabelDatabase = new QLabel( "Database", this );
    pcomboboxDatabase = new MYODBCSetupComboBoxDatabases( this );
    pcomboboxDatabase->setAssistText( "The database to be current upon connect.\nOptional: Yes\nDefault: <none>" );
    QToolTip::add( pcomboboxDatabase, "The database to be current upon connect.\nOptional: Yes\nDefault: <none>" );
    playoutFields->addWidget( plabelDatabase, nRow, nColLabel );
    playoutFields->addWidget( pcomboboxDatabase, nRow, nColField );
    connect( pcomboboxDatabase, SIGNAL(signalLoadRequest()), SIGNAL(signalRequestDatabaseNames()) );
    nRow++;
}


