/*
 * MVKWatermarkTextureContent.h
 *
 * Copyright (c) 2014-2018 The Brenwill Workshop Ltd. (http://www.brenwill.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once


#import <Metal/Metal.h>


/** This file contains static content for the Watermark texture. */

static MTLPixelFormat __watermarkTextureFormat = MTLPixelFormatRGBA8Unorm;

// Checkerboard texture pattern for testing
//static uint32_t __watermarkTextureWidth = 4;
//static uint32_t __watermarkTextureHeight = 4;
//static unsigned char __watermarkTextureContent[] = {
//	255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,
//	  0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,
//	255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,
//	  0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,
//};


/** MoltenVK logo texture created using MGLLogByteContent() and pasted with preserve-formatting. */

static uint32_t __watermarkTextureWidth = 128;
static uint32_t __watermarkTextureHeight = 128;

static unsigned char __watermarkTextureContent[] = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   4,   0,   0,   0,   0,   0,   0,   0,   0, 
 12,  12,  12,  53,  30,  30,  31, 132,  45,  45,  47, 195,  55,  55,  57, 238,  59,  59,  62, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255, 
 59,  59,  61, 255,  59,  59,  61, 255,  59,  59,  61, 255,  60,  60,  62, 255,  56,  56,  58, 242,  47,  47,  48, 201,  33,  33,  34, 142,  15,  15,  15,  64, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,  13,  13,  13,  61,  42,  42,  42, 189, 
 58,  58,  59, 255,  61,  61,  62, 255,  59,  59,  61, 255,  57,  57,  59, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255, 
 56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  56,  56,  58, 255,  57,  57,  58, 255,  59,  59,  60, 255,  61,  61,  62, 255,  59,  59,  60, 255, 
 46,  46,  47, 207,  18,  18,  18,  82,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,  30,  30,  31, 145,  55,  55,  57, 255,  56,  56,  58, 255, 
 52,  52,  54, 253,  52,  52,  53, 250,  52,  52,  54, 252,  52,  52,  54, 254,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 

 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255, 
 53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  53,  53,  55, 255,  52,  52,  54, 254,  52,  52,  54, 252,  52,  52,  53, 251,  52,  52,  54, 252, 
 55,  55,  57, 255,  56,  56,  58, 255,  35,  35,  37, 172,   2,   2,   2,  11,   0,   0,   0,   0,   1,   1,   1,   4,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   1,   1,   1,   7,  37,  37,  38, 191,  54,  54,  56, 255,  49,  49,  51, 252,  49,  49,  50, 251, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255,  50,  50,  51, 255, 
 49,  49,  51, 252,  49,  49,  50, 251,  54,  54,  55, 255,  42,  42,  44, 217,   4,   4,   5,  23,   0,   0,   0,   0,   1,   1,   1,   3,   0,   0,   0,   0, 
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,  35,  35,  36, 191,  51,  51,  52, 255,  46,  46,  47, 248,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255,  47,  47,  48, 255, 
 47,  47,  48, 255,  47,  47,  48, 255,  46,  46,  47, 249,  50,  50,  51, 255,  41,  41,  41, 220,   2,   2,   2,  14,   0,   0,   0,   0,   0,   0,   0,   2, 
  1,   1,   1,   4,   0,   0,   0,   0,  26,  26,  26, 145,  49,  49,  50, 255,  44,  44,  45, 248,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255, 
 45,  45,  46, 255,  45,  45,  46, 255,  45,  45,  46, 255,  44,  44,  45, 249,  48,  48,  49, 255,  32,  32,  33, 181,   0,   0,   0,   0,   0,   0,   0,   2, 
  0,   0,   0,   0,  10,  10,  10,  61,  43,  43,  45, 255,  41,  41,  43, 253,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255, 
 42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  42,  42,  43, 255,  41,  41,  42, 250,  45,  45,  46, 255,  16,  16,  16,  96,   0,   0,   0,   0, 
  0,   0,   0,   0,  29,  29,  30, 189,  41,  41,  42, 255,  39,  39,  40, 251,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255, 
 39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 255,  39,  39,  40, 253,  41,  41,  42, 255,  34,  34,  35, 222,   1,   1,   1,   5, 
  8,   8,   8,  53,  38,  38,  39, 255,  37,  37,  38, 253,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255, 
 37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  37,  37,  38, 255,  36,  36,  37, 251,  39,  39,  40, 255,  13,  13,  13,  86, 
 18,  18,  18, 132,  37,  37,  38, 255,  34,  34,  35, 250,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255, 
 35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  35,  35,  36, 255,  34,  34,  35, 251,  37,  37,  38, 255,  23,  23,  24, 170, 
 25,  25,  25, 195,  34,  34,  35, 255,  32,  32,  33, 252,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 255,  32,  32,  33, 254,  33,  33,  34, 255,  30,  30,  30, 234, 
 28,  28,  29, 238,  31,  31,  32, 255,  30,  30,  31, 254,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255, 
 30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  32, 255,  30,  30,  31, 255,  31,  31,  32, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255, 
 29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  29,  29,  29, 255,  28,  28,  29, 254, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255,  27,  27,  27, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255,  26,  26,  26, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255,  24,  24,  24, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255,  22,  22,  23, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 21,  21,  22, 255,  21,  21,  22, 255,  20,  20,  22, 255,  21,  21,  22, 255,  21,  21,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  21,  21,  22, 255,  21,  21,  22, 255, 
 21,  21,  22, 255,  20,  20,  22, 255,  21,  21,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255,  20,  20,  22, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255,  19,  19,  19, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  17,  17,  17, 255,  23,  23,  23, 255, 
 25,  25,  25, 255,  22,  22,  22, 255,  31,  32,  32, 255,  28,  28,  29, 255,  30,  30,  30, 255,  22,  22,  22, 255,  17,  17,  17, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  17,  17,  17, 255,  20,  20,  20, 255,  29,  29,  29, 255,  28,  28,  28, 255, 
 30,  30,  31, 255,  30,  31,  31, 255,  31,  31,  32, 255,  23,  23,  23, 255,  17,  17,  17, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255,  18,  18,  18, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  16,  16,  16, 255,  21,  21,  21, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   5,   5,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,  20,  20,  20, 255,  16,  16,  16, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  16,  16,  16, 255,  18,  18,  18, 255,  12,  12,  12, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  21,  21,  21, 255,  16,  16,  16, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  17, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  26,  26,  26, 255,   0,   0,   0, 255,  94,  94,  95, 255, 
163, 164, 165, 255, 134, 134, 136, 255, 156, 157, 159, 255, 165, 166, 167, 255, 169, 169, 171, 255,  59,  59,  58, 255,   0,   0,   0, 255,  21,  21,  21, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  17,  17,  17, 255,  14,  14,  15, 255,  20,  20,  19, 255, 159, 160, 161, 255, 167, 168, 170, 255, 
155, 156, 158, 255, 152, 153, 155, 255, 159, 160, 162, 255,  94,  94,  95, 255,   0,   0,   0, 255,  26,  26,  26, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  17,  17,  17, 255,  17,  17,  17, 255,  17,  17,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255,  16,  16,  16, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  14,  14,  15, 255,  29,  29,  30, 255,   0,   0,   0, 255, 118, 119, 119, 255, 
154, 154, 156, 255, 123, 124, 126, 255, 188, 189, 191, 255, 198, 199, 201, 255, 208, 209, 211, 255, 136, 137, 137, 255,   0,   0,   0, 255,  33,  33,  33, 255, 
 14,  14,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  29,  29,  29, 255,   0,   0,   0, 255, 113, 113, 113, 255, 202, 203, 205, 255, 191, 192, 194, 255, 
205, 206, 208, 255, 201, 202, 204, 255, 211, 212, 214, 255, 127, 128, 128, 255,   0,   0,   0, 255,  32,  32,  32, 255,  14,  14,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 14,  14,  14, 255,  18,  18,  18, 255,  21,  21,  22, 255,   5,   5,   6, 255,  13,  13,  13, 255,  15,  15,  16, 255,  14,  14,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  14,  14,  15, 255,  14,  14,  15, 255,  14,  14,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255,  15,  15,  15, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  28,  28,  29, 255,   0,   0,   0, 255, 107, 107, 108, 255, 
181, 182, 183, 255, 207, 208, 210, 255, 195, 196, 198, 255, 175, 176, 178, 255, 208, 209, 211, 255, 188, 188, 189, 255,   0,   0,   0, 255,  28,  28,  29, 255, 
 12,  12,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  12,  12,  13, 255,  34,  34,  34, 255,   0,   0,   0, 255, 173, 173, 174, 255, 207, 208, 209, 255, 190, 190, 192, 255, 
213, 214, 216, 255, 206, 207, 209, 255, 215, 216, 218, 255, 127, 127, 128, 255,   0,   0,   0, 255,  31,  31,  32, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  12,  12,  13, 255, 
 16,  16,  17, 255,   0,   0,   0, 255,   0,   0,   0, 255,  32,  32,  32, 255,  22,  22,  22, 255,   9,   9,  10, 255,  14,  14,  15, 255,  13,  13,  14, 255, 
 11,  11,  12, 255,  26,  26,  27, 255,  33,  33,  34, 255,  33,  33,  34, 255,  21,  21,  22, 255,  11,  11,  12, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255,  13,  13,  14, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  28,  28,  29, 255,   0,   0,   0, 255, 111, 111, 112, 255, 
217, 218, 219, 255, 208, 209, 211, 255, 185, 186, 188, 255, 198, 200, 202, 255, 211, 212, 214, 255, 213, 213, 215, 255,  91,  91,  91, 255,   0,   0,   0, 255, 
 24,  24,  25, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  18,  18,  19, 255,   0,   0,   0, 255,  51,  51,  50, 255, 210, 211, 212, 255, 188, 189, 191, 255, 108, 108, 110, 255, 
188, 189, 191, 255, 204, 205, 207, 255, 216, 217, 219, 255, 129, 129, 130, 255,   0,   0,   0, 255,  31,  31,  32, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  28,  28,  28, 255, 
  0,   0,   0, 255, 117, 118, 119, 255, 198, 198, 200, 255, 163, 163, 165, 255, 122, 122, 124, 255,   0,   0,   0, 255,  23,  23,  23, 255,  10,  10,  11, 255, 
 19,  19,  19, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  19,  20,  20, 255,  10,  10,  11, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255,  12,  12,  13, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  27,  27,  28, 255,   0,   0,   0, 255, 110, 111, 111, 255, 
215, 216, 218, 255, 202, 203, 205, 255, 207, 207, 209, 255, 216, 217, 219, 255, 207, 208, 210, 255, 219, 220, 221, 255, 158, 158, 159, 255,   0,   0,   0, 255, 
 34,  34,  34, 255,  10,  10,  10, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  32,  32,  32, 255,   0,   0,   0, 255, 134, 134, 135, 255, 224, 225, 227, 255, 172, 173, 175, 255, 182, 183, 185, 255, 
200, 201, 203, 255, 175, 176, 177, 255, 197, 198, 200, 255, 134, 135, 135, 255,   0,   0,   0, 255,  31,  31,  31, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  29,  29,  29, 255, 
  0,   0,   0, 255, 130, 131, 132, 255, 194, 195, 197, 255, 174, 175, 177, 255, 160, 161, 163, 255,   0,   0,   0, 255,  29,  29,  30, 255,  19,  19,  19, 255, 
  0,   0,   0, 255, 109, 109, 110, 255, 141, 141, 142, 255, 145, 145, 146, 255,  81,  81,  82, 255,   0,   0,   0, 255,  20,  20,  20, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  27,  28,  28, 255,   0,   0,   0, 255, 110, 111, 111, 255, 
217, 218, 220, 255, 209, 210, 212, 255, 212, 213, 215, 255, 205, 205, 206, 255, 211, 212, 214, 255, 214, 215, 217, 255, 200, 201, 202, 255,   0,   0,   0, 255, 
 13,  13,  14, 255,  13,  13,  13, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  10,  10,  10, 255,  28,  28,  29, 255,   0,   0,   0, 255, 187, 188, 189, 255, 210, 211, 213, 255, 199, 200, 202, 255, 199, 199, 201, 255, 
203, 204, 206, 255, 196, 196, 198, 255, 212, 213, 215, 255, 128, 128, 129, 255,   0,   0,   0, 255,  31,  31,  31, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  29,  29,  29, 255, 
  0,   0,   0, 255, 128, 128, 130, 255, 191, 191, 193, 255, 161, 162, 164, 255, 156, 157, 159, 255,   0,   0,   0, 255,  28,  28,  28, 255,  29,  29,  30, 255, 
  0,   0,   0, 255, 175, 176, 177, 255, 219, 219, 222, 255, 219, 220, 222, 255, 137, 137, 138, 255,   0,   0,   0, 255,  33,  33,  33, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
 11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255,  11,  11,  11, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  27,  27,  27, 255,   0,   0,   0, 255, 112, 112, 112, 255, 
213, 214, 215, 255, 201, 202, 203, 255, 207, 207, 209, 255, 157, 157, 158, 255, 207, 208, 209, 255, 211, 212, 213, 255, 218, 219, 220, 255, 117, 117, 117, 255, 
  0,   0,   0, 255,  28,  28,  28, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,  22,  22,  22, 255,   0,   0,   0, 255,  91,  91,  91, 255, 212, 213, 214, 255, 178, 179, 180, 255, 200, 201, 202, 255, 149, 149, 149, 255, 
190, 191, 192, 255, 193, 194, 195, 255, 207, 208, 210, 255, 129, 129, 130, 255,   0,   0,   0, 255,  30,  30,  30, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  29,  29,  29, 255, 
  0,   0,   0, 255, 127, 127, 128, 255, 216, 217, 218, 255, 212, 213, 214, 255, 156, 156, 158, 255,   0,   0,   0, 255,  28,  28,  28, 255,  27,  27,  27, 255, 
  0,   0,   0, 255, 169, 170, 171, 255, 191, 191, 193, 255, 203, 204, 205, 255, 135, 135, 136, 255,   0,   0,   0, 255,  31,  31,  31, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  26,  26,  26, 255,   0,   0,   0, 255, 112, 112, 113, 255, 
206, 207, 208, 255, 177, 178, 179, 255, 221, 222, 223, 255, 130, 130, 130, 255, 179, 180, 181, 255, 220, 221, 222, 255, 221, 222, 223, 255, 176, 177, 177, 255, 
  0,   0,   0, 255,  33,  33,  33, 255,   8,   8,   8, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  8,   8,   8, 255,  33,  33,  33, 255,   0,   0,   0, 255, 159, 160, 160, 255, 212, 212, 214, 255, 202, 203, 204, 255, 202, 202, 203, 255,  93,  93,  94, 255, 
214, 215, 217, 255, 193, 194, 195, 255, 209, 210, 211, 255, 133, 133, 134, 255,   0,   0,   0, 255,  30,  30,  30, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  21,  21,  21, 255,  32,  32,  32, 255,  33,  33,  33, 255,  33,  33,  34, 255,  33,  33,  33, 255, 
 28,  28,  28, 255,  14,  14,  14, 255,   8,   8,   8, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  29,  29,  30, 255, 
  0,   0,   0, 255, 131, 132, 132, 255, 218, 219, 220, 255, 221, 222, 223, 255, 167, 167, 168, 255,   0,   0,   0, 255,  35,  35,  36, 255,  35,  35,  35, 255, 
  0,   0,   0, 255, 175, 176, 177, 255, 205, 206, 207, 255, 221, 222, 223, 255, 134, 134, 134, 255,   0,   0,   0, 255,  36,  36,  36, 255,  17,  17,  17, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   8,   8,   8, 255,  18,  18,  18, 255,  30,  30,  30, 255, 
 32,  32,  33, 255,  32,  32,  33, 255,  31,  31,  31, 255,  23,  23,  23, 255,  10,  10,  10, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   8,   8,   8, 255,  16,  16,  16, 255,  21,  21,  21, 255,  20,  20,  20, 255,  11,  11,  11, 255,   9,   9,   9, 255, 
  8,   8,   8, 255,  19,  19,  19, 255,  31,  32,  32, 255,  33,  33,  33, 255,  33,  33,  33, 255,  32,  32,  32, 255,  23,  23,  23, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,  24,  24,  25, 255,   0,   0,   0, 255,  98,  98,  99, 255, 
222, 223, 224, 255, 219, 220, 221, 255, 229, 230, 231, 255, 131, 132, 132, 255, 120, 121, 121, 255, 228, 229, 230, 255, 221, 222, 223, 255, 215, 216, 217, 255, 
 57,  56,  56, 255,   0,   0,   0, 255,  17,  17,  17, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
 11,  11,  11, 255,  20,  20,  20, 255,   0,   0,   0, 255, 201, 202, 203, 255, 222, 223, 224, 255, 230, 231, 232, 255, 157, 158, 158, 255,  73,  73,  74, 255, 
222, 223, 225, 255, 222, 223, 224, 255, 229, 230, 231, 255, 131, 131, 132, 255,   0,   0,   0, 255,  31,  31,  31, 255,   9,   9,   9, 255,  10,  10,  10, 255, 
  6,   6,   6, 255,  27,  27,  28, 255,  33,  33,  33, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   4,   4,   4, 255,  36,  36,  36, 255,  16,  16,  16, 255,   7,   7,   7, 255,  10,  10,  10, 255,   9,   9,   9, 255,  30,  30,  31, 255, 
  0,   0,   0, 255, 136, 136, 137, 255, 224, 225, 227, 255, 226, 227, 228, 255, 170, 171, 172, 255,   0,   0,   0, 255,   3,   4,   4, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 180, 181, 182, 255, 228, 229, 230, 255, 222, 223, 224, 255, 122, 123, 123, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 10,  10,  10, 255,   9,   9,   9, 255,  10,  10,  10, 255,   7,   7,   7, 255,  20,  20,  20, 255,  36,  36,  36, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  29,  29,  29, 255,  29,  29,  29, 255,   6,   6,   6, 255,  10,  10,  10, 255, 
  9,   9,   9, 255,   8,   8,   8, 255,  13,  13,  13, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,  18,  18, 255, 
 35,  35,  35, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  28,  25,  24, 255, 
 22,  19,  18, 255,   6,   7,   7, 255,  10,  10,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255,   9,   9,   9, 255, 
  8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255, 
  8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,  24,  24,  25, 255,   0,   0,   0, 255, 101, 102, 102, 255, 
227, 228, 229, 255, 226, 227, 228, 255, 235, 236, 236, 255, 143, 143, 143, 255,   0,   0,   0, 255, 216, 216, 217, 255, 229, 230, 230, 255, 234, 235, 236, 255, 
142, 142, 142, 255,   0,   0,   0, 255,  32,  32,  32, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255, 
 25,  25,  25, 255,   0,   0,   0, 255, 104, 104, 105, 255, 228, 229, 230, 255, 228, 229, 229, 255, 229, 230, 230, 255,  81,  81,  81, 255,  91,  92,  92, 255, 
228, 229, 230, 255, 226, 226, 227, 255, 233, 234, 235, 255, 134, 134, 134, 255,   0,   0,   0, 255,  31,  31,  31, 255,   7,   7,   7, 255,   6,   6,   6, 255, 
 35,  35,  35, 255,   0,   0,   0, 255,   0,   0,   0, 255,  79,  79,  79, 255, 132, 132, 132, 255, 148, 149, 149, 255, 156, 156, 156, 255, 141, 141, 141, 255, 
114, 114, 114, 255,  15,  14,  14, 255,   0,   0,   0, 255,   3,   3,   3, 255,  27,  27,  27, 255,   2,   2,   2, 255,   8,   8,   8, 255,  31,  31,  31, 255, 
  0,   0,   0, 255, 139, 139, 139, 255, 232, 232, 233, 255, 233, 234, 235, 255, 176, 176, 177, 255,   0,   0,   0, 255,  72,  72,  72, 255,  80,  80,  80, 255, 
 45,  44,  44, 255, 193, 194, 194, 255, 232, 232, 233, 255, 220, 221, 221, 255, 139, 140, 140, 255,  43,  44,  44, 255,  69,  69,  70, 255,  58,  58,  58, 255, 
  5,   5,   5, 255,   9,   9,   9, 255,   2,   2,   2, 255,  31,  31,  31, 255,   0,   0,   0, 255,   0,   0,   0, 255,  58,  58,  58, 255, 125, 125, 125, 255, 
145, 145, 146, 255, 148, 148, 149, 255, 130, 131, 131, 255,  89,  90,  90, 255,   0,   0,   0, 255,   0,   0,   0, 255,  34,  34,  34, 255,   6,   6,   6, 255, 
  8,   8,   8, 255,  11,  11,  11, 255,   0,   0,   0, 255,  54,  54,  55, 255,  76,  76,  76, 255,  72,  72,  72, 255,  38,  38,  38, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  68,  68,  67, 255, 132, 132, 132, 255, 151, 152, 152, 255, 152, 152, 153, 255, 137, 137, 137, 255,  94,  94,  94, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  25,  20,  19, 255,   3,   5,   5, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255, 
  8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255,   8,   8,   8, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,  26,  26,  26, 255,   0,   0,   0, 255, 108, 108, 109, 255, 
236, 237, 237, 255, 234, 235, 235, 255, 242, 243, 244, 255, 149, 149, 150, 255,   0,   0,   0, 255, 180, 181, 181, 255, 242, 243, 243, 255, 240, 241, 242, 255, 
202, 202, 203, 255,   0,   0,   0, 255,  31,  31,  31, 255,   6,   6,   6, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   6,   6,   6, 255, 
 35,  35,  35, 255,   0,   0,   0, 255, 178, 179, 180, 255, 242, 243, 243, 255, 240, 241, 241, 255, 205, 205, 206, 255,   0,   0,   0, 255, 108, 109, 109, 255, 
235, 236, 237, 255, 234, 235, 236, 255, 242, 242, 243, 255, 136, 136, 136, 255,   0,   0,   0, 255,  31,  31,  31, 255,   7,   7,   7, 255,  31,  31,  31, 255, 
  0,   0,   0, 255, 108, 108, 108, 255, 202, 202, 202, 255, 232, 233, 233, 255, 240, 241, 241, 255, 241, 242, 242, 255, 241, 242, 242, 255, 240, 241, 242, 255, 
237, 238, 238, 255, 223, 223, 224, 255, 170, 170, 170, 255,   0,   0,   0, 255,   0,   0,   0, 255,  31,  31,  31, 255,   0,   0,   0, 255,  32,  32,  32, 255, 
  0,   0,   0, 255, 142, 143, 143, 255, 240, 240, 241, 255, 242, 242, 243, 255, 183, 184, 184, 255,   0,   0,   0, 255, 209, 210, 210, 255, 236, 237, 237, 255, 
229, 230, 230, 255, 235, 235, 236, 255, 234, 235, 236, 255, 236, 236, 237, 255, 205, 206, 207, 255, 218, 219, 219, 255, 233, 234, 235, 255, 207, 208, 208, 255, 
  0,   0,   0, 255,   8,   8,   8, 255,  35,  35,  35, 255,   0,   0,   0, 255,  56,  56,  56, 255, 183, 183, 183, 255, 227, 228, 228, 255, 238, 239, 240, 255, 
240, 241, 242, 255, 240, 241, 241, 255, 238, 239, 240, 255, 232, 233, 234, 255, 206, 207, 207, 255, 116, 116, 116, 255,   0,   0,   0, 255,  31,  31,  31, 255, 
  5,   5,   5, 255,  33,  33,  33, 255,   0,   0,   0, 255, 179, 179, 180, 255, 239, 240, 241, 255, 233, 233, 234, 255, 105, 105, 105, 255,   0,   0,   0, 255, 
181, 181, 181, 255, 229, 230, 230, 255, 240, 241, 241, 255, 241, 241, 242, 255, 241, 242, 242, 255, 240, 241, 242, 255, 229, 228, 229, 255, 191, 181, 177, 255, 
 71,  60,  56, 255,   0,   0,   0, 255,  24,  19,  18, 255,   5,   6,   6, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,  27,  27,  27, 255,   0,   0,   0, 255, 111, 111, 111, 255, 
243, 244, 244, 255, 243, 243, 243, 255, 249, 249, 250, 255, 150, 150, 150, 255,   0,   0,   0, 255, 116, 116, 116, 255, 244, 244, 245, 255, 244, 244, 245, 255, 
240, 240, 241, 255,  88,  88,  88, 255,   0,   0,   0, 255,  22,  22,  22, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,  15,  15,  15, 255, 
  0,   0,   0, 255,  41,  41,  41, 255, 230, 230, 230, 255, 245, 245, 245, 255, 250, 250, 250, 255, 151, 151, 151, 255,   0,   0,   0, 255, 114, 114, 114, 255, 
243, 243, 244, 255, 242, 242, 243, 255, 249, 249, 249, 255, 139, 139, 139, 255,   0,   0,   0, 255,  31,  31,  31, 255,  32,  32,  32, 255,   0,   0,   0, 255, 
160, 160, 160, 255, 246, 246, 246, 255, 249, 249, 249, 255, 246, 246, 247, 255, 250, 250, 250, 255, 248, 248, 249, 255, 248, 248, 248, 255, 249, 249, 250, 255, 
249, 249, 250, 255, 245, 246, 246, 255, 251, 252, 252, 255, 221, 221, 221, 255,  82,  82,  82, 255,   0,   0,   0, 255,  29,  29,  29, 255,  32,  32,  32, 255, 
  0,   0,   0, 255, 147, 147, 147, 255, 248, 248, 248, 255, 250, 250, 250, 255, 189, 189, 190, 255,   0,   0,   0, 255, 226, 226, 226, 255, 255, 255, 255, 255, 
250, 251, 251, 255, 247, 247, 247, 255, 240, 240, 241, 255, 236, 236, 237, 255, 224, 224, 224, 255, 247, 247, 247, 255, 255, 255, 255, 255, 229, 229, 229, 255, 
  0,   0,   0, 255,  38,  38,  38, 255,   0,   0,   0, 255, 111, 111, 111, 255, 233, 233, 233, 255, 250, 250, 251, 255, 249, 249, 250, 255, 250, 250, 250, 255, 
247, 247, 248, 255, 248, 248, 248, 255, 250, 250, 250, 255, 248, 249, 249, 255, 247, 247, 247, 255, 244, 244, 245, 255, 160, 159, 160, 255,   0,   0,   0, 255, 
 33,  33,  33, 255,  34,  34,  34, 255,   0,   0,   0, 255, 188, 188, 189, 255, 252, 252, 253, 255, 242, 242, 243, 255, 113, 113, 113, 255, 208, 208, 208, 255, 
255, 255, 255, 255, 252, 252, 253, 255, 248, 249, 249, 255, 248, 248, 248, 255, 247, 247, 248, 255, 239, 239, 239, 255, 227, 219, 216, 255, 235, 205, 195, 255, 
211, 165, 151, 255,  55,  36,  31, 255,   0,   0,   0, 255,  18,  13,  12, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,  26,  26,  27, 255,   0,   0,   0, 255, 111, 111, 111, 255, 
248, 248, 248, 255, 228, 228, 228, 255, 240, 240, 241, 255, 154, 154, 154, 255,   0,   0,   0, 255,   0,   0,   0, 255, 218, 218, 218, 255, 249, 248, 248, 255, 
252, 252, 252, 255, 169, 169, 169, 255,   0,   0,   0, 255,  36,  36,  36, 255,   6,   6,   6, 255,   7,   7,   7, 255,   7,   7,   7, 255,  32,  32,  32, 255, 
  0,   0,   0, 255, 142, 142, 142, 255, 250, 250, 250, 255, 246, 246, 246, 255, 234, 234, 234, 255,  59,  59,  59, 255,   0,   0,   0, 255, 113, 113, 113, 255, 
245, 245, 245, 255, 244, 244, 244, 255, 251, 251, 251, 255, 139, 139, 139, 255,   0,   0,   0, 255,  47,  47,  47, 255,   0,   0,   0, 255, 153, 153, 153, 255, 
253, 253, 253, 255, 244, 244, 244, 255, 248, 248, 248, 255, 238, 238, 238, 255, 183, 183, 183, 255, 140, 140, 140, 255, 136, 136, 136, 255, 153, 153, 153, 255, 
210, 210, 210, 255, 249, 249, 249, 255, 244, 244, 244, 255, 247, 247, 247, 255, 222, 222, 222, 255,  56,  56,  56, 255,   0,   0,   0, 255,  38,  38,  38, 255, 
  0,   0,   0, 255, 148, 148, 148, 255, 249, 249, 249, 255, 251, 251, 251, 255, 190, 190, 190, 255,   0,   0,   0, 255, 179, 179, 179, 255, 205, 205, 205, 255, 
195, 195, 195, 255, 231, 231, 230, 255, 247, 247, 247, 255, 243, 243, 243, 255, 218, 218, 218, 255, 198, 198, 198, 255, 207, 207, 207, 255, 183, 183, 183, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  94,  94,  94, 255, 241, 241, 241, 255, 249, 249, 249, 255, 249, 249, 249, 255, 226, 226, 225, 255, 165, 165, 165, 255, 
133, 133, 133, 255, 135, 135, 135, 255, 165, 165, 165, 255, 226, 226, 226, 255, 244, 244, 244, 255, 238, 238, 238, 255, 252, 252, 252, 255, 137, 137, 138, 255, 
  0,   0,   0, 255,  48,  48,  48, 255,   0,   0,   0, 255, 188, 188, 188, 255, 255, 255, 254, 255, 240, 240, 240, 255, 214, 214, 214, 255, 255, 255, 255, 255, 
241, 241, 241, 255, 191, 191, 191, 255, 144, 144, 144, 255, 137, 136, 136, 255, 141, 141, 142, 255, 191, 185, 183, 255, 230, 200, 190, 255, 223, 172, 157, 255, 
234, 166, 148, 255, 171, 114, 100, 255,   0,   0,   0, 255,  32,  20,  18, 255,   6,   6,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255,   7,   7,   7, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  25,  25,  26, 255,   0,   0,   0, 255, 112, 112, 112, 255, 
246, 246, 246, 255, 242, 242, 242, 255, 244, 244, 244, 255, 145, 145, 145, 255,   0,   0,   0, 255,   0,   0,   0, 255, 164, 164, 164, 255, 252, 252, 252, 255, 
249, 249, 249, 255, 222, 222, 222, 255,   0,   0,   0, 255,  20,  20,  20, 255,   6,   6,   7, 255,   4,   4,   5, 255,   3,   3,   4, 255,  32,  32,  32, 255, 
  0,   0,   0, 255, 205, 205, 205, 255, 251, 251, 251, 255, 252, 252, 252, 255, 191, 191, 191, 255,   0,   0,   0, 255,   0,   0,   0, 255, 111, 111, 111, 255, 
246, 245, 246, 255, 244, 244, 244, 255, 251, 251, 251, 255, 139, 139, 139, 255,   0,   0,   0, 255,   0,   0,   0, 255,  80,  80,  80, 255, 241, 241, 241, 255, 
246, 246, 246, 255, 250, 250, 250, 255, 220, 220, 220, 255,  72,  72,  72, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 158, 158, 158, 255, 235, 235, 235, 255, 221, 221, 221, 255, 254, 254, 254, 255, 195, 195, 195, 255,   0,   0,   0, 255,  47,  47,  47, 255, 
  0,   0,   0, 255, 147, 147, 147, 255, 250, 250, 250, 255, 252, 252, 252, 255, 188, 188, 189, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 198, 198, 198, 255, 252, 252, 252, 255, 250, 250, 250, 255, 125, 125, 125, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 22,  22,  22, 255,   0,   0,   0, 255, 218, 218, 218, 255, 251, 251, 251, 255, 250, 250, 250, 255, 201, 201, 201, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 191, 191, 191, 255, 248, 248, 248, 255, 248, 248, 248, 255, 232, 232, 232, 255, 
 43,  42,  43, 255,  24,  24,  24, 255,   0,   0,   0, 255, 191, 191, 192, 255, 249, 249, 249, 255, 227, 227, 227, 255, 254, 254, 254, 255, 230, 230, 230, 255, 
101, 101, 101, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 162, 124, 113, 255, 221, 158, 141, 255, 
217, 140, 122, 255, 211, 127, 108, 255,  27,   8,   7, 255,   0,   2,   4, 255,  10,   6,   6, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  25,  25,  26, 255,   0,   0,   0, 255, 112, 112, 112, 255, 
246, 246, 246, 255, 247, 247, 247, 255, 231, 231, 232, 255, 143, 143, 143, 255,   0,   0,   0, 255,   0,   0,   0, 255,  79,  79,  79, 255, 240, 240, 240, 255, 
247, 247, 247, 255, 248, 248, 248, 255, 118, 118, 118, 255,   0,   0,   0, 255,  27,  27,  27, 255,   4,   4,   5, 255,  19,  19,  20, 255,   0,   0,   0, 255, 
 82,  82,  82, 255, 241, 241, 241, 255, 247, 247, 247, 255, 249, 249, 249, 255, 121, 121, 121, 255,   0,   0,   0, 255,   0,   0,   0, 255, 111, 111, 111, 255, 
246, 246, 246, 255, 245, 245, 245, 255, 252, 252, 252, 255, 139, 139, 139, 255,   0,   0,   0, 255,   0,   0,   0, 255, 186, 187, 187, 255, 253, 254, 254, 255, 
247, 247, 247, 255, 235, 235, 235, 255,  54,  54,  55, 255,   0,   0,   0, 255,  44,  44,  44, 255,  30,  30,  31, 255,  30,  30,  31, 255,  34,  34,  34, 255, 
 39,  39,  40, 255,   0,   0,   0, 255, 152, 152, 153, 255, 231, 232, 232, 255, 239, 239, 240, 255, 234, 234, 234, 255, 104, 105, 105, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 149, 149, 149, 255, 247, 248, 248, 255, 251, 252, 252, 255, 192, 192, 193, 255,   0,   0,   0, 255,  45,  45,  45, 255,  46,  46,  46, 255, 
  0,   0,   0, 255, 202, 203, 203, 255, 252, 252, 252, 255, 249, 250, 250, 255, 139, 139, 139, 255,   0,   0,   0, 255,  45,  45,  46, 255,  43,  43,  43, 255, 
  0,   0,   0, 255, 145, 145, 145, 255, 252, 252, 252, 255, 249, 249, 249, 255, 220, 220, 220, 255,   0,   0,   0, 255,   0,   0,   0, 255,  40,  40,  41, 255, 
 29,  29,  30, 255,  30,  30,  30, 255,  39,  39,  39, 255,   0,   0,   0, 255,   0,   0,   0, 255, 207, 207, 207, 255, 238, 238, 238, 255, 255, 255, 255, 255, 
164, 164, 164, 255,   0,   0,   0, 255,   0,   0,   0, 255, 191, 191, 191, 255, 248, 248, 248, 255, 234, 234, 234, 255, 246, 246, 246, 255, 117, 117, 118, 255, 
  0,   0,   0, 255,  47,  47,  47, 255,  31,  31,  32, 255,  30,  30,  31, 255,  36,  34,  34, 255,   3,  16,  19, 255,  11,   1,   1, 255, 212, 137, 119, 255, 
233, 137, 116, 255, 225, 120,  99, 255,  85,  41,  33, 255,   0,   0,   0, 255,  19,   8,   8, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  26,  26,  26, 255,   0,   0,   0, 255, 111, 111, 111, 255, 
255, 255, 255, 255, 222, 222, 222, 255, 236, 237, 237, 255, 157, 158, 158, 255,   0,   0,   0, 255,  48,  48,  48, 255,   0,   0,   0, 255, 207, 207, 207, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 193, 193, 194, 255,   0,   0,   0, 255,  37,  37,  37, 255,   2,   2,   3, 255,  36,  36,  36, 255,   0,   0,   0, 255, 
173, 173, 173, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 226, 226, 255,   0,   0,   0, 255,  33,  33,  34, 255,   0,   0,   0, 255, 113, 113, 113, 255, 
251, 252, 252, 255, 251, 251, 251, 255, 255, 255, 255, 255, 141, 142, 142, 255,   0,   0,   0, 255,  50,  49,  50, 255, 237, 237, 237, 255, 253, 254, 254, 255, 
255, 255, 255, 255, 162, 162, 162, 255,   0,   0,   0, 255,  45,  45,  45, 255,   0,   0,   0, 255,   5,   5,   6, 255,   4,   4,   5, 255,   3,   3,   4, 255, 
 12,  12,  13, 255,  25,  25,  25, 255,   0,   0,   0, 255, 203, 203, 203, 255, 245, 245, 245, 255, 255, 255, 255, 255, 180, 180, 180, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 152, 152, 152, 255, 253, 254, 254, 255, 250, 250, 251, 255, 185, 186, 186, 255,   0,   0,   0, 255,  32,  32,  33, 255,  32,  32,  33, 255, 
  0,   0,   0, 255, 205, 206, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 141, 141, 141, 255,   0,   0,   0, 255,  31,  31,  32, 255,  32,  32,  33, 255, 
  0,   0,   0, 255, 212, 213, 213, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 147, 147, 255,   0,   0,   0, 255,  44,  45,  45, 255,  17,  17,  18, 255, 
 21,  21,  22, 255,  20,  21,  21, 255,  18,  18,  19, 255,  42,  42,  42, 255,   0,   0,   0, 255, 124, 125, 125, 255, 225, 226, 226, 255, 238, 238, 239, 255, 
226, 226, 226, 255,   0,   0,   0, 255,   0,   0,   0, 255, 183, 184, 184, 255, 247, 247, 247, 255, 247, 248, 248, 255, 201, 201, 201, 255,   0,   0,   0, 255, 
 38,  38,  38, 255,   0,   0,   1, 255,   5,   5,   6, 255,   4,   4,   5, 255,   3,   3,   4, 255,  21,  11,  10, 255,   0,   0,   3, 255, 185, 107,  90, 255, 
162,  87,  71, 255, 219, 104,  84, 255, 118,  49,  38, 255,   0,   0,   0, 255,  26,   9,   8, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  24,  24,  25, 255,   0,   0,   0, 255, 108, 108, 109, 255, 
237, 238, 239, 255, 209, 209, 211, 255, 232, 233, 234, 255, 148, 149, 149, 255,   0,   0,   0, 255,  44,  44,  44, 255,   0,   0,   0, 255, 133, 134, 134, 255, 
238, 238, 239, 255, 235, 235, 237, 255, 223, 223, 224, 255,  49,  49,  49, 255,   0,   0,   0, 255,  15,  15,  15, 255,  19,  19,  19, 255,   0,   0,   0, 255, 
208, 209, 210, 255, 236, 237, 238, 255, 240, 241, 242, 255, 167, 167, 168, 255,   0,   0,   0, 255,  43,  43,  44, 255,   0,   0,   0, 255, 110, 110, 110, 255, 
234, 235, 236, 255, 232, 232, 234, 255, 239, 240, 241, 255, 137, 137, 137, 255,   0,   0,   0, 255, 113, 114, 114, 255, 234, 235, 236, 255, 234, 235, 236, 255, 
229, 230, 231, 255,  79,  78,  79, 255,   0,   0,   0, 255,  17,  17,  18, 255,   5,   5,   6, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  2,   2,   3, 255,  34,  34,  34, 255,   0,   0,   0, 255, 158, 158, 159, 255, 233, 234, 235, 255, 221, 222, 223, 255, 201, 202, 203, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 142, 142, 143, 255, 225, 226, 227, 255, 220, 221, 222, 255, 158, 159, 160, 255,   0,   0,   0, 255,  25,  25,  26, 255,  29,  29,  30, 255, 
  0,   0,   0, 255, 193, 194, 195, 255, 238, 239, 240, 255, 239, 239, 240, 255, 137, 137, 137, 255,   0,   0,   0, 255,  35,  35,  35, 255,   0,   0,   0, 255, 
 58,  58,  58, 255, 225, 225, 226, 255, 235, 236, 237, 255, 229, 230, 231, 255,  74,  73,  73, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 218, 218, 219, 255, 234, 234, 236, 255, 
229, 230, 231, 255,  82,  82,  83, 255,   0,   0,   0, 255, 182, 182, 183, 255, 235, 236, 237, 255, 221, 221, 222, 255, 163, 163, 164, 255,   0,   0,   0, 255, 
 32,  32,  33, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   0,   1,   3, 255,  29,  16,  14, 255, 136,  68,  55, 255, 
159,  68,  52, 255, 209,  82,  65, 255, 127,  44,  34, 255,   0,   0,   0, 255,  28,   8,   7, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  23,  23,  24, 255,   0,   0,   0, 255, 105, 106, 106, 255, 
206, 207, 209, 255, 206, 207, 209, 255, 214, 215, 217, 255, 135, 135, 136, 255,   0,   0,   0, 255,  30,  30,  31, 255,   0,   0,   0, 255,  16,  17,  18, 255, 
190, 191, 193, 255, 204, 205, 208, 255, 212, 213, 215, 255, 134, 134, 135, 255,   0,   0,   0, 255,  36,  36,  37, 255,   0,   0,   0, 255,  97,  97,  99, 255, 
206, 207, 209, 255, 203, 204, 206, 255, 207, 208, 210, 255,  88,  88,  88, 255,   0,   0,   0, 255,  31,  31,  32, 255,   0,   0,   0, 255, 105, 105, 106, 255, 
207, 208, 210, 255, 201, 202, 204, 255, 211, 212, 214, 255, 127, 127, 128, 255,   0,   0,   0, 255, 123, 123, 125, 255, 208, 209, 211, 255, 206, 207, 209, 255, 
187, 188, 189, 255,   0,   0,   0, 255,  12,  12,  13, 255,   6,   6,   7, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,  24,  24,  25, 255,   0,   0,   0, 255, 112, 112, 114, 255, 207, 208, 210, 255, 204, 205, 207, 255, 188, 189, 191, 255,  27,  27,  28, 255, 
  0,   0,   0, 255, 124, 125, 125, 255, 194, 195, 197, 255, 206, 208, 210, 255, 158, 159, 160, 255,   0,   0,   0, 255,  27,  28,  28, 255,  22,  23,  24, 255, 
  0,   0,   0, 255, 176, 176, 178, 255, 207, 208, 210, 255, 211, 212, 214, 255, 130, 130, 131, 255,   0,   0,   0, 255,  37,  37,  37, 255,   0,   0,   0, 255, 
101, 101, 102, 255, 193, 194, 196, 255, 194, 195, 198, 255, 201, 202, 203, 255, 192, 192, 193, 255, 188, 188, 189, 255, 185, 186, 187, 255, 179, 180, 181, 255, 
177, 178, 179, 255, 177, 178, 180, 255, 177, 178, 180, 255, 177, 178, 180, 255, 177, 178, 180, 255, 176, 177, 179, 255, 199, 200, 202, 255, 203, 205, 207, 255, 
211, 212, 213, 255, 124, 124, 124, 255,   0,   0,   0, 255, 163, 164, 165, 255, 193, 195, 197, 255, 188, 189, 191, 255, 136, 137, 137, 255,   0,   0,   0, 255, 
 27,  27,  27, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,  20,   7,   7, 255,   0,   0,   0, 255, 177,  80,  64, 255, 
232,  97,  78, 255, 241,  82,  66, 255, 128,  34,  28, 255,   0,   0,   0, 255,  29,   7,   7, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255,   4,   4,   5, 255, 
  3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255, 
  3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,  21,  21,  22, 255,   0,   0,   0, 255, 103, 103, 103, 255, 
196, 197, 199, 255, 187, 188, 191, 255, 200, 201, 203, 255, 132, 133, 133, 255,   0,   0,   0, 255,  26,  26,  26, 255,  26,  26,  27, 255,   0,   0,   0, 255, 
150, 150, 152, 255, 197, 198, 200, 255, 195, 196, 198, 255, 174, 175, 176, 255,   0,   0,   0, 255,  34,  34,  35, 255,   0,   0,   0, 255, 146, 147, 148, 255, 
196, 197, 200, 255, 195, 196, 198, 255, 176, 177, 178, 255,   0,   0,   0, 255,  19,  19,  20, 255,  21,  21,  21, 255,   0,   0,   0, 255, 103, 103, 103, 255, 
195, 197, 199, 255, 188, 190, 192, 255, 199, 200, 202, 255, 123, 123, 124, 255,   0,   0,   0, 255, 126, 127, 128, 255, 195, 197, 199, 255, 194, 195, 198, 255, 
177, 177, 179, 255,   0,   0,   0, 255,  16,  17,  17, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255, 
  3,   3,   3, 255,  17,  18,  18, 255,   0,   0,   0, 255,  87,  87,  88, 255, 191, 192, 194, 255, 193, 195, 197, 255, 185, 186, 188, 255,  57,  58,  58, 255, 
  0,   0,   0, 255, 131, 131, 132, 255, 176, 177, 179, 255, 173, 175, 177, 255, 150, 151, 153, 255,   0,   0,   0, 255,  24,  24,  25, 255,  19,  19,  20, 255, 
  0,   0,   0, 255, 168, 169, 170, 255, 193, 195, 197, 255, 200, 201, 203, 255, 127, 127, 128, 255,   0,   0,   0, 255,  38,  38,  39, 255,   0,   0,   0, 255, 
119, 119, 119, 255, 197, 198, 200, 255, 190, 191, 193, 255, 193, 194, 196, 255, 198, 200, 202, 255, 199, 200, 203, 255, 199, 200, 203, 255, 199, 201, 203, 255, 
199, 201, 203, 255, 199, 201, 203, 255, 199, 201, 203, 255, 199, 201, 203, 255, 199, 200, 203, 255, 199, 201, 203, 255, 195, 196, 199, 255, 191, 192, 195, 255, 
204, 205, 207, 255, 131, 132, 133, 255,   0,   0,   0, 255, 156, 157, 158, 255, 196, 197, 199, 255, 196, 197, 199, 255, 120, 121, 122, 255,   0,   0,   0, 255, 
 24,  24,  24, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,  23,   5,   5, 255,   0,   0,   0, 255, 193,  77,  61, 255, 
233,  77,  63, 255, 242,  73,  55, 255, 130,  41,  25, 255,   0,   0,   0, 255,  29,   6,   4, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255, 
  3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255,   3,   3,   3, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 102, 103, 103, 255, 
191, 192, 195, 255, 183, 185, 187, 255, 194, 195, 198, 255, 127, 127, 128, 255,   0,   0,   0, 255,  24,  25,  25, 255,  20,  20,  20, 255,   0,   0,   0, 255, 
102, 103, 103, 255, 193, 194, 196, 255, 181, 182, 185, 255, 191, 192, 194, 255,  85,  85,  86, 255,   0,   0,   0, 255,  37,  38,  38, 255, 176, 178, 180, 255, 
186, 188, 190, 255, 195, 196, 198, 255, 130, 131, 131, 255,   0,   0,   0, 255,  26,  26,  26, 255,  20,  20,  21, 255,   0,   0,   0, 255, 102, 102, 102, 255, 
191, 192, 194, 255, 184, 185, 187, 255, 194, 196, 198, 255, 121, 121, 122, 255,   0,   0,   0, 255, 123, 124, 125, 255, 190, 192, 194, 255, 190, 191, 193, 255, 
164, 165, 167, 255,   0,   0,   0, 255,  18,  18,  18, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255,  99,  99, 100, 255, 190, 191, 193, 255, 187, 188, 191, 255, 180, 182, 184, 255,  56,  56,  57, 255, 
  0,   0,   0, 255, 125, 126, 127, 255, 190, 191, 193, 255, 189, 190, 193, 255, 143, 145, 146, 255,   0,   0,   0, 255,  23,  23,  23, 255,  17,  18,  18, 255, 
  0,   0,   0, 255, 165, 166, 167, 255, 188, 190, 192, 255, 196, 197, 199, 255, 126, 126, 127, 255,   0,   0,   0, 255,  33,  33,  34, 255,   0,   0,   0, 255, 
 88,  89,  90, 255, 188, 189, 191, 255, 187, 188, 190, 255, 184, 185, 187, 255, 170, 171, 173, 255, 171, 172, 173, 255, 170, 171, 173, 255, 172, 173, 175, 255, 
175, 176, 178, 255, 175, 176, 178, 255, 175, 176, 178, 255, 175, 176, 178, 255, 175, 176, 178, 255, 175, 176, 178, 255, 176, 178, 179, 255, 175, 176, 178, 255, 
184, 185, 187, 255, 120, 120, 121, 255,   0,   0,   0, 255, 157, 158, 159, 255, 188, 189, 192, 255, 182, 184, 186, 255, 115, 115, 116, 255,   0,   0,   0, 255, 
 22,  22,  22, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  24,   3,   3, 255,   0,   0,   0, 255, 200,  61,  50, 255, 
233,  67,  54, 255, 245,  89,  54, 255, 130,  50,  23, 255,   0,   0,   0, 255,  29,   7,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  22, 255,   0,   0,   0, 255, 106, 106, 106, 255, 
190, 191, 194, 255, 179, 181, 183, 255, 190, 191, 194, 255, 121, 122, 123, 255,   0,   0,   0, 255,  23,  23,  24, 255,   4,   4,   4, 255,   0,   1,   2, 255, 
  0,   0,   0, 255, 176, 177, 178, 255, 182, 184, 187, 255, 186, 188, 190, 255, 144, 144, 145, 255,   0,   0,   0, 255, 110, 111, 112, 255, 187, 188, 191, 255, 
181, 183, 185, 255, 185, 187, 189, 255,  62,  61,  61, 255,   0,   0,   0, 255,  11,  11,  11, 255,  20,  20,  21, 255,   0,   0,   0, 255, 101, 102, 102, 255, 
187, 188, 191, 255, 177, 178, 181, 255, 191, 192, 195, 255, 119, 119, 120, 255,   0,   0,   0, 255, 109, 110, 111, 255, 186, 187, 190, 255, 185, 186, 189, 255, 
163, 164, 167, 255,   0,   0,   0, 255,  12,  12,  12, 255,   3,   3,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,  23,  23,  24, 255,   0,   0,   0, 255, 115, 116, 117, 255, 190, 191, 194, 255, 183, 185, 188, 255, 167, 169, 171, 255,  22,  22,  22, 255, 
  0,   0,   0, 255, 122, 123, 124, 255, 188, 190, 192, 255, 187, 188, 191, 255, 140, 141, 143, 255,   0,   0,   0, 255,  22,  22,  23, 255,  16,  17,  17, 255, 
  0,   0,   0, 255, 163, 163, 165, 255, 184, 185, 188, 255, 192, 193, 196, 255, 125, 125, 126, 255,   0,   0,   0, 255,  30,  30,  31, 255,   0,   0,   0, 255, 
 62,  62,  63, 255, 178, 180, 182, 255, 186, 187, 190, 255, 170, 172, 174, 255,  27,  27,  26, 255,   0,   0,   0, 255,   8,   8,   6, 255,   8,   8,   6, 255, 
 15,  15,  13, 255,  15,  15,  12, 255,  15,  15,  12, 255,  15,  15,  13, 255,  14,  14,  12, 255,  18,  18,  16, 255,  23,  23,  22, 255,  20,  20,  19, 255, 
 19,  19,  17, 255,  16,  17,  17, 255,   0,   0,   0, 255, 151, 151, 153, 255, 163, 166, 169, 255, 174, 171, 171, 255, 115, 107, 104, 255,   0,   0,   0, 255, 
 21,  19,  19, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  23,   4,   3, 255,   0,   0,   0, 255, 199,  55,  44, 255, 
224,  76,  48, 255, 247, 105,  52, 255, 131,  57,  22, 255,   0,   0,   0, 255,  29,   9,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 105, 106, 106, 255, 
188, 190, 192, 255, 173, 175, 178, 255, 171, 173, 176, 255, 120, 121, 122, 255,   0,   0,   0, 255,  22,  23,  23, 255,   1,   1,   1, 255,  26,  27,  27, 255, 
  0,   0,   0, 255, 141, 142, 143, 255, 182, 184, 187, 255, 173, 175, 178, 255, 173, 175, 177, 255,   0,   0,   0, 255, 157, 159, 161, 255, 182, 184, 187, 255, 
184, 186, 189, 255, 157, 158, 159, 255,   0,   0,   0, 255,  24,  24,  25, 255,   1,   1,   1, 255,  20,  20,  20, 255,   0,   0,   0, 255, 101, 101, 101, 255, 
185, 186, 189, 255, 172, 174, 177, 255, 186, 188, 191, 255, 118, 119, 120, 255,   0,   0,   0, 255,  85,  86,  87, 255, 179, 181, 184, 255, 179, 181, 184, 255, 
170, 172, 175, 255,  54,  55,  56, 255,   0,   0,   0, 255,   9,   9,  10, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  0,   0,   0, 255,  27,  27,  27, 255,   0,   0,   0, 255, 145, 146, 148, 255, 184, 187, 189, 255, 181, 184, 187, 255, 153, 155, 157, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 121, 122, 123, 255, 184, 186, 189, 255, 183, 185, 188, 255, 137, 138, 141, 255,   0,   0,   0, 255,  22,  22,  22, 255,  16,  16,  17, 255, 
  0,   0,   0, 255, 161, 162, 164, 255, 180, 182, 185, 255, 189, 191, 194, 255, 124, 125, 125, 255,   0,   0,   0, 255,  27,  28,  28, 255,   0,   0,   0, 255, 
 24,  25,  25, 255, 167, 169, 171, 255, 183, 185, 188, 255, 176, 178, 181, 255,  57,  58,  59, 255,   0,   0,   0, 255,   8,   8,   9, 255,   0,   0,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   3,   3,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  18,  19,  19, 255,   0,   0,   0, 255, 143, 144, 146, 255, 174, 173, 175, 255, 180, 160, 154, 255, 115,  93,  86, 255,   0,   0,   0, 255, 
 22,  16,  15, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  20,   5,   3, 255,   0,   0,   0, 255, 194,  67,  40, 255, 
244, 100,  51, 255, 248, 118,  48, 255, 132,  65,  20, 255,   0,   0,   0, 255,  29,  10,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 105, 105, 106, 255, 
187, 188, 191, 255, 172, 173, 176, 255, 181, 182, 185, 255, 121, 122, 123, 255,   0,   0,   0, 255,  23,  23,  23, 255,   2,   2,   2, 255,  16,  16,  16, 255, 
  0,   0,   0, 255,  84,  84,  84, 255, 183, 184, 186, 255, 174, 175, 178, 255, 180, 181, 184, 255, 132, 132, 133, 255, 177, 178, 181, 255, 174, 175, 178, 255, 
186, 187, 190, 255, 108, 109, 109, 255,   0,   0,   0, 255,  22,  22,  22, 255,   2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 101, 101, 102, 255, 
183, 184, 187, 255, 173, 174, 177, 255, 182, 184, 186, 255, 112, 113, 114, 255,   0,   0,   0, 255,  31,  31,  32, 255, 166, 168, 171, 255, 179, 180, 184, 255, 
184, 185, 188, 255, 115, 116, 118, 255,   0,   0,   0, 255,  29,  30,  30, 255,   0,   0,   0, 255,   2,   2,   2, 255,   2,   2,   2, 255,   1,   1,   1, 255, 
 14,  14,  14, 255,   0,   0,   0, 255,  29,  28,  26, 255, 177, 178, 180, 255, 178, 180, 183, 255, 186, 187, 190, 255, 142, 143, 144, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 120, 121, 122, 255, 184, 185, 188, 255, 182, 184, 187, 255, 151, 151, 153, 255,   0,   0,   0, 255,  22,  22,  22, 255,  15,  16,  16, 255, 
  0,   0,   0, 255, 160, 161, 163, 255, 179, 180, 184, 255, 188, 189, 192, 255, 125, 125, 126, 255,   0,   0,   0, 255,  25,  25,  25, 255,  20,  21,  21, 255, 
  0,   0,   0, 255, 149, 150, 153, 255, 179, 180, 183, 255, 182, 184, 187, 255, 127, 127, 128, 255,   0,   0,   0, 255,  35,  35,  36, 255,   1,   1,   1, 255, 
  5,   5,   5, 255,   5,   5,   5, 255,   5,   5,   5, 255,  13,  13,  13, 255,   0,   0,   0, 255,  59,  59,  59, 255, 174, 175, 176, 255, 175, 176, 178, 255, 
177, 178, 179, 255,  66,  65,  65, 255,   0,   0,   0, 255, 140, 138, 138, 255, 177, 164, 160, 255, 185, 142, 130, 255, 115,  77,  68, 255,   0,   0,   0, 255, 
 22,  13,  11, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  27,   8,   3, 255,   0,   0,   0, 255, 215,  89,  44, 255, 
248, 115,  49, 255, 247, 130,  44, 255, 133,  72,  17, 255,   0,   0,   0, 255,  29,  12,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 105, 105, 105, 255, 
188, 188, 191, 255, 170, 171, 174, 255, 179, 180, 183, 255, 122, 122, 123, 255,   0,   0,   0, 255,  23,  23,  23, 255,   2,   2,   2, 255,   1,   1,   1, 255, 
 18,  18,  19, 255,   0,   0,   0, 255, 169, 170, 171, 255, 182, 183, 186, 255, 175, 176, 179, 255, 188, 188, 190, 255, 178, 179, 182, 255, 176, 177, 180, 255, 
172, 172, 174, 255,  26,  25,  24, 255,   0,   0,   0, 255,   5,   5,   5, 255,   2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 102, 102, 102, 255, 
182, 182, 185, 255, 159, 160, 163, 255, 172, 172, 175, 255, 105, 105, 107, 255,   0,   0,   0, 255,   0,   0,   0, 255, 133, 134, 136, 255, 183, 184, 187, 255, 
172, 172, 175, 255, 170, 171, 174, 255,  45,  45,  46, 255,   0,   0,   0, 255,  28,  28,  29, 255,  18,  18,  19, 255,  20,  20,  21, 255,  27,  27,  27, 255, 
 11,  12,  13, 255,   0,   0,   0, 255, 150, 150, 152, 255, 178, 178, 181, 255, 153, 154, 157, 255, 183, 184, 186, 255, 100, 100, 100, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 121, 122, 123, 255, 181, 181, 184, 255, 182, 183, 186, 255, 158, 158, 160, 255,   0,   0,   0, 255,  22,  22,  23, 255,  15,  16,  16, 255, 
  0,   0,   0, 255, 160, 160, 162, 255, 179, 180, 183, 255, 189, 189, 192, 255, 120, 120, 120, 255,   0,   0,   0, 255,  31,  32,  32, 255,  29,  29,  30, 255, 
  0,   0,   0, 255, 122, 122, 123, 255, 180, 181, 184, 255, 170, 170, 174, 255, 183, 184, 185, 255,  56,  56,  55, 255,   0,   0,   0, 255,  29,  29,  30, 255, 
 21,  21,  21, 255,  16,  16,  16, 255,  17,  18,  18, 255,  32,  32,  32, 255,   0,   0,   0, 255, 122, 123, 123, 255, 186, 187, 189, 255, 181, 182, 186, 255, 
177, 177, 179, 255,   0,   0,   0, 255,   0,   0,   0, 255, 144, 128, 123, 255, 187, 147, 137, 255, 190, 124, 109, 255, 114,  69,  60, 255,   0,   0,   0, 255, 
 22,  11,   8, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  24,   8,   3, 255,   0,   0,   0, 255, 207,  95,  39, 255, 
248, 129,  45, 255, 255, 145,  41, 255, 134,  76,  16, 255,   0,   0,   0, 255,  30,  14,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 105, 106, 106, 255, 
187, 188, 190, 255, 175, 176, 180, 255, 183, 184, 187, 255, 119, 120, 121, 255,   0,   0,   0, 255,  22,  23,  23, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
 25,  25,  26, 255,   0,   0,   0, 255, 128, 128, 129, 255, 185, 186, 188, 255, 169, 170, 173, 255, 179, 180, 183, 255, 174, 175, 178, 255, 172, 173, 175, 255, 
136, 137, 138, 255,   0,   0,   0, 255,  24,  24,  25, 255,   1,   1,   1, 255,   2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 100, 100, 101, 255, 
185, 186, 188, 255, 161, 162, 165, 255, 166, 167, 170, 255, 108, 108, 109, 255,   0,   0,   0, 255,   0,   0,   0, 255,  59,  59,  60, 255, 178, 179, 182, 255, 
157, 158, 161, 255, 167, 168, 171, 255, 158, 159, 162, 255,  58,  59,  60, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 146, 147, 147, 255, 190, 191, 193, 255, 168, 169, 172, 255, 172, 173, 175, 255, 159, 159, 160, 255,   0,   0,   0, 255,  32,  32,  33, 255, 
  0,   0,   0, 255, 121, 121, 122, 255, 184, 185, 188, 255, 179, 180, 183, 255, 157, 158, 159, 255,   0,   0,   0, 255,  22,  22,  23, 255,  15,  16,  16, 255, 
  0,   0,   0, 255, 162, 163, 164, 255, 178, 179, 182, 255, 185, 186, 189, 255, 141, 141, 142, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  26,  25,  23, 255, 176, 176, 178, 255, 173, 174, 177, 255, 180, 181, 184, 255, 178, 179, 180, 255,  73,  73,  73, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  86,  87,  88, 255, 166, 167, 170, 255, 173, 175, 178, 255, 187, 188, 191, 255, 
126, 126, 126, 255,   0,   0,   0, 255,   0,   0,   0, 255, 132, 100,  91, 255, 172, 116, 103, 255, 185, 109,  93, 255, 118,  65,  55, 255,   0,   0,   0, 255, 
 22,   9,   7, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  22,   9,   2, 255,   0,   0,   0, 255, 210, 108,  36, 255, 
178,  95,  25, 255, 226, 132,  32, 255, 135,  77,  15, 255,   0,   0,   0, 255,  28,  13,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 104, 104, 105, 255, 
185, 186, 189, 255, 167, 169, 172, 255, 177, 179, 182, 255, 119, 119, 120, 255,   0,   0,   0, 255,  22,  22,  22, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
 10,  10,  10, 255,   0,   0,   0, 255,  64,  64,  63, 255, 173, 174, 175, 255, 168, 170, 174, 255, 174, 176, 179, 255, 171, 173, 176, 255, 178, 180, 183, 255, 
 83,  83,  84, 255,   0,   0,   0, 255,  16,  16,  16, 255,   2,   2,   2, 255,   2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 101, 102, 102, 255, 
177, 178, 181, 255, 162, 164, 167, 255, 168, 170, 173, 255, 101, 101, 102, 255,   0,   0,   0, 255,  32,  32,  32, 255,   0,   0,   0, 255, 122, 123, 124, 255, 
184, 185, 188, 255, 156, 158, 161, 255, 163, 165, 168, 255, 170, 172, 175, 255, 137, 139, 141, 255, 102, 103, 105, 255, 108, 108, 110, 255, 136, 136, 137, 255, 
176, 177, 179, 255, 183, 185, 187, 255, 146, 148, 151, 255, 170, 172, 175, 255, 188, 189, 190, 255,  60,  59,  59, 255,   0,   0,   0, 255,  29,  29,  29, 255, 
  0,   0,   0, 255, 118, 119, 120, 255, 173, 175, 177, 255, 173, 175, 178, 255, 152, 153, 154, 255,   0,   0,   0, 255,  20,  21,  21, 255,  23,  23,  24, 255, 
  0,   0,   0, 255, 159, 159, 161, 255, 175, 176, 179, 255, 169, 171, 174, 255, 178, 179, 182, 255, 171, 172, 173, 255, 161, 162, 163, 255, 148, 149, 150, 255, 
 23,  22,  21, 255,   0,   0,   0, 255, 101, 101, 101, 255, 187, 189, 191, 255, 168, 170, 173, 255, 172, 174, 177, 255, 176, 177, 179, 255, 145, 146, 147, 255, 
119, 120, 121, 255,  88,  89,  90, 255, 100, 102, 103, 255, 128, 130, 132, 255, 163, 164, 167, 255, 172, 174, 177, 255, 167, 168, 171, 255, 158, 159, 160, 255, 
  0,   0,   0, 255,  11,   5,   4, 255,   0,   0,   0, 255, 103,  61,  52, 255, 160,  93,  78, 255, 166,  87,  72, 255,  78,  34,  26, 255,   0,   0,   0, 255, 
 13,   4,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   6,   3,   2, 255,   0,   0,   2, 255, 188, 104,  27, 255, 
159,  90,  17, 255, 207, 122,  26, 255, 122,  71,  12, 255,   0,   0,   0, 255,  25,  11,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  21,  21,  21, 255,   0,   0,   0, 255, 107, 107, 108, 255, 
176, 178, 180, 255, 142, 143, 146, 255, 161, 163, 166, 255, 111, 112, 113, 255,   0,   0,   0, 255,  20,  20,  20, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  1,   1,   1, 255,  25,  25,  25, 255,   0,   0,   0, 255, 157, 158, 159, 255, 177, 179, 182, 255, 166, 168, 171, 255, 172, 174, 177, 255, 155, 157, 159, 255, 
  0,   0,   0, 255,  15,  16,  16, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 103, 104, 104, 255, 
168, 169, 172, 255, 158, 160, 163, 255, 176, 178, 180, 255, 105, 106, 108, 255,   0,   0,   0, 255,  20,  20,  21, 255,  18,  18,  19, 255,   0,   0,   0, 255, 
132, 133, 133, 255, 171, 173, 175, 255, 132, 133, 135, 255, 136, 138, 140, 255, 147, 149, 152, 255, 152, 154, 157, 255, 160, 162, 165, 255, 160, 162, 165, 255, 
162, 164, 168, 255, 153, 155, 158, 255, 169, 170, 173, 255, 179, 180, 182, 255,  75,  75,  75, 255,   0,   0,   0, 255,  23,  23,  23, 255,  20,  21,  21, 255, 
  0,   0,   0, 255, 120, 121, 122, 255, 166, 168, 171, 255, 157, 159, 162, 255, 148, 148, 150, 255,   0,   0,   0, 255,  18,  18,  19, 255,  23,  23,  23, 255, 
  0,   0,   0, 255, 122, 123, 123, 255, 178, 180, 182, 255, 147, 149, 152, 255, 154, 156, 159, 255, 143, 144, 147, 255, 147, 148, 151, 255, 155, 156, 158, 255, 
 40,  40,  39, 255,   8,   9,  10, 255,   0,   0,   0, 255, 109, 110, 110, 255, 153, 154, 156, 255, 168, 170, 173, 255, 154, 156, 159, 255, 141, 143, 145, 255, 
137, 139, 141, 255, 106, 107, 109, 255, 123, 124, 126, 255, 151, 153, 156, 255, 165, 167, 170, 255, 161, 163, 165, 255, 162, 163, 164, 255,  29,  28,  27, 255, 
  0,   0,   0, 255,  28,  18,  17, 255,   0,   0,   0, 255, 151,  87,  74, 255, 181,  97,  81, 255,  78,  20,   9, 255,  52,  13,   9, 255,   0,   3,   3, 255, 
  6,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  11,   5,   2, 255,   0,   0,   2, 255, 189, 109,  25, 255, 
243, 143,  34, 255, 255, 167,  38, 255, 136,  91,  16, 255,   0,   0,   0, 255,  31,  18,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  19,  19,  19, 255,   0,   0,   0, 255, 101, 101, 101, 255, 
163, 164, 165, 255, 120, 120, 122, 255, 135, 137, 139, 255, 101, 102, 103, 255,   0,   0,   0, 255,  17,  17,  17, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,  20,  20,  20, 255,   0,   0,   0, 255, 100, 100, 100, 255, 174, 175, 177, 255, 156, 157, 160, 255, 153, 155, 157, 255, 101, 102, 103, 255, 
  0,   0,   0, 255,  18,  18,  19, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,  18,  18,  18, 255,   0,   0,   0, 255,  93,  93,  93, 255, 
169, 171, 173, 255, 158, 160, 162, 255, 152, 154, 157, 255,  88,  89,  90, 255,   0,   0,   0, 255,  16,  16,  16, 255,   3,   3,   3, 255,  18,  18,  19, 255, 
  0,   0,   0, 255,  98,  98,  99, 255, 146, 146, 148, 255, 146, 147, 148, 255, 150, 151, 154, 255, 157, 159, 161, 255, 166, 167, 170, 255, 155, 157, 159, 255, 
172, 173, 176, 255, 170, 171, 173, 255, 143, 144, 144, 255,  34,  33,  32, 255,   0,   0,   0, 255,  24,  24,  25, 255,   0,   0,   0, 255,  18,  18,  19, 255, 
  0,   0,   0, 255, 103, 104, 105, 255, 152, 154, 156, 255, 155, 157, 159, 255, 138, 139, 141, 255,   0,   0,   0, 255,  18,  19,  19, 255,   2,   2,   2, 255, 
 10,  10,  11, 255,   0,   0,   0, 255, 131, 132, 132, 255, 162, 163, 165, 255, 161, 163, 165, 255, 131, 132, 134, 255, 137, 139, 142, 255, 131, 133, 135, 255, 
 29,  29,  29, 255,   0,   0,   0, 255,  24,  25,  25, 255,   0,   0,   0, 255,  77,  77,  77, 255, 146, 147, 148, 255, 157, 158, 160, 255, 167, 169, 172, 255, 
147, 149, 151, 255, 141, 142, 145, 255, 150, 151, 153, 255, 168, 170, 172, 255, 173, 174, 176, 255, 140, 141, 141, 255,  18,  17,  15, 255,   0,   0,   0, 255, 
 17,  17,  17, 255,  19,   5,   3, 255,   0,   0,   0, 255, 140,  72,  60, 255, 173,  81,  67, 255, 150,  53,  42, 255, 107,  37,  29, 255,   0,   0,   0, 255, 
 19,   4,   4, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   6,   3,   2, 255,   6,   6,   2, 255, 160,  92,  19, 255, 
209, 127,  28, 255, 236, 167,  36, 255, 123,  94,  16, 255,   0,   0,   0, 255,  27,  18,   3, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255,   2,   2,   2, 255, 
  1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   0,   0,   0, 255,   7,   7,   6, 255, 
 60,  60,  59, 255,  59,  59,  59, 255,  29,  29,  30, 255,   5,   6,   6, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  1,   1,   1, 255,   0,   0,   0, 255,   6,   6,   6, 255,   0,   0,   0, 255,  53,  53,  52, 255,  45,  45,  45, 255,   3,   4,   4, 255,   0,   0,   0, 255, 
  4,   4,   5, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   0,   0,   0, 255,  12,  12,  12, 255, 
 58,  57,  57, 255,  52,  51,  51, 255,  17,  18,  19, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 23,  24,  24, 255,   0,   0,   0, 255,   0,   0,   0, 255,  79,  79,  79, 255, 117, 118, 118, 255, 123, 124, 125, 255, 122, 122, 123, 255, 121, 122, 123, 255, 
100, 101, 101, 255,  41,  41,  40, 255,   0,   0,   0, 255,   0,   0,   0, 255,  20,  20,  20, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  1,   1,   1, 255,   0,   0,   0, 255,  17,  18,  19, 255,  49,  50,  50, 255,  31,  31,  30, 255,   0,   0,   0, 255,   2,   2,   2, 255,   1,   1,   1, 255, 
  1,   1,   1, 255,   5,   5,   6, 255,   0,   0,   0, 255,   0,   0,   0, 255,  59,  58,  58, 255,  53,  54,  54, 255,  28,  29,  30, 255,  23,  24,  24, 255, 
  0,   0,   0, 255,   1,   1,   1, 255,   0,   0,   0, 255,  24,  24,  24, 255,   0,   0,   0, 255,   0,   0,   0, 255,  70,  70,  70, 255, 109, 110, 110, 255, 
122, 122, 123, 255, 113, 114, 114, 255, 118, 118, 119, 255, 104, 104, 104, 255,  36,  36,  34, 255,   0,   0,   0, 255,   0,   0,   0, 255,  14,  14,  14, 255, 
  0,   0,   0, 255,   2,   1,   1, 255,   0,   0,   0, 255,  26,   6,   5, 255,  47,  15,  11, 255,  60,  19,  15, 255,  28,   4,   3, 255,   0,   0,   0, 255, 
  3,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   3,   2,   1, 255,   0,   0,   0, 255,  49,  26,   3, 255, 
 41,  27,   3, 255,  25,  28,   3, 255,  11,  11,   1, 255,   0,   0,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   6,   6,   6, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   5,   5,   5, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  17,  17,  18, 255,  12,  12,  13, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  25,  25,  25, 255,   6,   6,   6, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   1,   1,   1, 255,  21,  22,  22, 255,   2,   2,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  14,  14,  14, 255,  17,  17,  18, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  24,  24,  24, 255,   4,   4,   4, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   3,   1,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255, 
  8,   8,   8, 255,   7,   7,   7, 255,   3,   3,   3, 255,   1,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   8,   8,   8, 255,   6,   6,   6, 255,   3,   3,   3, 255,   1,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255, 
  8,   8,   8, 255,   7,   7,   7, 255,   3,   3,   3, 255,   1,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  10,  10,  10, 255,  21,  21,  22, 255,  22,  22,  23, 255,  21,  21,  22, 255,  23,  23,  23, 255, 
 18,  18,  18, 255,   4,   4,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   1,   1,   1, 255,   3,   3,   3, 255,   6,   6,   6, 255,   4,   4,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   7,   7,   7, 255,   5,   5,   6, 255,   3,   3,   3, 255,   3,   3,   3, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   9,   9,   9, 255,  21,  21,  21, 255, 
 22,  22,  22, 255,  18,  19,  19, 255,  21,  22,  22, 255,  19,  19,  19, 255,   4,   4,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   3,   1,   0, 255,   6,   1,   1, 255,   5,   1,   0, 255,   2,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   6,   2,   0, 255, 
  8,   3,   0, 255,   8,   4,   0, 255,   2,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  2,   2,   2, 255,  11,  11,  11, 255,  11,  11,  11, 255,   8,   8,   8, 255,   4,   4,   4, 255,  14,  14,  14, 255,  14,  14,  15, 255,  14,  14,  15, 255, 
 14,  14,  15, 255,  15,  15,  15, 255,  13,  13,  13, 255,  12,  12,  12, 255,   1,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   5,   5,   5, 255,  15,  15,  15, 255,  14,  14,  14, 255,  14,  14,  15, 255,  14,  14,  15, 255,  14,  14,  15, 255,  14,  14,  15, 255, 
 14,  14,  15, 255,  14,  14,  14, 255,  14,  14,  14, 255,  15,  15,  15, 255,  10,   9,   9, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  2,   1,   1, 255,  16,  13,  12, 255,  14,  10,  10, 255,  15,  12,  11, 255,  17,  12,  11, 255,  13,   9,   8, 255,  16,  11,  10, 255,  16,  10,   9, 255, 
 13,   8,   7, 255,   9,   5,   5, 255,  16,  10,   9, 255,  10,   5,   5, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   9,   2,   1, 255,   0,   0,   0, 255, 
 13,   3,   2, 255,  23,   5,   4, 255,  11,   2,   1, 255,   0,   0,   0, 255,   5,   1,   0, 255,   5,   0,   0, 255,   6,   1,   0, 255,  13,   1,   1, 255, 
 18,   2,   2, 255,  23,   3,   2, 255,  24,   2,   2, 255,  12,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   2,   2, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  4,   4,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   4,   4,   4, 255,   0,   0,   0, 255,   2,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   6,   4,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  22,   4,   3, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   9,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   2,   3, 255,   0,   0,   0, 255, 
 36,  36,  37, 255,  89,  89,  90, 255,  89,  89,  90, 255,  73,  73,  74, 255,  61,  60,  61, 255, 102, 102, 103, 255, 103, 103, 105, 255, 103, 103, 104, 255, 
103, 103, 104, 255, 104, 104, 105, 255,  99,  99, 100, 255,  93,  93,  94, 255,  23,  23,  23, 255,   0,   0,   0, 255,   1,   1,   2, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   6,   6,   7, 255, 
  0,   0,   0, 255,  58,  57,  58, 255, 105, 105, 107, 255, 102, 103, 104, 255, 107, 107, 108, 255, 103, 104, 106, 255, 102, 103, 105, 255, 102, 103, 105, 255, 
102, 103, 105, 255, 102, 103, 105, 255, 102, 102, 103, 255, 106, 105, 106, 255,  87,  86,  86, 255,   0,   0,   0, 255,   9,   8,   8, 255,   0,   0,   0, 255, 
 33,  30,  29, 255, 108,  98,  95, 255, 101,  90,  88, 255, 106,  94,  90, 255, 112,  96,  93, 255,  92,  76,  72, 255, 106,  88,  83, 255, 104,  85,  80, 255, 
 93,  76,  71, 255,  84,  68,  63, 255, 113,  90,  83, 255,  84,  64,  60, 255,   0,   0,   0, 255,  10,   6,   5, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  20,   6,   5, 255,  57,  27,  22, 255,   0,   0,   0, 255, 
106,  49,  41, 255, 140,  67,  57, 255,  88,  39,  32, 255,   0,   0,   0, 255,  35,  14,   8, 255,  39,  19,  12, 255,  49,  21,  14, 255,  93,  35,  29, 255, 
120,  44,  38, 255, 137,  47,  43, 255, 145,  45,  43, 255, 105,  31,  29, 255,   0,   0,   0, 255,  12,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255, 
  0,   0,   0, 255, 128, 128, 130, 255, 136, 135, 137, 255, 116, 115, 117, 255, 122, 122, 123, 255, 144, 144, 146, 255, 145, 145, 147, 255, 144, 144, 147, 255, 
144, 144, 146, 255, 146, 146, 148, 255, 136, 136, 137, 255, 137, 137, 138, 255,  70,  70,  71, 255,   0,   0,   0, 255,   9,   9,  10, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,  15,  15, 255, 
  0,   0,   0, 255, 106, 107, 108, 255, 151, 151, 153, 255, 134, 133, 134, 255, 105, 104, 105, 255, 144, 141, 142, 255, 148, 143, 144, 255, 148, 142, 142, 255, 
149, 142, 140, 255, 150, 141, 139, 255, 150, 139, 137, 255, 157, 143, 140, 255, 106,  96,  94, 255,   0,   0,   0, 255,  21,  17,  16, 255,   0,   0,   0, 255, 
 53,  44,  41, 255, 156, 130, 123, 255, 154, 126, 118, 255, 159, 127, 119, 255, 157, 125, 117, 255, 149, 116, 108, 255, 147, 114, 105, 255, 165, 124, 114, 255, 
148, 109,  99, 255, 150, 108,  98, 255, 167, 118, 107, 255, 124,  87,  78, 255,   0,   0,   0, 255,  19,  10,   8, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  22,   3,   3, 255,   0,   0,   0, 255,  93,  39,  33, 255, 177,  76,  66, 255, 141,  51,  45, 255, 
138,  58,  49, 255, 182,  73,  64, 255, 139,  48,  43, 255, 116,  33,  30, 255, 157,  46,  45, 255, 172,  48,  48, 255, 169,  42,  45, 255, 186,  48,  51, 255, 
161,  39,  42, 255, 168,  41,  45, 255, 171,  40,  45, 255,  61,  13,  13, 255,   0,   0,   0, 255,   8,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,  15,  16, 255, 
  0,   0,   0, 255,  99,  99, 100, 255, 144, 144, 146, 255, 140, 140, 142, 255, 143, 143, 145, 255, 139, 139, 141, 255, 138, 138, 140, 255, 139, 139, 140, 255, 
139, 139, 141, 255, 139, 139, 141, 255, 138, 138, 140, 255, 144, 144, 146, 255, 101, 101, 102, 255,   0,   0,   0, 255,  14,  14,  15, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255, 133, 123, 121, 255, 150, 137, 134, 255, 139, 124, 121, 255,  81,  67,  64, 255, 147, 127, 122, 255, 151, 130, 124, 255, 151, 127, 121, 255, 
152, 127, 120, 255, 153, 125, 118, 255, 154, 124, 116, 255, 154, 122, 114, 255,  61,  45,  40, 255,   0,   0,   0, 255,  16,   9,   8, 255,   0,   0,   0, 255, 
 55,  38,  34, 255, 158, 112, 101, 255, 164, 115, 103, 255, 155, 107,  95, 255, 159, 105,  94, 255, 139,  90,  79, 255, 151,  95,  83, 255, 172, 109,  96, 255, 
161, 100,  87, 255, 161,  99,  86, 255, 176, 106,  92, 255, 124,  71,  61, 255,   0,   0,   0, 255,  20,   7,   5, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   6,   0,   0, 255,   0,   0,   0, 255,  14,   2,   1, 255, 144,  39,  39, 255, 156,  42,  43, 255, 152,  43,  43, 255, 
141,  23,  32, 255, 126,  18,  27, 255, 124,  22,  28, 255, 106,  20,  24, 255, 165,  30,  40, 255, 171,  29,  41, 255, 167,  27,  40, 255, 183,  29,  44, 255, 
171,  25,  40, 255, 152,  20,  34, 255,   6,   0,   0, 255,   0,   0,   0, 255,  14,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   9,   9,   9, 255, 
  0,   0,   0, 255,  64,  64,  65, 255, 141, 141, 143, 255, 139, 139, 141, 255, 140, 140, 142, 255, 140, 140, 141, 255, 143, 143, 145, 255, 141, 141, 143, 255, 
139, 139, 141, 255, 140, 140, 142, 255, 139, 139, 141, 255, 143, 143, 145, 255, 124, 125, 127, 255,   0,   0,   0, 255,   6,   5,   5, 255,   0,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  10,   7,   6, 255,   0,   0,   0, 255, 
 68,  55,  52, 255, 155, 127, 119, 255, 154, 124, 116, 255, 159, 126, 118, 255, 133, 104,  96, 255, 135, 104,  96, 255, 162, 122, 112, 255, 159, 118, 108, 255, 
161, 117, 106, 255, 161, 115, 104, 255, 166, 116, 105, 255, 147, 101,  90, 255,   0,   0,   0, 255,   6,   3,   2, 255,   9,   3,   3, 255,   0,   0,   0, 255, 
 58,  33,  28, 255, 165, 101,  88, 255, 172, 102,  89, 255, 153,  87,  75, 255, 168,  96,  83, 255, 169,  94,  81, 255, 160,  87,  75, 255, 162,  86,  74, 255, 
176,  90,  78, 255, 163,  80,  68, 255, 184,  88,  76, 255, 133,  61,  52, 255,   0,   0,   0, 255,  22,   5,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  10,   0,   1, 255,  13,   0,   1, 255,  61,   5,   9, 255, 153,  25,  36, 255, 167,  28,  40, 255,  82,   2,  13, 255,  90,   1,  14, 255, 
178,  30,  43, 255,  77,   6,  13, 255, 139,  20,  31, 255, 145,  21,  32, 255, 163,  26,  38, 255, 154,  24,  36, 255, 153,  25,  36, 255, 191,  34,  47, 255, 
171,  30,  41, 255,  33,   4,   5, 255,   0,   0,   0, 255,  19,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   2, 255, 
  0,   0,   0, 255,   0,   0,   0, 255, 128, 128, 130, 255, 144, 144, 146, 255, 121, 121, 123, 255,  67,  67,  67, 255,  78,  78,  80, 255, 126, 127, 129, 255, 
143, 143, 145, 255, 141, 141, 142, 255, 141, 140, 141, 255, 141, 139, 141, 255, 140, 138, 138, 255,  53,  52,  52, 255,   0,   0,   0, 255,   7,   6,   6, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,  10,   8, 255,   0,   0,   0, 255, 
113,  80,  73, 255, 167, 119, 108, 255, 162, 113, 101, 255, 164, 113, 101, 255, 164, 110,  98, 255, 155, 101,  89, 255, 167, 108,  96, 255, 167, 106,  93, 255, 
168, 104,  91, 255, 168, 102,  89, 255, 175, 104,  91, 255, 123,  71,  61, 255,   0,   0,   0, 255,  20,   7,   5, 255,   9,   2,   1, 255,   0,   0,   0, 255, 
 61,  27,  23, 255, 173,  86,  74, 255, 178,  86,  74, 255, 180,  85,  73, 255, 179,  80,  70, 255, 180,  79,  68, 255, 176,  73,  64, 255, 178,  71,  62, 255, 
178,  69,  61, 255, 166,  61,  54, 255, 183,  64,  59, 255, 129,  42,  38, 255,   0,   0,   0, 255,  20,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 12,   0,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,  96,  11,  19, 255, 138,  20,  31, 255, 109,  13,  22, 255,  87,  10,  17, 255,  51,   3,   6, 255, 
121,  17,  26, 255,  82,   8,  14, 255, 117,  17,  25, 255, 105,  14,  21, 255,  84,   9,  15, 255, 120,  17,  26, 255, 102,  13,  20, 255,  94,  11,  18, 255, 
 76,   8,  14, 255,   0,   0,   0, 255,  20,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  9,   8,   9, 255,   0,   0,   0, 255,  90,  89,  90, 255, 137, 134, 135, 255,  99,  96,  96, 255,  96,  90,  89, 255, 114, 105, 103, 255, 138, 129, 127, 255, 
144, 134, 132, 255, 139, 128, 126, 255, 144, 131, 128, 255, 148, 132, 128, 255, 155, 135, 130, 255,  98,  84,  80, 255,   0,   0,   0, 255,  15,  12,  11, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  11,   3,   3, 255,   0,   0,   0, 255, 
148,  91,  79, 255, 173, 105,  91, 255, 169, 100,  87, 255, 171,  99,  85, 255, 172,  97,  84, 255, 174,  97,  84, 255, 173,  93,  80, 255, 174,  92,  79, 255, 
175,  90,  77, 255, 176,  87,  75, 255, 178,  86,  74, 255,  83,  36,  30, 255,   0,   0,   0, 255,  14,   3,   2, 255,  10,   1,   1, 255,   0,   0,   0, 255, 
 64,  20,  17, 255, 180,  65,  59, 255, 185,  63,  58, 255, 183,  58,  55, 255, 186,  55,  54, 255, 187,  51,  53, 255, 189,  49,  52, 255, 191,  46,  51, 255, 
189,  40,  49, 255, 129,  20,  29, 255, 143,  23,  33, 255, 131,  19,  29, 255,   0,   0,   0, 255,  19,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  13,   0,   1, 255, 
  0,   0,   0, 255,  31,   2,   3, 255, 127,  19,  28, 255,  87,   9,  16, 255,  34,   1,   3, 255,  12,   0,   0, 255,  60,   3,   8, 255,  55,   2,   6, 255, 
  0,   0,   0, 255,  92,  10,  17, 255, 152,  26,  35, 255, 162,  28,  38, 255, 201,  37,  49, 255, 191,  35,  46, 255, 190,  35,  46, 255,  66,   7,  10, 255, 
  0,   0,   0, 255,  23,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  3,   2,   2, 255,   0,   0,   0, 255,  27,  19,  17, 255, 134, 119, 115, 255, 144, 126, 122, 255, 141, 122, 117, 255, 159, 137, 131, 255, 132, 111, 105, 255, 
 83,  65,  61, 255,  99,  76,  70, 255, 155, 122, 113, 255, 156, 122, 113, 255, 162, 124, 115, 255, 134, 101,  93, 255,   0,   0,   0, 255,  14,   8,   7, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  10,   2,   2, 255,   0,   0,   0, 255,  62,  29,  24, 255, 
173,  88,  75, 255, 177,  87,  75, 255, 177,  85,  73, 255, 178,  82,  71, 255, 179,  80,  69, 255, 179,  77,  67, 255, 181,  75,  66, 255, 183,  72,  64, 255, 
181,  69,  61, 255, 186,  67,  61, 255, 170,  57,  53, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255,  11,   0,   1, 255,   0,   0,   0, 255, 
 66,   9,  12, 255, 187,  36,  47, 255, 193,  35,  48, 255, 188,  32,  46, 255, 183,  30,  44, 255, 195,  32,  47, 255, 187,  30,  45, 255, 187,  30,  45, 255, 
196,  32,  48, 255, 188,  32,  46, 255, 201,  35,  49, 255, 148,  24,  35, 255,   0,   0,   0, 255,  25,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  10,   0,   1, 255,   0,   0,   0, 255, 
 48,   4,   6, 255, 144,  24,  33, 255, 179,  32,  43, 255, 167,  29,  39, 255,  87,   9,  16, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 72,   7,  11, 255, 142,  24,  32, 255, 158,  28,  36, 255, 195,  36,  47, 255, 179,  33,  42, 255, 166,  30,  39, 255,  98,  14,  20, 255,   0,   0,   0, 255, 
 26,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  3,   2,   2, 255,   0,   0,   0, 255,  28,  22,  20, 255, 142, 109, 100, 255, 164, 124, 114, 255, 163, 121, 111, 255, 158, 115, 104, 255, 132,  94,  85, 255, 
 72,  48,  44, 255,  99,  70,  64, 255, 148, 102,  92, 255, 165, 111,  99, 255, 166, 110,  97, 255, 161, 104,  92, 255,  44,  25,  21, 255,   0,   0,   0, 255, 
  6,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  21,   3,   2, 255,   0,   0,   0, 255, 116,  42,  37, 255, 
188,  70,  63, 255, 182,  64,  59, 255, 185,  61,  57, 255, 185,  58,  56, 255, 186,  54,  54, 255, 187,  51,  53, 255, 186,  47,  51, 255, 181,  42,  48, 255, 
190,  40,  49, 255, 197,  39,  50, 255, 145,  24,  34, 255,   0,   0,   0, 255,  23,   1,   2, 255,   0,   0,   0, 255,  11,   0,   1, 255,   0,   0,   0, 255, 
 68,   6,  12, 255, 190,  32,  46, 255, 196,  34,  48, 255, 155,  25,  36, 255, 189,  33,  46, 255, 185,  33,  45, 255, 185,  33,  45, 255, 163,  28,  39, 255, 
197,  35,  49, 255, 195,  35,  48, 255, 195,  35,  48, 255, 136,  22,  31, 255,   0,   0,   0, 255,  22,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   8,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255, 
101,  14,  20, 255, 118,  18,  25, 255, 111,  17,  23, 255, 179,  33,  43, 255,  81,   9,  14, 255, 149,  26,  34, 255, 160,  29,  37, 255,  97,  13,  18, 255, 
 53,   3,   6, 255,  99,  14,  19, 255, 194,  37,  46, 255, 205,  40,  49, 255, 146,  26,  33, 255, 103,  16,  21, 255,   0,   0,   0, 255,  23,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   9,   4,   3, 255,   0,   0,   0, 255, 110,  75,  67, 255, 123,  83,  74, 255, 106,  70,  63, 255, 131,  83,  73, 255, 167, 103,  91, 255, 
126,  76,  66, 255, 112,  62,  54, 255, 167,  96,  83, 255, 173,  98,  85, 255, 172,  95,  82, 255, 177,  96,  82, 255,  99,  50,  43, 255,   0,   0,   0, 255, 
 17,   5,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  20,   1,   1, 255,   0,   0,   0, 255, 158,  34,  40, 255, 
195,  41,  50, 255, 189,  36,  47, 255, 191,  34,  47, 255, 191,  32,  47, 255, 192,  31,  47, 255, 192,  31,  47, 255, 191,  31,  46, 255, 190,  31,  46, 255, 
185,  30,  45, 255, 190,  32,  46, 255, 104,  14,  21, 255,   0,   0,   0, 255,  19,   0,   1, 255,   0,   0,   0, 255,  12,   0,   1, 255,   0,   0,   0, 255, 
 68,   7,  12, 255, 192,  35,  47, 255, 196,  35,  48, 255, 171,  29,  41, 255, 193,  35,  47, 255, 202,  37,  50, 255, 162,  27,  38, 255, 167,  29,  39, 255, 
201,  37,  49, 255, 200,  37,  49, 255, 178,  32,  42, 255, 111,  17,  23, 255,   0,   0,   0, 255,  16,   0,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   0,   0, 255,  10,   0,   0, 255,   0,   0,   0, 255, 148,  26,  34, 255, 
152,  27,  35, 255, 136,  23,  30, 255, 136,  23,  30, 255, 147,  25,  33, 255, 176,  33,  41, 255, 155,  28,  35, 255, 167,  31,  39, 255, 183,  35,  43, 255, 
171,  32,  39, 255, 169,  32,  39, 255, 174,  33,  40, 255, 181,  35,  42, 255, 121,  20,  25, 255,   0,   0,   0, 255,  24,   1,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   4,   1,   1, 255,   0,   0,   0, 255,  28,   2,   2, 255, 110,  54,  47, 255, 151,  77,  66, 255, 154,  80,  68, 255, 160,  81,  69, 255, 
158,  78,  67, 255, 175,  85,  73, 255, 181,  85,  73, 255, 175,  78,  68, 255, 173,  75,  65, 255, 187,  78,  68, 255, 143,  56,  49, 255,   0,   0,   0, 255, 
 21,   3,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   0,   0, 255,   0,   0,   0, 255,  48,   4,   6, 255, 186,  31,  45, 255, 
195,  32,  47, 255, 193,  33,  47, 255, 194,  33,  47, 255, 194,  34,  48, 255, 194,  34,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 197,  35,  48, 255, 
187,  33,  46, 255, 175,  31,  43, 255,  44,   3,   5, 255,   0,   0,   0, 255,   5,   0,   0, 255,   0,   0,   0, 255,  12,   0,   1, 255,   0,   0,   0, 255, 
 69,   8,  12, 255, 194,  36,  47, 255, 199,  37,  48, 255, 202,  37,  49, 255, 201,  37,  49, 255, 192,  35,  46, 255, 184,  34,  44, 255, 202,  38,  49, 255, 
201,  38,  48, 255, 196,  36,  47, 255, 191,  36,  46, 255, 152,  27,  35, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255,   9,   0,   0, 255,   0,   0,   0, 255, 116,  19,  24, 255, 160,  30,  36, 255, 
203,  40,  49, 255, 201,  40,  48, 255, 191,  38,  45, 255, 176,  34,  41, 255, 199,  40,  47, 255, 160,  31,  36, 255, 145,  28,  32, 255, 207,  43,  50, 255, 
189,  38,  44, 255, 186,  37,  44, 255, 158,  31,  36, 255,  58,   7,   8, 255,   0,   0,   0, 255,  23,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   8,   1,   1, 255,   0,   0,   0, 255,  54,  22,  19, 255, 178,  78,  68, 255, 187,  80,  69, 255, 179,  70,  62, 255, 181,  67,  60, 255, 
179,  63,  58, 255, 181,  60,  56, 255, 188,  59,  57, 255, 114,  34,  33, 255, 149,  39,  41, 255, 196,  50,  54, 255, 175,  40,  46, 255,  17,   1,   2, 255, 
  0,   0,   0, 255,   4,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  21,   1,   1, 255,   0,   0,   0, 255, 111,  16,  24, 255, 199,  36,  49, 255, 
194,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 199,  36,  49, 255, 187,  33,  46, 255, 186,  33,  45, 255, 198,  36,  48, 255, 
202,  37,  49, 255, 147,  25,  34, 255,   0,   0,   0, 255,  22,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,  12,   0,   1, 255,   0,   0,   0, 255, 
 70,   8,  12, 255, 197,  37,  48, 255, 201,  38,  49, 255, 200,  38,  48, 255, 201,  38,  49, 255, 201,  38,  48, 255, 203,  39,  49, 255, 202,  39,  49, 255, 
202,  39,  49, 255, 199,  38,  48, 255, 197,  38,  47, 255, 150,  27,  34, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  27,   1,   2, 255,   0,   0,   0, 255, 142,  27,  32, 255, 210,  43,  51, 255, 204,  42,  49, 255, 
208,  43,  50, 255, 209,  43,  50, 255, 205,  42,  49, 255, 197,  40,  47, 255, 173,  34,  40, 255, 173,  35,  40, 255, 217,  46,  52, 255, 206,  43,  49, 255, 
176,  35,  41, 255, 211,  45,  50, 255, 132,  25,  29, 255,   0,   0,   0, 255,  25,   1,   1, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  17,   1,   1, 255,   0,   0,   0, 255, 160,  41,  43, 255, 192,  46,  51, 255, 188,  43,  49, 255, 190,  40,  49, 255, 
191,  37,  48, 255, 191,  35,  47, 255, 193,  33,  47, 255, 172,  28,  41, 255, 175,  29,  42, 255, 195,  31,  47, 255, 194,  32,  47, 255,  94,  12,  19, 255, 
  0,   0,   0, 255,  17,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  24,   1,   2, 255,   0,   0,   0, 255, 155,  26,  36, 255, 203,  37,  50, 255, 
196,  36,  48, 255, 198,  36,  48, 255, 198,  36,  48, 255, 198,  37,  48, 255, 200,  37,  49, 255, 194,  36,  47, 255, 194,  36,  47, 255, 200,  37,  48, 255, 
203,  38,  49, 255, 111,  17,  23, 255,   0,   0,   0, 255,  21,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,  12,   0,   1, 255,   0,   0,   0, 255, 
 71,   9,  12, 255, 199,  38,  48, 255, 204,  39,  49, 255, 203,  39,  49, 255, 203,  40,  49, 255, 204,  40,  49, 255, 200,  39,  48, 255, 203,  40,  49, 255, 
205,  41,  49, 255, 203,  41,  49, 255, 214,  44,  52, 255, 152,  29,  34, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  30,   2,   2, 255,   0,   0,   0, 255, 122,  22,  26, 255, 215,  45,  52, 255, 208,  44,  50, 255, 209,  44,  50, 255, 
209,  44,  50, 255, 206,  44,  49, 255, 210,  45,  50, 255, 211,  45,  50, 255, 176,  36,  40, 255, 200,  43,  47, 255, 213,  46,  50, 255, 207,  45,  49, 255, 
167,  35,  38, 255, 129,  25,  27, 255,   0,   0,   0, 255,   0,   0,   0, 255,   4,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  23,   1,   1, 255,   0,   0,   0, 255, 127,  16,  28, 255, 198,  32,  48, 255, 193,  31,  47, 255, 193,  32,  47, 255, 
193,  33,  47, 255, 194,  33,  47, 255, 194,  34,  47, 255, 198,  35,  48, 255, 197,  35,  48, 255, 193,  34,  47, 255, 201,  36,  50, 255, 142,  23,  33, 255, 
  0,   0,   0, 255,  24,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   4,   0,   0, 255,   0,   0,   0, 255,  17,   1,   2, 255, 186,  34,  45, 255, 203,  38,  49, 255, 
199,  37,  48, 255, 200,  38,  48, 255, 201,  38,  49, 255, 200,  38,  48, 255, 199,  38,  48, 255, 202,  39,  49, 255, 202,  39,  49, 255, 203,  39,  49, 255, 
194,  37,  47, 255,  52,   5,   7, 255,   0,   0,   0, 255,   8,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  13,   0,   1, 255,   0,   0,   0, 255, 
 72,   9,  12, 255, 201,  40,  48, 255, 206,  42,  49, 255, 205,  42,  49, 255, 205,  42,  49, 255, 208,  42,  50, 255, 194,  39,  46, 255, 204,  42,  49, 255, 
208,  43,  50, 255, 206,  42,  49, 255, 214,  45,  52, 255, 154,  30,  35, 255,   0,   0,   0, 255,  27,   1,   2, 255,   0,   0,   0, 255,   1,   0,   0, 255, 
  0,   0,   0, 255,  29,   2,   2, 255,   0,   0,   0, 255, 101,  18,  20, 255, 167,  34,  38, 255, 204,  44,  48, 255, 212,  46,  50, 255, 212,  46,  50, 255, 
211,  46,  50, 255, 181,  38,  42, 255, 217,  48,  52, 255, 213,  47,  51, 255, 214,  47,  51, 255, 217,  48,  52, 255, 211,  47,  50, 255, 223,  50,  53, 255, 
172,  37,  39, 255,   0,   0,   0, 255,  15,   0,   1, 255,   6,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  13,   0,   1, 255,   0,   0,   0, 255,  76,   9,  14, 255, 195,  35,  48, 255, 188,  33,  46, 255, 195,  35,  48, 255, 
196,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 196,  35,  48, 255, 201,  37,  49, 255, 176,  31,  42, 255, 
  0,   0,   0, 255,  12,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   1,   1, 255,   0,   0,   0, 255,  98,  14,  19, 255, 204,  39,  50, 255, 201,  39,  49, 255, 
202,  39,  49, 255, 202,  39,  49, 255, 203,  39,  49, 255, 203,  40,  49, 255, 193,  38,  46, 255, 204,  40,  49, 255, 202,  40,  48, 255, 210,  42,  50, 255, 
169,  32,  39, 255,   0,   0,   0, 255,  23,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  13,   1,   1, 255,   0,   0,   0, 255, 
 73,  10,  13, 255, 204,  42,  49, 255, 209,  43,  50, 255, 208,  43,  50, 255, 208,  44,  50, 255, 208,  44,  50, 255, 210,  44,  50, 255, 210,  44,  50, 255, 
209,  44,  50, 255, 208,  44,  49, 255, 217,  47,  52, 255, 156,  32,  35, 255,   0,   0,   0, 255,  27,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 30,   2,   2, 255,   0,   0,   0, 255,  98,  17,  19, 255, 205,  45,  48, 255, 185,  40,  43, 255, 202,  44,  48, 255, 216,  48,  51, 255, 214,  48,  51, 255, 
215,  48,  51, 255, 220,  50,  52, 255, 191,  42,  44, 255, 183,  40,  42, 255, 214,  49,  50, 255, 211,  48,  49, 255, 225,  52,  53, 255, 174,  39,  39, 255, 
  0,   0,   0, 255,  14,   0,   0, 255,  10,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,  24,   1,   2, 255, 145,  25,  34, 255, 158,  28,  38, 255, 199,  36,  49, 255, 
197,  36,  48, 255, 198,  36,  48, 255, 198,  37,  48, 255, 199,  37,  48, 255, 199,  37,  48, 255, 199,  37,  48, 255, 200,  37,  48, 255, 198,  37,  48, 255, 
 78,   9,  14, 255,   0,   0,   0, 255,  14,   0,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255, 149,  27,  33, 255, 210,  42,  51, 255, 203,  40,  48, 255, 
205,  41,  49, 255, 205,  41,  49, 255, 205,  41,  49, 255, 196,  40,  47, 255, 207,  42,  49, 255, 206,  42,  49, 255, 205,  42,  49, 255, 212,  44,  51, 255, 
128,  23,  28, 255,   0,   0,   0, 255,  25,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  13,   1,   1, 255,   0,   0,   0, 255, 
 74,  11,  13, 255, 206,  44,  49, 255, 211,  45,  50, 255, 210,  45,  50, 255, 211,  46,  50, 255, 211,  46,  50, 255, 211,  46,  50, 255, 212,  46,  50, 255, 
212,  47,  50, 255, 211,  46,  50, 255, 220,  49,  52, 255, 158,  33,  36, 255,   0,   0,   0, 255,  28,   2,   2, 255,   0,   0,   0, 255,  27,   2,   2, 255, 
  0,   0,   0, 255,  72,  11,  12, 255, 206,  47,  48, 255, 218,  50,  52, 255, 221,  51,  52, 255, 218,  50,  51, 255, 216,  50,  51, 255, 218,  50,  51, 255, 
213,  49,  50, 255, 211,  48,  49, 255, 191,  44,  44, 255, 208,  48,  48, 255, 188,  43,  43, 255, 217,  51,  51, 255, 185,  42,  42, 255,   0,   0,   0, 255, 
  2,   0,   0, 255,  14,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  21,   1,   1, 255,   0,   0,   0, 255, 125,  21,  28, 255, 204,  38,  49, 255, 199,  37,  48, 255, 
200,  38,  48, 255, 201,  38,  48, 255, 201,  38,  48, 255, 202,  38,  49, 255, 202,  39,  49, 255, 201,  38,  49, 255, 200,  38,  48, 255, 208,  40,  51, 255, 
132,  22,  29, 255,   0,   0,   0, 255,  25,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255,  11,   0,   0, 255,   0,   0,   0, 255, 185,  37,  44, 255, 211,  43,  51, 255, 206,  42,  49, 255, 
207,  43,  50, 255, 208,  43,  50, 255, 208,  43,  50, 255, 205,  43,  49, 255, 208,  44,  50, 255, 208,  44,  50, 255, 210,  44,  50, 255, 205,  43,  49, 255, 
 68,   9,  11, 255,   0,   0,   0, 255,  12,   0,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  14,   1,   1, 255,   0,   0,   0, 255, 
 75,  11,  13, 255, 209,  46,  50, 255, 214,  47,  51, 255, 213,  47,  51, 255, 214,  47,  51, 255, 214,  48,  51, 255, 214,  48,  51, 255, 215,  48,  51, 255, 
215,  48,  51, 255, 214,  48,  51, 255, 223,  51,  53, 255, 160,  34,  36, 255,   0,   0,   0, 255,  27,   1,   2, 255,  22,   1,   1, 255,   0,   0,   0, 255, 
 41,   4,   5, 255, 203,  47,  47, 255, 220,  51,  52, 255, 201,  46,  46, 255, 218,  51,  51, 255, 219,  51,  51, 255, 219,  52,  52, 255, 221,  52,  52, 255, 
218,  52,  51, 255, 213,  50,  50, 255, 226,  54,  53, 255, 221,  53,  52, 255, 231,  56,  54, 255, 192,  45,  44, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 17,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   1,   1, 255,   0,   0,   0, 255,  97,  14,  19, 255, 203,  39,  49, 255, 203,  39,  49, 255, 
202,  39,  49, 255, 202,  39,  49, 255, 204,  40,  49, 255, 197,  38,  48, 255, 199,  39,  48, 255, 205,  40,  49, 255, 203,  40,  48, 255, 211,  42,  51, 255, 
173,  33,  40, 255,   0,   0,   0, 255,  22,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255,  84,  12,  15, 255, 208,  44,  50, 255, 210,  44,  50, 255, 209,  44,  50, 255, 
210,  45,  50, 255, 210,  45,  50, 255, 210,  45,  50, 255, 212,  46,  50, 255, 211,  46,  50, 255, 210,  46,  50, 255, 217,  48,  52, 255, 182,  39,  42, 255, 
  0,   0,   0, 255,  21,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  14,   1,   1, 255,   0,   0,   0, 255, 
 76,  12,  13, 255, 212,  48,  50, 255, 217,  49,  51, 255, 216,  49,  51, 255, 216,  50,  51, 255, 217,  50,  51, 255, 217,  50,  51, 255, 217,  50,  51, 255, 
218,  50,  51, 255, 216,  50,  51, 255, 225,  53,  53, 255, 162,  36,  36, 255,   0,   0,   0, 255,  36,   3,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
195,  46,  45, 255, 226,  54,  53, 255, 221,  53,  52, 255, 213,  51,  50, 255, 213,  51,  50, 255, 223,  54,  52, 255, 222,  54,  52, 255, 222,  54,  52, 255, 
208,  50,  48, 255, 224,  55,  52, 255, 220,  54,  51, 255, 230,  57,  54, 255, 199,  48,  46, 255,   0,   1,   0, 255,   0,   0,   0, 255,  20,   1,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   3,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255, 189,  37,  45, 255, 203,  40,  49, 255, 
203,  41,  49, 255, 204,  41,  49, 255, 210,  43,  50, 255, 179,  36,  43, 255, 187,  38,  45, 255, 210,  43,  50, 255, 206,  42,  49, 255, 204,  42,  49, 255, 
200,  41,  48, 255,  57,   6,   8, 255,   0,   0,   0, 255,   9,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255, 140,  28,  31, 255, 218,  48,  52, 255, 210,  46,  50, 255, 212,  46,  50, 255, 
212,  47,  50, 255, 213,  47,  50, 255, 213,  47,  51, 255, 213,  47,  51, 255, 214,  48,  51, 255, 212,  47,  50, 255, 221,  50,  53, 255, 142,  29,  31, 255, 
  0,   0,   0, 255,  27,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  14,   1,   1, 255,   0,   0,   0, 255, 
 77,  13,  13, 255, 214,  50,  50, 255, 219,  51,  51, 255, 218,  51,  51, 255, 219,  51,  51, 255, 219,  52,  52, 255, 219,  52,  52, 255, 220,  52,  52, 255, 
220,  52,  52, 255, 219,  52,  51, 255, 228,  55,  54, 255, 164,  37,  37, 255,   0,   0,   0, 255,  34,   2,   2, 255,   0,   0,   0, 255, 186,  44,  42, 255, 
230,  56,  54, 255, 221,  54,  51, 255, 223,  55,  52, 255, 224,  55,  52, 255, 225,  55,  52, 255, 224,  55,  52, 255, 225,  55,  52, 255, 225,  56,  52, 255, 
221,  55,  51, 255, 224,  56,  52, 255, 233,  58,  54, 255, 207,  51,  48, 255,  38,   5,   4, 255,   0,   0,   0, 255,  24,   2,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255, 159,  31,  36, 255, 210,  44,  51, 255, 
206,  42,  49, 255, 207,  43,  50, 255, 210,  44,  50, 255, 184,  38,  44, 255, 205,  43,  49, 255, 212,  45,  51, 255, 197,  41,  47, 255, 183,  39,  44, 255, 
217,  47,  52, 255, 120,  22,  25, 255,   0,   0,   0, 255,  23,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  22,   1,   1, 255,   0,   0,   0, 255, 183,  40,  42, 255, 220,  49,  52, 255, 213,  48,  51, 255, 215,  48,  51, 255, 
215,  49,  51, 255, 215,  49,  51, 255, 216,  49,  51, 255, 216,  49,  51, 255, 216,  50,  51, 255, 217,  50,  51, 255, 215,  50,  50, 255,  85,  14,  15, 255, 
  0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,   1,   1, 255,   0,   0,   0, 255, 
 78,  14,  13, 255, 217,  52,  51, 255, 222,  53,  52, 255, 221,  53,  52, 255, 222,  53,  52, 255, 222,  54,  52, 255, 222,  54,  52, 255, 223,  54,  52, 255, 
223,  54,  52, 255, 221,  54,  51, 255, 231,  57,  54, 255, 166,  39,  37, 255,   0,   0,   0, 255,   0,   0,   0, 255, 176,  42,  39, 255, 232,  58,  54, 255, 
224,  55,  52, 255, 226,  56,  53, 255, 226,  56,  53, 255, 226,  57,  53, 255, 227,  57,  53, 255, 227,  57,  53, 255, 227,  57,  53, 255, 228,  58,  53, 255, 
228,  58,  53, 255, 231,  59,  54, 255, 210,  53,  48, 255,  60,  10,   8, 255,   0,   0,   0, 255,  27,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  22,   1,   1, 255,   0,   0,   0, 255, 113,  20,  23, 255, 214,  46,  51, 255, 
209,  45,  50, 255, 210,  45,  50, 255, 211,  45,  50, 255, 208,  45,  49, 255, 211,  46,  50, 255, 212,  46,  50, 255, 212,  46,  50, 255, 212,  46,  50, 255, 
219,  48,  52, 255, 168,  35,  38, 255,   0,   0,   0, 255,  27,   1,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  12,   1,   1, 255,   0,   0,   0, 255,  65,   9,   9, 255, 211,  48,  49, 255, 218,  50,  51, 255, 217,  50,  51, 255, 218,  50,  51, 255, 
218,  50,  51, 255, 218,  51,  51, 255, 218,  51,  51, 255, 219,  51,  51, 255, 218,  51,  51, 255, 224,  53,  53, 255, 194,  45,  45, 255,   0,   0,   0, 255, 
 17,   1,   1, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,   1,   1, 255,   0,   0,   0, 255, 
 79,  14,  13, 255, 219,  54,  51, 255, 225,  55,  52, 255, 224,  55,  52, 255, 224,  55,  52, 255, 225,  55,  52, 255, 225,  56,  52, 255, 225,  56,  52, 255, 
225,  56,  52, 255, 224,  56,  52, 255, 233,  59,  55, 255, 171,  41,  38, 255,   0,   0,   0, 255, 165,  40,  36, 255, 235,  60,  55, 255, 226,  57,  53, 255, 
228,  58,  53, 255, 228,  58,  53, 255, 229,  58,  53, 255, 229,  59,  54, 255, 229,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 229,  59,  54, 255, 
234,  61,  55, 255, 197,  50,  45, 255,  31,   4,   3, 255,   0,   0,   0, 255,  26,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   0,   0, 255,   0,   0,   0, 255,  42,   4,   5, 255, 202,  44,  48, 255, 
215,  47,  51, 255, 212,  47,  50, 255, 213,  47,  51, 255, 214,  48,  51, 255, 214,  48,  51, 255, 214,  48,  51, 255, 215,  48,  51, 255, 214,  48,  51, 255, 
219,  50,  52, 255, 201,  46,  47, 255,  20,   2,   2, 255,   0,   0,   0, 255,   5,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  26,   2,   2, 255,   0,   0,   0, 255, 132,  27,  28, 255, 225,  53,  53, 255, 218,  51,  51, 255, 220,  52,  52, 255, 220,  52,  52, 255, 
220,  53,  52, 255, 221,  53,  52, 255, 221,  53,  52, 255, 221,  53,  52, 255, 220,  53,  51, 255, 229,  56,  54, 255, 157,  36,  34, 255,   0,   0,   0, 255, 
 29,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,   1,   1, 255,   0,   0,   0, 255, 
 80,  15,  14, 255, 222,  55,  52, 255, 227,  57,  53, 255, 226,  57,  53, 255, 227,  57,  53, 255, 227,  57,  53, 255, 228,  58,  53, 255, 228,  58,  53, 255, 
228,  58,  53, 255, 227,  58,  53, 255, 238,  61,  56, 255, 159,  38,  35, 255, 134,  31,  28, 255, 237,  61,  56, 255, 229,  59,  53, 255, 230,  59,  54, 255, 
231,  60,  54, 255, 231,  60,  54, 255, 231,  60,  54, 255, 231,  60,  54, 255, 232,  60,  54, 255, 232,  60,  54, 255, 232,  60,  54, 255, 233,  61,  54, 255, 
231,  61,  54, 255, 101,  22,  19, 255,   0,   0,   0, 255,  30,   2,   2, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  26,   1,   2, 255,   0,   0,   0, 255, 175,  38,  40, 255, 
222,  51,  53, 255, 214,  49,  50, 255, 216,  49,  51, 255, 216,  50,  51, 255, 217,  50,  51, 255, 217,  50,  51, 255, 217,  50,  51, 255, 218,  50,  51, 255, 
218,  50,  51, 255, 220,  51,  52, 255, 106,  20,  21, 255,   0,   0,   0, 255,  21,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  28,   2,   2, 255,   0,   0,   0, 255, 179,  42,  41, 255, 228,  55,  54, 255, 221,  53,  51, 255, 222,  54,  52, 255, 223,  54,  52, 255, 
223,  54,  52, 255, 223,  55,  52, 255, 224,  55,  52, 255, 224,  55,  52, 255, 224,  55,  52, 255, 225,  56,  52, 255, 101,  20,  19, 255,   0,   0,   0, 255, 
 20,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255, 
 81,  16,  14, 255, 224,  57,  52, 255, 230,  59,  54, 255, 229,  59,  53, 255, 229,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 
231,  60,  54, 255, 230,  60,  54, 255, 234,  61,  55, 255, 207,  53,  48, 255, 227,  59,  53, 255, 234,  61,  54, 255, 232,  60,  54, 255, 233,  61,  54, 255, 
233,  61,  54, 255, 233,  61,  54, 255, 234,  62,  54, 255, 234,  62,  54, 255, 234,  62,  54, 255, 235,  62,  55, 255, 235,  62,  55, 255, 234,  62,  54, 255, 
222,  59,  51, 255, 152,  38,  33, 255,   0,   0,   0, 255,  33,   3,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  26,   2,   2, 255,   0,   0,   0, 255, 132,  27,  28, 255, 
224,  52,  53, 255, 217,  50,  51, 255, 219,  51,  51, 255, 219,  51,  51, 255, 219,  52,  52, 255, 220,  52,  52, 255, 220,  52,  52, 255, 220,  52,  52, 255, 
219,  52,  51, 255, 228,  55,  54, 255, 161,  37,  36, 255,   0,   0,   0, 255,  29,   2,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  7,   0,   0, 255,   0,   0,   0, 255,  38,   4,   4, 255, 212,  52,  49, 255, 227,  56,  53, 255, 224,  55,  52, 255, 225,  56,  52, 255, 225,  56,  52, 255, 
226,  56,  53, 255, 226,  56,  53, 255, 226,  57,  53, 255, 226,  57,  53, 255, 231,  58,  54, 255, 207,  52,  48, 255,   0,   0,   0, 255,   7,   0,   0, 255, 
  3,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255, 
 82,  16,  14, 255, 227,  59,  53, 255, 232,  60,  54, 255, 231,  60,  54, 255, 232,  60,  54, 255, 232,  61,  54, 255, 233,  61,  54, 255, 233,  61,  54, 255, 
233,  61,  54, 255, 234,  61,  54, 255, 233,  61,  54, 255, 237,  63,  55, 255, 235,  62,  55, 255, 234,  62,  54, 255, 235,  62,  55, 255, 235,  63,  55, 255, 
236,  63,  55, 255, 236,  63,  55, 255, 236,  63,  55, 255, 237,  63,  55, 255, 237,  64,  55, 255, 237,  64,  55, 255, 238,  64,  55, 255, 237,  64,  55, 255, 
240,  66,  55, 255, 236,  65,  54, 255,  89,  20,  15, 255,   0,   0,   0, 255,  23,   2,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  12,   1,   1, 255,   0,   0,   0, 255,  68,  11,  10, 255, 
215,  51,  51, 255, 222,  53,  52, 255, 221,  53,  52, 255, 222,  54,  52, 255, 222,  54,  52, 255, 222,  54,  52, 255, 223,  54,  52, 255, 223,  54,  52, 255, 
222,  54,  52, 255, 228,  56,  53, 255, 200,  48,  46, 255,   0,   0,   0, 255,  15,   1,   1, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 24,   2,   1, 255,   0,   0,   0, 255, 119,  26,  24, 255, 230,  58,  54, 255, 226,  57,  53, 255, 228,  58,  53, 255, 228,  58,  53, 255, 228,  58,  53, 255, 
228,  58,  53, 255, 229,  58,  53, 255, 229,  59,  54, 255, 228,  58,  53, 255, 237,  61,  56, 255, 171,  42,  38, 255,   0,   0,   0, 255,  31,   2,   2, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255, 
 83,  17,  14, 255, 229,  60,  53, 255, 235,  62,  54, 255, 234,  62,  54, 255, 235,  62,  54, 255, 235,  62,  55, 255, 235,  62,  55, 255, 235,  63,  55, 255, 
236,  63,  55, 255, 236,  63,  55, 255, 237,  63,  55, 255, 236,  63,  55, 255, 237,  64,  55, 255, 238,  64,  55, 255, 238,  64,  55, 255, 238,  65,  55, 255, 
238,  66,  55, 255, 239,  66,  55, 255, 239,  67,  55, 255, 239,  68,  55, 255, 239,  69,  55, 255, 239,  70,  55, 255, 239,  71,  55, 255, 239,  72,  54, 255, 
237,  73,  54, 255, 246,  77,  56, 255, 209,  65,  47, 255,   0,   0,   0, 255,  18,   2,   1, 255,   4,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  23,   1,   1, 255,   0,   0,   0, 255, 
191,  46,  43, 255, 229,  56,  54, 255, 222,  54,  51, 255, 224,  55,  52, 255, 225,  55,  52, 255, 225,  56,  52, 255, 225,  56,  52, 255, 226,  56,  53, 255, 
226,  56,  53, 255, 227,  57,  53, 255, 225,  56,  52, 255,  89,  17,  16, 255,   0,   0,   0, 255,  17,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 31,   2,   2, 255,   0,   0,   0, 255, 173,  43,  39, 255, 237,  61,  56, 255, 228,  59,  53, 255, 228,  58,  53, 255, 230,  59,  54, 255, 231,  60,  54, 255, 
231,  60,  54, 255, 231,  60,  54, 255, 231,  60,  54, 255, 231,  60,  54, 255, 235,  61,  55, 255, 117,  26,  23, 255,   0,   0,   0, 255,  24,   2,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  16,   1,   1, 255,   0,   0,   0, 255, 
 84,  18,  15, 255, 232,  62,  54, 255, 238,  63,  55, 255, 237,  63,  55, 255, 237,  64,  55, 255, 238,  64,  55, 255, 238,  64,  55, 255, 238,  65,  55, 255, 
239,  66,  55, 255, 239,  66,  55, 255, 239,  68,  55, 255, 239,  68,  55, 255, 239,  69,  55, 255, 239,  70,  55, 255, 239,  72,  54, 255, 239,  73,  54, 255, 
239,  74,  54, 255, 239,  75,  54, 255, 239,  76,  54, 255, 239,  76,  54, 255, 239,  77,  54, 255, 239,  78,  54, 255, 239,  79,  54, 255, 239,  80,  54, 255, 
242,  81,  54, 255, 226,  76,  50, 255, 240,  82,  54, 255, 169,  57,  35, 255,   0,   0,   0, 255,  34,   6,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  29,   2,   2, 255,   0,   0,   0, 255, 
150,  35,  32, 255, 234,  59,  55, 255, 222,  55,  52, 255, 221,  56,  52, 255, 228,  58,  53, 255, 227,  58,  53, 255, 228,  58,  53, 255, 228,  58,  53, 255, 
229,  58,  53, 255, 227,  58,  53, 255, 236,  61,  55, 255, 150,  36,  32, 255,   0,   0,   0, 255,  29,   2,   2, 255,   0,   0,   0, 255,   3,   0,   0, 255, 
  7,   0,   0, 255,   0,   0,   0, 255, 211,  54,  49, 255, 236,  61,  55, 255, 232,  60,  54, 255, 224,  58,  52, 255, 231,  60,  54, 255, 233,  61,  54, 255, 
233,  61,  54, 255, 233,  61,  54, 255, 233,  61,  54, 255, 238,  63,  55, 255, 218,  57,  50, 255,  20,   2,   2, 255,   0,   0,   0, 255,   6,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   1,   1, 255,   0,   0,   0, 255, 
 85,  19,  15, 255, 234,  66,  54, 255, 240,  68,  55, 255, 238,  69,  55, 255, 239,  70,  55, 255, 239,  71,  55, 255, 239,  72,  54, 255, 239,  73,  54, 255, 
239,  74,  54, 255, 239,  75,  54, 255, 239,  76,  54, 255, 239,  77,  54, 255, 239,  78,  54, 255, 239,  78,  54, 255, 239,  79,  54, 255, 240,  80,  54, 255, 
240,  81,  54, 255, 240,  81,  53, 255, 240,  82,  53, 255, 240,  83,  53, 255, 240,  84,  53, 255, 240,  85,  53, 255, 240,  85,  53, 255, 240,  86,  53, 255, 
241,  87,  52, 255, 238,  87,  52, 255, 244,  90,  53, 255, 230,  85,  50, 255,  83,  26,  13, 255,   0,   0,   0, 255,  22,   3,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   1,   1, 255,   0,   0,   0, 255, 
 91,  18,  16, 255, 227,  58,  53, 255, 230,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 230,  59,  54, 255, 231,  60,  54, 255, 
231,  60,  54, 255, 230,  60,  53, 255, 238,  62,  55, 255, 196,  50,  44, 255,   0,   0,   0, 255,  26,   2,   1, 255,   0,   0,   0, 255,  21,   1,   1, 255, 
  0,   0,   0, 255, 103,  23,  19, 255, 234,  62,  55, 255, 234,  62,  54, 255, 234,  62,  55, 255, 236,  63,  55, 255, 236,  63,  55, 255, 236,  63,  55, 255, 
236,  63,  55, 255, 236,  63,  55, 255, 235,  63,  55, 255, 244,  66,  57, 255, 185,  48,  41, 255,   0,   0,   0, 255,  32,   3,   2, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   2,   1, 255,   0,   0,   0, 255, 
 85,  22,  14, 255, 235,  74,  53, 255, 240,  77,  54, 255, 239,  77,  54, 255, 239,  78,  54, 255, 239,  79,  54, 255, 239,  80,  54, 255, 240,  80,  54, 255, 
240,  81,  54, 255, 240,  82,  53, 255, 240,  82,  53, 255, 240,  83,  53, 255, 240,  84,  53, 255, 240,  85,  53, 255, 240,  86,  53, 255, 240,  86,  53, 255, 
241,  87,  52, 255, 240,  88,  52, 255, 241,  89,  52, 255, 241,  90,  52, 255, 241,  90,  52, 255, 241,  91,  52, 255, 241,  92,  52, 255, 241,  93,  52, 255, 
241,  94,  52, 255, 240,  94,  51, 255, 231,  91,  49, 255, 239,  95,  51, 255, 207,  83,  43, 255,   0,   0,   0, 255,  19,   3,   0, 255,   3,   0,   0, 255, 
  1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255,  16,   1,   1, 255, 
  0,   0,   0, 255, 207,  53,  47, 255, 236,  61,  55, 255, 231,  60,  53, 255, 232,  60,  54, 255, 235,  61,  54, 255, 233,  61,  54, 255, 233,  61,  54, 255, 
234,  61,  54, 255, 233,  61,  54, 255, 236,  62,  55, 255, 227,  60,  53, 255,  65,  12,   9, 255,   0,   0,   0, 255,  12,   1,   1, 255,  32,   3,   2, 255, 
  0,   0,   0, 255, 164,  41,  36, 255, 244,  66,  57, 255, 236,  63,  55, 255, 238,  64,  55, 255, 238,  64,  55, 255, 238,  65,  55, 255, 238,  65,  55, 255, 
239,  66,  55, 255, 239,  67,  55, 255, 238,  67,  54, 255, 243,  71,  56, 255, 132,  35,  26, 255,   0,   0,   0, 255,  27,   3,   2, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   2,   1, 255,   0,   0,   0, 255, 
 85,  25,  14, 255, 236,  80,  53, 255, 241,  83,  54, 255, 240,  83,  53, 255, 240,  84,  53, 255, 240,  85,  53, 255, 240,  86,  53, 255, 240,  87,  52, 255, 
241,  87,  52, 255, 241,  88,  52, 255, 241,  89,  52, 255, 241,  90,  52, 255, 241,  91,  52, 255, 241,  92,  52, 255, 241,  92,  52, 255, 241,  93,  52, 255, 
240,  94,  51, 255, 243,  96,  52, 255, 241,  96,  51, 255, 241,  96,  51, 255, 242,  97,  51, 255, 242,  98,  51, 255, 242,  99,  51, 255, 242, 100,  51, 255, 
242, 101,  51, 255, 240, 101,  50, 255, 232,  98,  48, 255, 248, 106,  51, 255, 251, 108,  52, 255, 164,  69,  31, 255,   0,   0,   0, 255,  36,  10,   2, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  32,   3,   2, 255, 
  0,   0,   0, 255, 168,  42,  37, 255, 243,  64,  57, 255, 233,  62,  54, 255, 234,  62,  55, 255, 225,  60,  52, 255, 236,  63,  55, 255, 236,  63,  55, 255, 
236,  63,  55, 255, 237,  63,  55, 255, 236,  63,  55, 255, 243,  65,  56, 255, 137,  33,  28, 255,   0,   0,   0, 255,  28,   2,   2, 255,  23,   2,   1, 255, 
  0,   0,   0, 255, 209,  58,  47, 255, 244,  70,  56, 255, 238,  69,  54, 255, 239,  70,  55, 255, 239,  71,  55, 255, 239,  72,  54, 255, 239,  74,  54, 255, 
239,  75,  54, 255, 238,  75,  54, 255, 242,  77,  55, 255, 228,  73,  51, 255,  49,  11,   5, 255,   0,   0,   0, 255,   9,   1,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   2,   1, 255,   0,   0,   0, 255, 
 86,  27,  14, 255, 236,  87,  51, 255, 242,  90,  52, 255, 240,  90,  52, 255, 241,  91,  52, 255, 241,  92,  52, 255, 241,  93,  52, 255, 241,  93,  52, 255, 
241,  94,  52, 255, 241,  95,  51, 255, 241,  96,  51, 255, 241,  97,  51, 255, 242,  97,  51, 255, 242,  98,  51, 255, 242,  99,  51, 255, 240,  99,  50, 255, 
245, 102,  51, 255, 234,  98,  49, 255, 242, 102,  50, 255, 242, 103,  50, 255, 242, 104,  50, 255, 242, 104,  50, 255, 242, 105,  49, 255, 242, 106,  49, 255, 
242, 106,  49, 255, 244, 108,  49, 255, 237, 105,  48, 255, 180,  78,  35, 255, 233, 104,  46, 255, 243, 110,  49, 255,  97,  41,  14, 255,   0,   0,   0, 255, 
 25,   6,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  23,   2,   1, 255, 
  0,   0,   0, 255, 114,  27,  22, 255, 234,  63,  55, 255, 234,  63,  54, 255, 239,  64,  55, 255, 191,  51,  45, 255, 234,  64,  54, 255, 239,  66,  55, 255, 
238,  67,  55, 255, 239,  68,  55, 255, 237,  68,  54, 255, 246,  72,  57, 255, 189,  54,  42, 255,   0,   0,   0, 255,  38,   5,   3, 255,   0,   0,   0, 255, 
 84,  21,  13, 255, 235,  75,  53, 255, 240,  77,  54, 255, 239,  77,  54, 255, 239,  78,  54, 255, 239,  79,  54, 255, 240,  80,  54, 255, 240,  81,  54, 255, 
240,  81,  53, 255, 238,  81,  53, 255, 247,  86,  55, 255, 195,  67,  42, 255,   0,   0,   0, 255,  31,   4,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   2,   1, 255,   0,   0,   0, 255, 
 86,  30,  13, 255, 237,  94,  51, 255, 242,  97,  52, 255, 241,  97,  51, 255, 242,  98,  51, 255, 242,  99,  51, 255, 242,  99,  51, 255, 242, 100,  50, 255, 
242, 101,  50, 255, 242, 102,  50, 255, 242, 102,  50, 255, 242, 103,  50, 255, 242, 104,  50, 255, 242, 105,  50, 255, 240, 104,  49, 255, 248, 109,  51, 255, 
223,  97,  45, 255,  57,  21,   7, 255, 215,  95,  43, 255, 248, 111,  50, 255, 241, 109,  48, 255, 243, 110,  49, 255, 243, 111,  48, 255, 243, 111,  48, 255, 
244, 113,  49, 255, 238, 110,  47, 255, 228, 106,  45, 255, 227, 107,  44, 255, 236, 112,  46, 255, 250, 119,  49, 255, 216, 103,  41, 255,   0,   0,   0, 255, 
 16,   4,   0, 255,   4,   1,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   5,   0,   0, 255, 
  0,   0,   0, 255,  26,   2,   2, 255, 207,  59,  47, 255, 238,  70,  54, 255, 239,  71,  55, 255, 232,  70,  53, 255, 238,  73,  54, 255, 239,  74,  54, 255, 
239,  75,  54, 255, 239,  76,  54, 255, 238,  77,  54, 255, 243,  79,  55, 255, 224,  73,  50, 255,  23,   4,   2, 255,  26,   3,   1, 255,   0,   0,   0, 255, 
151,  49,  31, 255, 246,  85,  55, 255, 238,  82,  53, 255, 240,  84,  53, 255, 240,  85,  53, 255, 240,  85,  53, 255, 240,  86,  53, 255, 240,  87,  52, 255, 
241,  88,  52, 255, 239,  88,  52, 255, 247,  92,  54, 255, 145,  51,  28, 255,   0,   0,   0, 255,  30,   5,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   3,   1, 255,   0,   0,   0, 255, 
 86,  32,  13, 255, 238, 100,  49, 255, 243, 103,  50, 255, 242, 103,  50, 255, 242, 104,  50, 255, 242, 105,  50, 255, 242, 105,  49, 255, 242, 106,  49, 255, 
242, 107,  49, 255, 242, 107,  49, 255, 243, 108,  49, 255, 243, 109,  49, 255, 243, 110,  49, 255, 241, 109,  48, 255, 248, 114,  50, 255, 228, 105,  45, 255, 
 74,  30,   9, 255,   0,   0,   0, 255, 116,  51,  18, 255, 244, 115,  48, 255, 243, 115,  48, 255, 243, 116,  48, 255, 243, 117,  47, 255, 243, 117,  47, 255, 
243, 118,  47, 255, 244, 119,  47, 255, 244, 120,  47, 255, 247, 122,  47, 255, 245, 121,  46, 255, 241, 120,  45, 255, 252, 126,  47, 255, 171,  85,  29, 255, 
  0,   0,   0, 255,  36,  13,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 33,   4,   2, 255,   0,   0,   0, 255, 184,  58,  40, 255, 246,  80,  56, 255, 238,  79,  54, 255, 243,  81,  55, 255, 239,  80,  54, 255, 240,  81,  54, 255, 
240,  82,  53, 255, 240,  83,  53, 255, 240,  83,  53, 255, 240,  84,  53, 255, 242,  86,  53, 255, 118,  38,  21, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
199,  72,  42, 255, 247,  92,  54, 255, 239,  89,  52, 255, 241,  91,  52, 255, 241,  91,  52, 255, 241,  92,  52, 255, 241,  93,  52, 255, 241,  94,  52, 255, 
241,  95,  51, 255, 243,  96,  52, 255, 234,  93,  50, 255,  70,  24,   9, 255,   0,   0,   0, 255,  14,   2,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   3,   1, 255,   0,   0,   0, 255, 
 86,  35,  12, 255, 238, 106,  48, 255, 244, 109,  49, 255, 242, 109,  49, 255, 243, 110,  49, 255, 243, 111,  49, 255, 243, 111,  48, 255, 243, 112,  48, 255, 
243, 113,  48, 255, 243, 113,  48, 255, 243, 114,  48, 255, 243, 115,  48, 255, 241, 114,  48, 255, 247, 118,  48, 255, 233, 112,  45, 255,  86,  38,  11, 255, 
  0,   0,   0, 255,  51,  18,   3, 255,   0,   0,   0, 255, 183,  89,  33, 255, 252, 125,  47, 255, 242, 121,  45, 255, 244, 123,  45, 255, 244, 123,  45, 255, 
244, 124,  45, 255, 244, 125,  44, 255, 244, 125,  44, 255, 244, 126,  44, 255, 244, 127,  44, 255, 244, 127,  44, 255, 245, 128,  43, 255, 244, 128,  43, 255, 
103,  51,  13, 255,   0,   0,   0, 255,  26,   9,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 26,   4,   1, 255,   0,   0,   0, 255, 131,  42,  25, 255, 233,  82,  52, 255, 230,  82,  51, 255, 231,  82,  51, 255, 242,  87,  53, 255, 240,  87,  52, 255, 
241,  88,  52, 255, 241,  89,  52, 255, 241,  90,  52, 255, 239,  90,  51, 255, 249,  95,  54, 255, 176,  66,  36, 255,   0,   0,   0, 255,  67,  21,   8, 255, 
231,  91,  49, 255, 244,  97,  52, 255, 241,  96,  51, 255, 242,  97,  51, 255, 242,  98,  51, 255, 242,  99,  51, 255, 242, 100,  51, 255, 242, 100,  50, 255, 
240, 101,  50, 255, 248, 105,  52, 255, 204,  86,  41, 255,   0,   0,   0, 255,  28,   6,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   4,   1, 255,   0,   0,   0, 255, 
 87,  37,  12, 255, 239, 112,  47, 255, 244, 115,  48, 255, 243, 115,  48, 255, 243, 116,  48, 255, 243, 116,  48, 255, 243, 117,  47, 255, 243, 118,  47, 255, 
243, 118,  47, 255, 243, 119,  46, 255, 244, 120,  46, 255, 242, 120,  46, 255, 247, 123,  46, 255, 239, 119,  44, 255, 102,  48,  14, 255,   0,   0,   0, 255, 
 35,  11,   2, 255,   4,   1,   0, 255,   0,   0,   0, 255,  24,   9,   1, 255, 228, 118,  40, 255, 248, 129,  44, 255, 244, 127,  43, 255, 245, 129,  43, 255, 
245, 129,  43, 255, 245, 130,  43, 255, 245, 130,  43, 255, 245, 131,  42, 255, 245, 132,  42, 255, 245, 132,  42, 255, 244, 132,  41, 255, 251, 137,  43, 255, 
218, 119,  36, 255,   0,   0,   0, 255,  16,   4,   0, 255,   5,   1,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  9,   1,   0, 255,   0,   0,   0, 255,  53,  15,   5, 255, 224,  84,  48, 255, 220,  84,  48, 255, 218,  84,  47, 255, 244,  95,  52, 255, 240,  94,  51, 255, 
241,  95,  51, 255, 241,  96,  51, 255, 241,  97,  51, 255, 240,  97,  51, 255, 247, 101,  52, 255, 218,  89,  45, 255,   0,   0,   0, 255, 136,  54,  25, 255, 
247, 104,  52, 255, 241, 102,  50, 255, 242, 103,  50, 255, 242, 104,  50, 255, 242, 104,  50, 255, 242, 105,  49, 255, 242, 106,  49, 255, 242, 106,  49, 255, 
241, 106,  49, 255, 249, 111,  51, 255, 157,  68,  29, 255,   0,   0,   0, 255,  31,   8,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   4,   1, 255,   0,   0,   0, 255, 
 87,  39,  11, 255, 239, 117,  46, 255, 245, 121,  46, 255, 243, 121,  46, 255, 244, 121,  46, 255, 244, 122,  45, 255, 244, 123,  45, 255, 244, 124,  45, 255, 
244, 124,  44, 255, 244, 125,  44, 255, 243, 125,  44, 255, 248, 128,  44, 255, 242, 126,  43, 255, 115,  57,  16, 255,   0,   0,   0, 255,  37,  13,   2, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  32,  11,   1, 255,   0,   0,   0, 255, 135,  71,  19, 255, 250, 135,  43, 255, 244, 132,  42, 255, 246, 134,  41, 255, 
246, 134,  41, 255, 246, 135,  41, 255, 246, 136,  41, 255, 246, 136,  41, 255, 246, 137,  40, 255, 246, 138,  40, 255, 246, 138,  40, 255, 246, 139,  39, 255, 
251, 142,  40, 255, 150,  84,  21, 255,   0,   0,   0, 255,  33,  14,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  29,   5,   1, 255,   0,   0,   0, 255, 190,  76,  39, 255, 234,  96,  50, 255, 245, 100,  51, 255, 241, 100,  50, 255, 242, 101,  50, 255, 
242, 102,  50, 255, 242, 102,  50, 255, 242, 103,  50, 255, 242, 104,  50, 255, 243, 105,  50, 255, 239, 104,  49, 255,  48,  16,   5, 255, 185,  80,  35, 255, 
250, 111,  51, 255, 241, 107,  48, 255, 243, 109,  49, 255, 243, 110,  49, 255, 243, 110,  49, 255, 243, 111,  48, 255, 243, 112,  48, 255, 243, 112,  48, 255, 
244, 113,  48, 255, 239, 112,  47, 255,  86,  37,  11, 255,   0,   0,   0, 255,  17,   4,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   4,   1, 255,   0,   0,   0, 255, 
 87,  41,  10, 255, 240, 123,  43, 255, 245, 127,  44, 255, 244, 126,  44, 255, 245, 127,  44, 255, 245, 128,  43, 255, 245, 128,  43, 255, 245, 129,  43, 255, 
245, 129,  43, 255, 245, 130,  43, 255, 246, 131,  43, 255, 242, 129,  42, 255, 129,  67,  18, 255,   0,   0,   0, 255,  38,  14,   2, 255,   0,   0,   0, 255, 
  1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  33,  13,   1, 255,   0,   0,   0, 255, 199, 110,  31, 255, 253, 143,  41, 255, 244, 138,  39, 255, 
246, 140,  39, 255, 246, 140,  39, 255, 246, 140,  38, 255, 246, 141,  38, 255, 246, 141,  38, 255, 246, 142,  37, 255, 248, 143,  38, 255, 237, 137,  36, 255, 
239, 138,  36, 255, 248, 143,  38, 255, 107,  60,  11, 255,   0,   0,   0, 255,  27,  11,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  30,   7,   2, 255,   0,   0,   0, 255, 149,  62,  27, 255, 250, 108,  51, 255, 239, 104,  49, 255, 242, 106,  49, 255, 242, 107,  49, 255, 
244, 108,  49, 255, 243, 108,  49, 255, 243, 109,  49, 255, 242, 109,  48, 255, 244, 111,  49, 255, 232, 107,  47, 255, 132,  60,  25, 255, 220, 102,  43, 255, 
248, 116,  49, 255, 242, 114,  48, 255, 243, 115,  48, 255, 243, 115,  48, 255, 243, 116,  48, 255, 243, 117,  47, 255, 243, 117,  47, 255, 242, 117,  47, 255, 
249, 122,  48, 255, 213, 104,  40, 255,   0,   0,   0, 255,  24,   6,   1, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   5,   1, 255,   0,   0,   0, 255, 
 88,  43,  10, 255, 241, 128,  42, 255, 246, 132,  43, 255, 245, 131,  42, 255, 245, 132,  42, 255, 245, 133,  42, 255, 246, 133,  42, 255, 246, 134,  41, 255, 
246, 135,  41, 255, 244, 134,  40, 255, 254, 141,  42, 255, 186, 102,  29, 255,   0,   0,   0, 255,  44,  19,   2, 255,   0,   0,   0, 255,   1,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,   6,   0, 255,   0,   0,   0, 255,  66,  35,   4, 255, 237, 137,  36, 255, 249, 144,  38, 255, 
246, 142,  37, 255, 247, 143,  37, 255, 247, 143,  37, 255, 247, 143,  37, 255, 247, 143,  37, 255, 247, 143,  37, 255, 248, 144,  37, 255, 244, 142,  36, 255, 
242, 141,  36, 255, 253, 148,  38, 255, 221, 128,  32, 255,   0,   0,   0, 255,  13,   4,   0, 255,   5,   2,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  15,   3,   1, 255,   0,   0,   0, 255,  75,  30,   9, 255, 235, 107,  47, 255, 236, 108,  47, 255, 243, 112,  48, 255, 243, 113,  48, 255, 
235, 110,  47, 255, 242, 114,  48, 255, 243, 115,  48, 255, 242, 115,  48, 255, 245, 117,  48, 255, 230, 110,  45, 255, 202,  97,  40, 255, 242, 118,  47, 255, 
243, 119,  47, 255, 243, 120,  46, 255, 244, 120,  46, 255, 244, 121,  46, 255, 244, 122,  45, 255, 244, 123,  45, 255, 244, 123,  45, 255, 242, 123,  44, 255, 
252, 129,  46, 255, 168,  84,  27, 255,   0,   0,   0, 255,  33,  11,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   5,   0, 255,   0,   0,   0, 255, 
 88,  45,   9, 255, 241, 133,  40, 255, 247, 137,  41, 255, 245, 137,  40, 255, 246, 137,  40, 255, 246, 138,  40, 255, 246, 139,  39, 255, 246, 139,  39, 255, 
246, 140,  39, 255, 244, 139,  38, 255, 254, 145,  40, 255, 182, 103,  26, 255,   0,   0,   0, 255,  33,  14,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  35,  15,   1, 255,   0,   0,   0, 255, 155,  89,  20, 255, 254, 148,  38, 255, 
245, 143,  36, 255, 247, 144,  37, 255, 247, 144,  37, 255, 247, 144,  36, 255, 247, 144,  36, 255, 247, 144,  36, 255, 247, 144,  36, 255, 248, 145,  36, 255, 
248, 145,  36, 255, 245, 144,  36, 255, 255, 150,  37, 255, 175, 102,  23, 255,   0,   0,   0, 255,  37,  17,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  27,   7,   1, 255,   0,   0,   0, 255, 208,  99,  40, 255, 249, 120,  49, 255, 241, 117,  47, 255, 243, 118,  47, 255, 
238, 117,  46, 255, 242, 119,  46, 255, 243, 120,  46, 255, 249, 124,  46, 255, 236, 118,  44, 255, 191,  96,  37, 255, 240, 122,  44, 255, 248, 127,  45, 255, 
246, 126,  44, 255, 244, 125,  44, 255, 244, 126,  44, 255, 245, 127,  44, 255, 245, 127,  43, 255, 245, 128,  43, 255, 244, 129,  43, 255, 245, 129,  43, 255, 
244, 129,  43, 255, 102,  51,  12, 255,   0,   0,   0, 255,  21,   6,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  47,   8, 255, 241, 138,  38, 255, 247, 142,  38, 255, 246, 141,  38, 255, 246, 142,  38, 255, 246, 142,  37, 255, 246, 142,  37, 255, 246, 143,  37, 255, 
247, 143,  37, 255, 245, 142,  37, 255, 255, 148,  39, 255, 184, 106,  25, 255,   0,   0,   0, 255,  34,  15,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255,  26,  10,   1, 255,   0,   0,   0, 255, 212, 124,  30, 255, 
253, 149,  37, 255, 245, 144,  36, 255, 247, 145,  36, 255, 247, 145,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 
247, 146,  35, 255, 246, 146,  35, 255, 247, 147,  35, 255, 247, 146,  35, 255, 108,  62,  10, 255,   0,   0,   0, 255,  28,  12,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  32,  11,   1, 255,   0,   0,   0, 255, 163,  80,  27, 255, 251, 127,  47, 255, 243, 123,  44, 255, 247, 126,  45, 255, 
248, 127,  45, 255, 249, 128,  45, 255, 244, 127,  44, 255, 236, 122,  42, 255, 181,  94,  34, 255, 223, 117,  40, 255, 233, 122,  42, 255, 230, 121,  41, 255, 
237, 125,  42, 255, 246, 131,  43, 255, 245, 131,  42, 255, 245, 132,  42, 255, 245, 133,  42, 255, 245, 133,  42, 255, 244, 133,  41, 255, 251, 137,  42, 255, 
221, 121,  36, 255,   0,   0,   0, 255,  16,   4,   0, 255,   2,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  48,   8, 255, 242, 140,  36, 255, 248, 144,  37, 255, 246, 143,  37, 255, 247, 143,  37, 255, 247, 144,  37, 255, 247, 144,  37, 255, 247, 144,  37, 255, 
247, 144,  37, 255, 245, 143,  36, 255, 255, 149,  38, 255, 183, 106,  25, 255,   0,   0,   0, 255,  34,  15,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  24,   9,   1, 255,   0,   0,   0, 255,  97,  55,   8, 255, 
245, 145,  35, 255, 248, 147,  36, 255, 246, 146,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 247, 148,  35, 255, 244, 146,  35, 255, 
246, 147,  35, 255, 249, 149,  35, 255, 244, 146,  34, 255, 252, 151,  36, 255, 221, 132,  30, 255,   0,   0,   0, 255,  11,   5,   0, 255,   6,   2,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  20,   6,   1, 255,   0,   0,   0, 255,  96,  47,  12, 255, 245, 128,  43, 255, 243, 128,  43, 255, 231, 122,  41, 255, 
232, 123,  41, 255, 206, 110,  37, 255, 238, 127,  41, 255, 203, 109,  36, 255, 145,  79,  29, 255, 239, 130,  41, 255, 215, 118,  37, 255, 188, 103,  33, 255, 
203, 112,  35, 255, 248, 137,  41, 255, 245, 136,  40, 255, 246, 137,  40, 255, 246, 138,  40, 255, 246, 138,  39, 255, 244, 138,  39, 255, 254, 144,  40, 255, 
178, 100,  26, 255,   0,   0,   0, 255,  34,  14,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  49,   8, 255, 242, 142,  36, 255, 248, 145,  37, 255, 246, 144,  36, 255, 247, 144,  36, 255, 247, 145,  36, 255, 247, 145,  36, 255, 247, 145,  36, 255, 
247, 145,  36, 255, 245, 144,  36, 255, 255, 150,  37, 255, 183, 107,  25, 255,   0,   0,   0, 255,  34,  15,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  37,  17,   1, 255,   0,   0,   0, 255, 
173, 102,  22, 255, 255, 152,  36, 255, 245, 146,  34, 255, 247, 148,  35, 255, 247, 148,  35, 255, 246, 148,  34, 255, 249, 149,  35, 255, 236, 141,  32, 255, 
163,  96,  21, 255, 240, 144,  33, 255, 251, 151,  35, 255, 245, 148,  34, 255, 255, 155,  36, 255, 180, 108,  23, 255,   0,   0,   0, 255,  35,  17,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   2,   0,   0, 255,  17,   5,   0, 255,   0,   0,   0, 255, 201, 109,  34, 255, 231, 126,  40, 255, 216, 119,  37, 255, 
196, 108,  34, 255, 161,  90,  30, 255, 219, 122,  37, 255, 237, 132,  39, 255, 228, 128,  38, 255, 236, 133,  38, 255, 227, 128,  37, 255, 215, 121,  35, 255, 
210, 119,  35, 255, 251, 144,  39, 255, 245, 140,  38, 255, 246, 141,  38, 255, 246, 142,  37, 255, 246, 142,  37, 255, 246, 142,  37, 255, 248, 144,  38, 255, 
116,  65,  13, 255,   0,   0,   0, 255,  24,   9,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  49,   7, 255, 242, 143,  35, 255, 248, 146,  36, 255, 247, 145,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 247, 146,  35, 255, 
247, 146,  35, 255, 245, 145,  35, 255, 255, 151,  37, 255, 183, 108,  24, 255,   0,   0,   0, 255,  34,  16,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   5,   2,   0, 255,  12,   4,   0, 255, 
  0,   0,   0, 255, 223, 134,  30, 255, 252, 152,  35, 255, 245, 148,  34, 255, 247, 150,  34, 255, 247, 150,  34, 255, 249, 153,  35, 255, 239, 147,  33, 255, 
209, 129,  29, 255, 243, 151,  34, 255, 233, 146,  33, 255, 235, 148,  33, 255, 249, 159,  36, 255, 248, 159,  36, 255, 125,  80,  13, 255,   0,   0,   0, 255, 
 25,  13,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  32,  13,   1, 255,   0,   0,   0, 255, 171,  96,  25, 255, 251, 142,  40, 255, 248, 141,  39, 255, 
237, 135,  37, 255, 237, 135,  37, 255, 236, 135,  37, 255, 239, 137,  37, 255, 239, 138,  37, 255, 239, 138,  37, 255, 208, 121,  33, 255, 204, 118,  33, 255, 
219, 127,  34, 255, 251, 146,  37, 255, 246, 143,  37, 255, 247, 143,  37, 255, 247, 144,  37, 255, 246, 143,  37, 255, 251, 146,  38, 255, 227, 132,  33, 255, 
  0,   0,   0, 255,   1,   0,   0, 255,   5,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  50,   7, 255, 242, 144,  35, 255, 248, 147,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 247, 147,  35, 255, 
247, 148,  35, 255, 245, 146,  34, 255, 255, 153,  36, 255, 183, 109,  24, 255,   0,   0,   0, 255,  34,  16,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  29,  13,   1, 255, 
  0,   0,   0, 255, 120,  73,  12, 255, 250, 157,  36, 255, 247, 157,  35, 255, 248, 158,  35, 255, 248, 159,  36, 255, 248, 161,  36, 255, 247, 162,  36, 255, 
250, 164,  36, 255, 242, 161,  35, 255, 242, 162,  36, 255, 249, 168,  37, 255, 249, 169,  37, 255, 250, 170,  37, 255, 146,  96,  20, 255,   0,   0,   0, 255, 
 28,  17,   1, 255,   1,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  16,   5,   0, 255,   0,   0,   0, 255,  81,  45,   9, 255, 202, 117,  33, 255, 201, 116,  32, 255, 
210, 122,  33, 255, 174, 101,  30, 255, 209, 121,  33, 255, 213, 124,  33, 255, 219, 127,  34, 255, 249, 145,  37, 255, 254, 148,  38, 255, 253, 148,  37, 255, 
252, 147,  37, 255, 246, 144,  36, 255, 247, 144,  36, 255, 247, 144,  36, 255, 247, 144,  36, 255, 245, 144,  36, 255, 255, 150,  38, 255, 188, 109,  25, 255, 
  0,   0,   0, 255,  34,  15,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  50,   7, 255, 242, 145,  34, 255, 248, 149,  35, 255, 246, 148,  35, 255, 247, 148,  34, 255, 247, 148,  34, 255, 247, 148,  34, 255, 247, 148,  34, 255, 
247, 148,  34, 255, 245, 147,  34, 255, 255, 154,  35, 255, 184, 110,  23, 255,   0,   0,   0, 255,  34,  16,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 36,  19,   1, 255,   0,   0,   0, 255, 189, 126,  26, 255, 255, 172,  38, 255, 246, 167,  36, 255, 248, 169,  37, 255, 248, 170,  37, 255, 248, 172,  38, 255, 
247, 173,  38, 255, 248, 174,  38, 255, 241, 170,  37, 255, 242, 172,  38, 255, 209, 148,  32, 255, 249, 179,  39, 255, 236, 172,  37, 255, 174, 127,  25, 255, 
  0,   0,   0, 255,  34,  23,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   4,   1,   0, 255,   5,   1,   0, 255,   0,   0,   0, 255, 222, 129,  33, 255, 231, 135,  35, 255, 
242, 141,  36, 255, 246, 143,  36, 255, 242, 142,  36, 255, 243, 143,  36, 255, 244, 143,  36, 255, 241, 141,  36, 255, 228, 134,  34, 255, 220, 130,  33, 255, 
238, 140,  35, 255, 249, 147,  36, 255, 246, 145,  36, 255, 247, 146,  36, 255, 247, 146,  36, 255, 246, 145,  35, 255, 251, 148,  36, 255, 130,  75,  14, 255, 
  0,   0,   0, 255,  27,  11,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   6,   0, 255,   0,   0,   0, 255, 
 88,  50,   7, 255, 242, 146,  34, 255, 248, 150,  34, 255, 247, 149,  34, 255, 247, 150,  34, 255, 247, 151,  34, 255, 247, 152,  35, 255, 247, 153,  35, 255, 
247, 154,  35, 255, 246, 154,  35, 255, 255, 162,  37, 255, 184, 116,  24, 255,   0,   0,   0, 255,  34,  17,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
 13,   6,   0, 255,   0,   0,   0, 255,  39,  25,   2, 255, 234, 167,  36, 255, 252, 181,  40, 255, 247, 179,  39, 255, 248, 181,  39, 255, 247, 181,  39, 255, 
253, 187,  40, 255, 237, 176,  37, 255, 135, 100,  20, 255, 148, 110,  23, 255, 194, 147,  30, 255, 236, 180,  38, 255, 251, 192,  40, 255, 250, 193,  41, 255, 
107,  82,  13, 255,   0,   0,   0, 255,  26,  18,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  33,  15,   1, 255,   0,   0,   0, 255, 192, 112,  26, 255, 255, 152,  38, 255, 
245, 144,  36, 255, 247, 146,  36, 255, 248, 146,  36, 255, 247, 146,  36, 255, 239, 141,  35, 255, 222, 131,  33, 255, 200, 119,  31, 255, 165,  98,  28, 255, 
236, 140,  34, 255, 249, 148,  35, 255, 246, 146,  35, 255, 247, 147,  35, 255, 246, 146,  35, 255, 250, 149,  35, 255, 233, 139,  33, 255,  40,  20,   2, 255, 
  0,   0,   0, 255,   8,   3,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   7,   0, 255,   0,   0,   0, 255, 
 88,  53,   7, 255, 243, 153,  35, 255, 249, 158,  35, 255, 247, 158,  35, 255, 248, 159,  36, 255, 248, 161,  36, 255, 248, 162,  36, 255, 248, 163,  36, 255, 
248, 164,  36, 255, 246, 164,  36, 255, 255, 172,  38, 255, 184, 123,  25, 255,   0,   0,   0, 255,  34,  19,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,  33,  22,   1, 255,   0,   0,   0, 255, 142, 106,  19, 255, 254, 193,  41, 255, 247, 189,  39, 255, 248, 191,  40, 255, 249, 192,  40, 255, 
239, 186,  39, 255, 246, 193,  41, 255, 243, 192,  41, 255, 239, 190,  40, 255, 249, 199,  43, 255, 229, 184,  39, 255, 212, 171,  36, 255, 254, 208,  45, 255, 
164, 134,  28, 255,   0,   0,   0, 255,  29,  23,   1, 255,   2,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  28,  12,   1, 255,   0,   0,   0, 255, 134,  77,  15, 255, 251, 148,  36, 255, 
246, 146,  35, 255, 247, 146,  35, 255, 247, 147,  35, 255, 246, 146,  35, 255, 247, 147,  35, 255, 249, 149,  35, 255, 244, 146,  35, 255, 244, 146,  35, 255, 
248, 148,  35, 255, 247, 148,  35, 255, 247, 148,  35, 255, 247, 148,  35, 255, 245, 147,  34, 255, 254, 152,  36, 255, 197, 117,  26, 255,   0,   0,   0, 255, 
 33,  15,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   8,   0, 255,   0,   0,   0, 255, 
 89,  57,   8, 255, 243, 163,  36, 255, 249, 168,  37, 255, 248, 168,  37, 255, 248, 169,  37, 255, 248, 170,  37, 255, 248, 172,  38, 255, 248, 173,  38, 255, 
248, 174,  38, 255, 246, 174,  38, 255, 255, 182,  40, 255, 184, 131,  27, 255,   0,   0,   0, 255,  34,  21,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  1,   0,   0, 255,   0,   0,   0, 255,  32,  23,   1, 255,   0,   0,   0, 255, 203, 162,  33, 255, 255, 205,  44, 255, 245, 199,  43, 255, 247, 202,  44, 255, 
201, 166,  36, 255, 242, 200,  44, 255, 249, 207,  45, 255, 249, 208,  45, 255, 248, 208,  46, 255, 232, 197,  43, 255, 235, 201,  44, 255, 249, 213,  47, 255, 
224, 193,  43, 255, 138, 119,  24, 255,   0,   0,   0, 255,  30,  27,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  10,   3,   0, 255,   0,   0,   0, 255,  51,  27,   3, 255, 235, 140,  33, 255, 
250, 149,  35, 255, 246, 147,  35, 255, 247, 148,  35, 255, 247, 148,  34, 255, 247, 148,  34, 255, 246, 148,  34, 255, 248, 149,  34, 255, 248, 149,  34, 255, 
247, 149,  34, 255, 247, 149,  34, 255, 247, 149,  34, 255, 247, 150,  34, 255, 246, 150,  34, 255, 253, 155,  36, 255, 142,  85,  16, 255,   0,   0,   0, 255, 
 30,  14,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,   9,   0, 255,   0,   0,   0, 255, 
 89,  60,   8, 255, 244, 172,  38, 255, 249, 178,  39, 255, 248, 178,  39, 255, 248, 179,  39, 255, 248, 181,  39, 255, 248, 182,  39, 255, 248, 183,  39, 255, 
248, 184,  39, 255, 247, 184,  39, 255, 255, 193,  41, 255, 184, 139,  27, 255,   0,   0,   0, 255,  34,  23,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,  19,  14,   1, 255,   0,   0,   0, 255,  74,  62,   8, 255, 239, 203,  45, 255, 249, 212,  47, 255, 245, 211,  47, 255, 
248, 214,  47, 255, 246, 214,  47, 255, 246, 215,  48, 255, 245, 216,  48, 255, 245, 218,  48, 255, 249, 221,  49, 255, 248, 223,  49, 255, 244, 221,  49, 255, 
251, 229,  51, 255, 244, 225,  50, 255, 114, 105,  19, 255,   0,   0,   0, 255,  29,  26,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  32,  14,   1, 255,   0,   0,   0, 255, 201, 120,  26, 255, 
254, 153,  35, 255, 245, 148,  34, 255, 246, 149,  34, 255, 247, 150,  34, 255, 247, 151,  34, 255, 247, 152,  35, 255, 247, 153,  35, 255, 247, 154,  35, 255, 
247, 155,  35, 255, 248, 156,  35, 255, 248, 158,  35, 255, 247, 158,  35, 255, 250, 161,  36, 255, 238, 155,  34, 255,  64,  39,   4, 255,   0,   0,   0, 255, 
 12,   5,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,  10,   0, 255,   0,   0,   0, 255, 
 89,  64,   9, 255, 244, 182,  39, 255, 249, 188,  40, 255, 248, 188,  39, 255, 248, 189,  40, 255, 248, 191,  40, 255, 248, 192,  40, 255, 248, 193,  41, 255, 
248, 194,  41, 255, 246, 194,  41, 255, 255, 203,  44, 255, 184, 146,  29, 255,   0,   0,   0, 255,  34,  25,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  35,  30,   2, 255,   0,   0,   0, 255, 159, 142,  28, 255, 253, 228,  51, 255, 243, 220,  49, 255, 
246, 225,  49, 255, 246, 226,  50, 255, 244, 226,  49, 255, 246, 229,  50, 255, 245, 230,  50, 255, 244, 230,  50, 255, 243, 231,  50, 255, 248, 237,  51, 255, 
215, 206,  44, 255, 236, 226,  49, 255, 227, 219,  47, 255,   0,   0,   0, 255,   0,   0,   0, 255,   8,   7,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  31,  15,   1, 255,   0,   0,   0, 255, 150,  92,  18, 255, 
254, 159,  36, 255, 249, 158,  35, 255, 252, 161,  36, 255, 250, 161,  36, 255, 247, 160,  36, 255, 248, 162,  36, 255, 248, 163,  36, 255, 248, 164,  36, 255, 
248, 165,  36, 255, 248, 166,  36, 255, 248, 167,  37, 255, 246, 167,  37, 255, 255, 175,  39, 255, 205, 141,  30, 255,   0,   0,   0, 255,  31,  17,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,  12,   0, 255,   0,   0,   0, 255, 
 88,  68,   9, 255, 243, 192,  41, 255, 249, 198,  42, 255, 247, 198,  42, 255, 247, 199,  43, 255, 247, 201,  43, 255, 247, 202,  44, 255, 247, 203,  44, 255, 
247, 204,  44, 255, 245, 204,  44, 255, 255, 213,  47, 255, 183, 154,  32, 255,   0,   0,   0, 255,  34,  27,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   1,   2,   0, 255,  24,  20,   1, 255,   0,   0,   0, 255, 211, 201,  43, 255, 255, 244,  53, 255, 
209, 200,  43, 255, 216, 208,  45, 255, 234, 226,  49, 255, 243, 235,  51, 255, 241, 234,  50, 255, 245, 238,  51, 255, 246, 239,  51, 255, 239, 232,  50, 255, 
129, 126,  26, 255, 228, 222,  47, 255, 255, 249,  54, 255, 178, 173,  35, 255,   0,   0,   0, 255,  34,  32,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,   7,   0, 255,   0,   0,   0, 255,  75,  47,   5, 255, 
245, 164,  36, 255, 213, 142,  33, 255, 181, 121,  31, 255, 241, 163,  36, 255, 247, 169,  37, 255, 246, 169,  37, 255, 246, 171,  38, 255, 246, 172,  38, 255, 
246, 173,  38, 255, 246, 175,  38, 255, 246, 176,  39, 255, 245, 176,  38, 255, 254, 184,  40, 255, 154, 112,  21, 255,   0,   0,   0, 255,  32,  20,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  17,  12,   1, 255,   0,   0,   0, 255, 
 88,  71,  11, 255, 241, 200,  44, 255, 246, 206,  45, 255, 245, 206,  45, 255, 245, 207,  46, 255, 245, 208,  46, 255, 245, 209,  46, 255, 245, 211,  47, 255, 
245, 212,  47, 255, 243, 212,  47, 255, 252, 222,  49, 255, 181, 160,  33, 255,   0,   0,   0, 255,  34,  28,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  25,  24,   1, 255,   0,   0,   0, 255, 100,  98,  16, 255, 245, 238,  51, 255, 
239, 233,  50, 255, 237, 231,  49, 255, 244, 237,  51, 255, 206, 201,  43, 255, 234, 227,  48, 255, 245, 238,  51, 255, 245, 238,  51, 255, 236, 229,  49, 255, 
232, 225,  48, 255, 248, 241,  52, 255, 245, 238,  51, 255, 235, 228,  49, 255,  54,  53,   7, 255,   0,   0,   0, 255,  18,  17,   1, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  29,  17,   1, 255,   0,   0,   0, 255, 
217, 154,  33, 255, 247, 178,  40, 255, 217, 158,  37, 255, 248, 180,  40, 255, 255, 187,  41, 255, 255, 187,  41, 255, 255, 189,  41, 255, 255, 190,  41, 255, 
255, 191,  41, 255, 255, 193,  41, 255, 255, 193,  41, 255, 255, 197,  42, 255, 247, 190,  40, 255,  79,  59,   7, 255,   0,   0,   0, 255,  16,  10,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  18,  15,   1, 255,   0,   0,   0, 255, 
 90,  78,  12, 255, 248, 219,  49, 255, 254, 225,  50, 255, 252, 225,  50, 255, 252, 227,  50, 255, 252, 228,  51, 255, 252, 229,  51, 255, 252, 231,  51, 255, 
252, 232,  51, 255, 250, 232,  51, 255, 255, 243,  54, 255, 187, 175,  36, 255,   0,   0,   0, 255,  35,  32,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  36,  35,   2, 255,   0,   0,   0, 255, 174, 168,  34, 255, 
255, 250,  54, 255, 255, 248,  53, 255, 232, 225,  48, 255, 210, 204,  43, 255, 249, 242,  52, 255, 253, 245,  53, 255, 251, 244,  52, 255, 254, 247,  53, 255, 
247, 240,  52, 255, 246, 239,  51, 255, 239, 232,  50, 255, 203, 197,  42, 255, 181, 176,  37, 255,   0,   0,   0, 255,  20,  19,   1, 255,   3,   3,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  26,  16,   1, 255,   0,   0,   0, 255, 
141, 103,  18, 255, 212, 157,  32, 255, 202, 151,  30, 255, 205, 154,  31, 255, 202, 153,  31, 255, 202, 154,  31, 255, 202, 155,  31, 255, 202, 156,  32, 255, 
202, 157,  32, 255, 201, 158,  32, 255, 200, 158,  32, 255, 206, 164,  34, 255, 177, 142,  28, 255,   0,   0,   0, 255,  17,  11,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  12,  10,   0, 255,   0,   0,   0, 255, 
 70,  63,   8, 255, 196, 180,  38, 255, 200, 185,  39, 255, 199, 185,  39, 255, 199, 186,  39, 255, 199, 187,  39, 255, 199, 188,  40, 255, 199, 190,  40, 255, 
199, 190,  40, 255, 197, 190,  40, 255, 206, 199,  42, 255, 147, 143,  28, 255,   0,   0,   0, 255,  25,  24,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   6,   0, 255,   0,   0,   0, 255,  32,  31,   2, 255, 
190, 184,  38, 255, 201, 195,  40, 255, 200, 194,  40, 255, 199, 193,  40, 255, 198, 193,  40, 255, 199, 194,  40, 255, 199, 193,  40, 255, 200, 194,  40, 255, 
192, 187,  39, 255, 187, 182,  37, 255, 177, 172,  35, 255, 182, 177,  36, 255, 188, 183,  38, 255, 113, 110,  20, 255,   0,   0,   0, 255,  18,  17,   1, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  15,   8,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   9,   4,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   5,   4,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,  13,  12,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   7,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   4,   4,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   0,   0, 255,   0,   0,   0, 255, 
 21,  12,   0, 255,  32,  20,   1, 255,  28,  17,   1, 255,  31,  20,   1, 255,  31,  20,   1, 255,  31,  20,   1, 255,  31,  20,   1, 255,  31,  20,   1, 255, 
 31,  21,   1, 255,  31,  21,   1, 255,  30,  21,   1, 255,  31,  22,   1, 255,  27,  19,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  4,   3,   0, 255,  29,  25,   1, 255,  30,  26,   1, 255,  30,  26,   1, 255,  30,  27,   1, 255,  30,  27,   1, 255,  30,  27,   1, 255,  30,  27,   1, 255, 
 30,  27,   1, 255,  30,  27,   1, 255,  31,  29,   2, 255,  19,  18,   1, 255,   0,   0,   0, 255,   1,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   7,   7,   0, 255, 
 30,  29,   1, 255,  30,  29,   1, 255,  30,  29,   1, 255,  30,  29,   1, 255,  30,  29,   1, 255,  30,  29,   1, 255,  30,  29,   1, 255,  31,  29,   1, 255, 
 27,  26,   1, 255,  28,  27,   1, 255,  28,  27,   1, 255,  21,  20,   1, 255,  29,  28,   1, 255,   3,   2,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 254,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 230,   0,   0,   0, 255,   0,   0,   0, 254,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 184,   0,   0,   0, 255,   0,   0,   0, 252,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 253,   0,   0,   0, 255,   0,   0,   0, 223, 
  0,   0,   0, 118,   0,   0,   0, 255,   0,   0,   0, 250,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 251,   0,   0,   0, 255,   0,   0,   0, 155, 
  0,   0,   0,  37,   0,   0,   0, 252,   0,   0,   0, 255,   0,   0,   0, 254,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 252,   0,   0,   0, 255,   0,   0,   0,  68, 
  0,   0,   0,   0,   0,   0,   0, 167,   0,   0,   0, 255,   0,   0,   0, 250,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 251,   0,   0,   0, 255,   0,   0,   0, 203,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  36,   0,   0,   0, 253,   0,   0,   0, 255,   0,   0,   0, 253,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 252,   0,   0,   0, 255,   0,   0,   0,  68,   0,   0,   0,   0, 
  0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0, 108,   0,   0,   0, 255,   0,   0,   0, 250,   0,   0,   0, 254,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 248,   0,   0,   0, 255,   0,   0,   0, 145,   0,   0,   0,   0,   0,   0,   0,   4, 
  0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0, 149,   0,   0,   0, 255,   0,   0,   0, 250,   0,   0,   0, 253,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 254,   0,   0,   0, 249,   0,   0,   0, 255,   0,   0,   0, 183,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1, 
  0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 145,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 250, 
  0,   0,   0, 254,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 254, 
  0,   0,   0, 250,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 175,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  94,   0,   0,   0, 241,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 251,   0,   0,   0, 251,   0,   0,   0, 252,   0,   0,   0, 252,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253, 
  0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 253,   0,   0,   0, 252,   0,   0,   0, 251,   0,   0,   0, 251,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 253,   0,   0,   0, 120,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,  22,   0,   0,   0, 143, 
  0,   0,   0, 235,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 
  0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 243, 
  0,   0,   0, 158,   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  15,   0,   0,   0,  82,   0,   0,   0, 142,   0,   0,   0, 184,   0,   0,   0, 205,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206, 
  0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 206,   0,   0,   0, 188,   0,   0,   0, 150,   0,   0,   0,  92,   0,   0,   0,  23, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
};


