# -*- tcl -*-
#
# _idx_common.tcl
#
# (c) 2003 Andreas Kupries <andreas_kupries@sourceforge.net>

################################################################
# The code here contains general definitions for API functions and
# state information. They are used by several formatters to simplify
# their own code.

proc idx_initialize    {}             {return}
proc idx_shutdown      {}             {return}
proc idx_numpasses     {}             {return 1}
proc idx_postprocess   {text}         {return $text}
proc idx_setup         {n}            {return}
proc idx_listvariables {}             {return {}}
proc idx_varset        {varname text} {return}


proc fmt_plain_text  {text} {return $text}

################################################################
# Functions made available to the formatter to access the common
# state managed here.

proc c_provenance {} {
    return "Generated by tcllib/doctools/idx with format '[dt_format]'"
}

################################################################
