'\"
'\" Generated from file 'bench_lang_intro\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "bench_lang_intro" n 1\&.0 tcllib "Benchmarking/Performance tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
bench_lang_intro \- bench language introduction
.SH DESCRIPTION
.PP
This document is an informal introduction to version 1 of the bench
language based on a multitude of examples\&. After reading this a
benchmark writer should be ready to understand the formal
\fIbench language specification\fR\&.
.SS FUNDAMENTALS
In the broadest terms possible the \fIbench language\fR is
essentially Tcl, plus a number of commands to support the declaration
of benchmarks\&.
A document written in this language is a Tcl script and has the same
syntax\&.
.PP
.SS BASICS
One of the most simplest benchmarks which can be written in bench is
.CS


bench -desc LABEL -body {
    set a b
}

.CE
This code declares a benchmark named \fBLABEL\fR which measures the
time it takes to assign a value to a variable\&. The Tcl code doing this
assignment is the \fB-body\fR of the benchmark\&.
.SS "PRE- AND POSTPROCESSING"
Our next example demonstrates how to declare \fIinitialization\fR and
\fIcleanup\fR code, i\&.e\&. code computing information for the use of
the \fB-body\fR, and for releasing such resources after the
measurement is done\&.
They are the \fB-pre\fR- and the \fB-post\fR-body, respectively\&.
.PP
In our example, directly drawn from the benchmark suite of Tcllib's
\fBaes\fR package, the concrete initialization code constructs the
key schedule used by the encryption command whose speed we measure,
and the cleanup code releases any resources bound to that schedule\&.
.CS


bench -desc "AES-${len} ECB encryption core" \fB-pre\fR {
    set key [aes::Init ecb $k $i]
} -body {
    aes::Encrypt $key $p
} \fB-post\fR {
    aes::Final $key
}

.CE
.SS "ADVANCED PRE- AND POSTPROCESSING"
Our last example again deals with initialization and cleanup code\&. To
see the difference to the regular initialization and cleanup discussed
in the last section it is necessary to know a bit more about how bench
actually measures the speed of the the \fB-body\fR\&.
.PP
Instead of running the \fB-body\fR just once the system actually
executes the \fB-body\fR several hundred times and then returns the
average of the found execution times\&. This is done to remove
environmental effects like machine load from the result as much as
possible, with outliers canceling each other out in the average\&.
.PP
The drawback of doing things this way is that when we measure
operations which are not idempotent we will most likely not measure
the time for the operation we want, but of the state(s) the system is
in after the first iteration, a mixture of things we have no interest
in\&.
.PP
Should we wish, for example, to measure the time it takes to include
an element into a set, with the element not yet in the set, and the
set having specific properties like being a shared Tcl_Obj, then the
first iteration will measure the time for this\&. \fIHowever\fR all
subsequent iterations will measure the time to include an element
which is already in the set, and the Tcl_Obj holding the set will not
be shared anymore either\&. In the end the timings taken for the several
hundred iterations of this state will overwhelm the time taken from
the first iteration, the only one which actually measured what we
wanted\&.
.PP
The advanced initialization and cleanup codes, \fB-ipre\fR- and the
\fB-ipost\fR-body respectively, are present to solve this very
problem\&. While the regular initialization and cleanup codes are
executed before and after the whole series of iterations the advanced
codes are executed before and after each iteration of the body,
without being measured themselves\&. This allows them to bring the
system into the exact state the body wishes to measure\&.
.PP
Our example, directly drawn from the benchmark suite of Tcllib's
\fBstruct::set\fR package, is for exactly the example we used
above to demonstrate the necessity for the advanced initialization and
cleanup\&. Its concrete initialization code constructs a variable
refering to a set with specific properties (The set has a string
representation, which is shared) affecting the speed of the inclusion
command, and the cleanup code releases the temporary variables created
by this initialization\&.
.CS


bench -desc "set include, missing <SC> x$times $n" \fB-ipre\fR {
    set A $sx($times,$n)
    set B $A
} -body {
    struct::set include A x
} \fB-ipost\fR {
    unset A B
}

.CE
.SH "FURTHER READING"
Now that this document has been digested the reader, assumed to be a
\fIwriter\fR of benchmarks, he should be fortified enough to be able
to understand the formal \fIbench language specfication\fR\&. It will
also serve as the detailed specification and cheat sheet for all
available commands and their syntax\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIbench\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
bench_intro, bench_lang_spec
.SH KEYWORDS
bench language, benchmark, examples, performance, testing
.SH CATEGORY
Benchmark tools
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi