'\"
'\" Generated from file 'mime\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1999-2000 Marshall T\&. Rose
'\"
.TH "mime" n 1\&.6 tcllib "Mime"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
mime \- Manipulation of MIME body parts
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBmime  ?1\&.6?\fR
.sp
\fB::mime::initialize\fR ?\fB-canonical\fR \fItype/subtype\fR ?\fB-param\fR {\fIkey value\fR}\&.\&.\&.? ?\fB-encoding\fR \fIvalue\fR? ?\fB-header\fR {\fIkey value\fR}\&.\&.\&.?? (\fB-file\fR \fIname\fR | \fB-string\fR \fIvalue\fR | \fB-parts\fR {\fItoken1\fR \&.\&.\&. \fItokenN\fR})
.sp
\fB::mime::finalize\fR \fItoken\fR ?\fB-subordinates\fR \fBall\fR | \fBdynamic\fR | \fBnone\fR?
.sp
\fB::mime::getproperty\fR \fItoken\fR ?\fIproperty\fR | \fB-names\fR?
.sp
\fB::mime::getheader\fR \fItoken\fR ?\fIkey\fR | \fB-names\fR?
.sp
\fB::mime::setheader\fR \fItoken\fR \fIkey value\fR ?\fB-mode\fR \fBwrite\fR | \fBappend\fR | \fBdelete\fR?
.sp
\fB::mime::getbody\fR \fItoken\fR ?\fB-decode\fR? ?\fB-command\fR \fIcallback\fR ?\fB-blocksize\fR \fIoctets\fR??
.sp
\fB::mime::copymessage\fR \fItoken\fR \fIchannel\fR
.sp
\fB::mime::buildmessage\fR \fItoken\fR
.sp
\fB::mime::parseaddress\fR \fIstring\fR
.sp
\fB::mime::parsedatetime\fR (\fIstring\fR | \fB-now\fR) \fIproperty\fR
.sp
\fB::mime::mapencoding\fR \fIencoding_name\fR
.sp
\fB::mime::reversemapencoding\fR \fIcharset_type\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBmime\fR library package provides the commands to create and
manipulate MIME body parts\&.
.TP
\fB::mime::initialize\fR ?\fB-canonical\fR \fItype/subtype\fR ?\fB-param\fR {\fIkey value\fR}\&.\&.\&.? ?\fB-encoding\fR \fIvalue\fR? ?\fB-header\fR {\fIkey value\fR}\&.\&.\&.?? (\fB-file\fR \fIname\fR | \fB-string\fR \fIvalue\fR | \fB-parts\fR {\fItoken1\fR \&.\&.\&. \fItokenN\fR})
This command creates a MIME part and returns a token representing it\&.
.RS
.IP \(bu
If the \fB-canonical\fR option is present, then the body is in
canonical (raw) form and is found by consulting either the
\fB-file\fR, \fB-string\fR, or \fB-parts\fR option\&.
.sp
In addition, both the \fB-param\fR and \fB-header\fR options may
occur zero or more times to specify \fBContent-Type\fR parameters
(e\&.g\&., \fBcharset\fR) and header keyword/values (e\&.g\&.,
\fBContent-Disposition\fR), respectively\&.
.sp
Also, \fB-encoding\fR, if present, specifies the
\fBContent-Transfer-Encoding\fR when copying the body\&.
.IP \(bu
If the \fB-canonical\fR option is not present, then the MIME part
contained in either the \fB-file\fR or the \fB-string\fR option
is parsed, dynamically generating subordinates as appropriate\&.
.RE
.TP
\fB::mime::finalize\fR \fItoken\fR ?\fB-subordinates\fR \fBall\fR | \fBdynamic\fR | \fBnone\fR?
This command destroys the MIME part represented by \fItoken\fR\&. It
returns an empty string\&.
.sp
If the \fB-subordinates\fR option is present, it specifies which
subordinates should also be destroyed\&. The default value is
\fBdynamic\fR, destroying all subordinates which were created by
\fB::mime::initialize\fR together with the containing body part\&.
.TP
\fB::mime::getproperty\fR \fItoken\fR ?\fIproperty\fR | \fB-names\fR?
This command returns a string or a list of strings containing the
properties of a MIME part\&. If the command is invoked with the name of
a specific property, then the corresponding value is returned;
instead, if \fB-names\fR is specified, a list of all properties is
returned; otherwise, a serialized array of properties and values is
returned\&.
.sp
The possible properties are:
.RS
.TP
\fBcontent\fR
The type/subtype describing the content
.TP
\fBencoding\fR
The "Content-Transfer-Encoding"
.TP
\fBparams\fR
A list of "Content-Type" parameters
.TP
\fBparts\fR
A list of tokens for the part's subordinates\&.  This property is
present only if the MIME part has subordinates\&.
.TP
\fBsize\fR
The approximate size of the content (unencoded)
.RE
.TP
\fB::mime::getheader\fR \fItoken\fR ?\fIkey\fR | \fB-names\fR?
This command returns the header of a MIME part, as a list of strings\&.
.sp
A header consists of zero or more key/value pairs\&. Each value is a
list containing one or more strings\&.
.sp
If this command is invoked with the name of a specific \fIkey\fR, then
a list containing the corresponding value(s) is returned; instead, if
-names is specified, a list of all keys is returned; otherwise, a
serialized array of keys and values is returned\&. Note that when a key
is specified (e\&.g\&., "Subject"), the list returned usually contains
exactly one string; however, some keys (e\&.g\&., "Received") often occur
more than once in the header, accordingly the list returned usually
contains more than one string\&.
.TP
\fB::mime::setheader\fR \fItoken\fR \fIkey value\fR ?\fB-mode\fR \fBwrite\fR | \fBappend\fR | \fBdelete\fR?
This command writes, appends to, or deletes the \fIvalue\fR associated
with a \fIkey\fR in the header\&. It returns a list of strings
containing the previous value associated with the key\&.
.sp
The value for \fB-mode\fR is one of:
.RS
.TP
\fBwrite\fR
The \fIkey\fR/\fIvalue\fR is either created or overwritten (the default)\&.
.TP
\fBappend\fR
A new \fIvalue\fR is appended for the \fIkey\fR (creating it as necessary)\&.
.TP
\fBdelete\fR
All values associated with the key are removed (the \fIvalue\fR
parameter is ignored)\&.
.RE
.TP
\fB::mime::getbody\fR \fItoken\fR ?\fB-decode\fR? ?\fB-command\fR \fIcallback\fR ?\fB-blocksize\fR \fIoctets\fR??
This command returns a string containing the body of the leaf MIME
part represented by \fItoken\fR in canonical form\&.
.sp
If the \fB-command\fR option is present, then it is repeatedly
invoked with a fragment of the body as this:
.CS


  uplevel #0 $callback [list "data" $fragment]

.CE
.sp
(The \fB-blocksize\fR option, if present, specifies the maximum
size of each fragment passed to the callback\&.)
.sp
When the end of the body is reached, the callback is invoked as:
.CS


    uplevel #0 $callback "end"

.CE
.sp
Alternatively, if an error occurs, the callback is invoked as:
.CS


    uplevel #0 $callback [list "error" reason]

.CE
.sp
Regardless, the return value of the final invocation of the callback
is propagated upwards by \fB::mime::getbody\fR\&.
.sp
If the \fB-command\fR option is absent, then the return value of
\fB::mime::getbody\fR is a string containing the MIME part's entire
body\&.
.sp
If the option \fB-decode\fR is absent the return value computed
above is returned as is\&. This means that it will be in the charset
specified for the token and not the usual utf-8\&.
If the option \fB-decode\fR is present however the command will use
the charset information associated with the token to convert the
string from its encoding into utf-8 before returning it\&.
.TP
\fB::mime::copymessage\fR \fItoken\fR \fIchannel\fR
This command copies the MIME represented by \fItoken\fR part to the
specified \fIchannel\fR\&. The command operates synchronously, and uses
fileevent to allow asynchronous operations to proceed
independently\&. It returns an empty string\&.
.TP
\fB::mime::buildmessage\fR \fItoken\fR
This command returns the MIME part represented by \fItoken\fR as a
string\&.  It is similar to \fB::mime::copymessage\fR, only it returns
the data as a return string instead of writing to a channel\&.
.TP
\fB::mime::parseaddress\fR \fIstring\fR
This command takes a string containing one or more 822-style address
specifications and returns a list of serialized arrays, one element
for each address specified in the argument\&. If the string contains
more than one address they will be separated by commas\&.
.sp
Each serialized array contains the properties below\&. Note that one or
more of these properties may be empty\&.
.RS
.TP
\fBaddress\fR
local@domain
.TP
\fBcomment\fR
822-style comment
.TP
\fBdomain\fR
the domain part (rhs)
.TP
\fBerror\fR
non-empty on a parse error
.TP
\fBgroup\fR
this address begins a group
.TP
\fBfriendly\fR
user-friendly rendering
.TP
\fBlocal\fR
the local part (lhs)
.TP
\fBmemberP\fR
this address belongs to a group
.TP
\fBphrase\fR
the phrase part
.TP
\fBproper\fR
822-style address specification
.TP
\fBroute\fR
822-style route specification (obsolete)
.RE
.TP
\fB::mime::parsedatetime\fR (\fIstring\fR | \fB-now\fR) \fIproperty\fR
This command takes a string containing an 822-style date-time
specification and returns the specified property as a serialized
array\&.
.sp
The list of properties and their ranges are:
.RS
.TP
\fBhour\fR
0 \&.\&. 23
.TP
\fBlmonth\fR
January, February, \&.\&.\&., December
.TP
\fBlweekday\fR
Sunday, Monday, \&.\&.\&. Saturday
.TP
\fBmday\fR
1 \&.\&. 31
.TP
\fBmin\fR
0 \&.\&. 59
.TP
\fBmon\fR
1 \&.\&. 12
.TP
\fBmonth\fR
Jan, Feb, \&.\&.\&., Dec
.TP
\fBproper\fR
822-style date-time specification
.TP
\fBrclock\fR
elapsed seconds between then and now
.TP
\fBsec\fR
0 \&.\&. 59
.TP
\fBwday\fR
0 \&.\&. 6 (Sun \&.\&. Mon)
.TP
\fBweekday\fR
Sun, Mon, \&.\&.\&., Sat
.TP
\fByday\fR
1 \&.\&. 366
.TP
\fByear\fR
1900 \&.\&.\&.
.TP
\fBzone\fR
-720 \&.\&. 720 (minutes east of GMT)
.RE
.TP
\fB::mime::mapencoding\fR \fIencoding_name\fR
This commansd maps tcl encodings onto the proper names for their MIME
charset type\&.  This is only done for encodings whose charset types
were known\&.  The remaining encodings return "" for now\&.
.TP
\fB::mime::reversemapencoding\fR \fIcharset_type\fR
This command maps MIME charset types onto tcl encoding names\&.  Those
that are unknown return ""\&.
.PP
.SH "KNOWN BUGS"
.TP
Tcllib Bug #447037
This problem affects only people which are using Tcl and Mime on a
64-bit system\&. The currently recommended fix for this problem is to
upgrade to Tcl version 8\&.4\&. This version has extended 64 bit support
and the bug does not appear anymore\&.
.sp
The problem could have been generally solved by requiring the use of
Tcl 8\&.4 for this package\&. We decided against this solution as it would
force a large number of unaffected users to upgrade their Tcl
interpreter for no reason\&.
.sp
See \fITicket 447037\fR [/tktview?name=447037] for additional information\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fImime\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
ftp, http, pop3, smtp
.SH KEYWORDS
email, internet, mail, mime, net, rfc 2045, rfc 2046, rfc 2049, rfc 821, rfc 822, smtp
.SH CATEGORY
Text processing
.SH COPYRIGHT
.nf
Copyright (c) 1999-2000 Marshall T\&. Rose

.fi