[comment {-*- tcl -*- doctools manpage}]
[manpage_begin nntp n 1.5.1]
[moddesc   {Tcl NNTP Client Library}]
[titledesc {Tcl client for the NNTP protocol}]
[category  Networking]
[require Tcl  8.2]
[require nntp [opt 0.2.1]]
[description]

The package [package nntp] provides a simple Tcl-only client library
for the NNTP protocol.  It works by opening the standard NNTP socket
on the server, and then providing a Tcl API to access the NNTP
protocol commands.  All server errors are returned as Tcl errors
(thrown) which must be caught with the Tcl [cmd catch] command.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::nntp::nntp] [opt [arg host]] [opt [arg port]] [opt [arg nntpName]]]

The command opens a socket connection to the specified NNTP server and
creates a new nntp object with an associated global Tcl command whose
name is [arg nntpName]. This command may be used to access the various
NNTP protocol commands for the new connection. The default [arg port]
number is "119" and the default [arg host] is "news". These defaults
can be overridden with the environment variables [var NNTPPORT] and
[var NNTPHOST] respectively.

[para]

Some of the commands supported by this package are not part of the
nntp rfc 977 ([uri http://www.rfc-editor.org/rfc/rfc977.txt]) and will
not be available (or implemented) on all nntp servers.

[para]

The access command [arg nntpName] has the following general form:

[list_begin definitions]

[call [arg nntpName] [method method] [opt [arg "arg arg ..."]]]

[arg Option] and the [arg arg]s determine the exact behavior of the
command.

[list_end]

[call [arg nntpName] [method article] [opt [arg msgid]]]

Query the server for article [arg msgid] from the current group.  The article
is returned as a valid tcl list which contains the headers, followed by
a blank line, and then followed by the body of the article. Each element
in the list is one line of the article.

[call [arg nntpName] [method authinfo] [opt [arg user]] [opt [arg pass]]]

Send authentication information (username and password) to the server.

[call [arg nntpName] [method body] [opt [arg msgid]]]

Query the server for the body of the article [arg msgid] from the current
group.  The body of the article is returned as a valid tcl list. Each element
in the list is one line of the body of the article.

[call [arg nntpName] [method configure]]
[call [arg nntpName] [method configure] [arg option]]
[call [arg nntpName] [method configure] [arg option] [arg value] ...]
[call [arg nntpName] [method cget] [arg option]]

Query and configure options of the nntp connection object. Currently
only one option is supported, [option -binary]. When set articles are
retrieved as binary data instead of text. The only methods affected by
this are [method article] and [method body].

[para]

One application of this option would be the download of articles
containing yEnc encoded images. Although encoded the data is still
mostly binary and retrieving it as text will corrupt the information.

[para]

See package [package yencode] for both encoder and decoder of such data.


[call [arg nntpName] [method date]]

Query the server for the servers current date.  The date is returned in the
format [emph YYYYMMDDHHMMSS].

[call [arg nntpName] [method group] [opt [arg group]]]

Optionally set the current group, and retrieve information about the
currently selected group.  Returns the estimated number of articles in
the group followed by the number of the first article in the group, followed
by the last article in the group, followed by the name of the group.

[call [arg nntpName] [method head] [opt [arg msgid]]]

Query the server for the headers of the article [arg msgid] from the current
group.  The headers of the article are returned as a valid tcl list. Each element
in the list is one line of the headers of the article.

[call [arg nntpName] [method help]]

Retrieves a list of the commands that are supported by the news server that
is currently attached to.

[call [arg nntpName] [method last]]

Sets the current article pointer to point to the previous message (if there is
one) and returns the msgid of that message.

[call [arg nntpName] [method list]]

Returns a tcl list of valid newsgroups and associated information.  Each
newsgroup is returned as an element in the tcl list with the following format:
[example {
      group last first p
}]
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').
[para]
The <first> and <last> fields will always be numeric.  They may have
leading zeros.  If the <last> field evaluates to less than the
<first> field, there are no articles currently on file in the
newsgroup.

[call [arg nntpName] [method listgroup] [opt [arg group]]]

Query the server for a list of all the messages (message numbers) in the
group specified by the argument [arg group] or by the current group if
the [arg group] argument was not passed.

[call [arg nntpName] [method mode_reader]]

Query the server for its nntp 'MODE READER' response string.

[call [arg nntpName] [method newgroups] [arg since]]

Query the server for a list of all the new newsgroups created since the time
specified by the argument [arg since].  The argument [arg since] can be any
time string that is understood by [cmd {clock scan}]. The tcl list of newsgroups
is returned in a similar form to the list of groups returned by the
[cmd {nntpName list}] command.  Each element of the list has the form:

[example {
      group last first p
}]
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').

[call [arg nntpName] [method newnews]]

Query the server for a list of new articles posted to the current group in the
last day.

[call [arg nntpName] [method newnews] [arg since]]

Query the server for a list of new articles posted to the current group since
the time specified by the argument [arg since].  The argument [arg since] can
be any time string that is understood by [cmd {clock scan}].

[call [arg nntpName] [method newnews] [arg group] [opt [arg since]]]

Query the server for a list of new articles posted to the group specified by
the argument [arg group] since the time specified by the argument [arg since]
(or in the past day if no [arg since] argument is passed.  The argument
[arg since] can be any time string that is understood by [cmd {clock scan}].

[call [arg nntpName] [method next]]

Sets the current article pointer to point to the next message (if there is
one) and returns the msgid of that message.

[call [arg nntpName] [method post] [arg article]]

Posts an article of the form specified in
RFC 1036 ([uri http://www.rfc-editor.org/rfc/rfc1036.txt], successor
to RFC 850) to the current news group.

[call [arg nntpName] [method slave]]

Identifies a connection as being made from a slave nntp server. This might
be used to indicate that the connection is serving multiple people and should
be given priority.  Actual use is entirely implementation dependent and may
vary from server to server.

[call [arg nntpName] [method stat] [opt [arg msgid]]]

The stat command is similar to the article command except that no
text is returned.  When selecting by message number within a group,
the stat command serves to set the current article pointer without
sending text. The returned acknowledgment response will contain the
message-id, which may be of some value.  Using the stat command to
select by message-id is valid but of questionable value, since a
selection by message-id does NOT alter the "current article pointer"

[call [arg nntpName] [method quit]]

Gracefully close the connection after sending a NNTP QUIT command down
the socket.

[call [arg nntpName] [method xgtitle] [opt [arg group_pattern]]]

Returns a tcl list where each element is of the form:
[example {
newsgroup description
}]
If a [arg group_pattern] is specified then only newsgroups that match
the pattern will have their name and description returned.

[call [arg nntpName] [method xhdr] [arg field] [opt [arg range]]]

Returns the specified header field value for the current message or for a
list of messages from the current group.  [arg field] is the title of a
field in the header such as from, subject, date, etc.  If [arg range] is
not specified or is "" then the current message is queried.  The command
returns a list of elements where each element has the form of:
[example {
    msgid value
}]
Where msgid is the number of the message and value is the value set for the
queried field.  The [arg range] argument can be in any of the following forms:

[list_begin definitions]

[def [const {""}]]

The current message is queried.

[def [arg msgid1]-[arg msgid2]]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[def "[arg msgid1] [arg msgid2]"]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[list_end]


[call [arg nntpName] [method xover] [opt [arg range]]]

Returns header information for the current message or for a range of messages
from the current group.  The information is returned in a tcl list
where each element is of the form:
[example {
    msgid subject from date idstring bodysize headersize xref
}]
If [arg range] is not specified or is "" then the current message is queried.
The [arg range] argument can be in any of the following forms:

[list_begin definitions]


[def [const {""}]]

The current message is queried.

[def [arg msgid1]-[arg msgid2]]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[def "[arg msgid1] [arg msgid2]"]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[list_end]


[call [arg nntpName] [method xpat] [arg field] [arg range] [opt [arg pattern_list]]]

Returns the specified header field value for a specified message or for a
list of messages from the current group where the messages match the
pattern(s) given in the pattern_list.  [arg field] is the title of a
field in the header such as from, subject, date, etc.  The information is
returned in a tcl list where each element is of the form:
[example {
    msgid value
}]
Where msgid is the number of the message and value is the value set for the
queried field.  The [arg range] argument can be in any of the following forms:

[list_begin definitions]

[def [arg msgid]]

The message specified by [arg msgid] is queried.

[def [arg msgid1]-[arg msgid2]]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[def "[arg msgid1] [arg msgid2]"]

All messages between [arg msgid1] and [arg msgid2]
(including [arg msgid1] and [arg msgid2]) are queried.

[list_end]
[list_end]

[section EXAMPLE]

A bigger example for posting a single article.

[para]
[example {
    package require nntp 
    set n [nntp::nntp NNTP_SERVER] 
    $n post "From: USER@DOMAIN.EXT (USER_FULL) 
    Path: COMPUTERNAME!USERNAME 
    Newsgroups: alt.test 
    Subject: Tcl test post -ignore 
    Message-ID: <[pid][clock seconds] 
    @COMPUTERNAME> 
    Date: [clock format [clock seconds] -format "%a, %d % 
    b %y %H:%M:%S GMT" -gmt true] 
    
    Test message body" 
}]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph nntp] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords news nntp nntpclient {rfc 1036} {rfc 977}]
[manpage_end]
