/////////////////////////////////////////////////////////////////////////////
// Name:      MediaFile.h
// Author:    Alex Thuering
// Created:   7.07.2012
// Copyright: (c) Alex Thuering
// Licence:   GPL
/////////////////////////////////////////////////////////////////////////////
#ifndef MEDIAFILE_H_
#define MEDIAFILE_H_

#include "MediaStream.h"
#include <vector>

using namespace std;

/**
 * Stores information about media file
 */
class MediaFile {
public:
	/** Constructor */
	MediaFile();
	/** Destructor */
	~MediaFile();
	
	/** Reads file info */
	bool Init(const wxString& fileName);
	
	/** Returns filename */
	wxString GetFileName() const {
		return fileName;
	}
	
	/** Returns size of file in KB */
	long GetSize() const {
		return size;
	}
	
	/** Returns duration in sec */
	double GetDuration() const {
		return duration;
	}
	
	/** Returns video image */
	const wxImage& GetImage() const {
		return image;
	}

	/** Returns media streams of the file */
	const vector<MediaStream*>& GetStreams() const {
		return streams;
	}

	/** Returns video stream */
	MediaStream* GetVideoStream() const;
	
	/** Checks this file has streams compatible to given one */
	bool HasCompatibleStreams(const MediaFile* mediaFile);
	
private:
	/** File name */
	wxString fileName;
	/** Size of file in KB */
	long size;
	/** Duration of video in sec. */
	double duration;
	/** Video image */
	wxImage image;
	/** Media streams of the file */
	vector<MediaStream*> streams;
};

#endif
