[Setup]
AppName=MP4Joiner
AppVerName=MP4Joiner v2.1.2
AppPublisherURL=http://www.mp4joiner.org
AppSupportURL=http://www.mp4joiner.org
AppUpdatesURL=http://www.mp4joiner.org
DefaultDirName={pf}\MP4Joiner
DefaultGroupName=MP4Joiner
OutputBaseFilename=MP4Joiner-2.1.2-win32
Compression=lzma
SolidCompression=yes
UninstallDisplayIcon={app}\bin\MP4Joiner.exe
PrivilegesRequired=admin
WizardSmallImageFile=MP4Joiner.bmp
ChangesAssociations=yes
AllowNoIcons=yes
LicenseFile=..\COPYING

[Languages]
Name: "de"; MessagesFile: "compiler:Languages\German.isl"
Name: "en"; MessagesFile: "compiler:Default.isl"
Name: "es"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "pt"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "ru"; MessagesFile: "compiler:Languages\Russian.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "..\src\*.exe"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "..\src\*.dll"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "..\COPYING"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\ChangeLog"; DestDir: "{app}"; Flags: ignoreversion

Source: "..\locale\de\*"; DestDir: "{app}\locale\de"; Flags: ignoreversion
Source: "..\locale\es\*"; DestDir: "{app}\locale\es"; Flags: ignoreversion
Source: "..\locale\pt\*"; DestDir: "{app}\locale\pt"; Flags: ignoreversion
Source: "..\locale\ru\*"; DestDir: "{app}\locale\ru"; Flags: ignoreversion

[Icons]
Name: "{group}\MP4Joiner"; Filename: "{app}\bin\MP4Joiner.exe"
Name: "{group}\{cm:ProgramOnTheWeb,MP4Joiner}"; Filename: "http://www.mp4joiner.org/"
Name: "{group}\{cm:UninstallProgram,MP4Joiner}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\MP4Joiner"; Filename: "{app}\bin\MP4Joiner.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\MP4Joiner"; Filename: "{app}\bin\MP4Joiner.exe"; Tasks: quicklaunchicon

[Registry]
Root: HKCU; Subkey: "Software\MP4Joiner"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\MP4Joiner\Interface"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\MP4Joiner\Interface"; ValueType: string; ValueName: "LanguageCode"; ValueData: {language}

[Run]
Filename: "{app}\bin\MP4Joiner.exe"; Description: "{cm:LaunchProgram,MP4Joiner}"; Flags: nowait postinstall skipifsilent
