/////////////////////////////////////////////////////////////////////////////
// Name:      utils.h
// Author:    Alex Thuering
// Created:   7.07.2012
// Copyright: (c) Alex Thuering
// Licence:   GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_H_
#define UTILS_H_

#include <wx/wx.h>
#include <wx/log.h>
#include <wx/mstream.h>
#include <vector>

using namespace std;

#define VECTOR_CLEAR(obj, elem_type) \
	for (vector<elem_type*>::iterator vectorIt = obj.begin(); vectorIt != obj.end(); vectorIt++) \
		delete *vectorIt; \
	obj.clear();

#define VECTOR_COPY(src, dst, elem_type) \
	for (vector<elem_type*>::const_iterator vectorIt = src.begin(); vectorIt != src.end(); vectorIt++) \
		dst.push_back(new elem_type(**vectorIt));

wxString wxGetAppPath();
void wxSetAppPath(wxString value);

wxString wxFindDataDirectory(wxString dir);
wxString wxFindDataFile(wxString filename);

#define wxBITMAP_FROM_MEMORY(name) wxGetBitmapFromMemory(name##_png, sizeof(name##_png))

inline wxBitmap wxGetBitmapFromMemory(const unsigned char *data, int length) {
   wxMemoryInputStream is(data, length);
   return wxBitmap(wxImage(is, wxBITMAP_TYPE_ANY, -1), -1);
}

#define wxICON_FROM_MEMORY(name) wxGetIconFromMemory(name##_png, sizeof(name##_png))

inline wxIcon wxGetIconFromMemory(const unsigned char *data, int length) {
   wxIcon icon;
   icon.CopyFromBitmap(wxGetBitmapFromMemory(data, length));
   return icon;
}

#endif // UTILS_H_
