/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2011  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_DIGIT_RULE_H
#define NJD_SET_DIGIT_RULE_H

#ifdef __cplusplus
#define NJD_SET_DIGIT_RULE_H_START extern "C" {
#define NJD_SET_DIGIT_RULE_H_END   }
#else
#define NJD_SET_DIGIT_RULE_H_START
#define NJD_SET_DIGIT_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_DIGIT_RULE_H_START;

#define NJD_SET_DIGIT_KAZU ""
#define NJD_SET_DIGIT_SUUSETSUZOKU "ڑ"
#define NJD_SET_DIGIT_JOSUUSHI ""
#define NJD_SET_DIGIT_HAIHUN1 "\"
#define NJD_SET_DIGIT_HAIHUN2 "|"
#define NJD_SET_DIGIT_HAIHUN3 "]"
#define NJD_SET_DIGIT_KAKKO1 "i"
#define NJD_SET_DIGIT_KAKKO2 "j"
#define NJD_SET_DIGIT_BANGOU "ԍ"
#define NJD_SET_DIGIT_TEN1 "D"
#define NJD_SET_DIGIT_TEN2 "E"
#define NJD_SET_DIGIT_TEN_FEATURE "D,,ڔ,,*,*,*,D,e,e,0/2,*,-1"
#define NJD_SET_DIGIT_ZERO "Z"
#define NJD_SET_DIGIT_ZERO_BEFORE_DP "["
#define NJD_SET_DIGIT_ZERO_AFTER_DP "["
#define NJD_SET_DIGIT_TWO ""
#define NJD_SET_DIGIT_TWO_BEFORE_DP "j["
#define NJD_SET_DIGIT_TWO_AFTER_DP "j["
#define NJD_SET_DIGIT_FIVE ""
#define NJD_SET_DIGIT_FIVE_BEFORE_DP "S["
#define NJD_SET_DIGIT_FIVE_AFTER_DP "S["
#define NJD_SET_DIGIT_NIN "l"
#define NJD_SET_DIGIT_GATSU ""
#define NJD_SET_DIGIT_NICHI ""
#define NJD_SET_DIGIT_NICHIKAN ""
#define NJD_SET_DIGIT_ONE ""
#define NJD_SET_DIGIT_TSUITACHI ",,\,*,*,*,*,,cC^`,cC^`,4/4,*"

static const char *njd_set_digit_rule_numeral_list1[] = {
   "", "0", "Z",
   "P", "1", "",
   "Q", "2", "",
   "R", "3", "O",
   "S", "4", "l",
   "T", "5", "",
   "U", "6", "Z",
   "V", "7", "",
   "W", "8", "",
   "X", "9", "",
   "", "1", "",
   "", "2", "",
   "O", "3", "O",
   "l", "4", "l",
   "", "5", "",
   "Z", "6", "Z",
   "", "7", "",
   "", "8", "",
   "", "9", "",
   "", "1", "",
   "", "2", "",
   "", "3", "O",
   "", "4", "l",
   "", "5", "",
   "낭", "6", "Z",
   "Ȃ", "7", "",
   "͂", "8", "",
   "イ", "9", "",
   "Z", "0", "Z",
   "O", "0", "Z",
   "", "1", "",
   "", "2", "",
   "", "2", "",
   "j", "2", "",
   "Q", "3", "O",
   "", "4", "l",
   "", "7", "",
   "", "9", "",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numeral_list2[] = {
   "",
   "\,,,*,*,*,*,\,WE,W[,1/2,*",
   "S,,,*,*,*,*,S,qN,qN,2/2,*",
   ",,,*,*,*,*,,Z,Z,1/2,*",
   NULL
};

static const char *njd_set_digit_rule_numeral_list3[] = {
   "",
   ",,,*,*,*,*,,},},1/2,*",
   ",,,*,*,*,*,,IN,IN,1/2,*",
   ",,,*,*,*,*,,`E,`[,1/2,C3",
   ",,,*,*,*,*,,PC,PC,1/2,*",
   ",,,*,*,*,*,,KC,KC,1/2,*",
   "ї\,,,*,*,*,*,ї\,W,W,1/1,*", /* No character in EUC-JP */
   ",,,*,*,*,*,,WE,WE,1/2,*",
   "a,,,*,*,*,*,a,RE,RE,1/2,*",
   ",,,*,*,*,*,,J,J,1/2,*",
   ",,,*,*,*,*,,ZC,ZC,1/2,*",
   ",,,*,*,*,*,,TC,TC,1/2,*",
   ",,,*,*,*,*,,SN,SN,1/2,*",
   "P͍,,,*,*,*,*,P͍,SEKV,SEKV,1/4,*",
   "m_,,,*,*,*,*,m_,A\EM,A\EM,2/4,*",
   "ߗR,,,*,*,*,*,ߗR,i^,i^,1/3,*",
   "svc,,,*,*,*,*,svc,tJVM,tJVM,2/4,*",
   "ʑ吔,,,*,*,*,*,ʑ吔,E^CXE,[^CXE,6/7,*",
   NULL
};

static const char *njd_set_digit_rule_numeral_list4[] = {
   "", "", "O", "l", "", "Z", "", "", "", "", "", "",
   NULL
};

static const char *njd_set_digit_rule_numeral_list5[] = {
   "\", "S", "", "", "", "", "", "", "ї\", "", "a", "", "", "", "",
   "P͍", "m_", "ߗR", "svc", "ʑ吔",
   NULL
};

static const char *njd_set_digit_rule_numeral_list6[] = {
   "S", "", NULL
};

static const char *njd_set_digit_rule_numeral_list7[] = {
   "O", "1",
   "Z", "2",
   "", "2",
   "", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numeral_list8[] = {
   "S", "", NULL
};

static const char *njd_set_digit_rule_numeral_list9[] = {
   "Z", "b", "0", "2",
   "", "nb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1b[] = {
   /* from paper */
   "N" /* ˂ */ , "~",
   /* from dictionary */
   "N", "N", "N", "Nx", "N", "N]", "N]", "N", "",
   NULL
};

static const char *njd_set_digit_rule_conv_table1b[] = {
   "l", "", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1c[] = {
   /* from paper */
   "", "", "l",
   /* from dictionary */
   "", "", "l", "lO", "lg",
   NULL
};

static const char *njd_set_digit_rule_conv_table1c[] = {
   "l", "", "0", "1",
   "", "V`", "1", "2",
   "", "N", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1d[] = {
   /* from paper */
   "" /* ɂ */ ,
   /* from dictionary */
   "",
   NULL
};

static const char *njd_set_digit_rule_conv_table1d[] = {
   /* "l", "b", "1", "2", *//* modified */
   "", "V`", "1", "2",
   "", "N", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1e[] = {
   /* from paper */
   "" /*  */ ,
   NULL
};

static const char *njd_set_digit_rule_conv_table1e[] = {
   "l", "V", "0", "1",
   "", "V`", "1", "2",
   "", "N", "0", "1",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1f[] = {
   /* from paper */
   /* "H", "c", *//* modified */
   NULL
};

static const char *njd_set_digit_rule_conv_table1f[] = {
   "Z", "b", "1", "2",
   "", "nb", "1", "2",
   "\", "Wb", "1", "2",
   "S", "qb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1g[] = {
   /* from paper */
   "", "K", "" /* ӂ */ , "", "{", "", "", "؂", "",
   /* from dictionary */
   "", "", "", "", "", "N", "J", "J", "J", "J", "J", "J",
   "JX", "JN", "P", "P", "P", "P", "P", "PN", "", "", "",
   "", "", "N", "", "", "", "", "", "N", "", "",
   "", "", "N", "ӌ", "Ӎ", "ӏ", "ӏ", "ӔN", "", "", "",
   "", "", "", "", "", "", "", "", "", "C", "JC", "\", "p",
   "", "", "", "", "", "і", "", "", "", "", "@", "C", "G", "R",
   "q", "r", "", "", "", "", "", "", "d", "", "", "", "", "", "v",
   "", "P^", "Z", "`", "s", "", "g", "", "", "", "", "", "N", "",
   "҂", "؂", "g", "h", "s", "t", "", "", "", "", "", "C", "C", "M", "U",
   "[", "i", "", "", "", "", "", "", "", "", "", "", "", "", "",
   "@", "{",
   NULL
};

static const char *njd_set_digit_rule_conv_table1g[] = {
   "", "Cb", "1", "2",
   "Z", "b", "1", "2",
   "", "nb", "1", "2",
   "\", "Wb", "1", "2",
   "S", "qb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1h[] = {
   /* from paper */
   "D", "E", "", "", "", "", "", "", "ʂ", "Z`", "V[V[",
   /* from dictionary */
   "bb", "", "", "TCN", "T`[", "V[Y", "V[g", "VO",
   "VK|[h", "XCXt", "XEF[fN[l", "XN", "Zbg", "Zg",
   "\", "][", "W", "W", "", "", "", "", "Ύ", "", "", "", "M", "",
   "z", "q", "", "", "", "", "", "", "", "", "", "", "", "N", "B",
   "T", "T", "W", "h", "", "", "", "", "", "F", "F", "H", "e", "i",
   "i", "i", "", "", "낢", "", "", "", "", "", "", "", "", "",
   "", "I", "K", "w", "", "", "", "", "", "", "܂", "",
   "܂", "Ƃ", "Ƃ", "Ƃ", "Ƃ", "", "", "", "", "", "", "",
   "", "M", "", "", "", "", "", "͂", "", "H", "X", "]", "_", "l", "",
   "", "", "", "", "n", "", "", "", "", "",
   NULL
};

static const char *njd_set_digit_rule_conv_table1h[] = {
   "", "Cb", "1", "2",
   "", "nb", "1", "2",
   "\", "Wb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1i[] = {
   /* from paper */
   "L", "J[",
   /* from dictionary */
   "", "", "", "", "", "", "", "O", "oCg", "wc",
   "[g", "bg", "bg", "Ji_h", "Jbg", "K", "L[",
   "LJ[", "LO", "Lg", "LoCg", "Lwc", "L[g",
   "Lbg", "Lbg", "Lbg", "NX", "N[i", "N[l", "O@j",
   "P[X", "R[X", "",
   NULL
};

static const char *njd_set_digit_rule_conv_table1i[] = {
   "Z", "b", "1", "2",
   "\", "Wb", "1", "2",
   "S", "qb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1j[] = {
   /* from paper */
   "g",
   /* from dictionary */
   "", "^", "e", "gC",
   NULL
};

static const char *njd_set_digit_rule_conv_table1j[] = {
   "", "Cb", "1", "2",
   "\", "Wb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1k[] = {
   /* from paper */
   "[" /* ӂ */ , "", "", "|h",
   /* from dictionary */
   "", "", "p[Zg", "p[~", "pXJ", "pbN", "pbg", "s[s[G",
   "sR", "y[W", "", "yA", "yZ^", "y\", "yj[", "yjq", "yX", "|Cg",
   "U", "j", "", "", "", "L", "L[g", "Z`[g",
   "[g",
   NULL
};

static const char *njd_set_digit_rule_conv_table1k[] = {
   "\", "Wb", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2b[] = {
   /* from paper */
   "", "", "s", "", "", "",
   /* from dictionary */
   "g", "h", "", "", "", "i", "", "", "", "", "", "", "", "", "",
   "",
   NULL
};

static const char *njd_set_digit_rule_conv_table2b[] = {
   "", "2",
   "O", "2",
   "l", "2",
   "Z", "2",
   "", "2",
   "\", "2",
   "S", "2",
   "", "2",
   "", "2",
   "", "2",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2c[] = {
   /* from paper */
   "{", "C", "[", "U", "",
   /* from dictionary */
   "{", "t", "j", "",
   NULL
};

static const char *njd_set_digit_rule_conv_table2c[] = {
   "", "2",
   "O", "1",
   "Z", "2",
   "", "2",
   "\", "2",
   "S", "2",
   "", "1",
   "", "1",
   "", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2d[] = {
/* from paper */
   /* "H", "c", *//* modified */
   NULL
};

static const char *njd_set_digit_rule_conv_table2d[] = {
   "O", "1",
   "Z", "2",
   "", "2",
   "\", "2",
   "S", "2",
   "", "1",
   "", "1",
   "", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2e[] = {
   /* from paper */
   "", "", "", "",
   /* from dictionary */
   "", "d", "", "",
   NULL
};

static const char *njd_set_digit_rule_conv_table2e[] = {
   "O", "1",
   "", "1",
   "", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2f[] = {
   /* from paper */
   "K",
   NULL
};

static const char *njd_set_digit_rule_conv_table2f[] = {
   "O", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_voiced_sound_symbol_list[] = {
   "J", "K",
   "L", "M",
   "N", "O",
   "P", "Q",
   "R", "S",
   "T", "U",
   "V", "W",
   "X", "Y",
   "Z", "[",
   "\", "]",
   "^", "_",
   "`", "a",
   "c", "d",
   "e", "f",
   "g", "h",
   "n", "o",
   "q", "r",
   "t", "u",
   "w", "x",
   "z", "{",
   NULL, NULL
};

static const char *njd_set_digit_rule_semivoiced_sound_symbol_list[] = {
   "n", "p",
   "q", "s",
   "t", "v",
   "w", "y",
   "z", "|",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class3[] = {
   /* from paper */
   "", "l",
   /* from dictionary */
   "", "JP",
   "", "N_",
   "", "P^",
   "", "XW",
   "낢", "\C",
   "", "^r",
   "", "cJ~",
   "", "cKC",
   "܂", "c}~",
   "Ƃ", "gI",
   "Ƃ", "gR",
   "Ƃ", "gZ",
   "܂", "}",
   "V[Y", "V[Y",
   "Zbg", "Zbg",
   "", "jM",
   "", "}",
   "", "Ju",
   "", "TI",
   "", "XW",
   "", "P^",
   "P^", "P^",
   "", "cL",
   "", "Rg",
   "", "N`",
   "", "TV",
   "M", "T",
   "R", "}",
   "", "VN",
   "", "VN",
   "d", "JTl",
   "U", "t",
   "j", "n",
   "؂", "L",
   "", "^o",
   "", "cdL",
   "", "\C",
   "", "tN",
   "", "nV",
   "", "n",
   "ʂ", "gI",
   "͂", "cJ~",
   "", "c{",
   "", "nR",
   "", "n`",
   "", "o",
   "i", "Vi",
   "r", "r",
   "", "P",
   "", "}N",
   "", "",
   "", "",
   "", "cu",
   "g", "N",
   "", "TI",
   "", "cI",
   "܂", "cI",
   "", "cu",
   "", "cu",
   "Ƃ", "gL",
   "d", "KTl",
   NULL, NULL
};

static const char *njd_set_digit_rule_conv_table3[] = {
   "", "qg", "0", "2",
   "", "t^", "0", "2",
   /* "O", "~", "1", "1", *//* modified */
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_conv_table4[] = {
   "", "l,,\,*,*,*,*,l,qg,qg,2/3,*",
   "", "l,,\,*,*,*,*,l,t^,t^,3/3,*",
   NULL, NULL
};

static const char *njd_set_digit_rule_conv_table5[] = {
   "", ",,\,*,*,*,*,,C`j`,C`j`,4/4,*",
   "", ",,\,*,*,*,*,,tcJ,tcJ,3/3,*",
   "O", "O,,\,*,*,*,*,O,~bJ,~bJ,3/3,*",
   "l", "l,,\,*,*,*,*,l,bJ,bJ,3/3,*",
   "", "ܓ,,\,*,*,*,*,ܓ,CcJ,CcJ,3/3,*",
   "Z", "Z,,\,*,*,*,*,Z,CJ,CJ,3/3,*",
   "", ",,\,*,*,*,*,,imJ,imJ,3/3,*",
   "", ",,\,*,*,*,*,,EJ,EJ,3/3,*",
   "", ",,\,*,*,*,*,,RRmJ,RRmJ,4/4,*",
   "\", "\,,\,*,*,*,*,\,gEJ,g[J,3/3,*",
   NULL, NULL
};
static const char *njd_set_digit_rule_conv_table6[] = {
   "", ",,\,*,*,*,*,,C`j`J,C`j`J,4/6,*",
   "", ",,\,*,*,*,*,,tcJJ,tcJJ,3/5,*",
   "O", "O,,\,*,*,*,*,O,~bJJ,~bJJ,3/5,*",
   "l", "l,,\,*,*,*,*,l,bJJ,bJJ,3/5,*",
   "", "ܓ,,\,*,*,*,*,ܓ,CcJJ,CcJJ,3/5,*",
   "Z", "Z,,\,*,*,*,*,Z,CJJ,CJJ,3/5,*",
   "", ",,\,*,*,*,*,,imJJ,imJJ,3/5,*",
   "", ",,\,*,*,*,*,,EJJ,EJJ,3/5,*",
   "", ",,\,*,*,*,*,,RRmJJ,RRmJJ,4/6,*",
   "\", "\,,\,*,*,*,*,\,gEJJ,g[JJ,3/5,*",
   NULL, NULL
};

NJD_SET_DIGIT_RULE_H_END;

#endif                          /* !NJD_SET_DIGIT_RULE_H */
