/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#define _VECTORMATH_AOS_TEST

#include "vectormath_aos.h"
#include "test.h"

int iteration = 0;

using namespace Vectormath;
using namespace Vectormath::Aos;

void
Matrix3_methods_test()
{
    Matrix3 a_Matrix3, b_Matrix3;
    Matrix4 a_Matrix4, b_Matrix4;
    Transform3 a_Transform3, b_Transform3;
    Vector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    Vector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    Point3 a_Point3, b_Point3, c_Point3, d_Point3;
    Quat a_Quat, b_Quat, c_Quat, d_Quat;
    Vector4 tmpV4;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector3 = Vector3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( a_Vector3, pad );
    a_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( b_Vector3, pad );
    b_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( c_Vector3, pad );
    c_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( d_Vector3, pad );
    d_Vector3 = tmpV4.getXYZ( );
    print( a_Vector3, "set Vector3 with floats" );
    print( b_Vector3, "set Vector3 with floats" );
    print( c_Vector3, "set Vector3 with floats" );
    print( d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector4 = Vector4( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Vector4, "set Vector4 with floats" );
    print( b_Vector4, "set Vector4 with floats" );
    print( c_Vector4, "set Vector4 with floats" );
    print( d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Point3 = Point3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( Vector3( a_Point3 ), pad );
    a_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( b_Point3 ), pad );
    b_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( c_Point3 ), pad );
    c_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( d_Point3 ), pad );
    d_Point3 = Point3( tmpV4.getXYZ( ) );
    print( a_Point3, "set Point3 with floats" );
    print( b_Point3, "set Point3 with floats" );
    print( c_Point3, "set Point3 with floats" );
    print( d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Quat = Quat( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Quat, "set Quat with floats" );
    print( b_Quat, "set Quat with floats" );
    print( c_Quat, "set Quat with floats" );
    print( d_Quat, "set Quat with floats" );
    a_Matrix3 = Matrix3( a_Vector3, b_Vector3, c_Vector3 );
    b_Matrix3 = Matrix3( d_Vector3, a_Vector3, b_Vector3 );
    print( a_Matrix3, "set Matrix3 columns" );
    print( b_Matrix3, "set Matrix3 columns" );
    a_Matrix4 = Matrix4( a_Vector4, b_Vector4, c_Vector4, d_Vector4 );
    b_Matrix4 = Matrix4( d_Vector4, a_Vector4, b_Vector4, c_Vector4 );
    print( a_Matrix4, "set Matrix4 columns" );
    print( b_Matrix4, "set Matrix4 columns" );
    a_Transform3 = Transform3( a_Vector3, b_Vector3, c_Vector3, d_Vector3 );
    b_Transform3 = Transform3( d_Vector3, a_Vector3, b_Vector3, c_Vector3 );
    print( a_Transform3, "set Transform3 columns" );
    print( b_Transform3, "set Transform3 columns" );
    a_Matrix3 = Matrix3( normalize( a_Quat ) );
    print( a_Matrix3, "construct Matrix3 with Quat" );
    a_Quat = Quat( a_Matrix3 );
    print( a_Quat, "construct Quat with Matrix3" );
    a_Matrix3 = b_Matrix3;
    print( a_Matrix3, "assign to Matrix3 from Matrix3" );
    a_Matrix3 = Matrix3( randfloat() );
    print( a_Matrix3, "set Matrix3 with float" );
    a_Matrix3 = Matrix3( scalar_float(randfloat()) );
    print( a_Matrix3, "set Matrix3 with float" );
    a_Matrix3 = Matrix3( 0.0f );
    print( a_Matrix3, "set elements to zero" );
    a_Matrix3 = Matrix3::identity( );
    print( a_Matrix3, "set to identity" );
    a_Matrix3 = Matrix3::rotationX( randfloat() );
    print( a_Matrix3, "set to rotationX" );
    a_Matrix3 = Matrix3::rotationY( randfloat() );
    print( a_Matrix3, "set to rotationY" );
    a_Matrix3 = Matrix3::rotationZ( randfloat() );
    print( a_Matrix3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Matrix3 = Matrix3::rotationZYX( Vector3( rndflt3, rndflt2, rndflt1 ) );
    print( a_Matrix3, "set to rotation from Z,Y,X angles" );
    a_Matrix3 = Matrix3::rotation( randfloat(), normalize( a_Vector3 ) );
    print( a_Matrix3, "set to rotation from axis angle" );
    a_Matrix3.setCol0( a_Vector3 );
    print( a_Matrix3, "Matrix3 set col 0" );
    a_Matrix3.setCol1( a_Vector3 );
    print( a_Matrix3, "Matrix3 set col 1" );
    a_Matrix3.setCol2( a_Vector3 );
    print( a_Matrix3, "Matrix3 set col 2" );
    print( a_Matrix3.getCol0( ), "Matrix3 get col 0" );
    print( a_Matrix3.getCol1( ), "Matrix3 get col 1" );
    print( a_Matrix3.getCol2( ), "Matrix3 get col 2" );
    a_Matrix3.setCol( 0, b_Vector3 );
    print( a_Matrix3, "Matrix3 set col 0" );
    a_Matrix3.setCol( 1, b_Vector3 );
    print( a_Matrix3, "Matrix3 set col 1" );
    a_Matrix3.setCol( 2, b_Vector3 );
    print( a_Matrix3, "Matrix3 set col 2" );
    print( a_Matrix3.getCol( 0 ), "Matrix3 get col 0" );
    print( a_Matrix3.getCol( 1 ), "Matrix3 get col 1" );
    print( a_Matrix3.getCol( 2 ), "Matrix3 get col 2" );
    a_Matrix3.setRow( 0, a_Vector3 );
    print( a_Matrix3, "Matrix3 set row 0" );
    a_Matrix3.setRow( 1, a_Vector3 );
    print( a_Matrix3, "Matrix3 set row 1" );
    a_Matrix3.setRow( 2, a_Vector3 );
    print( a_Matrix3, "Matrix3 set row 2" );
    print( a_Matrix3.getRow( 0 ), "Matrix3 get row 0" );
    print( a_Matrix3.getRow( 1 ), "Matrix3 get row 1" );
    print( a_Matrix3.getRow( 2 ), "Matrix3 get row 2" );
    a_Matrix3[0] = a_Vector3;
    print( a_Matrix3, "set Matrix3[0]" );
    a_Matrix3[1] = a_Vector3;
    print( a_Matrix3, "set Matrix3[1]" );
    a_Matrix3[2] = a_Vector3;
    print( a_Matrix3, "set Matrix3[2]" );
    a_Matrix3[0] = a_Vector3;
    print( a_Matrix3[0], "get Matrix3[0]" );
    a_Matrix3[1] = a_Vector3;
    print( a_Matrix3[1], "get Matrix3[1]" );
    a_Matrix3[2] = a_Vector3;
    print( a_Matrix3[2], "get Matrix3[2]" );
    a_Matrix3.setElem( 0, 0, randfloat() );
    a_Matrix3.setElem( 0, 1, randfloat() );
    a_Matrix3.setElem( 0, 2, randfloat() );
    a_Matrix3.setElem( 1, 0, randfloat() );
    a_Matrix3.setElem( 1, 1, randfloat() );
    a_Matrix3.setElem( 1, 2, randfloat() );
    a_Matrix3.setElem( 2, 0, randfloat() );
    a_Matrix3.setElem( 2, 1, randfloat() );
    a_Matrix3.setElem( 2, 2, randfloat() );
    print( a_Matrix3, "Matrix3 set elements" );
    printf("%f\n", getfloat(a_Matrix3.getElem( 0, 0 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 0, 1 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 0, 2 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 1, 0 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 1, 1 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 1, 2 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 2, 0 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 2, 1 )) );
    printf("%f\n", getfloat(a_Matrix3.getElem( 2, 2 )) );
}

void
Matrix4_methods_test()
{
    Matrix3 a_Matrix3, b_Matrix3;
    Matrix4 a_Matrix4, b_Matrix4;
    Transform3 a_Transform3, b_Transform3;
    Vector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    Vector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    Point3 a_Point3, b_Point3, c_Point3, d_Point3;
    Quat a_Quat, b_Quat, c_Quat, d_Quat;
    Vector4 tmpV4;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector3 = Vector3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( a_Vector3, pad );
    a_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( b_Vector3, pad );
    b_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( c_Vector3, pad );
    c_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( d_Vector3, pad );
    d_Vector3 = tmpV4.getXYZ( );
    print( a_Vector3, "set Vector3 with floats" );
    print( b_Vector3, "set Vector3 with floats" );
    print( c_Vector3, "set Vector3 with floats" );
    print( d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector4 = Vector4( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Vector4, "set Vector4 with floats" );
    print( b_Vector4, "set Vector4 with floats" );
    print( c_Vector4, "set Vector4 with floats" );
    print( d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Point3 = Point3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( Vector3( a_Point3 ), pad );
    a_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( b_Point3 ), pad );
    b_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( c_Point3 ), pad );
    c_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( d_Point3 ), pad );
    d_Point3 = Point3( tmpV4.getXYZ( ) );
    print( a_Point3, "set Point3 with floats" );
    print( b_Point3, "set Point3 with floats" );
    print( c_Point3, "set Point3 with floats" );
    print( d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Quat = Quat( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Quat, "set Quat with floats" );
    print( b_Quat, "set Quat with floats" );
    print( c_Quat, "set Quat with floats" );
    print( d_Quat, "set Quat with floats" );
    a_Matrix3 = Matrix3( a_Vector3, b_Vector3, c_Vector3 );
    b_Matrix3 = Matrix3( d_Vector3, a_Vector3, b_Vector3 );
    print( a_Matrix3, "set Matrix3 columns" );
    print( b_Matrix3, "set Matrix3 columns" );
    a_Matrix4 = Matrix4( a_Vector4, b_Vector4, c_Vector4, d_Vector4 );
    b_Matrix4 = Matrix4( d_Vector4, a_Vector4, b_Vector4, c_Vector4 );
    print( a_Matrix4, "set Matrix4 columns" );
    print( b_Matrix4, "set Matrix4 columns" );
    a_Transform3 = Transform3( a_Vector3, b_Vector3, c_Vector3, d_Vector3 );
    b_Transform3 = Transform3( d_Vector3, a_Vector3, b_Vector3, c_Vector3 );
    print( a_Transform3, "set Transform3 columns" );
    print( b_Transform3, "set Transform3 columns" );
    a_Matrix4 = Matrix4( a_Transform3 );
    print( a_Matrix4, "construct Matrix4 with Transform3" );
    a_Matrix4 = Matrix4( a_Matrix3, a_Vector3 );
    print( a_Matrix4, "construct Matrix4 with Matrix3 and Vector3" );
    a_Matrix4 = Matrix4( a_Quat, a_Vector3 );
    print( a_Matrix4, "construct Matrix4 with Quat and Vector3" );
    a_Matrix4 = b_Matrix4;
    print( a_Matrix4, "assign to Matrix4 from Matrix4" );
    a_Matrix4 = Matrix4( randfloat() );
    print( a_Matrix4, "set Matrix4 with float" );
    a_Matrix4 = Matrix4( scalar_float(randfloat()) );
    print( a_Matrix4, "set Matrix4 with float" );
    a_Matrix4 = Matrix4( 0.0f );
    print( a_Matrix4, "set elements to zero" );
    a_Matrix4 = Matrix4::identity( );
    print( a_Matrix4, "set to identity" );
    a_Matrix4 = Matrix4::rotationX( randfloat() );
    print( a_Matrix4, "set to rotationX" );
    a_Matrix4 = Matrix4::rotationY( randfloat() );
    print( a_Matrix4, "set to rotationY" );
    a_Matrix4 = Matrix4::rotationZ( randfloat() );
    print( a_Matrix4, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Matrix4 = Matrix4::rotationZYX( Vector3( rndflt3, rndflt2, rndflt1 ) );
    print( a_Matrix4, "set to rotation from Z,Y,X angles" );
    a_Matrix4 = Matrix4::rotation( randfloat(), normalize( a_Vector3 ) );
    print( a_Matrix4, "set to rotation from axis angle" );
    a_Matrix4 = Matrix4::translation( a_Vector3 );
    print( a_Matrix4, "set to translation" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Matrix4 = Matrix4::perspective( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Matrix4, "set to perspective matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    a_Matrix4 = Matrix4::frustum( rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    print( a_Matrix4, "set to frustum matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    a_Matrix4 = Matrix4::orthographic( rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    print( a_Matrix4, "set to orthographic matrix" );
    a_Matrix4 = Matrix4::lookAt( a_Point3, b_Point3, a_Vector3 );
    print( a_Matrix4, "set to look-at matrix" );
    a_Matrix4.setCol0( a_Vector4 );
    print( a_Matrix4, "Matrix4 set col 0" );
    a_Matrix4.setCol1( a_Vector4 );
    print( a_Matrix4, "Matrix4 set col 1" );
    a_Matrix4.setCol2( a_Vector4 );
    print( a_Matrix4, "Matrix4 set col 2" );
    a_Matrix4.setCol3( a_Vector4 );
    print( a_Matrix4, "Matrix4 set col 3" );
    print( a_Matrix4.getCol0( ), "Matrix4 get col 0" );
    print( a_Matrix4.getCol1( ), "Matrix4 get col 1" );
    print( a_Matrix4.getCol2( ), "Matrix4 get col 2" );
    print( a_Matrix4.getCol3( ), "Matrix4 get col 3" );
    a_Matrix4.setCol( 0, b_Vector4 );
    print( a_Matrix4, "Matrix4 set col 0" );
    a_Matrix4.setCol( 1, b_Vector4 );
    print( a_Matrix4, "Matrix4 set col 1" );
    a_Matrix4.setCol( 2, b_Vector4 );
    print( a_Matrix4, "Matrix4 set col 2" );
    a_Matrix4.setCol( 3, b_Vector4 );
    print( a_Matrix4, "Matrix4 set col 3" );
    print( a_Matrix4.getCol( 0 ), "Matrix4 get col 0" );
    print( a_Matrix4.getCol( 1 ), "Matrix4 get col 1" );
    print( a_Matrix4.getCol( 2 ), "Matrix4 get col 2" );
    print( a_Matrix4.getCol( 3 ), "Matrix4 get col 3" );
    a_Matrix4.setRow( 0, a_Vector4 );
    print( a_Matrix4, "Matrix4 set row 0" );
    a_Matrix4.setRow( 1, a_Vector4 );
    print( a_Matrix4, "Matrix4 set row 1" );
    a_Matrix4.setRow( 2, a_Vector4 );
    print( a_Matrix4, "Matrix4 set row 2" );
    a_Matrix4.setRow( 3, a_Vector4 );
    print( a_Matrix4, "Matrix4 set row 3" );
    print( a_Matrix4.getRow( 0 ), "Matrix4 get row 0" );
    print( a_Matrix4.getRow( 1 ), "Matrix4 get row 1" );
    print( a_Matrix4.getRow( 2 ), "Matrix4 get row 2" );
    print( a_Matrix4.getRow( 3 ), "Matrix4 get row 3" );
    a_Matrix4[0] = a_Vector4;
    print( a_Matrix4, "set Matrix4[0]" );
    a_Matrix4[1] = a_Vector4;
    print( a_Matrix4, "set Matrix4[1]" );
    a_Matrix4[2] = a_Vector4;
    print( a_Matrix4, "set Matrix4[2]" );
    a_Matrix4[3] = a_Vector4;
    print( a_Matrix4, "set Matrix4[3]" );
    a_Matrix4[0] = a_Vector4;
    print( a_Matrix4[0], "get Matrix4[0]" );
    a_Matrix4[1] = a_Vector4;
    print( a_Matrix4[1], "get Matrix4[1]" );
    a_Matrix4[2] = a_Vector4;
    print( a_Matrix4[2], "get Matrix4[2]" );
    a_Matrix4[3] = a_Vector4;
    print( a_Matrix4[3], "get Matrix4[3]" );
    a_Matrix4.setElem( 0, 0, randfloat() );
    a_Matrix4.setElem( 0, 1, randfloat() );
    a_Matrix4.setElem( 0, 2, randfloat() );
    a_Matrix4.setElem( 0, 3, randfloat() );
    a_Matrix4.setElem( 1, 0, randfloat() );
    a_Matrix4.setElem( 1, 1, randfloat() );
    a_Matrix4.setElem( 1, 2, randfloat() );
    a_Matrix4.setElem( 1, 3, randfloat() );
    a_Matrix4.setElem( 2, 0, randfloat() );
    a_Matrix4.setElem( 2, 1, randfloat() );
    a_Matrix4.setElem( 2, 2, randfloat() );
    a_Matrix4.setElem( 2, 3, randfloat() );
    a_Matrix4.setElem( 3, 0, randfloat() );
    a_Matrix4.setElem( 3, 1, randfloat() );
    a_Matrix4.setElem( 3, 2, randfloat() );
    a_Matrix4.setElem( 3, 3, randfloat() );
    print( a_Matrix4, "Matrix4 set elements" );
    printf("%f\n", getfloat(a_Matrix4.getElem( 0, 0 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 0, 1 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 0, 2 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 0, 3 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 1, 0 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 1, 1 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 1, 2 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 1, 3 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 2, 0 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 2, 1 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 2, 2 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 2, 3 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 3, 0 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 3, 1 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 3, 2 )) );
    printf("%f\n", getfloat(a_Matrix4.getElem( 3, 3 )) );
}

void
Transform3_methods_test()
{
    Matrix3 a_Matrix3, b_Matrix3;
    Matrix4 a_Matrix4, b_Matrix4;
    Transform3 a_Transform3, b_Transform3;
    Vector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    Vector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    Point3 a_Point3, b_Point3, c_Point3, d_Point3;
    Quat a_Quat, b_Quat, c_Quat, d_Quat;
    Vector4 tmpV4;
    float rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector3 = Vector3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Vector3 = Vector3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( a_Vector3, pad );
    a_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( b_Vector3, pad );
    b_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( c_Vector3, pad );
    c_Vector3 = tmpV4.getXYZ( );
    tmpV4 = Vector4( d_Vector3, pad );
    d_Vector3 = tmpV4.getXYZ( );
    print( a_Vector3, "set Vector3 with floats" );
    print( b_Vector3, "set Vector3 with floats" );
    print( c_Vector3, "set Vector3 with floats" );
    print( d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Vector4 = Vector4( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Vector4 = Vector4( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Vector4, "set Vector4 with floats" );
    print( b_Vector4, "set Vector4 with floats" );
    print( c_Vector4, "set Vector4 with floats" );
    print( d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Point3 = Point3( rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    c_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    d_Point3 = Point3( rndflt1, rndflt2, rndflt3 );
    tmpV4 = Vector4( Vector3( a_Point3 ), pad );
    a_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( b_Point3 ), pad );
    b_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( c_Point3 ), pad );
    c_Point3 = Point3( tmpV4.getXYZ( ) );
    tmpV4 = Vector4( Vector3( d_Point3 ), pad );
    d_Point3 = Point3( tmpV4.getXYZ( ) );
    print( a_Point3, "set Point3 with floats" );
    print( b_Point3, "set Point3 with floats" );
    print( c_Point3, "set Point3 with floats" );
    print( d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    a_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    b_Quat = Quat( rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    c_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    d_Quat = Quat( rndflt1, rndflt2, rndflt3, rndflt4 );
    print( a_Quat, "set Quat with floats" );
    print( b_Quat, "set Quat with floats" );
    print( c_Quat, "set Quat with floats" );
    print( d_Quat, "set Quat with floats" );
    a_Matrix3 = Matrix3( a_Vector3, b_Vector3, c_Vector3 );
    b_Matrix3 = Matrix3( d_Vector3, a_Vector3, b_Vector3 );
    print( a_Matrix3, "set Matrix3 columns" );
    print( b_Matrix3, "set Matrix3 columns" );
    a_Matrix4 = Matrix4( a_Vector4, b_Vector4, c_Vector4, d_Vector4 );
    b_Matrix4 = Matrix4( d_Vector4, a_Vector4, b_Vector4, c_Vector4 );
    print( a_Matrix4, "set Matrix4 columns" );
    print( b_Matrix4, "set Matrix4 columns" );
    a_Transform3 = Transform3( a_Vector3, b_Vector3, c_Vector3, d_Vector3 );
    b_Transform3 = Transform3( d_Vector3, a_Vector3, b_Vector3, c_Vector3 );
    print( a_Transform3, "set Transform3 columns" );
    print( b_Transform3, "set Transform3 columns" );
    a_Transform3 = Transform3( a_Matrix3, a_Vector3 );
    print( a_Transform3, "construct Transform3 with Matrix3 and Vector3" );
    a_Transform3 = Transform3( a_Quat, a_Vector3 );
    print( a_Transform3, "construct Transform3 with Quat and Vector3" );
    a_Transform3 = b_Transform3;
    print( a_Transform3, "assign to Transform3 from Transform3" );
    a_Transform3 = Transform3( randfloat() );
    print( a_Transform3, "set Transform3 with float" );
    a_Transform3 = Transform3( scalar_float(randfloat()) );
    print( a_Transform3, "set Transform3 with float" );
    a_Transform3 = Transform3( 0.0f );
    print( a_Transform3, "set elements to zero" );
    a_Transform3 = Transform3::identity( );
    print( a_Transform3, "set to identity" );
    a_Transform3 = Transform3::rotationX( randfloat() );
    print( a_Transform3, "set to rotationX" );
    a_Transform3 = Transform3::rotationY( randfloat() );
    print( a_Transform3, "set to rotationY" );
    a_Transform3 = Transform3::rotationZ( randfloat() );
    print( a_Transform3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    a_Transform3 = Transform3::rotationZYX( Vector3( rndflt3, rndflt2, rndflt1 ) );
    print( a_Transform3, "set to rotation from Z,Y,X angles" );
    a_Transform3 = Transform3::rotation( randfloat(), normalize( a_Vector3 ) );
    print( a_Transform3, "set to rotation from axis angle" );
    a_Transform3 = Transform3::translation( a_Vector3 );
    print( a_Transform3, "set to translation" );
    a_Transform3.setCol0( a_Vector3 );
    print( a_Transform3, "Transform3 set col 0" );
    a_Transform3.setCol1( a_Vector3 );
    print( a_Transform3, "Transform3 set col 1" );
    a_Transform3.setCol2( a_Vector3 );
    print( a_Transform3, "Transform3 set col 2" );
    a_Transform3.setCol3( a_Vector3 );
    print( a_Transform3, "Transform3 set col 3" );
    print( a_Transform3.getCol0( ), "Transform3 get col 0" );
    print( a_Transform3.getCol1( ), "Transform3 get col 1" );
    print( a_Transform3.getCol2( ), "Transform3 get col 2" );
    print( a_Transform3.getCol3( ), "Transform3 get col 3" );
    a_Transform3.setCol( 0, b_Vector3 );
    print( a_Transform3, "Transform3 set col 0" );
    a_Transform3.setCol( 1, b_Vector3 );
    print( a_Transform3, "Transform3 set col 1" );
    a_Transform3.setCol( 2, b_Vector3 );
    print( a_Transform3, "Transform3 set col 2" );
    a_Transform3.setCol( 3, b_Vector3 );
    print( a_Transform3, "Transform3 set col 3" );
    print( a_Transform3.getCol( 0 ), "Transform3 get col 0" );
    print( a_Transform3.getCol( 1 ), "Transform3 get col 1" );
    print( a_Transform3.getCol( 2 ), "Transform3 get col 2" );
    print( a_Transform3.getCol( 3 ), "Transform3 get col 3" );
    a_Transform3.setRow( 0, a_Vector4 );
    print( a_Transform3, "Transform3 set row 0" );
    a_Transform3.setRow( 1, a_Vector4 );
    print( a_Transform3, "Transform3 set row 1" );
    a_Transform3.setRow( 2, a_Vector4 );
    print( a_Transform3, "Transform3 set row 2" );
    print( a_Transform3.getRow( 0 ), "Transform3 get row 0" );
    print( a_Transform3.getRow( 1 ), "Transform3 get row 1" );
    print( a_Transform3.getRow( 2 ), "Transform3 get row 2" );
    a_Transform3[0] = a_Vector3;
    print( a_Transform3, "set Transform3[0]" );
    a_Transform3[1] = a_Vector3;
    print( a_Transform3, "set Transform3[1]" );
    a_Transform3[2] = a_Vector3;
    print( a_Transform3, "set Transform3[2]" );
    a_Transform3[3] = a_Vector3;
    print( a_Transform3, "set Transform3[3]" );
    a_Transform3[0] = a_Vector3;
    print( a_Transform3[0], "get Transform3[0]" );
    a_Transform3[1] = a_Vector3;
    print( a_Transform3[1], "get Transform3[1]" );
    a_Transform3[2] = a_Vector3;
    print( a_Transform3[2], "get Transform3[2]" );
    a_Transform3[3] = a_Vector3;
    print( a_Transform3[3], "get Transform3[3]" );
    a_Transform3.setElem( 0, 0, randfloat() );
    a_Transform3.setElem( 0, 1, randfloat() );
    a_Transform3.setElem( 0, 2, randfloat() );
    a_Transform3.setElem( 1, 0, randfloat() );
    a_Transform3.setElem( 1, 1, randfloat() );
    a_Transform3.setElem( 1, 2, randfloat() );
    a_Transform3.setElem( 2, 0, randfloat() );
    a_Transform3.setElem( 2, 1, randfloat() );
    a_Transform3.setElem( 2, 2, randfloat() );
    a_Transform3.setElem( 3, 0, randfloat() );
    a_Transform3.setElem( 3, 1, randfloat() );
    a_Transform3.setElem( 3, 2, randfloat() );
    print( a_Transform3, "Transform3 set elements" );
    printf("%f\n", getfloat(a_Transform3.getElem( 0, 0 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 0, 1 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 0, 2 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 1, 0 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 1, 1 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 1, 2 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 2, 0 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 2, 1 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 2, 2 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 3, 0 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 3, 1 )) );
    printf("%f\n", getfloat(a_Transform3.getElem( 3, 2 )) );
}

int main()
{
    int i;
    printf("\n __begin__ \n");
    for ( i = 0; i < 2; i++ ) {
        Matrix3_methods_test();
        Matrix4_methods_test();
        Transform3_methods_test();
    }
    printf("\n __end__ \n");
    return 0;
}
