
#include <config.h>
#include <stdio.h>
#include "global.h"

/* output motion vectors (6.2.5.2, 6.3.16.2)
 *
 * this routine also updates the predictions for motion vectors (PMV)
 */
static void putmvs(
	pict_data_s *picture,
	mbinfo_s *mb,
	int PMV[2][2][2],
	int back )

{
	int hor_f_code;
	int vert_f_code;

	if( back )
	{
		hor_f_code = picture->back_hor_f_code;
		vert_f_code = picture->back_vert_f_code;
	}
	else
	{
		hor_f_code = picture->forw_hor_f_code;
		vert_f_code = picture->forw_vert_f_code;
	}

	if (mb->motion_type==MC_FRAME)
	{
		/* frame prediction */
		putmv(mb->MV[0][back][0]-PMV[0][back][0],hor_f_code);
		putmv(mb->MV[0][back][1]-PMV[0][back][1],vert_f_code);
		PMV[0][back][0]=PMV[1][back][0]=mb->MV[0][back][0];
		PMV[0][back][1]=PMV[1][back][1]=mb->MV[0][back][1];
	}
	else if (mb->motion_type==MC_FIELD)
	{
		/* field prediction */

		putbits(mb->mv_field_sel[0][back],1);
		putmv(mb->MV[0][back][0]-PMV[0][back][0],hor_f_code);
		putmv((mb->MV[0][back][1]>>1)-(PMV[0][back][1]>>1),vert_f_code);
		putbits(mb->mv_field_sel[1][back],1);
		putmv(mb->MV[1][back][0]-PMV[1][back][0],hor_f_code);
		putmv((mb->MV[1][back][1]>>1)-(PMV[1][back][1]>>1),vert_f_code);
		PMV[0][back][0]=mb->MV[0][back][0];
		PMV[0][back][1]=mb->MV[0][back][1];
		PMV[1][back][0]=mb->MV[1][back][0];
		PMV[1][back][1]=mb->MV[1][back][1];

	}
	else
	{
		/* dual prime prediction */
		putmv(mb->MV[0][back][0]-PMV[0][back][0],hor_f_code);
		putdmv(mb->dmvector[0]);
		putmv((mb->MV[0][back][1]>>1)-(PMV[0][back][1]>>1),vert_f_code);
		putdmv(mb->dmvector[1]);
		PMV[0][back][0]=PMV[1][back][0]=mb->MV[0][back][0];
		PMV[0][back][1]=PMV[1][back][1]=mb->MV[0][back][1];
	}

}


void putpictdata(pict_data_s *picture, int cur_mquant)
{
	int i, j, k, comp, cc;
	int mb_type;
	int PMV[2][2][2];
	int cbp, MBAinc;
	mbinfo_s *cur_mb;
	int cur_mb_blocks;
	short (*quant_blocks)[64] = picture->qblocks;
	MBAinc = 0;          /* Annoying warning otherwise... */


    //if( picture->decode == 0 || (picture->gop_start && opt_seq_hdr_every_gop) )
	if ( picture->seqHead)
			putseqhdr();

	if( picture->gop_start )
		putgophdr( picture->decode, picture->decode == 0 );


	/* picture header and picture coding extension */
	putpicthdr(picture);
	putpictcodext(picture);

	if( opt_svcd_scan_data && picture->pict_type == I_TYPE )
		putuserdata( dummy_svcd_scan_data, sizeof(dummy_svcd_scan_data) );

	k = 0;

	for (j=0; j<mb_height2; j++)
	{
		/* macroblock row loop */
		for (i=0; i<mb_width; i++)
		{
			cur_mb = &picture->mbinfo[k];
			cur_mb_blocks = k*block_count;
			/* macroblock loop */
			if (i==0)
			{
				/* slice header (6.2.4) */
				alignbits();

				if (opt_vertical_size<=2800)
					putbits(SLICE_MIN_START+j,32); /* slice_start_code */
				else
				{
					putbits(SLICE_MIN_START+(j&127),32); /* slice_start_code */
					putbits(j>>7,3); /* slice_vertical_position_extension */
				}
  
				/* quantiser_scale_code */
				putbits(picture->q_scale_type ? 
						map_non_linear_mquant[cur_mquant]
						: cur_mquant >> 1, 5);
  
				putbits(0,1); /* extra_bit_slice */
  
				/* reset predictors */

				for (cc=0; cc<3; cc++)
					dc_dct_pred[cc] = 0;

				PMV[0][0][0]=PMV[0][0][1]=PMV[1][0][0]=PMV[1][0][1]=0;
				PMV[0][1][0]=PMV[0][1][1]=PMV[1][1][0]=PMV[1][1][1]=0;
  
				MBAinc = i + 1; /* first MBAinc denotes absolute position */
			}
			
			mb_type = (cur_mb->mb_type & 0xD);
			cur_mb->mquant = cur_mquant;

			/* quantize macroblock */
			if (mb_type & MB_INTRA)
			{
				quant_intra( picture,
					         picture->blocks[cur_mb_blocks],
							 quant_blocks[cur_mb_blocks],
							 cur_mb->mquant, 
							 &cur_mb->mquant );
		
				cur_mb->cbp = cbp = (1<<block_count) - 1;
			}
			else
			{
				cbp = (*pquant_non_intra)(picture,
									  picture->blocks[cur_mb_blocks],
									  quant_blocks[cur_mb_blocks],
									  cur_mb->mquant,
									  &cur_mb->mquant );
				cur_mb->cbp = cbp;
				if (cbp) mb_type|= MB_PATTERN;
			}


			/* check if macroblock can be skipped */
			if (i!=0 && i!=mb_width-1 && !cbp)
			{
				/* no DCT coefficients and neither first nor last macroblock of slice */

				if (picture->pict_type==P_TYPE && !(mb_type&MB_FORWARD))
				{
					/* P picture, no motion vectors -> skip */
					/* reset predictors */

					for (cc=0; cc<3; cc++) dc_dct_pred[cc] = 0;

					PMV[0][0][0]=PMV[0][0][1]=PMV[1][0][0]=PMV[1][0][1]=0;
					PMV[0][1][0]=PMV[0][1][1]=PMV[1][1][0]=PMV[1][1][1]=0;

					cur_mb->mb_type = mb_type;
					cur_mb->skipped = 1;
					MBAinc++;
					k++;
					continue;
				}

				if (picture->pict_type==B_TYPE &&
					picture->pict_struct==FRAME_PICTURE
					&& cur_mb->motion_type==MC_FRAME
					&& ((picture->mbinfo[k-1].mb_type^mb_type)&(MB_FORWARD|MB_BACKWARD))==0
					&& (!(mb_type&MB_FORWARD) ||
						(PMV[0][0][0]==cur_mb->MV[0][0][0] &&
						 PMV[0][0][1]==cur_mb->MV[0][0][1]))
					&& (!(mb_type&MB_BACKWARD) ||
						(PMV[0][1][0]==cur_mb->MV[0][1][0] &&
						 PMV[0][1][1]==cur_mb->MV[0][1][1])))
				{
					/* conditions for skipping in B frame pictures:
					 * - must be frame predicted
					 * - must be the same prediction type (forward/backward/interp.)
					 *   as previous macroblock
					 * - relevant vectors (forward/backward/both) have to be the same
					 *   as in previous macroblock
					 */

					cur_mb->mb_type = mb_type;
					cur_mb->skipped = 1;
					MBAinc++;
					k++;
					continue;
				}

				if (picture->pict_type==B_TYPE 
					&& picture->pict_struct!=FRAME_PICTURE
					&& cur_mb->motion_type==MC_FIELD
					&& ((picture->mbinfo[k-1].mb_type^mb_type)&(MB_FORWARD|MB_BACKWARD))==0
					&& (!(mb_type&MB_FORWARD) ||
						(PMV[0][0][0]==cur_mb->MV[0][0][0] &&
						 PMV[0][0][1]==cur_mb->MV[0][0][1] &&
						 cur_mb->mv_field_sel[0][0]==(picture->pict_struct==BOTTOM_FIELD)))
					&& (!(mb_type&MB_BACKWARD) ||
						(PMV[0][1][0]==cur_mb->MV[0][1][0] &&
						 PMV[0][1][1]==cur_mb->MV[0][1][1] &&
						 cur_mb->mv_field_sel[0][1]==(picture->pict_struct==BOTTOM_FIELD))))
				{
					/* conditions for skipping in B field pictures:
					 * - must be field predicted
					 * - must be the same prediction type (forward/backward/interp.)
					 *   as previous macroblock
					 * - relevant vectors (forward/backward/both) have to be the same
					 *   as in previous macroblock
					 * - relevant motion_vertical_field_selects have to be of same
					 *   parity as current field
					 */

					cur_mb->mb_type = mb_type;
					cur_mb->skipped = 1;
					MBAinc++;
					k++;
					continue;
				}
			}

			/* macroblock cannot be skipped */
			cur_mb->skipped = 0;

			/* there's no VLC for 'No MC, Not Coded':
			 * we have to transmit (0,0) motion vectors */
			if (picture->pict_type==P_TYPE && !cbp && !(mb_type&MB_FORWARD))
				mb_type |= MB_FORWARD;

			putaddrinc(MBAinc); /* macroblock_address_increment */
			MBAinc = 1;

			putmbtype(picture->pict_type,mb_type); /* macroblock type */

			if (mb_type & MB_FORWARD)
			{
				/* forward motion vectors, update predictors */
				putmvs(picture, cur_mb, PMV,  0 );
			}

			if (mb_type & MB_BACKWARD)
			{
				/* backward motion vectors, update predictors */
				putmvs(picture,  cur_mb, PMV, 1 );
			}

			if (mb_type & MB_PATTERN)
			{
				putcbp((cbp >> (block_count-6)) & 63);
				if (opt_chroma_format!=CHROMA420) putbits(cbp,block_count-6);
			}

			for (comp=0; comp<block_count; comp++)
			{
				/* block loop */
				if (cbp & (1<<(block_count-1-comp)))
				{
					if (mb_type & MB_INTRA)
					{
						cc = (comp<4) ? 0 : (comp&1)+1;
						putintrablk(picture,quant_blocks[cur_mb_blocks+comp],cc);
					}
					else
					{
						putnonintrablk(picture,quant_blocks[cur_mb_blocks+comp]);
					}
				}
			}

			/* reset predictors */
			if (!(mb_type & MB_INTRA))
				for (cc=0; cc<3; cc++) dc_dct_pred[cc] = 0;

			if (mb_type & MB_INTRA || 
				(picture->pict_type==P_TYPE && !(mb_type & MB_FORWARD)))
			{
				PMV[0][0][0]=PMV[0][0][1]=PMV[1][0][0]=PMV[1][0][1]=0;
				PMV[0][1][0]=PMV[0][1][1]=PMV[1][1][0]=PMV[1][1][1]=0;
			}

			cur_mb->mb_type = mb_type;
			k++;
		}
	}
	
	alignbits();
}

static int increment_quant(pict_data_s *picture, int quant)
{
	if (picture->q_scale_type)
	{
		quant = map_non_linear_mquant[quant] + 1;
		if (quant > 31) quant = 31;
		quant = non_linear_mquant_table[quant];
	}
	else
	{
		quant += 2;
		if (quant > 62) quant = 62;
	}
	return quant;
}

static int is_maxquant(pict_data_s *picture, int quant)
{
	if ((picture->q_scale_type) && (quant == 112)) return 1;
	else if (quant == 62) return 1;
	return 0;
}

static int decrement_quant(pict_data_s *picture, int quant)
{
	if (picture->q_scale_type)
	{
		quant = map_non_linear_mquant[quant] - 1;
		if (quant < 1) quant = 1;
		quant = non_linear_mquant_table[quant];
	}
	else
	{
		quant -= 2;
		if (quant < 2) quant = 2;
	}
	return quant;
}

static int is_minquant(pict_data_s *picture, int quant)
{
	if ((picture->q_scale_type) && (quant == 1)) return 1;
	else if (quant == 2) return 1;
	return 0;
}

void Clear_Block(int16_t *blk)
{
  short *Block_Ptr = blk, a;
  for (a=0; a<64*block_count; a++) *Block_Ptr++ = 0;
}

int DC_sum(int16_t *blk)
{
  short *Block_Ptr = blk, a;
  a = *Block_Ptr; Block_Ptr += 64;
  a += *Block_Ptr; Block_Ptr += 64;
  a += *Block_Ptr; Block_Ptr += 64;
  a += *Block_Ptr;
  return a;
}

void DC_set(int16_t *blk, int DC)
{
  short *Block_Ptr = blk;
  *Block_Ptr = DC; Block_Ptr += 64;
  *Block_Ptr = DC; Block_Ptr += 64;
  *Block_Ptr = DC; Block_Ptr += 64;
  *Block_Ptr = DC;
}


void erasepictdata(pict_data_s *picture)
{
	int i, j, k;
	int cur_mb_blocks;
	int averageDC = 0;
	mbinfo_s *cur_mb;
	
//	fprintf(stderr, "-*");

	picture->dc_prec = 0;
	
	if (picture->pict_type==I_TYPE)
	{
		k = 0; averageDC = 0;
		for (j=0; j<mb_height2; j++)
		{
			for (i=0; i<mb_width; i++)
			{
				cur_mb = &picture->mbinfo[k];
				cur_mb_blocks = k*block_count;
				averageDC += DC_sum(picture->blocks[cur_mb_blocks]);
				k++;
			}
		}
		averageDC /= mb_height2 * mb_width * 4;
	}
	
	k = 0;
	for (j=0; j<mb_height2; j++)
	{
		for (i=0; i<mb_width; i++)
		{
			cur_mb = &picture->mbinfo[k];
			cur_mb_blocks = k*block_count;
			
			Clear_Block(picture->blocks[cur_mb_blocks]);
			
			if (picture->pict_type==I_TYPE)
			{
				DC_set(picture->blocks[cur_mb_blocks], averageDC);
			}
			else if (picture->pict_type==P_TYPE)
			{
				cur_mb->mb_type = 0;
				cur_mb->motion_type = MC_FRAME;
				cur_mb->MV[0][0][0] = 0;
				cur_mb->MV[0][0][1] = 0;
			}
			else if (picture->pict_type==B_TYPE)
			{
				cur_mb->mb_type = MB_FORWARD | MB_BACKWARD;
				cur_mb->MV[0][0][0] = 0;
				cur_mb->MV[0][0][1] = 0;
				cur_mb->MV[0][1][0] = 0;
				cur_mb->MV[0][1][1] = 0;
			}

			k++;
		}
	}
}


void putpict(pict_data_s *picture )
{
	int mquant;
	int erased = 0;
	int newSize;
	int oriSize = picture->pictSize;
	int dstSize = oriSize / opt_fact_x;
	int minSize = 0;
	
	switch(picture->pict_type)
	{
		case I_TYPE: minSize = dstSize      ; break;
		case P_TYPE: minSize = dstSize * 0.8; break;
		case B_TYPE: minSize = dstSize * 0.3; break;
	}
	
	writeBuffer();
	
	/*while(1)
	{
		putpictdata(picture, mquant);
		newSize = bufferSize();
		if (newSize >= picture->pictSize)
		{
			if (!is_maxquant(picture, mquant))
			{
				resetBuffer();
				mquant = increment_quant(picture, mquant);
			}
			else if (!erased)
			{
				resetBuffer();
				erasepictdata(picture);
				erased = 1;
			}
			else break;
		}
		else if (newSize < minSize)
		{
			if (!is_minquant(picture, mquant))
			{
				resetBuffer();
				mquant = decrement_quant(picture, mquant);
			}
			else break;
		}
		else break;
	}*/
	
	mquant = rc_calc_mquant(picture);
	putpictdata(picture, mquant);
	newSize = bufferSize();
	
	while(newSize < minSize)
	{
		if (!is_minquant(picture, mquant))
		{
			resetBuffer();
			mquant = decrement_quant(picture, mquant);
			putpictdata(picture, mquant);
			newSize = bufferSize();
		}
		else break;
	}
	
	while(newSize >= picture->pictSize)
	{
		if (!is_maxquant(picture, mquant))
		{
			resetBuffer();
			mquant = increment_quant(picture, mquant);
			putpictdata(picture, mquant);
			newSize = bufferSize();
		}
		else if (!erased)
		{
			resetBuffer();
			erasepictdata(picture); erased = 1;
			putpictdata(picture, mquant);
			newSize = bufferSize();
		}
		else break;
	}
	
	switch(picture->pict_type)
	{
		case I_TYPE: lastIquant = mquant; break;
		case P_TYPE: lastPquant = mquant; break;
		case B_TYPE: lastBquant = mquant; break;
	}

	/*
	if (newSize > picture->pictSize)
		fprintf(stderr, "*** picture data bigger than before! type: %s oriSize: %i newSize: %i\n",
			(picture->pict_type == I_TYPE ? "I_TYPE" : (picture->pict_type == P_TYPE ? "P_TYPE" : "B_TYPE")),
			picture->pictSize, newSize);
	*/
	//fprintf(stderr, "oriSize: %i newSize: %i quant: %i\n", picture->pictSize, bufferSize(), mquant);
	//fprintf(stderr, "final_quant: %3d\n", mquant);

	writeBuffer();
}

/* 
 * Local variables:
 *  c-file-style: "stroustrup"
 *  tab-width: 4
 *  indent-tabs-mode: nil
 * End:
 */
