/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.models.command.CommandDetail;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class CommandSet {
    private final Map<String, CommandDetail> commands;
    private final EnumSet<CommandType> availableCommands = EnumSet.noneOf(CommandType.class);

    public CommandSet(Collection<CommandDetail> commands) {
        HashMap<String, CommandDetail> map = new HashMap<String, CommandDetail>();
        for (CommandDetail command : commands) {
            map.put(command.getName().toLowerCase(), command);
            CommandType commandType = CommandSet.getCommandType(command);
            if (commandType == null) continue;
            this.availableCommands.add(commandType);
        }
        this.commands = map;
    }

    private static CommandType getCommandType(CommandDetail command) {
        try {
            return CommandType.valueOf(command.getName().toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean hasCommand(ProtocolKeyword commandName) {
        if (commandName instanceof CommandType) {
            return this.availableCommands.contains(commandName);
        }
        return this.commands.containsKey(commandName.name().toLowerCase());
    }
}

