/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.structures;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dependency.perceptron.accessories.Options;
import com.hankcs.hanlp.dependency.perceptron.learning.AveragedPerceptron;
import com.hankcs.hanlp.dependency.perceptron.structures.CompactArray;
import com.hankcs.hanlp.dependency.perceptron.structures.IndexMaps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ParserModel {
    public HashMap<Object, Float>[] shiftFeatureAveragedWeights;
    public HashMap<Object, Float>[] reduceFeatureAveragedWeights;
    public HashMap<Object, CompactArray>[] leftArcFeatureAveragedWeights;
    public HashMap<Object, CompactArray>[] rightArcFeatureAveragedWeights;
    public int dependencySize;
    public IndexMaps maps;
    public ArrayList<Integer> dependencyLabels;
    public Options options;

    public ParserModel(HashMap<Object, Float>[] shiftFeatureAveragedWeights, HashMap<Object, Float>[] reduceFeatureAveragedWeights, HashMap<Object, CompactArray>[] leftArcFeatureAveragedWeights, HashMap<Object, CompactArray>[] rightArcFeatureAveragedWeights, IndexMaps maps, ArrayList<Integer> dependencyLabels, Options options, int dependencySize) {
        this.shiftFeatureAveragedWeights = shiftFeatureAveragedWeights;
        this.reduceFeatureAveragedWeights = reduceFeatureAveragedWeights;
        this.leftArcFeatureAveragedWeights = leftArcFeatureAveragedWeights;
        this.rightArcFeatureAveragedWeights = rightArcFeatureAveragedWeights;
        this.maps = maps;
        this.dependencyLabels = dependencyLabels;
        this.options = options;
        this.dependencySize = dependencySize;
    }

    public ParserModel(AveragedPerceptron perceptron, IndexMaps maps, ArrayList<Integer> dependencyLabels, Options options) {
        this.shiftFeatureAveragedWeights = new HashMap[perceptron.shiftFeatureAveragedWeights.length];
        this.reduceFeatureAveragedWeights = new HashMap[perceptron.reduceFeatureAveragedWeights.length];
        HashMap<Object, Float>[] map = perceptron.shiftFeatureWeights;
        HashMap<Object, Float>[] avgMap = perceptron.shiftFeatureAveragedWeights;
        this.dependencySize = perceptron.dependencySize;
        for (int i = 0; i < this.shiftFeatureAveragedWeights.length; ++i) {
            this.shiftFeatureAveragedWeights[i] = new HashMap();
            for (Object feat : map[i].keySet()) {
                float vals = map[i].get(feat).floatValue();
                float avgVals = avgMap[i].get(feat).floatValue();
                float newVals = vals - avgVals / (float)perceptron.iteration;
                this.shiftFeatureAveragedWeights[i].put(feat, Float.valueOf(newVals));
            }
        }
        HashMap<Object, Float>[] map4 = perceptron.reduceFeatureWeights;
        HashMap<Object, Float>[] avgMap4 = perceptron.reduceFeatureAveragedWeights;
        this.dependencySize = perceptron.dependencySize;
        for (int i = 0; i < this.reduceFeatureAveragedWeights.length; ++i) {
            this.reduceFeatureAveragedWeights[i] = new HashMap();
            for (Object feat : map4[i].keySet()) {
                float vals = map4[i].get(feat).floatValue();
                float avgVals = avgMap4[i].get(feat).floatValue();
                float newVals = vals - avgVals / (float)perceptron.iteration;
                this.reduceFeatureAveragedWeights[i].put(feat, Float.valueOf(newVals));
            }
        }
        this.leftArcFeatureAveragedWeights = new HashMap[perceptron.leftArcFeatureAveragedWeights.length];
        HashMap<Object, CompactArray>[] map2 = perceptron.leftArcFeatureWeights;
        HashMap<Object, CompactArray>[] avgMap2 = perceptron.leftArcFeatureAveragedWeights;
        for (int i = 0; i < this.leftArcFeatureAveragedWeights.length; ++i) {
            this.leftArcFeatureAveragedWeights[i] = new HashMap();
            for (Object feat : map2[i].keySet()) {
                CompactArray vals = map2[i].get(feat);
                CompactArray avgVals = avgMap2[i].get(feat);
                this.leftArcFeatureAveragedWeights[i].put(feat, this.getAveragedCompactArray(vals, avgVals, perceptron.iteration));
            }
        }
        this.rightArcFeatureAveragedWeights = new HashMap[perceptron.rightArcFeatureAveragedWeights.length];
        HashMap<Object, CompactArray>[] map3 = perceptron.rightArcFeatureWeights;
        HashMap<Object, CompactArray>[] avgMap3 = perceptron.rightArcFeatureAveragedWeights;
        for (int i = 0; i < this.rightArcFeatureAveragedWeights.length; ++i) {
            this.rightArcFeatureAveragedWeights[i] = new HashMap();
            for (Object feat : map3[i].keySet()) {
                CompactArray vals = map3[i].get(feat);
                CompactArray avgVals = avgMap3[i].get(feat);
                this.rightArcFeatureAveragedWeights[i].put(feat, this.getAveragedCompactArray(vals, avgVals, perceptron.iteration));
            }
        }
        this.maps = maps;
        this.dependencyLabels = dependencyLabels;
        this.options = options;
    }

    public ParserModel(String modelPath) throws IOException, ClassNotFoundException {
        ObjectInputStream reader = new ObjectInputStream(new GZIPInputStream(IOUtil.newInputStream(modelPath)));
        this.dependencyLabels = (ArrayList)reader.readObject();
        this.maps = (IndexMaps)reader.readObject();
        this.options = (Options)reader.readObject();
        this.shiftFeatureAveragedWeights = (HashMap[])reader.readObject();
        this.reduceFeatureAveragedWeights = (HashMap[])reader.readObject();
        this.leftArcFeatureAveragedWeights = (HashMap[])reader.readObject();
        this.rightArcFeatureAveragedWeights = (HashMap[])reader.readObject();
        this.dependencySize = reader.readInt();
        reader.close();
    }

    public void saveModel(String modelPath) throws IOException {
        ObjectOutputStream writer = new ObjectOutputStream(new GZIPOutputStream(IOUtil.newOutputStream(modelPath)));
        writer.writeObject(this.dependencyLabels);
        writer.writeObject(this.maps);
        writer.writeObject(this.options);
        writer.writeObject(this.shiftFeatureAveragedWeights);
        writer.writeObject(this.reduceFeatureAveragedWeights);
        writer.writeObject(this.leftArcFeatureAveragedWeights);
        writer.writeObject(this.rightArcFeatureAveragedWeights);
        writer.writeInt(this.dependencySize);
        writer.close();
    }

    private CompactArray getAveragedCompactArray(CompactArray ca, CompactArray aca, int iteration) {
        int offset = ca.getOffset();
        float[] a = ca.getArray();
        float[] aa = aca.getArray();
        float[] aNew = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            aNew[i] = a[i] - aa[i] / (float)iteration;
        }
        return new CompactArray(offset, aNew);
    }
}

