/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.VectorsReader;
import java.io.IOException;
import java.util.Scanner;

public abstract class AbstractClosestVectors {
    static final int N = 40;
    protected Scanner scanner;
    protected final VectorsReader vectorsReader;

    protected AbstractClosestVectors(String file) {
        this.vectorsReader = new VectorsReader(file);
    }

    protected String[] nextWords(int n, String msg) {
        System.out.println(msg + " ('q' to break): ");
        String[] words = new String[n];
        for (int i = 0; i < n; ++i) {
            String word = this.nextWord();
            if (word == null) {
                return null;
            }
            words[i] = word;
        }
        return words;
    }

    protected String nextWord() {
        String word = this.scanner.next();
        return word == null || word.length() == 0 || word.equals("q") ? null : word;
    }

    protected abstract Result getTargetVector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute() throws IOException {
        this.vectorsReader.readVectorFile();
        int words = this.vectorsReader.getNumWords();
        int size = this.vectorsReader.getSize();
        try {
            this.scanner = new Scanner(System.in);
            Result result = null;
            while ((result = this.getTargetVector()) != null) {
                double[] bestd = new double[40];
                String[] bestw = new String[40];
                block4: for (int i = 0; i < words; ++i) {
                    int j;
                    for (int bi : result.bi) {
                        if (i == bi) continue block4;
                    }
                    double dist = 0.0;
                    for (j = 0; j < size; ++j) {
                        dist += (double)(result.vec[j] * this.vectorsReader.getMatrixElement(i, j));
                    }
                    for (j = 0; j < 40; ++j) {
                        if (!(dist > bestd[j])) continue;
                        for (int k = 39; k > j; --k) {
                            bestd[k] = bestd[k - 1];
                            bestw[k] = bestw[k - 1];
                        }
                        bestd[j] = dist;
                        bestw[j] = this.vectorsReader.getWord(i);
                        continue block4;
                    }
                }
                System.out.printf("\n                                              Word       Cosine cosine\n------------------------------------------------------------------------\n", new Object[0]);
                for (int j = 0; j < 40; ++j) {
                    System.out.printf("%50s\t\t%f\n", bestw[j], bestd[j]);
                }
            }
        }
        finally {
            this.scanner.close();
        }
    }

    protected static class Result {
        float[] vec;
        int[] bi;

        public Result(float[] vec, int[] bi) {
            this.vec = vec;
            this.bi = bi;
        }
    }
}

