/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleHandler;
import org.languagetool.tools.Tools;
import org.xml.sax.helpers.DefaultHandler;

public class PatternRuleLoader
extends DefaultHandler {
    private boolean relaxedMode = false;

    public final List<AbstractPatternRule> getRules(File file, Language lang) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            PatternRuleLoader ruleLoader = new PatternRuleLoader();
            List<AbstractPatternRule> list = ruleLoader.getRules(inputStream, file.getAbsolutePath(), lang);
            return list;
        }
    }

    public void setRelaxedMode(boolean relaxedMode) {
        this.relaxedMode = relaxedMode;
    }

    public final List<AbstractPatternRule> getRules(InputStream is, String filename, Language lang) throws IOException {
        try {
            PatternRuleHandler handler = new PatternRuleHandler(filename, lang);
            handler.setRelaxedMode(this.relaxedMode);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (JLanguageTool.isCustomPasswordAuthenticatorUsed()) {
                Tools.setPasswordAuthenticator();
            }
            saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getRules();
        }
        catch (Exception e) {
            throw new IOException("Cannot load or parse input stream of '" + filename + "'", e);
        }
    }
}

