/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import com.ibm.icu.text.Normalizer2;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.gosen.GosenNormalizerCharFilter;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.solr.common.SolrException;

public class GosenNormalizerCharFilterFactory
extends CharFilterFactory {
    private final String strNormForm;
    private final Normalizer2.Mode normMode;

    public GosenNormalizerCharFilterFactory(Map<String, String> args) {
        super(args);
        String strName = args.get("name");
        String strMode = args.get("mode");
        this.strNormForm = strName == null ? GosenNormalizerCharFilter.DEFAULT_NORM_FORM : strName;
        if (strMode == null) {
            strMode = "compose";
        }
        if (strMode.equals("compose")) {
            this.normMode = Normalizer2.Mode.COMPOSE;
        } else if (strMode.equals("decompose")) {
            this.normMode = Normalizer2.Mode.DECOMPOSE;
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid mode: " + strMode);
        }
    }

    public Reader create(Reader reader) {
        return new GosenNormalizerCharFilter(reader, this.strNormForm, this.normMode);
    }
}

