/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.CheckResults;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.xml.sax.SAXException;

class Pipeline
extends JLanguageTool {
    private boolean setup = false;

    void setupFinished() {
        this.setup = true;
    }

    Pipeline(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig, boolean inputLogging) {
        super(language, altLanguages, motherTongue, cache, globalConfig, userConfig, inputLogging);
    }

    @Override
    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        this.preventModificationAfterSetup();
        super.setCleanOverlappingMatches(cleanOverlappingMatches);
    }

    private void preventModificationAfterSetup() {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
    }

    @Override
    public void setMaxErrorsPerWordRate(float maxErrorsPerWordRate) {
        this.preventModificationAfterSetup();
        super.setMaxErrorsPerWordRate(maxErrorsPerWordRate);
    }

    @Override
    public void setOutput(PrintStream printStream) {
        this.preventModificationAfterSetup();
        super.setOutput(printStream);
    }

    @Override
    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        this.preventModificationAfterSetup();
        return super.loadPatternRules(filename);
    }

    @Override
    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        this.preventModificationAfterSetup();
        return super.loadFalseFriendRules(filename);
    }

    @Override
    public void activateLanguageModelRules(File indexDir) throws IOException {
        this.preventModificationAfterSetup();
        super.activateLanguageModelRules(indexDir);
    }

    @Override
    public void activateRemoteRules(File configFile) throws IOException {
        this.preventModificationAfterSetup();
        super.activateRemoteRules(configFile);
    }

    @Override
    public void activateRemoteRules(List<RemoteRuleConfig> configs) throws IOException {
        this.preventModificationAfterSetup();
        super.activateRemoteRules(configs);
    }

    @Override
    public void addMatchFilter(@NotNull RuleMatchFilter filter) {
        this.preventModificationAfterSetup();
        super.addMatchFilter(filter);
    }

    @Override
    public void addRule(Rule rule) {
        this.preventModificationAfterSetup();
        super.addRule(rule);
    }

    @Override
    public void disableRule(String ruleId) {
        this.preventModificationAfterSetup();
        super.disableRule(ruleId);
    }

    @Override
    public void disableRules(List<String> ruleIds) {
        this.preventModificationAfterSetup();
        super.disableRules(ruleIds);
    }

    @Override
    public void disableCategory(CategoryId id) {
        this.preventModificationAfterSetup();
        super.disableCategory(id);
    }

    @Override
    public Set<String> getDisabledRules() {
        return Collections.unmodifiableSet(super.getDisabledRules());
    }

    @Override
    public void enableRule(String ruleId) {
        this.preventModificationAfterSetup();
        super.enableRule(ruleId);
    }

    @Override
    public void enableRuleCategory(CategoryId id) {
        this.preventModificationAfterSetup();
        super.enableRuleCategory(id);
    }

    @Override
    public List<String> getUnknownWords() {
        return Collections.unmodifiableList(super.getUnknownWords());
    }

    @Override
    public Map<CategoryId, Category> getCategories() {
        return Collections.unmodifiableMap(super.getCategories());
    }

    @Override
    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(super.getAllRules());
    }

    @Override
    public List<Rule> getAllActiveRules() {
        return Collections.unmodifiableList(super.getAllActiveRules());
    }

    @Override
    public List<Rule> getAllActiveOfficeRules() {
        return Collections.unmodifiableList(super.getAllActiveOfficeRules());
    }

    @Override
    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String Id, String subId) {
        return Collections.unmodifiableList(super.getPatternRulesByIdAndSubId(Id, subId));
    }

    @Override
    public void setConfigValues(Map<String, Integer> v) {
        this.preventModificationAfterSetup();
        super.setConfigValues(v);
    }

    CheckResults checkAnalyzedSentences(List<AnalyzedSentence> analyzed, RuleMatchListener listener) throws Exception {
        List<String> sentences = analyzed.stream().map(AnalyzedSentence::getText).collect(Collectors.toList());
        String text = sentences.stream().collect(Collectors.joining());
        AnnotatedText annotated = new AnnotatedTextBuilder().addText(text).build();
        return this.checkInternal(annotated, JLanguageTool.ParagraphHandling.NORMAL, listener, JLanguageTool.Mode.ALL, JLanguageTool.Level.DEFAULT, null, sentences, analyzed);
    }

    static class IllegalPipelineMutationException
    extends RuntimeException {
        IllegalPipelineMutationException() {
            super("Pipeline is frozen; mutating shared JLanguageTool instance is forbidden.");
        }
    }
}

