/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterslave.MasterSlaveChannelWriter;
import io.lettuce.core.masterslave.MasterSlaveConnectionProvider;
import io.lettuce.core.masterslave.MasterSlaveConnector;
import io.lettuce.core.masterslave.MasterSlaveTopologyProvider;
import io.lettuce.core.masterslave.MasterSlaveTopologyRefresh;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnection;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnectionImpl;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class AutodiscoveryConnector<K, V>
implements MasterSlaveConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final RedisURI redisURI;
    private final Map<RedisURI, StatefulRedisConnection<?, ?>> initialConnections = new ConcurrentHashMap();

    AutodiscoveryConnector(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURI = redisURI;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsync() {
        ConnectionFuture<StatefulRedisConnection<K, V>> initialConnection = this.redisClient.connectAsync(this.codec, this.redisURI);
        Mono connect = Mono.fromCompletionStage(initialConnection).flatMap(nodeConnection -> {
            this.initialConnections.put(this.redisURI, (StatefulRedisConnection<?, ?>)nodeConnection);
            MasterSlaveTopologyProvider topologyProvider = new MasterSlaveTopologyProvider((StatefulRedisConnection<?, ?>)nodeConnection, this.redisURI);
            return Mono.fromCompletionStage(topologyProvider.getNodesAsync()).flatMap(nodes -> this.getMasterConnectionAndUri((List<RedisNodeDescription>)nodes, (Tuple2<RedisURI, StatefulRedisConnection<K, V>>)Tuples.of((Object)this.redisURI, (Object)nodeConnection), this.codec));
        }).flatMap(connectionAndUri -> this.initializeConnection(this.codec, (Tuple2<RedisURI, StatefulRedisConnection<K, V>>)connectionAndUri));
        return connect.onErrorResume(t -> {
            Mono close = Mono.empty();
            for (StatefulRedisConnection<?, ?> connection : this.initialConnections.values()) {
                close = close.then(Mono.fromFuture(connection.closeAsync()));
            }
            return close.then(Mono.error((Throwable)t));
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<Tuple2<RedisURI, StatefulRedisConnection<K, V>>> getMasterConnectionAndUri(List<RedisNodeDescription> nodes, Tuple2<RedisURI, StatefulRedisConnection<K, V>> connectionTuple, RedisCodec<K, V> codec) {
        RedisNodeDescription node = AutodiscoveryConnector.getConnectedNode(this.redisURI, nodes);
        if (node.getRole() != RedisInstance.Role.MASTER) {
            RedisNodeDescription master = AutodiscoveryConnector.lookupMaster(nodes);
            ConnectionFuture<StatefulRedisConnection<K, V>> masterConnection = this.redisClient.connectAsync(codec, master.getUri());
            return Mono.just((Object)master.getUri()).zipWith(Mono.fromCompletionStage(masterConnection)).doOnNext(it -> this.initialConnections.put((RedisURI)it.getT1(), (StatefulRedisConnection<?, ?>)it.getT2()));
        }
        return Mono.just(connectionTuple);
    }

    private Mono<StatefulRedisMasterSlaveConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, Tuple2<RedisURI, StatefulRedisConnection<K, V>> connectionAndUri) {
        MasterSlaveTopologyProvider topologyProvider = new MasterSlaveTopologyProvider((StatefulRedisConnection)connectionAndUri.getT2(), (RedisURI)connectionAndUri.getT1());
        MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(this.redisClient, topologyProvider);
        MasterSlaveConnectionProvider<K, V> connectionProvider = new MasterSlaveConnectionProvider<K, V>(this.redisClient, codec, this.redisURI, this.initialConnections);
        Mono<List<RedisNodeDescription>> refreshFuture = refresh.getNodes(this.redisURI);
        return refreshFuture.map(nodes -> {
            connectionProvider.setKnownNodes((Collection<RedisNodeDescription>)nodes);
            MasterSlaveChannelWriter channelWriter = new MasterSlaveChannelWriter(connectionProvider, this.redisClient.getResources());
            StatefulRedisMasterSlaveConnectionImpl connection = new StatefulRedisMasterSlaveConnectionImpl(channelWriter, codec, this.redisURI.getTimeout());
            connection.setOptions(this.redisClient.getOptions());
            return connection;
        });
    }

    private static RedisNodeDescription lookupMaster(List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = AutodiscoveryConnector.findFirst(nodes, n -> n.getRole() == RedisInstance.Role.MASTER);
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup master from " + nodes));
    }

    private static RedisNodeDescription getConnectedNode(RedisURI redisURI, List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = AutodiscoveryConnector.findFirst(nodes, n -> AutodiscoveryConnector.equals(redisURI, n));
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup node descriptor for connected node at " + redisURI));
    }

    private static Optional<RedisNodeDescription> findFirst(List<RedisNodeDescription> nodes, Predicate<? super RedisNodeDescription> predicate) {
        return nodes.stream().filter(predicate).findFirst();
    }

    private static boolean equals(RedisURI redisURI, RedisNodeDescription node) {
        return node.getUri().getHost().equals(redisURI.getHost()) && node.getUri().getPort() == redisURI.getPort();
    }
}

