/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.RuleSet;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.xml.sax.SAXException;

public class XmlRuleDisambiguator
extends AbstractDisambiguator {
    private static final String DISAMBIGUATION_FILE = "disambiguation.xml";
    private final RuleSet disambiguationRules;

    public XmlRuleDisambiguator(Language language) {
        Objects.requireNonNull(language);
        String disambiguationFile = language.getShortCode() + "/" + DISAMBIGUATION_FILE;
        try {
            this.disambiguationRules = RuleSet.textHinted(this.loadPatternRules(disambiguationFile));
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with loading disambiguation file: " + disambiguationFile, e);
        }
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence sentence) throws IOException {
        for (Rule rule : this.disambiguationRules.rulesForSentence(sentence)) {
            sentence = ((DisambiguationPatternRule)rule).replace(sentence);
        }
        return sentence;
    }

    protected List<DisambiguationPatternRule> loadPatternRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        DisambiguationRuleLoader ruleLoader = new DisambiguationRuleLoader();
        return ruleLoader.getRules(JLanguageTool.getDataBroker().getFromResourceDirAsStream(filename));
    }
}

