/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.text;

import com.optimaize.langdetect.text.TextFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RemoveMinorityScriptsTextFilter
implements TextFilter {
    private final double threshold;

    public static RemoveMinorityScriptsTextFilter forThreshold(double threshold) {
        return new RemoveMinorityScriptsTextFilter(threshold);
    }

    private RemoveMinorityScriptsTextFilter(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public String filter(CharSequence text) {
        Map<Character.UnicodeScript, Long> counts = this.countByScript(text);
        if (counts.size() <= 1) {
            return text.toString();
        }
        long most = this.findMost(counts);
        HashSet<Character.UnicodeScript> toRemove = new HashSet<Character.UnicodeScript>();
        for (Map.Entry<Character.UnicodeScript, Long> entry : counts.entrySet()) {
            double ratio;
            if (entry.getValue() == most || !((ratio = entry.getValue().doubleValue() / (double)most) <= this.threshold)) continue;
            toRemove.add(entry.getKey());
        }
        if (toRemove.isEmpty()) {
            return text.toString();
        }
        return this.remove(text, toRemove);
    }

    private String remove(CharSequence text, Set<Character.UnicodeScript> toRemove) {
        StringBuilder remaining = new StringBuilder();
        Character.UnicodeScript last = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            Character.UnicodeScript unicodeScript = Character.UnicodeScript.of(c);
            if (unicodeScript == Character.UnicodeScript.INHERITED && toRemove.contains((Object)last)) continue;
            last = unicodeScript;
            if (toRemove.contains((Object)unicodeScript)) continue;
            remaining.append(c);
        }
        return remaining.toString();
    }

    private long findMost(Map<Character.UnicodeScript, Long> counts) {
        long max = 0L;
        for (Long aLong : counts.values()) {
            if (aLong <= max) continue;
            max = aLong;
        }
        return max;
    }

    private Map<Character.UnicodeScript, Long> countByScript(CharSequence text) {
        HashMap<Character.UnicodeScript, Long> counter = new HashMap<Character.UnicodeScript, Long>();
        Character.UnicodeScript last = null;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            Character.UnicodeScript unicodeScript = Character.UnicodeScript.of(c);
            switch (unicodeScript) {
                case INHERITED: {
                    if (last == null) continue block4;
                    this.increment(counter, last);
                    continue block4;
                }
                case COMMON: 
                case UNKNOWN: {
                    continue block4;
                }
                default: {
                    this.increment(counter, unicodeScript);
                    last = unicodeScript;
                }
            }
        }
        return counter;
    }

    private void increment(Map<Character.UnicodeScript, Long> counter, Character.UnicodeScript unicodeScript) {
        Long number = counter.get((Object)unicodeScript);
        if (number == null) {
            counter.put(unicodeScript, 1L);
        } else {
            counter.put(unicodeScript, number + 1L);
        }
    }
}

