/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class MultiThreadedJLanguageTool
extends JLanguageTool {
    private final int threadPoolSize;
    private final ExecutorService threadPool;

    public MultiThreadedJLanguageTool(Language language) {
        this(language, null);
    }

    public MultiThreadedJLanguageTool(Language language, int threadPoolSize) {
        this(language, null, threadPoolSize, null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, UserConfig userConfig) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), userConfig);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, int threadPoolSize, UserConfig userConfig) {
        super(language, motherTongue, null, userConfig);
        this.threadPoolSize = threadPoolSize;
        this.threadPool = new ForkJoinPool(threadPoolSize, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, false);
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
    }

    public void shutdownWhenDone() {
        this.threadPool.shutdown();
    }

    private static int getDefaultThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    protected ExecutorService getExecutorService() {
        return this.threadPool;
    }

    @Override
    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        ExecutorService executorService = this.getExecutorService();
        int j = 0;
        ArrayList<AnalyzeSentenceCallable> callables = new ArrayList<AnalyzeSentenceCallable>();
        for (String sentence : sentences) {
            AnalyzeSentenceCallable analyzeSentenceCallable = ++j < sentences.size() ? new AnalyzeSentenceCallable(sentence) : new ParagraphEndAnalyzeSentenceCallable(sentence);
            callables.add(analyzeSentenceCallable);
        }
        try {
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                AnalyzedSentence analyzedSentence = (AnalyzedSentence)future.get();
                this.rememberUnknownWords(analyzedSentence);
                this.printSentenceInfo(analyzedSentence);
                analyzedSentences.add(analyzedSentence);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return analyzedSentences;
    }

    @Override
    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, JLanguageTool.Mode mode, boolean checkRemoteRules) {
        int charCount = 0;
        int lineCount = 0;
        int columnCount = 1;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ExecutorService executorService = this.getExecutorService();
        try {
            List<Callable<List<RuleMatch>>> callables = this.createTextCheckCallables(paraMode, annotatedText, analyzedSentences, sentences, allRules, charCount, lineCount, columnCount, listener, mode);
            List<Future<List<RuleMatch>>> futures = executorService.invokeAll(callables);
            for (Future<List<RuleMatch>> future : futures) {
                ruleMatches.addAll((Collection<RuleMatch>)future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.applyCustomFilters(ruleMatches, annotatedText);
    }

    private List<Callable<List<RuleMatch>>> createTextCheckCallables(JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, int charCount, int lineCount, int columnCount, RuleMatchListener listener, JLanguageTool.Mode mode) {
        ArrayList<Callable<List<RuleMatch>>> callables = new ArrayList<Callable<List<RuleMatch>>>();
        for (Rule rule : allRules) {
            callables.add(new JLanguageTool.TextCheckCallable(Arrays.asList(rule), sentences, analyzedSentences, paraMode, annotatedText, charCount, lineCount, columnCount, listener, mode, true));
        }
        return callables;
    }

    private final class ParagraphEndAnalyzeSentenceCallable
    extends AnalyzeSentenceCallable {
        private ParagraphEndAnalyzeSentenceCallable(String sentence) {
            super(sentence);
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            AnalyzedSentence analyzedSentence = super.call();
            AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
            anTokens[anTokens.length - 1].setParagraphEnd();
            AnalyzedTokenReadings[] preDisambigAnTokens = analyzedSentence.getPreDisambigTokens();
            preDisambigAnTokens[anTokens.length - 1].setParagraphEnd();
            analyzedSentence = new AnalyzedSentence(anTokens, preDisambigAnTokens);
            return analyzedSentence;
        }
    }

    private class AnalyzeSentenceCallable
    implements Callable<AnalyzedSentence> {
        private final String sentence;

        private AnalyzeSentenceCallable(String sentence) {
            this.sentence = sentence;
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            return MultiThreadedJLanguageTool.this.getAnalyzedSentence(this.sentence);
        }
    }
}

