/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.java.sen.dictionary.CToken;
import net.java.sen.dictionary.Node;
import net.java.sen.trie.CharIterator;
import net.java.sen.trie.TrieSearcher;

public class Dictionary {
    private final ByteBuffer tokenBuffer;
    private final ByteBuffer partOfSpeechInfoBuffer;
    private final IntBuffer trieBuffer;
    private final ShortBuffer connectionCostBuffer;
    private final int connectionSize1;
    private final int connectionSize2;
    private final int connectionSize3;
    private final CToken bosToken;
    private final CToken eosToken;
    private final CToken unknownToken;
    private final int[] trieSearchResults = new int[256];
    private final CToken[] results = new CToken[256];
    final String[] posIndex;
    final String[] conjTypeIndex;
    final String[] conjFormIndex;

    public CToken getBOSToken() {
        return this.bosToken.clone();
    }

    public CToken getEOSToken() {
        return this.eosToken.clone();
    }

    public CToken getUnknownToken() {
        return this.unknownToken.clone();
    }

    ByteBuffer getPartOfSpeechInfoBuffer() {
        return this.partOfSpeechInfoBuffer;
    }

    public int getCost(Node lNode2, Node lNode, Node rNode) {
        int position = this.connectionSize3 * (this.connectionSize2 * lNode2.rcAttr2 + lNode.rcAttr1) + rNode.lcAttr;
        return this.connectionCostBuffer.get(position) + rNode.dictionaryCost;
    }

    public CToken[] commonPrefixSearch(CharIterator iterator) {
        int size = 0;
        int n = TrieSearcher.commonPrefixSearch(this.trieBuffer, iterator, this.trieSearchResults);
        for (int i = 0; i < n; ++i) {
            int k = this.trieSearchResults[i] & 0xFF;
            int p = this.trieSearchResults[i] >> 8;
            this.tokenBuffer.position((int)((long)(p + 3) * 14L));
            for (int j = 0; j < k; ++j) {
                this.results[size++].read(this.tokenBuffer);
            }
        }
        this.results[size].terminator = true;
        return this.results;
    }

    public Dictionary(ShortBuffer connectionCostBuffer, ByteBuffer partOfSpeechInfoBuffer, ByteBuffer tokenBuffer, IntBuffer trieBuffer, String[] posIndex, String[] conjTypeIndex, String[] conjFormIndex) {
        ShortBuffer buffer = connectionCostBuffer;
        this.connectionSize1 = buffer.get();
        this.connectionSize2 = buffer.get();
        this.connectionSize3 = buffer.get();
        int expectedSize = 3 + this.connectionSize1 * this.connectionSize2 * this.connectionSize3;
        if (expectedSize != buffer.limit()) {
            throw new RuntimeException("Expected connection cost file to be " + 2 * expectedSize + " bytes, but was " + 2 * buffer.limit());
        }
        this.connectionCostBuffer = buffer.slice();
        this.partOfSpeechInfoBuffer = partOfSpeechInfoBuffer;
        this.tokenBuffer = tokenBuffer;
        this.bosToken = new CToken();
        this.bosToken.read(this.tokenBuffer);
        this.eosToken = new CToken();
        this.eosToken.read(this.tokenBuffer);
        this.unknownToken = new CToken();
        this.unknownToken.read(this.tokenBuffer);
        this.trieBuffer = trieBuffer;
        this.posIndex = posIndex;
        this.conjTypeIndex = conjTypeIndex;
        this.conjFormIndex = conjFormIndex;
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = new CToken();
        }
    }
}

