/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.gbm.GBBase;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class GBLinear
extends GBBase {
    private ModelParam mparam;
    private float[] weights;

    GBLinear() {
    }

    @Override
    public void loadModel(ModelReader reader, boolean ignored_with_pbuffer) throws IOException {
        this.mparam = new ModelParam(reader);
        reader.readInt();
        this.weights = reader.readFloatArray((this.mparam.num_feature + 1) * this.mparam.num_output_group);
    }

    @Override
    public double[] predict(FVec feat, int ntree_limit) {
        double[] preds = new double[this.mparam.num_output_group];
        for (int gid = 0; gid < this.mparam.num_output_group; ++gid) {
            preds[gid] = this.pred(feat, gid);
        }
        return preds;
    }

    @Override
    public double predictSingle(FVec feat, int ntree_limit) {
        if (this.mparam.num_output_group != 1) {
            throw new IllegalStateException("Can't invoke predictSingle() because this model outputs multiple values: " + this.mparam.num_output_group);
        }
        return this.pred(feat, 0);
    }

    double pred(FVec feat, int gid) {
        double psum = this.bias(gid);
        for (int fid = 0; fid < this.mparam.num_feature; ++fid) {
            double featValue = feat.fvalue(fid);
            if (Double.isNaN(featValue)) continue;
            psum += featValue * (double)this.weight(fid, gid);
        }
        return psum;
    }

    @Override
    public int[] predictLeaf(FVec feat, int ntree_limit) {
        throw new UnsupportedOperationException("gblinear does not support predict leaf index");
    }

    float weight(int fid, int gid) {
        return this.weights[fid * this.mparam.num_output_group + gid];
    }

    float bias(int gid) {
        return this.weights[this.mparam.num_feature * this.mparam.num_output_group + gid];
    }

    static class ModelParam
    implements Serializable {
        final int num_feature;
        final int num_output_group;
        final int[] reserved;

        ModelParam(ModelReader reader) throws IOException {
            this.num_feature = reader.readInt();
            this.num_output_group = reader.readInt();
            this.reserved = reader.readIntArray(32);
            reader.readInt();
        }
    }
}

