/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.languagetool.AnalyzedToken;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tools.StringTools;

public final class AnalyzedTokenReadings
implements Iterable<AnalyzedToken> {
    private static final Pattern NON_WORD_REGEX = Pattern.compile("[.?!\u2026:;,~\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]\\-\u2013\u2014*\u00d7\u2217\u00b7+\u00f7/=]");
    private final boolean isWhitespace;
    private final boolean isLinebreak;
    private final boolean isSentStart;
    private AnalyzedToken[] anTokReadings;
    private int startPos;
    private String token;
    private List<ChunkTag> chunkTags = new ArrayList<ChunkTag>();
    private boolean isSentEnd;
    private boolean isParaEnd;
    private boolean isWhitespaceBefore;
    private boolean isPosTagUnknown;
    private boolean isImmunized;
    private boolean isIgnoredBySpeller;
    private String historicalAnnotations = "";
    private boolean hasSameLemmas;

    public AnalyzedTokenReadings(AnalyzedToken[] tokens, int startPos) {
        this(Arrays.asList(tokens), startPos);
    }

    public AnalyzedTokenReadings(AnalyzedToken token, int startPos) {
        this(Collections.singletonList(token), startPos);
    }

    public AnalyzedTokenReadings(List<AnalyzedToken> tokens, int startPos) {
        this.anTokReadings = tokens.toArray(new AnalyzedToken[0]);
        this.startPos = startPos;
        this.token = this.anTokReadings[0].getToken();
        this.isWhitespace = StringTools.isWhitespace(this.token);
        this.isWhitespaceBefore = this.anTokReadings[0].isWhitespaceBefore();
        this.isLinebreak = "\n".equals(this.token) || "\r\n".equals(this.token) || "\r".equals(this.token) || "\n\r".equals(this.token);
        this.isSentStart = "SENT_START".equals(this.anTokReadings[0].getPOSTag());
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.isPosTagUnknown = tokens.size() == 1 && tokens.get(0).getPOSTag() == null;
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    AnalyzedTokenReadings(AnalyzedToken token) {
        this(Collections.singletonList(token), 0);
    }

    public List<AnalyzedToken> getReadings() {
        return Arrays.asList(this.anTokReadings);
    }

    public AnalyzedToken getAnalyzedToken(int idx) {
        return this.anTokReadings[idx];
    }

    public boolean hasPosTag(String posTag) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] analyzedTokenArray = this.anTokReadings;
        int n = analyzedTokenArray.length;
        for (int i = 0; !(i >= n || (reading = analyzedTokenArray[i]).getPOSTag() != null && (found = posTag.equals(reading.getPOSTag()))); ++i) {
        }
        return found;
    }

    public boolean hasLemma(String lemma) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] analyzedTokenArray = this.anTokReadings;
        int n = analyzedTokenArray.length;
        for (int i = 0; !(i >= n || (reading = analyzedTokenArray[i]).getLemma() != null && (found = lemma.equals(reading.getLemma()))); ++i) {
        }
        return found;
    }

    public boolean hasAnyLemma(String ... lemmas) {
        boolean found = false;
        for (String lemma : lemmas) {
            for (AnalyzedToken reading : this.anTokReadings) {
                if (reading.getLemma() == null || !(found = lemma.equals(reading.getLemma()))) continue;
                return found;
            }
        }
        return found;
    }

    public boolean hasPartialPosTag(String posTag) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] analyzedTokenArray = this.anTokReadings;
        int n = analyzedTokenArray.length;
        for (int i = 0; !(i >= n || (reading = analyzedTokenArray[i]).getPOSTag() != null && (found = reading.getPOSTag().contains(posTag))); ++i) {
        }
        return found;
    }

    public boolean hasAnyPartialPosTag(String ... posTags) {
        for (String posTag : posTags) {
            if (!this.hasPartialPosTag(posTag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPosTagStartingWith(String posTag) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] analyzedTokenArray = this.anTokReadings;
        int n = analyzedTokenArray.length;
        for (int i = 0; !(i >= n || (reading = analyzedTokenArray[i]).getPOSTag() != null && (found = reading.getPOSTag().startsWith(posTag))); ++i) {
        }
        return found;
    }

    public boolean matchesPosTagRegex(String posTagRegex) {
        AnalyzedToken reading;
        Pattern pattern = Pattern.compile(posTagRegex);
        boolean found = false;
        AnalyzedToken[] analyzedTokenArray = this.anTokReadings;
        int n = analyzedTokenArray.length;
        for (int i = 0; !(i >= n || (reading = analyzedTokenArray[i]).getPOSTag() != null && (found = pattern.matcher(reading.getPOSTag()).matches())); ++i) {
        }
        return found;
    }

    public void addReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>(Arrays.asList(this.anTokReadings).subList(0, this.anTokReadings.length - 1));
        if (this.anTokReadings[this.anTokReadings.length - 1].getPOSTag() != null) {
            l.add(this.anTokReadings[this.anTokReadings.length - 1]);
        }
        token.setWhitespaceBefore(this.isWhitespaceBefore);
        l.add(token);
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        if (token.getToken().length() > this.token.length()) {
            this.token = token.getToken();
        }
        this.anTokReadings[this.anTokReadings.length - 1].setWhitespaceBefore(this.isWhitespaceBefore);
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public void removeReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        boolean removedSentEnd = false;
        boolean removedParaEnd = false;
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (!anTokReading.matches(tmpTok)) {
                l.add(anTokReading);
                continue;
            }
            if ("SENT_END".equals(anTokReading.getPOSTag())) {
                removedSentEnd = true;
                continue;
            }
            if (!"PARA_END".equals(anTokReading.getPOSTag())) continue;
            removedParaEnd = true;
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        this.setNoRealPOStag();
        if (removedSentEnd) {
            this.isSentEnd = false;
            this.setSentEnd();
        }
        if (removedParaEnd) {
            this.isParaEnd = false;
            this.setParagraphEnd();
        }
        this.hasSameLemmas = this.areLemmasSame();
    }

    public void leaveReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (!anTokReading.matches(tmpTok)) continue;
            l.add(anTokReading);
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[0]);
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public int getReadingsLength() {
        return this.anTokReadings.length;
    }

    public boolean isWhitespace() {
        return this.isWhitespace;
    }

    public boolean isLinebreak() {
        return this.isLinebreak;
    }

    public boolean isSentenceStart() {
        return this.isSentStart;
    }

    public boolean isParagraphEnd() {
        return this.isParaEnd;
    }

    public void setParagraphEnd() {
        if (!this.isParagraphEnd()) {
            AnalyzedToken paragraphEnd = new AnalyzedToken(this.getToken(), "PARA_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(paragraphEnd);
        }
    }

    public boolean isSentenceEnd() {
        return this.isSentEnd;
    }

    public boolean isFieldCode() {
        return "\u0001".equals(this.token) || "\u0002".equals(this.token);
    }

    public void setSentEnd() {
        if (!this.isSentenceEnd()) {
            AnalyzedToken sentenceEnd = new AnalyzedToken(this.getToken(), "SENT_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(sentenceEnd);
        }
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.startPos + this.token.length();
    }

    public void setStartPos(int position) {
        this.startPos = position;
    }

    public String getToken() {
        return this.token;
    }

    public void setWhitespaceBefore(boolean isWhiteSpaceBefore) {
        this.isWhitespaceBefore = isWhiteSpaceBefore;
        for (AnalyzedToken aTok : this.anTokReadings) {
            aTok.setWhitespaceBefore(isWhiteSpaceBefore);
        }
    }

    public boolean isWhitespaceBefore() {
        return this.isWhitespaceBefore;
    }

    public void immunize() {
        this.isImmunized = true;
    }

    public boolean isImmunized() {
        return this.isImmunized;
    }

    public void ignoreSpelling() {
        this.isIgnoredBySpeller = true;
    }

    public boolean isIgnoredBySpeller() {
        return this.isIgnoredBySpeller;
    }

    public boolean isPosTagUnknown() {
        return this.isPosTagUnknown;
    }

    private void setNoRealPOStag() {
        boolean hasNoPOStag = !this.isLinebreak();
        for (AnalyzedToken an : this.anTokReadings) {
            String posTag = an.getPOSTag();
            if ("PARA_END".equals(posTag) || "SENT_END".equals(posTag) || posTag == null) continue;
            hasNoPOStag = false;
        }
        for (AnalyzedToken an : this.anTokReadings) {
            an.setNoPOSTag(hasNoPOStag);
        }
    }

    public String getHistoricalAnnotations() {
        return this.historicalAnnotations;
    }

    public void setHistoricalAnnotations(String historicalAnnotations) {
        this.historicalAnnotations = historicalAnnotations;
    }

    public void setChunkTags(List<ChunkTag> chunkTags) {
        this.chunkTags = Objects.requireNonNull(chunkTags);
    }

    public List<ChunkTag> getChunkTags() {
        return this.chunkTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.token);
        sb.append('[');
        for (AnalyzedToken element : this.anTokReadings) {
            sb.append(element);
            if (!element.isWhitespaceBefore()) {
                sb.append('*');
            }
            sb.append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        if (this.chunkTags.size() > 0) {
            sb.append(',');
            sb.append(StringUtils.join(this.chunkTags, (String)"|"));
        }
        sb.append(']');
        if (this.isImmunized()) {
            sb.append("{!},");
        }
        return sb.toString();
    }

    public boolean isTagged() {
        for (AnalyzedToken element : this.anTokReadings) {
            if (element.hasNoTag()) continue;
            return true;
        }
        return false;
    }

    private boolean areLemmasSame() {
        String previousLemma = this.anTokReadings[0].getLemma();
        if (previousLemma == null) {
            for (AnalyzedToken element : this.anTokReadings) {
                if (element.getLemma() == null) continue;
                return false;
            }
            return true;
        }
        for (AnalyzedToken element : this.anTokReadings) {
            if (previousLemma.equals(element.getLemma())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameLemmas() {
        return this.hasSameLemmas;
    }

    public boolean isNonWord() {
        return NON_WORD_REGEX.matcher(this.token).matches();
    }

    public int hashCode() {
        return Arrays.hashCode(this.anTokReadings) + Objects.hash(this.isLinebreak, this.isParaEnd, this.isSentEnd, this.isSentStart, this.isWhitespace, this.isWhitespaceBefore, this.chunkTags, this.startPos, this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedTokenReadings other = (AnalyzedTokenReadings)obj;
        return new EqualsBuilder().append((Object[])this.anTokReadings, (Object[])other.anTokReadings).append(this.isLinebreak, other.isLinebreak).append(this.isParaEnd, other.isParaEnd).append(this.isSentEnd, other.isSentEnd).append(this.isSentStart, other.isSentStart).append(this.isWhitespace, other.isWhitespace).append(this.isWhitespaceBefore, other.isWhitespaceBefore).append(this.isImmunized, other.isImmunized).append(this.startPos, other.startPos).append(this.chunkTags, other.chunkTags).append(this.hasSameLemmas, other.hasSameLemmas).append(this.isIgnoredBySpeller, other.isIgnoredBySpeller).append((Object)this.token, (Object)other.token).isEquals();
    }

    @Override
    public Iterator<AnalyzedToken> iterator() {
        final AtomicInteger i = new AtomicInteger(0);
        return new Iterator<AnalyzedToken>(){

            @Override
            public boolean hasNext() {
                return i.get() < AnalyzedTokenReadings.this.getReadingsLength();
            }

            @Override
            public AnalyzedToken next() {
                try {
                    return AnalyzedTokenReadings.this.anTokReadings[i.getAndAdd(1)];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException("No such element: " + i + ", element count: " + AnalyzedTokenReadings.this.anTokReadings.length);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

