/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class MyTest {
    public static void main(String[] args) throws IOException {
        AmericanEnglish english = new AmericanEnglish();
        english.getSentenceTokenizer().setSingleLineBreaksMarksParagraph(true);
        JLanguageTool lang = new JLanguageTool((Language)english);
        List<RuleMatch> matches = lang.check("tuesday, march 3, 2018\nhello");
        System.out.println(matches);
        Assert.assertEquals(2L, matches.size());
    }

    public static void main3(String[] args) throws IOException {
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode("en"));
        AnnotatedText text = new AnnotatedTextBuilder().addText("This is ").addMarkup("<b>").addText("an test").addMarkup("</b>").build();
        List<RuleMatch> matches = lt.check(text);
        for (RuleMatch match : matches) {
            System.out.println(match);
        }
        List<RuleMatch> matches2 = lt.check("This is an test.");
        for (RuleMatch match : matches2) {
            System.out.println(match);
        }
    }

    public static void main2(String[] args) throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new AmericanEnglish());
        for (Rule rule : lt.getAllActiveRules()) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            List<String> wordsToIgnore = Arrays.asList("specialword", "myotherword");
            ((SpellingCheckRule)rule).addIgnoreTokens(wordsToIgnore);
        }
        List<RuleMatch> list = lt.check("This is specialwort.");
        System.out.println(list.size());
        System.out.println(list.get(0).getSuggestedReplacements());
    }
}

