/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class EmptyLineRule
extends TextLevelRule {
    private final Language lang;

    public EmptyLineRule(ResourceBundle messages, Language lang, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.lang = lang;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public EmptyLineRule(ResourceBundle messages, Language lang) {
        this(messages, lang, false);
    }

    @Override
    public String getId() {
        return "EMPTY_LINE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("empty_line_rule_desc");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size() - 1; ++n) {
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence = sentences.get(n);
            if (sentence.hasParagraphEndMark(this.lang) && (tokens = sentences.get(n + 1).getTokensWithoutWhitespace()).length <= 2 && tokens[tokens.length - 1].isWhitespace() && ((tokens = sentence.getTokensWithoutWhitespace()).length > 2 || tokens.length == 2 && !tokens[1].isWhitespace())) {
                int fromPos = pos + tokens[tokens.length - 1].getStartPos();
                int toPos = pos + tokens[tokens.length - 1].getEndPos();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("empty_line_rule_msg"));
                ruleMatches.add(ruleMatch);
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

