/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DatabaseRuleMatchLogEntry;

class DatabaseCheckLogEntry
extends DatabaseLogEntry {
    private final Long userId;
    private final Long client;
    private final Long server;
    private final int textSize;
    private final int matches;
    private final Language lang;
    private final Language langDetected;
    private final int computationTime;
    private final Long textSessionId;
    private final Calendar date;
    private final List<DatabaseRuleMatchLogEntry> ruleMatches = new ArrayList<DatabaseRuleMatchLogEntry>();

    public DatabaseCheckLogEntry(Long userId, Long client, Long server, int textSize, int matches, Language lang, Language langDetected, int computationTime, Long textSessionId) {
        this.userId = userId;
        this.client = client;
        this.server = server;
        this.textSize = textSize;
        this.matches = matches;
        this.lang = lang;
        this.langDetected = langDetected;
        this.computationTime = computationTime;
        this.textSessionId = textSessionId;
        this.date = Calendar.getInstance();
    }

    public void addRuleMatch(DatabaseRuleMatchLogEntry entry) {
        this.ruleMatches.add(entry);
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("day", dayFormat.format(this.date.getTime()));
        map.put("date", dateFormat.format(this.date.getTime()));
        map.put("user_id", this.userId);
        map.put("textsize", this.textSize);
        map.put("matches", this.matches);
        map.put("language", this.lang.getShortCodeWithCountryAndVariant());
        map.put("language_detected", this.langDetected.getShortCodeWithCountryAndVariant());
        map.put("computation_time", this.computationTime);
        map.put("text_session_id", this.textSessionId);
        map.put("server", this.server);
        map.put("client", this.client);
        return map;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.logCheck";
    }

    @Override
    public void followup(Map<Object, Object> parameters) {
        Long checkId = (Long)parameters.get("id");
        if (checkId == null) {
            System.err.println("Could not get generated key for check log entry in database.");
            return;
        }
        DatabaseLogger logger = DatabaseLogger.getInstance();
        for (DatabaseRuleMatchLogEntry entry : this.ruleMatches) {
            entry.setCheckId(checkId);
            logger.log(entry);
        }
    }
}

