/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractDateCheckFilter
extends RuleFilter {
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d+).*");

    protected abstract int getDayOfWeek(String var1);

    protected abstract String getDayOfWeek(Calendar var1);

    protected int getDayOfMonth(String localizedDayOfMonth) {
        return 0;
    }

    protected abstract int getMonth(String var1);

    protected abstract Calendar getCalendar();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        int dayOfWeekFromDate;
        int dayOfWeekFromString = this.getDayOfWeek(this.getRequired("weekDay", args));
        Calendar dateFromDate = this.getDate(args);
        try {
            dayOfWeekFromDate = dateFromDate.get(7);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
        if (dayOfWeekFromString != dayOfWeekFromDate) {
            Calendar calFromDateString = Calendar.getInstance();
            calFromDateString.set(7, dayOfWeekFromString);
            String message = match.getMessage().replace("{realDay}", this.getDayOfWeek(dateFromDate)).replace("{day}", this.getDayOfWeek(calFromDateString));
            return new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        }
        return null;
    }

    protected String getRequired(String key, Map<String, String> map) {
        String result = map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing key '" + key + "'");
        }
        return result;
    }

    private Calendar getDate(Map<String, String> args) {
        int year = Integer.parseInt(this.getRequired("year", args));
        int month = this.getMonthFromArguments(args);
        int dayOfMonth = this.getDayOfMonthFromArguments(args);
        Calendar calendar = this.getCalendar();
        calendar.setLenient(false);
        calendar.set(year, month, dayOfMonth, 0, 0, 0);
        return calendar;
    }

    private int getDayOfMonthFromArguments(Map<String, String> args) {
        String dayOfMonthString = this.getRequired("day", args);
        Matcher matcherDayOfMonth = DAY_OF_MONTH_PATTERN.matcher(dayOfMonthString);
        int dayOfMonth = matcherDayOfMonth.matches() ? Integer.parseInt(matcherDayOfMonth.group(1)) : this.getDayOfMonth(dayOfMonthString);
        return dayOfMonth;
    }

    private int getMonthFromArguments(Map<String, String> args) {
        String monthStr = this.getRequired("month", args);
        int month = StringUtils.isNumeric((CharSequence)monthStr) ? Integer.parseInt(monthStr) : this.getMonth(monthStr);
        return month - 1;
    }
}

