/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.languagetool.gui.Tools;

class LocalStorage {
    private static final String VENDOR_ID = "languagetool.org";
    private static final String APPLICATION_ID = "LanguageTool";
    private final File directory;

    LocalStorage() {
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userHome == null) {
            this.directory = null;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            String path;
            File appDataDir = null;
            try {
                String appData = System.getenv("APPDATA");
                if (!StringUtils.isEmpty(appData)) {
                    appDataDir = new File(appData);
                }
            }
            catch (SecurityException appData) {
                // empty catch block
            }
            if (appDataDir != null && appDataDir.isDirectory()) {
                path = "languagetool.org\\LanguageTool\\";
                this.directory = new File(appDataDir, path);
            } else {
                path = "Application Data\\languagetool.org\\LanguageTool\\";
                this.directory = new File(userHome, path);
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            String path;
            File appDataDir = null;
            try {
                String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
                if (!StringUtils.isEmpty(xdgConfigHome) && !(appDataDir = new File(xdgConfigHome)).isAbsolute()) {
                    appDataDir = null;
                }
            }
            catch (SecurityException xdgConfigHome) {
                // empty catch block
            }
            if (appDataDir != null && appDataDir.isDirectory()) {
                path = "LanguageTool/";
                this.directory = new File(appDataDir, path);
            } else {
                path = ".config/LanguageTool/";
                this.directory = new File(userHome, path);
            }
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            String path = "Library/Application Support/LanguageTool/";
            this.directory = new File(userHome, path);
        } else {
            String path = ".LanguageTool/";
            this.directory = new File(userHome, path);
        }
        if (this.directory != null && !this.directory.exists()) {
            this.directory.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperty(String name, Object obj) {
        if (this.directory == null) {
            return;
        }
        File file = this.directory;
        synchronized (file) {
            try (XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(new File(this.directory, name))));){
                encoder.writeObject(obj);
            }
            catch (FileNotFoundException ex) {
                Tools.showError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T loadProperty(String name, Class<T> clazz) {
        if (this.directory == null) {
            return null;
        }
        File file = this.directory;
        synchronized (file) {
            try {
                Throwable throwable = null;
                try (XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(new File(this.directory, name))));){
                    T t = clazz.cast(decoder.readObject());
                    return t;
                }
                catch (ClassCastException ex) {
                    Tools.showError(ex);
                    T t = null;
                    return t;
                }
                catch (Exception ex) {
                    T t;
                    try {
                        Tools.showError(ex);
                        t = null;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    return t;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }
}

