/*
 *  Copyright (C) 2017 KeePassXC Team <team@keepassxc.org>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 or (at your option)
 *  version 3 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEEPASSXC_CLIP_H
#define KEEPASSXC_CLIP_H

#include "Command.h"

class Clip : public Command
{
public:
    Clip();
    ~Clip();
    int execute(const QStringList& arguments) override;
    int clipEntry(QSharedPointer<Database> database,
                  const QString& entryPath,
                  const QString& timeout,
                  bool clipTotp,
                  bool silent);
};

#endif // KEEPASSXC_CLIP_H
