/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class OsmServerReader
extends OsmConnection {
    private final OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate;
    protected boolean gpxParsedProperly;
    protected String contentType;

    public OsmServerReader() {
        try {
            this.doAuthenticate = OsmApi.isUsingOAuth() && CredentialsManager.getInstance().lookupOAuthAccessToken() != null && OsmApi.USE_OAUTH_FOR_ALL_REQUESTS.get() != false;
        }
        catch (CredentialsAgentException e) {
            Logging.warn(e);
        }
    }

    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStream(urlStr, progressMonitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String urlStr, ProgressMonitor progressMonitor, String reason) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            String url = urlStr.startsWith("http") ? urlStr : this.getBaseUrl() + urlStr;
            InputStream inputStream = this.getInputStreamRaw(url, progressMonitor, reason);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected String getBaseUrl() {
        return this.api.getBaseUrl();
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, null);
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, reason, false);
    }

    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition) throws OsmTransferException {
        return this.getInputStreamRaw(urlStr, progressMonitor, reason, uncompressAccordingToContentDisposition, "GET", null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getInputStreamRaw(String urlStr, ProgressMonitor progressMonitor, String reason, boolean uncompressAccordingToContentDisposition, String httpMethod, byte[] requestBody) throws OsmTransferException {
        HttpClient.Response response;
        HttpClient client;
        URL url;
        block20: {
            if (NetworkManager.isOffline(urlStr)) {
                throw new OsmApiException(OfflineAccessException.forResource(urlStr));
            }
            url = null;
            try {
                url = new URL(urlStr.replace(" ", "%20"));
            }
            catch (MalformedURLException e) {
                throw new OsmTransferException(e);
            }
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                try {
                    InputStream inputStream = Utils.openStream(url);
                    return inputStream;
                }
                catch (IOException e) {
                    throw new OsmTransferException(e);
                }
            }
            this.activeConnection = client = HttpClient.create(url, httpMethod).setAccept("application/xml, */*;q=0.8").setFinishOnCloseOutput(false).setReasonForRequest(reason).setOutputMessage(I18n.tr("Downloading data...", new Object[0])).setRequestBody(requestBody);
            this.adaptRequest(client);
            if (!this.doAuthenticate) break block20;
            this.addAuth(client);
        }
        if (this.cancel) {
            throw new OsmTransferCanceledException("Operation canceled");
        }
        try {
            response = client.connect(progressMonitor);
            this.contentType = response.getContentType();
        }
        catch (IOException e) {
            Logging.error(e);
            OsmTransferException ote = new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection.", new Object[0]), e);
            ote.setUrl(url.toString());
            throw ote;
        }
        try {
            if (response.getResponseCode() == 401) {
                CredentialsManager.getInstance().purgeCredentialsCache(Authenticator.RequestorType.SERVER);
                throw new OsmApiException(401, null, null);
            }
            if (response.getResponseCode() == 407) {
                throw new OsmTransferCanceledException("Proxy Authentication Required");
            }
            if (response.getResponseCode() != 200) {
                String errorHeader = response.getHeaderField("Error");
                String errorBody = OsmServerReader.fetchResponseText(response);
                throw new OsmApiException(response.getResponseCode(), errorHeader, errorBody, url.toString(), null, this.contentType);
            }
            response.uncompressAccordingToContentDisposition(uncompressAccordingToContentDisposition);
            return response.getContent();
        }
        catch (OsmTransferException e) {
            throw e;
            catch (IOException e2) {
                throw new OsmTransferException(e2);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    private static String fetchResponseText(HttpClient.Response response) {
        try {
            return response.fetchContent();
        }
        catch (IOException e) {
            Logging.error(e);
            return I18n.tr("Reading error text failed.", new Object[0]);
        }
    }

    protected void adaptRequest(HttpClient request) {
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public DataSet parseOsm(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChange(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean doAuthenticate) {
        this.doAuthenticate = doAuthenticate;
    }

    public final boolean isGpxParsedProperly() {
        return this.gpxParsedProperly;
    }

    public List<Note> parseNotes(int noteLimit, int daysClosed, ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        throw new UnsupportedOperationException();
    }

    protected static String getAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    /*
     * Exception decompiling
     */
    public <T> T fetchData(String api, String subtask, DomParser<T> parser, ProgressMonitor monitor, String reason) throws OsmTransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    protected static interface DomParser<R> {
        public R parse(Document var1) throws XmlParsingException;
    }
}

