/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class ColorScale {
    private static final Color LEGEND_BACKGROUND = new NamedColorProperty(I18n.marktr("gpx legend background"), new Color(180, 180, 180, 160)).get();
    private static final Color LEGEND_TEXT_OUTLINE_DARK = new NamedColorProperty(I18n.marktr("gpx legend text outline dark"), new Color(102, 102, 102)).get();
    private static final Color LEGEND_TEXT_OUTLINE_BRIGHT = new NamedColorProperty(I18n.marktr("gpx legend text outline bright"), new Color(204, 204, 204)).get();
    private static final Color LEGEND_TITLE = new NamedColorProperty(I18n.marktr("gpx legend title color"), new Color(0, 0, 0)).get();
    private static final String DAY_TIME_FORMAT = "yyyy-MM-dd      HH:mm";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final byte PADDING = 19;
    private double min;
    private double max;
    private Color noDataColor;
    private Color belowMinColor;
    private Color aboveMaxColor;
    private Color[] colors;
    private String[] colorBarTitles;
    private String title = "";
    private int intervalCount = 5;

    private ColorScale() {
    }

    public static ColorScale createFixedScale(Color[] colors) {
        ColorScale sc = new ColorScale();
        sc.colors = Utils.copyArray(colors);
        sc.setRange(0.0, (double)colors.length - 1.0);
        sc.addBounds();
        return sc;
    }

    public static ColorScale createHSBScale(int count) {
        ColorScale sc = new ColorScale();
        sc.colors = new Color[count];
        for (int i = 0; i < count; ++i) {
            sc.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        sc.setRange(0.0, 255.0);
        sc.addBounds();
        return sc;
    }

    public static ColorScale createCyclicScale(int count) {
        ColorScale sc = new ColorScale();
        int[] h = new int[]{0, 59, 127, 244, 360};
        int[] s = new int[]{100, 84, 99, 100};
        int[] b = new int[]{90, 93, 74, 83};
        sc.colors = new Color[count];
        for (int i = 0; i < sc.colors.length; ++i) {
            float angle = (float)i * 4.0f / (float)count;
            int quadrant = (int)angle;
            angle -= (float)quadrant;
            quadrant = Utils.mod(quadrant + 1, 4);
            float vh = (float)h[quadrant] * ColorScale.weighted(angle) + (float)h[quadrant + 1] * (1.0f - ColorScale.weighted(angle));
            float vs = (float)s[quadrant] * ColorScale.weighted(angle) + (float)s[Utils.mod(quadrant + 1, 4)] * (1.0f - ColorScale.weighted(angle));
            float vb = (float)b[quadrant] * ColorScale.weighted(angle) + (float)b[Utils.mod(quadrant + 1, 4)] * (1.0f - ColorScale.weighted(angle));
            sc.colors[i] = Color.getHSBColor(vh / 360.0f, vs / 100.0f, vb / 100.0f);
        }
        sc.setRange(0.0, Math.PI * 2);
        sc.addBounds();
        return sc;
    }

    private static float weighted(float x) {
        if ((double)x < 0.5) {
            return 1.0f - 2.0f * x * x;
        }
        return 2.0f * (1.0f - x) * (1.0f - x);
    }

    public void setRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public void addBounds() {
        this.aboveMaxColor = this.colors[this.colors.length - 1];
        this.belowMinColor = this.colors[0];
    }

    public Color getColor(double value) {
        if (value < this.min) {
            return this.belowMinColor;
        }
        if (value > this.max) {
            return this.aboveMaxColor;
        }
        if (Double.isNaN(value)) {
            return this.noDataColor;
        }
        int n = this.colors.length;
        int idx = (int)((value - this.min) * (double)this.colors.length / (this.max - this.min));
        if (idx < this.colors.length) {
            return this.colors[idx];
        }
        return this.colors[n - 1];
    }

    public Color getColor(Number value) {
        return value == null ? this.noDataColor : this.getColor(value.doubleValue());
    }

    public Color getNoDataColor() {
        return this.noDataColor;
    }

    public void setNoDataColor(Color noDataColor) {
        this.noDataColor = noDataColor;
    }

    public ColorScale makeTransparent(int alpha) {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(this.colors[i].getRGB() & 0xFFFFFF | (alpha & 0xFF) << 24, true);
        }
        return this;
    }

    public ColorScale addTitle(String title) {
        Objects.requireNonNull(title);
        this.title = title;
        return this;
    }

    public ColorScale addColorBarTitles(String[] titles) {
        this.intervalCount = titles.length - 1;
        this.colorBarTitles = titles;
        return this;
    }

    public ColorScale setIntervalCount(int intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    public ColorScale makeReversed() {
        Color tmp;
        int n = this.colors.length;
        for (int i = 0; i < n / 2; ++i) {
            tmp = this.colors[i];
            this.colors[i] = this.colors[n - 1 - i];
            this.colors[n - 1 - i] = tmp;
        }
        tmp = this.belowMinColor;
        this.belowMinColor = this.aboveMaxColor;
        this.aboveMaxColor = tmp;
        return this;
    }

    private void drawOutline(Graphics2D g, String txt, int x, int y, Color color) {
        if (ColorHelper.calculateContrastRatio(color, LEGEND_TEXT_OUTLINE_DARK) >= ColorHelper.calculateContrastRatio(color, LEGEND_TEXT_OUTLINE_BRIGHT)) {
            g.setColor(LEGEND_TEXT_OUTLINE_DARK);
        } else {
            g.setColor(LEGEND_TEXT_OUTLINE_BRIGHT);
        }
        g.drawString(txt, x - 1, y - 1);
        g.drawString(txt, x + 1, y - 1);
        g.drawString(txt, x - 1, y + 1);
        g.drawString(txt, x + 1, y + 1);
        g.setColor(color);
    }

    public void drawColorBar(Graphics2D g, int x, int y, int w, int h, double valueScale) {
        int n = this.colors.length;
        FontMetrics fm = ColorScale.calculateFontMetrics(g);
        g.setColor(LEGEND_BACKGROUND);
        int fh = fm.getHeight() / 2;
        int fw = this.colorBarTitles != null && this.colorBarTitles.length > 0 ? Arrays.stream(this.colorBarTitles).mapToInt(fm::stringWidth).max().orElse(50) : fm.stringWidth(String.valueOf(Math.max((int)Math.abs(this.max * valueScale), (int)Math.abs(this.min * valueScale)))) + fm.stringWidth("0.123");
        int[] t = this.drawBackgroundRectangle(g, x, y, w, h, fw, fh, fm.stringWidth(this.title));
        int xRect = t[0];
        int rectWidth = t[1];
        int xText = t[2];
        int titleWidth = t[3];
        for (int i = 0; i < n; ++i) {
            g.setColor(this.colors[i]);
            if (w < h) {
                double factor;
                double d = factor = n == 6 ? 1.2 : 1.07 + 0.045 * Math.log(n);
                if (n < 200) {
                    g.fillRect(xText + fw + 6, y - 9 + i * (int)((double)h / (double)n * factor), w, (int)((double)h / (double)n * factor));
                    continue;
                }
                g.fillRect(xText + fw + 6, y - 9 + i * h / (int)((double)n * 0.875), w, h / n + 1);
                continue;
            }
            g.fillRect(xText + fw + 7 + i * w / n, y, w / n, h + 1);
        }
        g.setColor(LEGEND_TITLE);
        g.drawString(this.title, xRect + rectWidth / 2 - titleWidth / 2, y - fh * 3 / 2 - 10);
        this.drawLegend(g, y, w, h, valueScale, fh, fw, xText);
        g.setColor(this.noDataColor);
    }

    public void drawColorBarTime(Graphics2D g, int x, int y, int w, int h, double minVal, double maxVal) {
        int n = this.colors.length;
        FontMetrics fm = ColorScale.calculateFontMetrics(g);
        g.setColor(LEGEND_BACKGROUND);
        int padding = 19;
        int fh = fm.getHeight() / 2;
        int fw = maxVal - minVal > 86400.0 ? fm.stringWidth(DAY_TIME_FORMAT) : fm.stringWidth(TIME_FORMAT);
        int[] t = this.drawBackgroundRectangle(g, x, y, w, h, fw, fh, fm.stringWidth(this.title));
        int xRect = t[0];
        int rectWidth = t[1];
        int xText = t[2];
        int titleWidth = t[3];
        for (int i = 0; i < n; ++i) {
            g.setColor(this.colors[i]);
            if (w < h) {
                g.fillRect(xText + fw + 6, y - 9 + i * h / (int)((double)n * 0.875), w, h / n + 1);
                continue;
            }
            g.fillRect(xText + fw + 6 + i * w / n, y, w / n + 1, h);
        }
        g.setColor(LEGEND_TITLE);
        g.drawString(this.title, xRect + rectWidth / 2 - titleWidth / 2, y - fh * 3 / 2 - 9);
        this.drawTimeLegend(g, y, x, h, minVal, maxVal, fh, fw, xText);
        g.setColor(this.noDataColor);
    }

    private static FontMetrics calculateFontMetrics(Graphics2D g) {
        Font newFont = UIManager.getFont("PopupMenu.font");
        g.setFont(newFont);
        return g.getFontMetrics();
    }

    private int[] drawBackgroundRectangle(Graphics2D g, int x, int y, int w, int h, int fw, int fh, int titleWidth) {
        int xText;
        int xRect;
        int rectWidth;
        int arcWidth = 20;
        int arcHeight = 20;
        if (fw + w > titleWidth) {
            rectWidth = w + fw + 38;
            xRect = x - rectWidth;
            xText = xRect + 15;
            g.fillRoundRect(xRect, fh * 3 / 2, rectWidth, h + y - fh * 3 / 2 + 12, 20, 20);
        } else {
            if (titleWidth >= 120) {
                titleWidth = 120;
            }
            rectWidth = w + titleWidth + 19 + 9;
            xRect = x - rectWidth;
            xText = xRect + 9 + rectWidth / 2 - fw;
            g.fillRoundRect(xRect, fh * 3 / 2, rectWidth, h + y - fh * 3 / 2 + 12, 20, 20);
        }
        return new int[]{xRect, rectWidth, xText, titleWidth};
    }

    private void drawLegend(Graphics2D g, int y, int w, int h, double valueScale, int fh, int fw, int xText) {
        for (int i = 0; i <= this.intervalCount; ++i) {
            String txt;
            Color color = this.colors[(int)(1.0 * (double)i * (double)this.colors.length / (double)this.intervalCount - 1.0E-10)];
            g.setColor(color);
            if (this.colorBarTitles != null && i < this.colorBarTitles.length) {
                txt = this.colorBarTitles[i];
            } else {
                double val = this.min + (double)i * (this.max - this.min) / (double)this.intervalCount;
                txt = String.format("%.3f", val * valueScale);
            }
            this.drawLegendText(g, y, w, h, fh, fw, xText, i, color, txt);
        }
    }

    private void drawTimeLegend(Graphics2D g, int y, int w, int h, double minVal, double maxVal, int fh, int fw, int xText) {
        for (int i = 0; i <= this.intervalCount; ++i) {
            String txt;
            Color color = this.colors[(int)(1.0 * (double)i * (double)this.colors.length / (double)this.intervalCount - 1.0E-10)];
            g.setColor(color);
            if (this.colorBarTitles != null && i < this.colorBarTitles.length) {
                txt = this.colorBarTitles[i];
            } else {
                String formatted;
                double val = minVal + (double)i * (maxVal - minVal) / (double)this.intervalCount;
                long longval = (long)val;
                Date date = new Date(longval * 1000L);
                Instant dateInst = date.toInstant();
                ZoneId gmt = ZoneId.of("GMT");
                ZonedDateTime zonedDateTime = dateInst.atZone(gmt);
                if (maxVal - minVal > 86400.0) {
                    DateTimeFormatter day = DateTimeFormatter.ofPattern(DAY_TIME_FORMAT);
                    formatted = zonedDateTime.format(day);
                } else {
                    DateTimeFormatter time = DateTimeFormatter.ofPattern(TIME_FORMAT);
                    formatted = zonedDateTime.format(time);
                }
                txt = formatted;
            }
            this.drawLegendText(g, y, w, h, fh, fw, xText, i, color, txt);
        }
    }

    private void drawLegendText(Graphics2D g, int y, int w, int h, int fh, int fw, int xText, int i, Color color, String txt) {
        if (this.intervalCount == 0) {
            this.drawOutline(g, txt, xText, y + h / 2 + fh / 2, color);
            g.drawString(txt, xText, y + h / 2 + fh / 2);
        } else if (w < h) {
            this.drawOutline(g, txt, xText, y + i * h / this.intervalCount + fh / 2, color);
            g.drawString(txt, xText, y + i * h / this.intervalCount + fh / 2);
        } else {
            int xLoc = xText + i * w / this.intervalCount - fw / 2 - 14;
            int yLoc = y + fh - 5;
            this.drawOutline(g, txt, xLoc, yLoc, color);
            g.drawString(txt, xLoc, yLoc);
        }
    }
}

