/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class HistoryWay
extends HistoryOsmPrimitive {
    private final List<Long> nodeIds = new ArrayList<Long>();

    public HistoryWay(long id, long version, boolean visible, User user, long changesetId, Instant timestamp) {
        super(id, version, visible, user, changesetId, timestamp);
    }

    public HistoryWay(long id, long version, boolean visible, User user, long changesetId, Instant timestamp, boolean checkHistoricParams) {
        super(id, version, visible, user, changesetId, timestamp, checkHistoricParams);
    }

    public HistoryWay(long id, long version, boolean visible, User user, long changesetId, Instant timestamp, List<Long> nodeIdList) {
        this(id, version, visible, user, changesetId, timestamp);
        CheckParameterUtil.ensureParameterNotNull(nodeIdList, "nodeIdList");
        this.nodeIds.addAll(nodeIdList);
    }

    public HistoryWay(Way w) {
        super(w);
    }

    public int getNumNodes() {
        return this.nodeIds.size();
    }

    public long getNodeId(int idx) {
        if (idx < 0 || idx >= this.nodeIds.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.nodeIds.size(), idx));
        }
        return this.nodeIds.get(idx);
    }

    public List<Long> getNodes() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    public void addNode(long ref) {
        this.nodeIds.add(ref);
    }

    public boolean isClosed() {
        return this.getNumNodes() >= 3 && Objects.equals(this.nodeIds.get(0), this.nodeIds.get(this.nodeIds.size() - 1));
    }

    @Override
    public String getDisplayName(HistoryNameFormatter formatter) {
        return formatter.format(this);
    }

    public WayData fillPrimitiveData(WayData data) {
        super.fillPrimitiveCommonData(data);
        data.setNodeIds(this.nodeIds);
        return data;
    }
}

