/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.EnumProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.IExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.RecentTagCollection;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompListener;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmListCellRenderer;
import org.openstreetmap.josm.gui.widgets.OrientationAction;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmPrimitiveImageProvider;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class TagEditHelper {
    private final JTable tagTable;
    private final DefaultTableModel tagData;
    private final Map<String, Map<String, Integer>> valueCount;
    protected Collection<OsmPrimitive> sel;
    private String changedKey;
    static final Comparator<AutoCompletionItem> DEFAULT_AC_ITEM_COMPARATOR = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    public static final BooleanProperty AUTOCOMPLETE_KEYS = new BooleanProperty("properties.autocomplete-keys", true);
    public static final BooleanProperty AUTOCOMPLETE_VALUES = new BooleanProperty("properties.autocomplete-values", true);
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);
    public static final ListProperty PROPERTY_RECENT_TAGS = new ListProperty("properties.recent-tags", Collections.emptyList());
    public static final StringProperty PROPERTY_TAGS_TO_IGNORE = new StringProperty("properties.recent-tags.ignore", new SearchSetting().writeToString());
    public static final EnumProperty<RecentExisting> PROPERTY_RECENT_EXISTING = new EnumProperty<RecentExisting>("properties.recently-added-tags-existing-key", RecentExisting.class, RecentExisting.DISABLE);
    public static final EnumProperty<RefreshRecent> PROPERTY_REFRESH_RECENT = new EnumProperty<RefreshRecent>("properties.refresh-recently-added-tags", RefreshRecent.class, RefreshRecent.STATUS);
    final RecentTagCollection recentTags = new RecentTagCollection(30);
    SearchSetting tagsToIgnore;
    private List<Tag> tags;

    public TagEditHelper(JTable tagTable, DefaultTableModel propertyData, Map<String, Map<String, Integer>> valueCount) {
        this.tagTable = tagTable;
        this.tagData = propertyData;
        this.valueCount = valueCount;
    }

    public final String getDataKey(int viewRow) {
        return this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(viewRow), 0).toString();
    }

    boolean containsDataKey(String key) {
        return IntStream.range(0, this.tagData.getRowCount()).anyMatch(i -> key.equals(this.tagData.getValueAt(i, 0)) && !((Map)this.tagData.getValueAt(i, 1)).containsKey(""));
    }

    public final Map<String, Integer> getDataValues(int viewRow) {
        return (Map)this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(viewRow), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag() {
        this.changedKey = null;
        DataSet activeDataSet = OsmDataManager.getInstance().getActiveDataSet();
        if (activeDataSet == null) {
            return;
        }
        try {
            activeDataSet.beginUpdate();
            Collection<OsmPrimitive> selection = OsmDataManager.getInstance().getInProgressSelection();
            this.sel = selection;
            if (Utils.isEmpty(selection)) {
                return;
            }
            AddTagsDialog addDialog = this.getAddTagsDialog();
            addDialog.showDialog();
            addDialog.destroyActions();
            if (addDialog.getValue() == 1 && (selection == this.sel || TagEditHelper.warnSelectionChanged())) {
                addDialog.performTagAdding(selection);
            } else {
                addDialog.undoAllTagsAdding();
            }
        }
        finally {
            activeDataSet.endUpdate();
        }
    }

    protected AddTagsDialog getAddTagsDialog() {
        return new AddTagsDialog();
    }

    public void editTag(int row, boolean focusOnKey) {
        this.changedKey = null;
        this.sel = OsmDataManager.getInstance().getInProgressSelection();
        if (Utils.isEmpty(this.sel)) {
            return;
        }
        IEditTagDialog editDialog = this.getEditTagDialog(row, focusOnKey, this.getDataKey(row));
        editDialog.showDialog();
        if (editDialog.getValue() != 1) {
            return;
        }
        editDialog.performTagEdit();
    }

    protected IEditTagDialog getEditTagDialog(int row, boolean focusOnKey, String key) {
        return new EditTagDialog(key, this.getDataValues(row), focusOnKey);
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    public void resetChangedKey() {
        this.changedKey = null;
    }

    private static List<String> getAutocompletionKeys(String key) {
        if ("name".equals(key) || "addr:street".equals(key)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(key);
    }

    public void loadTagsIfNeeded() {
        this.loadTagsToIgnore();
        if (Boolean.TRUE.equals(PROPERTY_REMEMBER_TAGS.get()) && this.recentTags.isEmpty()) {
            this.recentTags.loadFromPreference(PROPERTY_RECENT_TAGS);
        }
    }

    void loadTagsToIgnore() {
        SearchSetting searchSetting = Utils.firstNonNull(SearchSetting.readFromString(PROPERTY_TAGS_TO_IGNORE.get()), new SearchSetting());
        if (!Objects.equals(this.tagsToIgnore, searchSetting)) {
            try {
                this.tagsToIgnore = searchSetting;
                this.recentTags.setTagsToIgnore(this.tagsToIgnore);
            }
            catch (SearchParseError parseError) {
                TagEditHelper.warnAboutParseError(parseError);
                this.tagsToIgnore = new SearchSetting();
                this.recentTags.setTagsToIgnore(SearchCompiler.Never.INSTANCE);
            }
        }
    }

    private static void warnAboutParseError(SearchParseError parseError) {
        Logging.warn(parseError);
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
    }

    public void saveTagsIfNeeded() {
        if (Boolean.TRUE.equals(PROPERTY_REMEMBER_TAGS.get()) && !this.recentTags.isEmpty()) {
            this.recentTags.saveToPreference(PROPERTY_RECENT_TAGS);
        }
    }

    public void resetSelection() {
        this.sel = null;
    }

    private void cacheRecentTags() {
        this.tags = this.recentTags.toList();
        Collections.reverse(this.tags);
    }

    public static String getEditItem(AutoCompComboBox<AutoCompletionItem> cb) {
        return Utils.removeWhiteSpaces(cb.getEditorItemAsString());
    }

    public static String getSelectedOrEditItem(AutoCompComboBox<AutoCompletionItem> cb) {
        Object selectedItem = cb.getSelectedItem();
        if (selectedItem != null) {
            return selectedItem.toString();
        }
        return TagEditHelper.getEditItem(cb);
    }

    private static boolean warnSelectionChanged() {
        return ConditionalOptionPaneUtil.showConfirmationDialog("properties.selection-changed", MainApplication.getMainFrame(), I18n.tr("Data selection has changed since the dialog was opened", new Object[0]), I18n.tr("Apply tag change to old selection?", new Object[0]), 0, 2, 0);
    }

    private static boolean warnOverwriteKey(String action, String togglePref) {
        return new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Overwrite tag", new Object[0]), I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("ok", "cancel").setContent(action).setCancelButton(2).toggleEnable(togglePref).showDialog().getValue() == 1;
    }

    static {
        RecentTagCollection recentTags = new RecentTagCollection(30);
        recentTags.loadFromPreference(PROPERTY_RECENT_TAGS);
        recentTags.toList().forEach(tag -> AutoCompletionManager.rememberUserInput(tag.getKey(), tag.getValue(), false));
    }

    protected class AddTagsDialog
    extends AbstractTagsDialog {
        private final List<JosmAction> recentTagsActions;
        private final JPanel mainPanel;
        private JPanel recentTagsPanel;
        private int commandCount;
        private final transient AutoCompletionManager autocomplete;

        protected AddTagsDialog() {
            super(MainApplication.getMainFrame(), I18n.tr("Add tag", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.setButtonIcons("ok", "cancel");
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            this.mainPanel = new JPanel(new GridBagLayout()){

                @Override
                public void applyComponentOrientation(ComponentOrientation o) {
                    this.setComponentOrientation(o);
                }
            };
            this.mainPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
            this.keys = new AutoCompComboBox();
            this.keys.setPrototypeDisplayValue(new AutoCompletionItem("dummy"));
            this.keys.setEditable(true);
            ((AutoCompComboBoxModel)this.keys.getModel()).setComparator(Comparator.naturalOrder());
            this.keys.setAutocompleteEnabled(AUTOCOMPLETE_KEYS.get());
            this.mainPanel.add((Component)this.keys, GBC.eop().fill(2));
            this.mainPanel.add((Component)new JLabel(I18n.tr("Choose a value", new Object[0])), GBC.eol());
            this.values = new AutoCompComboBox();
            this.values.setPrototypeDisplayValue(new AutoCompletionItem("dummy"));
            this.values.setEditable(true);
            ((AutoCompComboBoxModel)this.values.getModel()).setComparator(Comparator.naturalOrder());
            this.values.setAutocompleteEnabled(AUTOCOMPLETE_VALUES.get());
            this.mainPanel.add((Component)this.values, GBC.eop().fill(2));
            TagEditHelper.this.cacheRecentTags();
            this.autocomplete = AutoCompletionManager.of(OsmDataManager.getInstance().getActiveDataSet());
            List<AutoCompletionItem> keyList = this.autocomplete.getTagKeys(DEFAULT_AC_ITEM_COMPARATOR);
            keyList.removeIf(item -> TagEditHelper.this.containsDataKey(item.getValue()));
            this.keys.getModel().addAllElements(keyList);
            this.updateValueModel(this.autocomplete, DEFAULT_AC_ITEM_COMPARATOR);
            TagEditHelper.this.tags.stream().filter(tag -> !TagEditHelper.this.containsDataKey(tag.getKey())).findFirst().ifPresent(tag -> {
                this.keys.setSelectedItemText(tag.getKey());
                this.values.setSelectedItemText(tag.getValue());
            });
            this.keys.addActionListener(ignore -> this.updateOkButtonIcon());
            this.values.addActionListener(ignore -> this.updateOkButtonIcon());
            this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 64), "addAndContinue");
            this.mainPanel.getActionMap().put("addAndContinue", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.performTagAdding();
                    AddTagsDialog.this.refreshRecentTags();
                    AddTagsDialog.this.keys.requestFocus();
                }
            });
            this.suggestRecentlyAddedTags();
            this.mainPanel.add(Box.createVerticalGlue(), GBC.eop().fill());
            this.mainPanel.applyComponentOrientation(OrientationAction.getDefaultComponentOrientation());
            this.setContent(this.mainPanel, false);
            this.addEventListeners();
            this.popupMenu.add(new AbstractAction(I18n.tr("Set number of recently added tags", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.selectNumberOfTags();
                    AddTagsDialog.this.suggestRecentlyAddedTags();
                }
            });
            this.popupMenu.add(this.buildMenuRecentExisting());
            this.popupMenu.add(this.buildMenuRefreshRecent());
            JCheckBoxMenuItem rememberLastTags = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Remember last used tags after a restart", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean state = ((JCheckBoxMenuItem)e.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(state);
                    if (state) {
                        TagEditHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            rememberLastTags.setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add(rememberLastTags);
        }

        @Override
        public void autoCompBefore(AutoCompEvent e) {
            this.updateValueModel(this.autocomplete, DEFAULT_AC_ITEM_COMPARATOR);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.updateValueModel(this.autocomplete, DEFAULT_AC_ITEM_COMPARATOR);
        }

        private JMenu buildMenuRecentExisting() {
            JMenu menu = new JMenu(I18n.tr("Recent tags with existing key", new Object[0]));
            TreeMap<RecentExisting, String> radios = new TreeMap<RecentExisting, String>();
            radios.put(RecentExisting.ENABLE, I18n.tr("Enable", new Object[0]));
            radios.put(RecentExisting.DISABLE, I18n.tr("Disable", new Object[0]));
            radios.put(RecentExisting.HIDE, I18n.tr("Hide", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : radios.entrySet()) {
                JRadioButtonMenuItem radio = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PROPERTY_RECENT_EXISTING.put((RecentExisting)((Object)entry.getKey()), new String[0]);
                        AddTagsDialog.this.suggestRecentlyAddedTags();
                    }
                });
                buttonGroup.add(radio);
                radio.setSelected(PROPERTY_RECENT_EXISTING.get(new String[0]) == entry.getKey());
                menu.add(radio);
            }
            return menu;
        }

        private JMenu buildMenuRefreshRecent() {
            JMenu menu = new JMenu(I18n.tr("Refresh recent tags list after applying tag", new Object[0]));
            TreeMap<RefreshRecent, String> radios = new TreeMap<RefreshRecent, String>();
            radios.put(RefreshRecent.NO, I18n.tr("No refresh", new Object[0]));
            radios.put(RefreshRecent.STATUS, I18n.tr("Refresh tag status only (enabled / disabled)", new Object[0]));
            radios.put(RefreshRecent.REFRESH, I18n.tr("Refresh tag status and list of recently added tags", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : radios.entrySet()) {
                JRadioButtonMenuItem radio = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PROPERTY_REFRESH_RECENT.put((RefreshRecent)((Object)entry.getKey()), new String[0]);
                    }
                });
                buttonGroup.add(radio);
                radio.setSelected(PROPERTY_REFRESH_RECENT.get(new String[0]) == entry.getKey());
                menu.add(radio);
            }
            return menu;
        }

        @Override
        public void setContentPane(Container contentPane) {
            int commandDownMask = PlatformManager.getPlatform().getMenuShortcutKeyMaskEx();
            ArrayList<String> lines = new ArrayList<String>();
            Shortcut.findShortcut(49, commandDownMask).ifPresent(sc -> lines.add(sc.getKeyText() + ' ' + I18n.tr("to apply first suggestion", new Object[0])));
            lines.add(Shortcut.getKeyText(KeyStroke.getKeyStroke(10, 64)) + ' ' + I18n.tr("to add without closing the dialog", new Object[0]));
            Shortcut.findShortcut(49, commandDownMask | 0x40).ifPresent(sc -> lines.add(sc.getKeyText() + ' ' + I18n.tr("to add first suggestion without closing the dialog", new Object[0])));
            JLabel helpLabel = new JLabel("<html>" + String.join((CharSequence)"<br>", lines) + "</html>");
            helpLabel.setFont(helpLabel.getFont().deriveFont(0));
            contentPane.add((Component)helpLabel, GBC.eol().fill(2).insets(5, 5, 5, 5));
            super.setContentPane(contentPane);
        }

        protected void selectNumberOfTags() {
            String s = String.format("%d", PROPERTY_RECENT_TAGS_NUMBER.get());
            while (!Utils.isEmpty(s = JOptionPane.showInputDialog(this, I18n.tr("Please enter the number of recently added tags to display", new Object[0]), s))) {
                try {
                    int v = Integer.parseInt(s);
                    if (v >= 0 && v <= 30) {
                        PROPERTY_RECENT_TAGS_NUMBER.put(v);
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    Logging.warn(ex);
                }
                JOptionPane.showMessageDialog(this, I18n.tr("Please enter integer number between 0 and {0}", 30));
            }
            return;
        }

        protected void suggestRecentlyAddedTags() {
            if (this.recentTagsPanel == null) {
                this.recentTagsPanel = new JPanel(new GridBagLayout());
                this.buildRecentTagsPanel();
                this.mainPanel.add((Component)this.recentTagsPanel, GBC.eol().fill(2));
            } else {
                Dimension panelOldSize = this.recentTagsPanel.getPreferredSize();
                this.recentTagsPanel.removeAll();
                this.buildRecentTagsPanel();
                Dimension panelNewSize = this.recentTagsPanel.getPreferredSize();
                Dimension dialogOldSize = this.getMinimumSize();
                Dimension dialogNewSize = new Dimension(dialogOldSize.width, dialogOldSize.height - panelOldSize.height + panelNewSize.height);
                this.setMinimumSize(dialogNewSize);
                this.setPreferredSize(dialogNewSize);
                this.setSize(dialogNewSize);
                this.revalidate();
                this.repaint();
            }
        }

        protected void buildRecentTagsPanel() {
            int tagsToShow = Math.min(PROPERTY_RECENT_TAGS_NUMBER.get(), 30);
            if (tagsToShow <= 0 || TagEditHelper.this.recentTags.isEmpty()) {
                return;
            }
            this.recentTagsPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int count = 0;
            this.destroyActions();
            for (int i = 0; i < TagEditHelper.this.tags.size() && count < tagsToShow; ++i) {
                final Tag t = (Tag)TagEditHelper.this.tags.get(i);
                boolean keyExists = TagEditHelper.this.containsDataKey(t.getKey());
                if (keyExists && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.HIDE) continue;
                Shortcut sc = ++count > 10 ? null : Shortcut.registerShortcut("properties:recent:" + count, I18n.tr("Choose recent tag {0}", count), 48 + count % 10, 5006);
                final JosmAction action = new JosmAction(I18n.tr("Choose recent tag {0}", count), null, I18n.tr("Use this tag again", new Object[0]), sc, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddTagsDialog.this.keys.setSelectedItemText(t.getKey());
                        AddTagsDialog.this.updateValueModel(AddTagsDialog.this.autocomplete, DEFAULT_AC_ITEM_COMPARATOR);
                        AddTagsDialog.this.values.setSelectedItemText(t.getValue());
                        AddTagsDialog.this.values.requestFocus();
                    }
                };
                Shortcut scShift = count > 10 ? null : Shortcut.registerShortcut("properties:recent:apply:" + count, I18n.tr("Apply recent tag {0}", count), 48 + count % 10, 5009);
                JosmAction actionShift = new JosmAction(I18n.tr("Apply recent tag {0}", count), null, I18n.tr("Use this tag again", new Object[0]), scShift, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        action.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                        AddTagsDialog.this.refreshRecentTags();
                        AddTagsDialog.this.keys.requestFocus();
                    }
                };
                this.recentTagsActions.add(action);
                this.recentTagsActions.add(actionShift);
                if (keyExists && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.DISABLE) {
                    action.setEnabled(false);
                }
                ImageIcon icon = this.findIcon(t.getKey(), t.getValue()).orElseGet(() -> new ImageIcon(new BufferedImage(16, 16, 2)));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.ipadx = 5;
                this.recentTagsPanel.add((Component)new JLabel(action.isEnabled() ? icon : GuiHelper.getDisabledIcon(icon)), gbc);
                String color = action.isEnabled() ? "" : "; color:gray";
                JLabel tagLabel = new JLabel("<html><style>td{" + color + "}</style><table><tr><td>" + count + ".</td><td style='border:1px solid gray'>" + XmlWriter.encode(t.toString(), true) + '<' + "/td></tr></table></html>");
                tagLabel.setFont(tagLabel.getFont().deriveFont(0));
                if (action.isEnabled() && sc != null && scShift != null) {
                    this.recentTagsPanel.getInputMap(2).put(sc.getKeyStroke(), "choose" + count);
                    this.recentTagsPanel.getActionMap().put("choose" + count, action);
                    this.recentTagsPanel.getInputMap(2).put(scShift.getKeyStroke(), "apply" + count);
                    this.recentTagsPanel.getActionMap().put("apply" + count, actionShift);
                }
                if (action.isEnabled()) {
                    tagLabel.setToolTipText((String)action.getValue("ShortDescription"));
                    tagLabel.setCursor(Cursor.getPredefinedCursor(12));
                    tagLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            action.actionPerformed(null);
                            if (SwingUtilities.isRightMouseButton(e)) {
                                Component component = e.getComponent();
                                if (component.isShowing()) {
                                    new TagPopupMenu(t).show(component, e.getX(), e.getY());
                                }
                            } else if (e.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                                AddTagsDialog.this.refreshRecentTags();
                                AddTagsDialog.this.keys.requestFocus();
                            } else if (e.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                        }
                    });
                } else {
                    tagLabel.setEnabled(false);
                    tagLabel.setToolTipText(I18n.tr("The key ''{0}'' is already used", t.getKey()));
                }
                JPanel tagPanel = new JPanel(new FlowLayout(0, 0, 0));
                tagPanel.add(tagLabel);
                this.recentTagsPanel.add((Component)tagPanel, GBC.eol().fill(2));
            }
            if (count == 0) {
                this.recentTagsPanel.removeAll();
            }
        }

        public void destroyActions() {
            for (JosmAction action : this.recentTagsActions) {
                action.destroy();
            }
            this.recentTagsActions.clear();
        }

        public final void performTagAdding() {
            Collection<OsmPrimitive> selection = TagEditHelper.this.sel;
            if (!Utils.isEmpty(selection)) {
                this.performTagAdding(selection);
            }
        }

        private void performTagAdding(Collection<OsmPrimitive> selection) {
            String key = TagEditHelper.getEditItem(this.keys);
            String value = TagEditHelper.getEditItem(this.values);
            if (key.isEmpty() || value.isEmpty()) {
                return;
            }
            for (Tagged tagged : selection) {
                String val = tagged.get(key);
                if (val == null || val.equals(value)) continue;
                String valueHtmlString = Utils.joinAsHtmlUnorderedList(Arrays.asList("<strike>" + val + "</strike>", value));
                if (TagEditHelper.warnOverwriteKey("<html>" + I18n.tr("You changed the value of ''{0}'': {1}", key, valueHtmlString) + I18n.tr("Overwrite?", new Object[0]), "overwriteAddKey")) break;
                return;
            }
            TagEditHelper.this.recentTags.add(new Tag(key, value));
            TagEditHelper.this.valueCount.put(key, new TreeMap());
            AutoCompletionManager.rememberUserInput(key, value, false);
            ++this.commandCount;
            UndoRedoHandler.getInstance().add(new ChangePropertyCommand(selection, key, value));
            TagEditHelper.this.changedKey = key;
            this.clearEntries();
        }

        protected void clearEntries() {
            this.keys.getEditor().setItem("");
            this.values.getEditor().setItem("");
        }

        public void undoAllTagsAdding() {
            UndoRedoHandler.getInstance().undo(this.commandCount);
        }

        private void refreshRecentTags() {
            switch ((RefreshRecent)((Object)PROPERTY_REFRESH_RECENT.get(new String[0]))) {
                case REFRESH: {
                    TagEditHelper.this.cacheRecentTags();
                    this.suggestRecentlyAddedTags();
                    break;
                }
                case STATUS: {
                    this.suggestRecentlyAddedTags();
                    break;
                }
            }
        }

        class EditIgnoreTagsAction
        extends AbstractAction {
            EditIgnoreTagsAction() {
                super(I18n.tr("Edit ignore list", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSetting newTagsToIngore = SearchAction.showSearchDialog(TagEditHelper.this.tagsToIgnore);
                if (newTagsToIngore == null) {
                    return;
                }
                try {
                    TagEditHelper.this.tagsToIgnore = newTagsToIngore;
                    TagEditHelper.this.recentTags.setTagsToIgnore(TagEditHelper.this.tagsToIgnore);
                    PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                }
                catch (SearchParseError parseError) {
                    TagEditHelper.warnAboutParseError(parseError);
                }
            }
        }

        class IgnoreTagAction
        extends AbstractAction {
            final transient Tag tag;

            IgnoreTagAction(String name, Tag tag) {
                super(name);
                this.tag = tag;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (TagEditHelper.this.tagsToIgnore != null) {
                        TagEditHelper.this.recentTags.ignoreTag(this.tag, TagEditHelper.this.tagsToIgnore);
                        PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                    }
                }
                catch (SearchParseError parseError) {
                    throw new IllegalStateException(parseError);
                }
            }
        }

        class TagPopupMenu
        extends JPopupMenu {
            TagPopupMenu(Tag t) {
                this.add(new IgnoreTagAction(I18n.tr("Ignore key ''{0}''", t.getKey()), new Tag(t.getKey(), "")));
                this.add(new IgnoreTagAction(I18n.tr("Ignore tag ''{0}''", t), t));
                this.add(new EditIgnoreTagsAction());
            }
        }
    }

    protected static interface IEditTagDialog
    extends IExtendedDialog {
        public void performTagEdit();
    }

    protected class EditTagDialog
    extends AbstractTagsDialog
    implements IEditTagDialog {
        private final String key;
        private final transient Map<String, Integer> m;
        private final transient Comparator<AutoCompletionItem> usedValuesAwareComparator;
        private final transient AutoCompletionManager autocomplete;

        protected EditTagDialog(String key, Map<String, Integer> map, boolean initialFocusOnKey) {
            super(MainApplication.getMainFrame(), I18n.trn("Change value?", "Change values?", map.size(), new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.setButtonIcons("ok", "cancel");
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/EditValue", true);
            this.key = key;
            this.m = map;
            this.initialFocusOnKey = initialFocusOnKey;
            this.usedValuesAwareComparator = (o1, o2) -> {
                boolean c2;
                boolean c1 = this.m.containsKey(o1.getValue());
                if (c1 == (c2 = this.m.containsKey(o2.getValue()))) {
                    return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
                }
                if (c1) {
                    return -1;
                }
                return 1;
            };
            JPanel mainPanel = new JPanel(new BorderLayout());
            String msg = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", key) + ")</html>";
            mainPanel.add((Component)new JLabel(msg), "North");
            JPanel p = new JPanel(new GridBagLayout()){

                @Override
                public void applyComponentOrientation(ComponentOrientation o) {
                    this.setComponentOrientation(o);
                }
            };
            mainPanel.add((Component)p, "Center");
            this.autocomplete = AutoCompletionManager.of(OsmDataManager.getInstance().getActiveDataSet());
            List<AutoCompletionItem> keyList = this.autocomplete.getTagKeys(DEFAULT_AC_ITEM_COMPARATOR);
            this.keys = new AutoCompComboBox();
            ((AutoCompComboBoxModel)this.keys.getModel()).setComparator(Comparator.naturalOrder());
            this.keys.setEditable(true);
            this.keys.setPrototypeDisplayValue(new AutoCompletionItem("dummy"));
            this.keys.getModel().addAllElements(keyList);
            this.keys.setSelectedItemText(key);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.keys, GBC.eol().fill(2));
            List<AutoCompletionItem> valueList = this.autocomplete.getTagValues(TagEditHelper.getAutocompletionKeys(key), this.usedValuesAwareComparator);
            String selection = this.m.size() != 1 ? KeyedItem.DIFFERENT_I18N : this.m.entrySet().iterator().next().getKey();
            this.values = new AutoCompComboBox();
            ((AutoCompComboBoxModel)this.values.getModel()).setComparator(Comparator.naturalOrder());
            this.values.setRenderer(new TEHListCellRenderer(this.values, this.values.getRenderer(), (Map)TagEditHelper.this.valueCount.get(key)));
            this.values.setEditable(true);
            this.values.setPrototypeDisplayValue(new AutoCompletionItem("dummy"));
            this.values.getModel().addAllElements(valueList);
            this.values.setSelectedItemText(selection);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.values, GBC.eol().fill(2));
            p.add(Box.createVerticalStrut(2), GBC.eol());
            p.applyComponentOrientation(OrientationAction.getDefaultComponentOrientation());
            this.keys.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.values.applyComponentOrientation(OrientationAction.getNamelikeOrientation(this.keys.getText()));
            this.setContent(mainPanel, false);
            this.addEventListeners();
        }

        @Override
        public void autoCompBefore(AutoCompEvent e) {
            this.updateValueModel(this.autocomplete, this.usedValuesAwareComparator);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.updateValueModel(this.autocomplete, this.usedValuesAwareComparator);
        }

        @Override
        public void performTagEdit() {
            String value = TagEditHelper.getEditItem(this.values);
            if ((value = Normalizer.normalize(value, Normalizer.Form.NFC)).isEmpty()) {
                value = null;
            }
            String newkey = TagEditHelper.getEditItem(this.keys);
            if ((newkey = Normalizer.normalize(newkey, Normalizer.Form.NFC)).isEmpty()) {
                newkey = this.key;
                value = null;
            }
            if (this.key.equals(newkey) && KeyedItem.DIFFERENT_I18N.equals(value)) {
                return;
            }
            if (this.key.equals(newkey) || value == null) {
                UndoRedoHandler.getInstance().add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                if (value != null) {
                    AutoCompletionManager.rememberUserInput(newkey, value, true);
                    TagEditHelper.this.recentTags.add(new Tag(this.key, value));
                }
            } else {
                for (OsmPrimitive osm2 : TagEditHelper.this.sel) {
                    if (osm2.get(newkey) == null) continue;
                    if (TagEditHelper.warnOverwriteKey(I18n.tr("You changed the key from ''{0}'' to ''{1}''.", this.key, newkey) + "\n" + I18n.tr("The new key is already used, overwrite values?", new Object[0]), "overwriteEditKey")) break;
                    return;
                }
                ArrayList<Command> commands = new ArrayList<Command>();
                commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, this.key, null));
                if (value.equals(KeyedItem.DIFFERENT_I18N)) {
                    String newKey = newkey;
                    TagEditHelper.this.sel.stream().filter(osm -> osm.hasKey(this.key)).collect(Collectors.groupingBy(osm -> osm.get(this.key))).forEach((newValue, osmPrimitives) -> commands.add(new ChangePropertyCommand((Collection<? extends OsmPrimitive>)osmPrimitives, newKey, (String)newValue)));
                } else {
                    commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                    AutoCompletionManager.rememberUserInput(newkey, value, false);
                }
                UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()), commands));
            }
            TagEditHelper.this.changedKey = newkey;
        }
    }

    private static enum RecentExisting {
        ENABLE,
        DISABLE,
        HIDE;

    }

    private static enum RefreshRecent {
        NO,
        STATUS,
        REFRESH;

    }

    protected abstract class AbstractTagsDialog
    extends ExtendedDialog
    implements AutoCompListener,
    FocusListener,
    PopupMenuListener {
        protected AutoCompComboBox<AutoCompletionItem> keys;
        protected AutoCompComboBox<AutoCompletionItem> values;
        protected boolean initialFocusOnKey;
        protected String currentValuesModelKey;
        protected JPopupMenu popupMenu;

        AbstractTagsDialog(Component parent, String title, String ... buttonTexts) {
            super(parent, title, buttonTexts);
            this.initialFocusOnKey = true;
            this.currentValuesModelKey = "";
            this.popupMenu = new JPopupMenu(){
                private final JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Use English language for tag by default", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean use = ((JCheckBoxMenuItem)e.getSource()).getState();
                        PROPERTY_FIX_TAG_LOCALE.put(use);
                        AbstractTagsDialog.this.keys.setFixedLocale(use);
                    }
                });
                {
                    this.add(this.fixTagLanguageCb);
                    this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
                }
            };
            this.addMouseListener(new PopupMenuLauncher(this.popupMenu));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!OsmDataManager.getInstance().getActiveDataSet().isLocked());
            Dimension size = this.getSize();
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), size));
            this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get());
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                Dimension size;
                WindowGeometry geometry = this.initWindowGeometry();
                Dimension storedSize = geometry.getSize();
                if (!storedSize.equals(size = this.getSize())) {
                    if (storedSize.width < size.width) {
                        storedSize.width = size.width;
                    }
                    if (storedSize.height != size.height) {
                        storedSize.height = size.height;
                    }
                    this.rememberWindowGeometry(geometry);
                }
                this.updateOkButtonIcon();
            }
            super.setVisible(visible);
        }

        protected void updateValueModel(AutoCompletionManager autocomplete, Comparator<AutoCompletionItem> comparator) {
            String key = this.keys.getText();
            if (!key.equals(this.currentValuesModelKey)) {
                Logging.debug("updateValueModel: lazy loading values for key ''{0}''", key);
                String savedText = this.values.getText();
                this.values.getModel().removeAllElements();
                this.values.getModel().addAllElements(autocomplete.getTagValues(TagEditHelper.getAutocompletionKeys(key), comparator));
                this.values.applyComponentOrientation(OrientationAction.getNamelikeOrientation(key));
                this.values.setSelectedItemText(savedText);
                this.values.getEditor().selectAll();
                this.currentValuesModelKey = key;
            }
        }

        protected void addEventListeners() {
            this.values.getEditor().addActionListener(e -> this.buttonAction(0, null));
            this.keys.getEditorComponent().addFocusListener(this);
            ((AutoCompTextField)this.values.getEditorComponent()).addAutoCompListener(this);
            this.values.addPopupMenuListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (AbstractTagsDialog.this.initialFocusOnKey) {
                        AbstractTagsDialog.this.keys.requestFocus();
                    } else {
                        AbstractTagsDialog.this.values.requestFocus();
                    }
                }
            });
        }

        @Override
        public void autoCompPerformed(AutoCompEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.values.applyComponentOrientation(OrientationAction.getNamelikeOrientation(this.keys.getText()));
        }

        protected void updateOkButtonIcon() {
            if (this.buttons.isEmpty()) {
                return;
            }
            ((JButton)this.buttons.get(0)).setIcon(this.findIcon(TagEditHelper.getSelectedOrEditItem(this.keys), TagEditHelper.getSelectedOrEditItem(this.values)).orElse(ImageProvider.get("ok", ImageProvider.ImageSizes.LARGEICON)));
        }

        protected Optional<ImageIcon> findIcon(String key, String value) {
            Iterator<OsmPrimitive> osmPrimitiveIterator = TagEditHelper.this.sel.iterator();
            OsmPrimitiveType type = osmPrimitiveIterator.hasNext() ? osmPrimitiveIterator.next().getType() : OsmPrimitiveType.NODE;
            return OsmPrimitiveImageProvider.getResource(key, value, type).map(resource -> resource.getPaddedIcon(ImageProvider.ImageSizes.LARGEICON.getImageDimension()));
        }
    }

    static class TEHListCellRenderer
    extends JosmListCellRenderer<AutoCompletionItem> {
        protected Map<String, Integer> map;

        TEHListCellRenderer(Component component, ListCellRenderer<? super AutoCompletionItem> renderer, Map<String, Integer> map) {
            super(component, renderer);
            this.map = map;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionItem> list, AutoCompletionItem value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            Integer count = null;
            if (this.map != null && (count = this.map.get(text = value == null ? "" : value.toString())) != null) {
                value = new AutoCompletionItem(I18n.tr("{0} ({1})", text, count));
            }
            Component l = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            l.setComponentOrientation(this.component.getComponentOrientation());
            if (count != null) {
                l.setFont(l.getFont().deriveFont(3));
            }
            return l;
        }
    }
}

