/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.tools.Logging;

public class HostLimitQueue
extends LinkedBlockingDeque<Runnable> {
    private static final long serialVersionUID = 1L;
    private final Map<String, Semaphore> hostSemaphores = new ConcurrentHashMap<String, Semaphore>();
    private final int hostLimit;

    public HostLimitQueue(int hostLimit) {
        this.hostLimit = hostLimit;
    }

    public HostLimitQueue(int hostLimit, int queueLimit) {
        super(queueLimit);
        this.hostLimit = hostLimit;
    }

    private JCSCachedTileLoaderJob<?, ?> findJob() {
        for (Runnable r : this) {
            if (!(r instanceof JCSCachedTileLoaderJob)) continue;
            JCSCachedTileLoaderJob job = (JCSCachedTileLoaderJob)r;
            if (this.tryAcquireSemaphore(job)) {
                if (this.remove(job)) {
                    return job;
                }
                this.releaseSemaphore(job);
                continue;
            }
            URL url = null;
            try {
                url = job.getUrl();
            }
            catch (IOException e) {
                Logging.debug(e);
            }
            Logging.debug("TMS - Skipping job {0} because host limit reached", url);
        }
        return null;
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable job = this.findJob();
        if (job != null) {
            return job;
        }
        job = (Runnable)this.pollFirst(timeout, unit);
        if (job != null) {
            try {
                boolean gotLock = this.tryAcquireSemaphore(job, timeout, unit);
                return gotLock ? job : null;
            }
            catch (InterruptedException e) {
                if (!this.offer(job)) {
                    Logging.warn("Unable to offer back " + job);
                }
                throw e;
            }
        }
        return job;
    }

    @Override
    public Runnable take() throws InterruptedException {
        Runnable job = this.findJob();
        if (job != null) {
            return job;
        }
        job = (Runnable)this.takeFirst();
        try {
            this.acquireSemaphore(job);
        }
        catch (InterruptedException e) {
            if (!this.offer(job)) {
                Logging.warn("Unable to offer back " + job);
            }
            throw e;
        }
        return job;
    }

    private Semaphore getSemaphore(JCSCachedTileLoaderJob<?, ?> job) {
        String host;
        try {
            host = job.getUrl().getHost();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Semaphore limit = this.hostSemaphores.get(host);
        if (limit == null) {
            limit = this.hostSemaphores.computeIfAbsent(host, k -> new Semaphore(this.hostLimit));
        }
        return limit;
    }

    private void acquireSemaphore(Runnable job) throws InterruptedException {
        if (job instanceof JCSCachedTileLoaderJob) {
            JCSCachedTileLoaderJob jcsJob = (JCSCachedTileLoaderJob)job;
            this.getSemaphore(jcsJob).acquire();
            jcsJob.setFinishedTask(() -> this.releaseSemaphore(jcsJob));
        }
    }

    private boolean tryAcquireSemaphore(JCSCachedTileLoaderJob<?, ?> job) {
        boolean ret = true;
        Semaphore limit = this.getSemaphore(job);
        if (limit != null && (ret = limit.tryAcquire())) {
            job.setFinishedTask(() -> this.releaseSemaphore(job));
        }
        return ret;
    }

    private boolean tryAcquireSemaphore(Runnable job, long timeout, TimeUnit unit) throws InterruptedException {
        JCSCachedTileLoaderJob jcsJob;
        Semaphore limit;
        boolean ret = true;
        if (job instanceof JCSCachedTileLoaderJob && (limit = this.getSemaphore(jcsJob = (JCSCachedTileLoaderJob)job)) != null && (ret = limit.tryAcquire(timeout, unit))) {
            jcsJob.setFinishedTask(() -> this.releaseSemaphore(jcsJob));
        }
        return ret;
    }

    private void releaseSemaphore(JCSCachedTileLoaderJob<?, ?> job) {
        Semaphore limit = this.getSemaphore(job);
        if (limit != null) {
            limit.release();
            if (limit.availablePermits() > this.hostLimit) {
                Logging.warn("More permits than it should be");
            }
        }
    }
}

