/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.MapPaintPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintPreference
extends DefaultTabPreferenceSetting {
    private SourceEditor sources;
    private JCheckBox enableIconDefault;
    private static final List<SourceProvider> styleSourceProviders = new ArrayList<SourceProvider>();

    MapPaintPreference() {
        super("dialogs/mapstyle", I18n.tr("Map Paint Styles", new Object[0]), I18n.tr("Map Paint Styles", new Object[0]));
    }

    public static boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return styleSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.enableIconDefault = new JCheckBox(I18n.tr("Enable built-in icon defaults", new Object[0]), Config.getPref().getBoolean("mappaint.icon.enable-defaults", true));
        this.sources = new MapPaintSourceEditor();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.sources, GBC.eol().fill(1));
        panel.add((Component)this.enableIconDefault, GBC.eol().insets(11, 2, 5, 0));
        PreferenceTabbedPane.PreferencePanel preferencePanel = gui.createPreferenceTab(this);
        preferencePanel.add((Component)panel, GBC.std().fill());
        this.sources.deferLoading(gui, (Component)preferencePanel);
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/MapPaintPreference");
    }

    public static String getTitleFromSourceEntry(SourceEntry entry) {
        try {
            MapCSSStyleSource css = new MapCSSStyleSource(entry);
            css.loadStyleSource();
            if (!Utils.isEmpty(css.title)) {
                return css.title;
            }
        }
        catch (RuntimeException ignore) {
            Logging.debug(ignore);
        }
        return null;
    }

    @Override
    public boolean ok() {
        boolean reload = Config.getPref().putBoolean("mappaint.icon.enable-defaults", this.enableIconDefault.isSelected());
        if (reload |= this.sources.finish()) {
            MapPaintStyles.readFromPreferences();
        }
        if (MainApplication.isDisplayingMapView()) {
            MapPaintStyles.getStyles().clearCached();
        }
        return false;
    }

    public static void initialize() {
        MapPaintStyles.readFromPreferences();
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    static class MapPaintSourceEditor
    extends SourceEditor {
        private static final String ICONPREF = "mappaint.icon.sources";

        MapPaintSourceEditor() {
            super(SourceType.MAP_PAINT_STYLE, Config.getUrls().getJOSMWebsite() + "/styles", styleSourceProviders, true);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return MapPaintPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            return this.doFinish(MapPaintPrefHelper.INSTANCE, ICONPREF);
        }

        @Override
        public Collection<ExtendedSourceEntry> getDefault() {
            return MapPaintPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Config.getPref().getList(ICONPREF, null);
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available styles:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active styles:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new style by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New style entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected styles from the list of active styles", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active style", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available styles to the list of active styles", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available styles from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading style sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of style sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Styles#FailedToLoadStyleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }

        @Override
        protected String getTitleForSourceEntry(SourceEntry entry) {
            String title = MapPaintPreference.getTitleFromSourceEntry(entry);
            return title != null ? title : super.getTitleForSourceEntry(entry);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new MapPaintPreference();
        }
    }
}

