/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.util.Arrays;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Command;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.InvalidMapboxVectorTileException;

public class CommandInteger {
    private final Command type;
    private final short[] parameters;
    private int added;

    public CommandInteger(int command) {
        long unsigned = Integer.toUnsignedLong(command);
        this.type = Stream.of(Command.values()).filter(e -> (long)e.getId() == (unsigned & 7L)).findAny().orElseThrow(InvalidMapboxVectorTileException::new);
        int operationsInt = (int)(unsigned >> 3);
        this.parameters = new short[operationsInt * this.type.getParameterNumber()];
    }

    public void addParameter(Number parameterInteger) {
        this.parameters[this.added++] = parameterInteger.shortValue();
    }

    public short[] getOperations() {
        return this.parameters;
    }

    public Command getType() {
        return this.type;
    }

    public boolean hasAllExpectedParameters() {
        return this.added >= this.parameters.length;
    }

    public String toString() {
        return "CommandInteger [type=" + (Object)((Object)this.type) + ", parameters=" + Arrays.toString(this.parameters) + ']';
    }
}

