/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.spi.preferences.Config;

public class AutoCompComboBoxModel<E>
extends AbstractListModel<E>
implements MutableComboBoxModel<E>,
Iterable<E> {
    private Comparator<E> comparator;
    private int maxSize = -1;
    protected ArrayList<E> elements = new ArrayList();
    protected Object selected;

    public AutoCompComboBoxModel() {
        this.setComparator(Comparator.comparing(Object::toString));
    }

    public AutoCompComboBoxModel(Comparator<E> comparator) {
        this.setComparator(comparator);
    }

    public void setComparator(Comparator<E> comparator) {
        Objects.requireNonNull(comparator, "A comparator cannot be null.");
        this.comparator = comparator;
    }

    public void setSize(int size) {
        this.maxSize = size;
    }

    public Collection<E> asCollection() {
        return new ArrayList<E>(this.elements);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public void addElement(E element) {
        if (element != null && (this.maxSize == -1 || this.getSize() < this.maxSize)) {
            this.elements.add(element);
        }
    }

    @Override
    public void removeElement(Object elem) {
        this.elements.remove(elem);
    }

    @Override
    public void removeElementAt(int index) {
        E elem = this.getElementAt(index);
        if (elem == this.selected) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.elements.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void insertElementAt(E element, int index) {
        if (this.maxSize != -1 && this.maxSize <= this.getSize()) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.elements.add(index, element);
    }

    @Override
    public void setSelectedItem(Object elem) {
        if (this.selected != null && !this.selected.equals(elem) || this.selected == null && elem != null) {
            this.selected = elem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public E getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public void addAllElements(Collection<E> elems) {
        elems.forEach(e -> this.addElement(e));
    }

    public void addAllElements(Collection<String> strings, Function<String, E> buildE) {
        strings.forEach(s -> this.addElement(buildE.apply((String)s)));
    }

    public E addTopElement(E newElement) {
        if (newElement.equals(this.getElementAt(0))) {
            return this.getElementAt(0);
        }
        this.removeElement(newElement);
        this.insertElementAt(newElement, 0);
        return newElement;
    }

    public void removeAllElements() {
        if (!this.elements.isEmpty()) {
            int firstIndex = 0;
            int lastIndex = this.elements.size() - 1;
            this.elements.clear();
            this.selected = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selected = null;
        }
    }

    public E findBestCandidate(String prefix) {
        return this.elements.stream().filter(o -> o.toString().startsWith(prefix)).min((x, y) -> x.toString().equals(prefix) ? -1 : (y.toString().equals(prefix) ? 1 : this.comparator.compare(x, y))).orElse(null);
    }

    public Preferences prefs(Function<String, E> readE, Function<E, String> writeE) {
        return new Preferences(readE, writeE);
    }

    public final class Preferences {
        private Function<String, E> readE;
        private Function<E, String> writeE;

        private Preferences(Function<String, E> readE, Function<E, String> writeE) {
            this.readE = readE;
            this.writeE = writeE;
        }

        public void load(String key) {
            AutoCompComboBoxModel.this.removeAllElements();
            AutoCompComboBoxModel.this.addAllElements(Config.getPref().getList(key), this.readE);
        }

        public void load(String key, List<String> defaults) {
            AutoCompComboBoxModel.this.removeAllElements();
            AutoCompComboBoxModel.this.addAllElements(Config.getPref().getList(key, defaults), this.readE);
        }

        public void load(ListProperty prop) {
            AutoCompComboBoxModel.this.removeAllElements();
            AutoCompComboBoxModel.this.addAllElements((Collection<String>)prop.get(), this.readE);
        }

        public List<String> asStringList() {
            ArrayList<String> list = new ArrayList<String>(AutoCompComboBoxModel.this.getSize());
            AutoCompComboBoxModel.this.forEach(element -> list.add(this.writeE.apply(element)));
            return list;
        }

        public void save(String key) {
            Config.getPref().putList(key, this.asStringList());
        }

        public void save(ListProperty prop) {
            prop.put(this.asStringList());
        }
    }
}

