/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionTableModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionTableRowSorter;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ChangesetDiscussionPanel
extends JPanel
implements PropertyChangeListener {
    private final UpdateChangesetDiscussionAction actUpdateChangesets = new UpdateChangesetDiscussionAction();
    private final AddChangesetCommentAction actAddChangesetComment = new AddChangesetCommentAction();
    private final ChangesetDiscussionTableModel model = new ChangesetDiscussionTableModel();
    private JTable table;
    private transient Changeset current;

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.actUpdateChangesets);
        tb.add(this.actAddChangesetComment);
        this.initProperties();
        pnl.add(tb);
        return pnl;
    }

    void initProperties() {
        this.actUpdateChangesets.initProperties(this.current);
        this.actAddChangesetComment.initProperties(this.current);
    }

    public ChangesetDiscussionPanel() {
        this.build();
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.current = cs;
        if (cs == null) {
            this.clearView();
        } else {
            this.updateView(cs);
        }
        this.initProperties();
        if (cs != null && cs.getDiscussion().size() < cs.getCommentsCount()) {
            this.actUpdateChangesets.actionPerformed(null);
        }
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add(this.buildDiscussionPanel(), "Center");
    }

    private Component buildDiscussionPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.table = new JTable(this.model, new ChangesetDiscussionTableColumnModel());
        this.table.setRowSorter(new ChangesetDiscussionTableRowSorter(this.model));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(2).addPropertyChangeListener(evt -> {
            if ("width".equals(evt.getPropertyName())) {
                this.updateRowHeights();
            }
        });
        pnl.add((Component)new JScrollPane(this.table), "Center");
        return pnl;
    }

    protected void clearView() {
        this.model.populate(null);
    }

    protected void updateView(Changeset cs) {
        this.model.populate(cs.getDiscussion());
        this.updateRowHeights();
    }

    protected void updateRowHeights() {
        int intercellWidth = this.table.getIntercellSpacing().width;
        int colWidth = this.table.getColumnModel().getColumn(2).getWidth();
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            int rowHeight = this.table.getRowHeight();
            Component comp = this.table.prepareRenderer(this.table.getCellRenderer(row, 2), row, 2);
            comp.setBounds(new Rectangle(0, 0, colWidth - intercellWidth, Integer.MAX_VALUE));
            rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            this.table.setRowHeight(row, rowHeight);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.setCurrentChangeset((Changeset)evt.getNewValue());
    }

    class UpdateChangesetDiscussionAction
    extends AbstractAction {
        UpdateChangesetDiscussionAction() {
            this.putValue("Name", I18n.tr("Update changeset discussion", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Update the changeset discussion from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDiscussionPanel.this.current == null) {
                return;
            }
            ChangesetHeaderDownloadTask task = new ChangesetHeaderDownloadTask(ChangesetDiscussionPanel.this, Collections.singleton(ChangesetDiscussionPanel.this.current.getId()), true);
            MainApplication.worker.submit(new PostDownloadHandler(task, task.download()));
        }

        void initProperties(Changeset cs) {
            this.setEnabled(cs != null && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }

    class AddChangesetCommentAction
    extends AbstractAction {
        AddChangesetCommentAction() {
            this.putValue("Name", I18n.tr("Comment", new Object[0]));
            new ImageProvider("dialogs/notes", "note_comment").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Add comment", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDiscussionPanel.this.current == null) {
                return;
            }
            NoteInputDialog dialog = new NoteInputDialog((Component)MainApplication.getMainFrame(), I18n.tr("Comment on changeset", new Object[0]), I18n.tr("Add comment", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Add comment to changeset:", new Object[0]), ImageProvider.get("dialogs/notes", "note_comment"));
            if (dialog.getValue() != 1) {
                return;
            }
            try {
                OsmApi.getOsmApi().addCommentToChangeset(ChangesetDiscussionPanel.this.current, dialog.getInputText(), null);
                ChangesetDiscussionPanel.this.actUpdateChangesets.actionPerformed(null);
            }
            catch (IllegalArgumentException | OsmTransferException e) {
                Logging.error(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), ExceptionUtil.explainException(e), I18n.tr("Error", new Object[0]), 0);
            }
        }

        void initProperties(Changeset cs) {
            this.setEnabled(cs != null && !cs.isOpen() && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }
}

