/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ColorInfo;
import org.openstreetmap.josm.data.preferences.JosmBaseDirectories;
import org.openstreetmap.josm.data.preferences.PreferencesReader;
import org.openstreetmap.josm.data.preferences.PreferencesWriter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.spi.preferences.AbstractPreferences;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.DefaultPreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.IBaseDirectories;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.ReflectionUtils;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class Preferences
extends AbstractPreferences {
    private static final String[] OBSOLETE_PREF_KEYS = new String[]{"remotecontrol.https.enabled", "remotecontrol.https.port", "curves.circlearc.angle-separation", "update.selected.complete-relation"};
    private static final String[] OBSOLETE_PREF_KEYS_START = new String[]{"draw.rawgps.layer.wpt.", "draw.rawgps.layer.audiowpt.", "draw.rawgps.lines.force.", "draw.rawgps.lines.alpha-blend.", "draw.rawgps.lines.", "markers.show ", "marker.makeautomarker.", "clr.layer.", "draw.rawgps.colors", "draw.rawgps.direction", "draw.rawgps.alternatedirection", "draw.rawgps.linewidth", "draw.rawgps.max-line-length.local", "draw.rawgps.max-line-length", "draw.rawgps.large", "draw.rawgps.large.size", "draw.rawgps.hdopcircle", "draw.rawgps.min-arrow-distance", "draw.rawgps.colorTracksTune", "draw.rawgps.colors.dynamic", "draw.rawgps.lines.local", "draw.rawgps.heatmap"};
    private static final List<String> KEEP_PREF_KEYS = Arrays.asList("draw.rawgps.lines.alpha-blend", "draw.rawgps.lines.arrows", "draw.rawgps.lines.arrows.fast", "draw.rawgps.lines.arrows.min-distance", "draw.rawgps.lines.force", "draw.rawgps.lines.max-length", "draw.rawgps.lines.max-length.local", "draw.rawgps.lines.width");
    private static final Map<String, String> UPDATE_PREF_KEYS = Preferences.getUpdatePrefKeys();
    private static final long MAX_AGE_DEFAULT_PREFERENCES = TimeUnit.DAYS.toSeconds(50L);
    private final IBaseDirectories dirs;
    boolean modifiedDefault;
    private boolean saveOnPut = true;
    protected final SortedMap<String, Setting<?>> settingsMap = new TreeMap();
    protected final SortedMap<String, Setting<?>> defaultsMap = new TreeMap();
    protected boolean initSuccessful;
    private final ListenerList<PreferenceChangedListener> listeners = ListenerList.create();
    private final HashMap<String, ListenerList<PreferenceChangedListener>> keyListeners = new HashMap();
    private static final Preferences defaultInstance = new Preferences(JosmBaseDirectories.getInstance());
    private static final Collection<Class<?>> preferencesClasses = Arrays.asList(Preferences.class, PreferencesUtils.class, AbstractPreferences.class);

    private static Map<String, String> getUpdatePrefKeys() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("draw.rawgps.direction", "draw.rawgps.lines.arrows");
        m.put("draw.rawgps.alternatedirection", "draw.rawgps.lines.arrows.fast");
        m.put("draw.rawgps.min-arrow-distance", "draw.rawgps.lines.arrows.min-distance");
        m.put("draw.rawgps.linewidth", "draw.rawgps.lines.width");
        m.put("draw.rawgps.max-line-length.local", "draw.rawgps.lines.max-length.local");
        m.put("draw.rawgps.max-line-length", "draw.rawgps.lines.max-length");
        m.put("draw.rawgps.large", "draw.rawgps.points.large");
        m.put("draw.rawgps.large.alpha", "draw.rawgps.points.large.alpha");
        m.put("draw.rawgps.large.size", "draw.rawgps.points.large.size");
        m.put("draw.rawgps.hdopcircle", "draw.rawgps.points.hdopcircle");
        m.put("draw.rawgps.layer.wpt.pattern", "draw.rawgps.markers.pattern");
        m.put("draw.rawgps.layer.audiowpt.pattern", "draw.rawgps.markers.audio.pattern");
        m.put("draw.rawgps.colors", "draw.rawgps.colormode");
        m.put("draw.rawgps.colorTracksTune", "draw.rawgps.colormode.velocity.tune");
        m.put("draw.rawgps.colors.dynamic", "draw.rawgps.colormode.dynamic-range");
        m.put("draw.rawgps.heatmap.line-extra", "draw.rawgps.colormode.heatmap.line-extra");
        m.put("draw.rawgps.heatmap.colormap", "draw.rawgps.colormode.heatmap.colormap");
        m.put("draw.rawgps.heatmap.use-points", "draw.rawgps.colormode.heatmap.use-points");
        m.put("draw.rawgps.heatmap.gain", "draw.rawgps.colormode.heatmap.gain");
        m.put("draw.rawgps.heatmap.lower-limit", "draw.rawgps.colormode.heatmap.lower-limit");
        m.put("draw.rawgps.date-coloring-min-dt", "draw.rawgps.colormode.time.min-distance");
        return Collections.unmodifiableMap(m);
    }

    public Preferences() {
        this.dirs = Config.getDirs();
    }

    public Preferences(IBaseDirectories dirs) {
        this.dirs = dirs;
    }

    public Preferences(Preferences pref) {
        this(pref.dirs);
        this.settingsMap.putAll(pref.settingsMap);
        this.defaultsMap.putAll(pref.defaultsMap);
    }

    public static Preferences main() {
        return defaultInstance;
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangedListener listener) {
        if (listener != null) {
            this.listeners.addListener(listener);
        }
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangedListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void addKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
        this.listenersForKey(key).addListener(listener);
    }

    public void addWeakKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
        this.listenersForKey(key).addWeakListener(listener);
    }

    private ListenerList<PreferenceChangedListener> listenersForKey(String key) {
        return this.keyListeners.computeIfAbsent(key, k -> ListenerList.create());
    }

    @Override
    public void removeKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
        Optional.ofNullable(this.keyListeners.get(key)).orElseThrow(() -> new IllegalArgumentException("There are no listeners registered for " + key)).removeListener(listener);
    }

    protected void firePreferenceChanged(String key, Setting<?> oldValue, Setting<?> newValue) {
        Class<?> source = ReflectionUtils.findCallerClass(preferencesClasses);
        DefaultPreferenceChangeEvent evt = new DefaultPreferenceChangeEvent(source != null ? source : this.getClass(), key, oldValue, newValue);
        this.listeners.fireEvent(listener -> listener.preferenceChanged(evt));
        ListenerList<PreferenceChangedListener> forKey = this.keyListeners.get(key);
        if (forKey != null) {
            forKey.fireEvent(listener -> listener.preferenceChanged(evt));
        }
    }

    public static String getJOSMDirectoryBaseName() {
        String name = Utils.getSystemProperty("josm.dir.name");
        if (name != null) {
            return name;
        }
        return "JOSM";
    }

    public IBaseDirectories getDirs() {
        return this.dirs;
    }

    public File getPreferenceFile() {
        return new File(this.dirs.getPreferencesDirectory(false), "preferences.xml");
    }

    public File getDefaultsCacheFile() {
        return new File(this.dirs.getCacheDirectory(true), "default_preferences.xml");
    }

    public File getPluginsDirectory() {
        return new File(this.dirs.getUserDataDirectory(false), "plugins");
    }

    private static void addPossibleResourceDir(Set<String> locations, String s) {
        if (s != null) {
            if (!s.endsWith(File.separator)) {
                s = s + File.separator;
            }
            locations.add(s);
        }
    }

    public static Collection<String> getAllPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        Preferences.addPossibleResourceDir(locations, Preferences.defaultInstance.dirs.getPreferencesDirectory(false).getPath());
        Preferences.addPossibleResourceDir(locations, Preferences.defaultInstance.dirs.getUserDataDirectory(false).getPath());
        Preferences.addPossibleResourceDir(locations, Utils.getSystemEnv("JOSM_RESOURCES"));
        Preferences.addPossibleResourceDir(locations, Utils.getSystemProperty("josm.resources"));
        locations.addAll(PlatformManager.getPlatform().getPossiblePreferenceDirs());
        return locations;
    }

    public synchronized Map<String, ColorInfo> getAllNamedColors() {
        TreeMap<String, ColorInfo> all = new TreeMap<String, ColorInfo>();
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            if (!e.getKey().startsWith("clr.")) continue;
            Utils.instanceOfAndCast(e.getValue(), ListSetting.class).map(AbstractSetting::getValue).map(lst -> ColorInfo.fromPref(lst, false)).ifPresent(info -> all.put((String)e.getKey(), (ColorInfo)info));
        }
        for (Map.Entry<String, Setting<?>> e : this.defaultsMap.entrySet()) {
            if (!e.getKey().startsWith("clr.")) continue;
            Utils.instanceOfAndCast(e.getValue(), ListSetting.class).map(AbstractSetting::getValue).map(lst -> ColorInfo.fromPref(lst, true)).ifPresent(infoDef -> {
                ColorInfo info = (ColorInfo)all.get(e.getKey());
                if (info == null) {
                    all.put((String)e.getKey(), (ColorInfo)infoDef);
                } else {
                    info.setDefaultValue(infoDef.getDefaultValue());
                }
            });
        }
        return all;
    }

    public synchronized void save() throws IOException {
        this.save(this.getPreferenceFile(), this.settingsMap.entrySet().stream().filter(e -> !((Setting)e.getValue()).equals(this.defaultsMap.get(e.getKey()))), false);
    }

    public synchronized void saveDefaults() throws IOException {
        this.save(this.getDefaultsCacheFile(), this.defaultsMap.entrySet().stream(), true);
    }

    protected void save(File prefFile, Stream<Map.Entry<String, Setting<?>>> settings, boolean defaults) throws IOException {
        if (!defaults) {
            this.putInt("josm.version", Version.getInstance().getVersion());
        }
        File backupFile = new File(prefFile + "_backup");
        if (this.initSuccessful && prefFile.exists() && prefFile.length() > 0L) {
            Utils.copyFile(prefFile, backupFile);
        }
        try (PreferencesWriter writer = new PreferencesWriter(new PrintWriter(new File(prefFile + "_tmp"), StandardCharsets.UTF_8.name()), false, defaults);){
            writer.write(settings);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        File tmpFile = new File(prefFile + "_tmp");
        Files.move(tmpFile.toPath(), prefFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Preferences.setCorrectPermissions(prefFile);
        Preferences.setCorrectPermissions(backupFile);
    }

    private static void setCorrectPermissions(File file) {
        if (!file.setReadable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-writable {0}", file.getAbsolutePath()));
        }
        if (!file.setExecutable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-executable {0}", file.getAbsolutePath()));
        }
        if (!file.setReadable(true, true) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(true, true) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file writable {0}", file.getAbsolutePath()));
        }
    }

    protected void load() throws IOException, SAXException, XMLStreamException {
        File pref = this.getPreferenceFile();
        PreferencesReader.validateXML(pref);
        PreferencesReader reader = new PreferencesReader(pref, false);
        reader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(reader.getSettings());
        this.removeAndUpdateObsolete(reader.getVersion());
    }

    protected void loadDefaults() throws IOException, XMLStreamException, SAXException {
        File def = this.getDefaultsCacheFile();
        PreferencesReader.validateXML(def);
        PreferencesReader reader = new PreferencesReader(def, true);
        reader.parse();
        this.defaultsMap.clear();
        long minTime = System.currentTimeMillis() / 1000L - MAX_AGE_DEFAULT_PREFERENCES;
        for (Map.Entry<String, Setting<?>> e : reader.getSettings().entrySet()) {
            if (e.getValue().getTime() < minTime) continue;
            this.defaultsMap.put(e.getKey(), e.getValue());
        }
    }

    public synchronized void fromXML(Reader in) throws XMLStreamException, IOException {
        PreferencesReader reader = new PreferencesReader(in, false);
        reader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(reader.getSettings());
    }

    public synchronized void init(boolean reset) {
        File preferenceFile;
        File prefDir;
        block26: {
            this.initSuccessful = false;
            prefDir = this.dirs.getPreferencesDirectory(false);
            if (prefDir.exists()) {
                if (!prefDir.isDirectory()) {
                    Logging.warn(I18n.tr("Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", prefDir.getAbsoluteFile()));
                    if (!GraphicsEnvironment.isHeadless()) {
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                    }
                    return;
                }
            } else if (!prefDir.mkdirs()) {
                Logging.warn(I18n.tr("Failed to initialize preferences. Failed to create missing preference directory: {0}", prefDir.getAbsoluteFile()));
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                }
                return;
            }
            preferenceFile = this.getPreferenceFile();
            try {
                if (!preferenceFile.exists()) {
                    Logging.info(I18n.tr("Missing preference file ''{0}''. Creating a default preference file.", preferenceFile.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                } else if (reset) {
                    File backupFile = new File(prefDir, "preferences.xml.bak");
                    PlatformManager.getPlatform().rename(preferenceFile, backupFile);
                    Logging.warn(I18n.tr("Replacing existing preference file ''{0}'' with default preference file.", preferenceFile.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                }
            }
            catch (IOException | InvalidPathException e) {
                Logging.error(e);
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                }
                return;
            }
            File def = this.getDefaultsCacheFile();
            if (def.exists()) {
                try {
                    this.loadDefaults();
                }
                catch (IOException | XMLStreamException | SAXException e) {
                    Logging.error(e);
                    Logging.warn(I18n.tr("Failed to load defaults cache file: {0}", def));
                    this.defaultsMap.clear();
                    if (def.delete()) break block26;
                    Logging.warn(I18n.tr("Failed to delete faulty defaults cache file: {0}", def));
                }
            }
        }
        File possiblyGoodBackupFile = new File(prefDir, "preferences.xml_backup");
        try {
            this.load();
            this.initSuccessful = true;
        }
        catch (IOException | XMLStreamException | SAXException e) {
            Logging.error(e);
            File backupFile = new File(prefDir, "preferences.xml.bak");
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and trying to read last good preference file <br>{1}<br>.</html>", backupFile.getAbsoluteFile(), possiblyGoodBackupFile.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            }
            PlatformManager.getPlatform().rename(preferenceFile, backupFile);
        }
        if (!this.initSuccessful) {
            try {
                if (possiblyGoodBackupFile.exists() && possiblyGoodBackupFile.length() > 0L) {
                    Utils.copyFile(possiblyGoodBackupFile, preferenceFile);
                }
                this.load();
                this.initSuccessful = true;
            }
            catch (IOException | XMLStreamException | SAXException e) {
                Logging.error(e);
                Logging.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
        if (!this.initSuccessful) {
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Preferences file had errors.<br> Creating a new default preference file.</html>", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                }
                this.resetToDefault();
                this.save();
            }
            catch (IOException e1) {
                Logging.error(e1);
                Logging.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public void resetToInitialState() {
        this.resetToDefault();
        this.saveOnPut = true;
        this.initSuccessful = false;
    }

    public final synchronized void resetToDefault() {
        this.settingsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean putSetting(String key, Setting<?> setting) {
        Setting settingOld;
        CheckParameterUtil.ensureParameterNotNull(key);
        if (setting != null && setting.getValue() == null) {
            throw new IllegalArgumentException("setting argument must not have null value");
        }
        Setting<?> settingCopy = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (setting == null) {
                settingOld = (Setting)this.settingsMap.remove(key);
                if (settingOld == null) {
                    return false;
                }
            } else {
                settingOld = (Setting)this.settingsMap.get(key);
                if (setting.equals(settingOld)) {
                    return false;
                }
                if (settingOld == null && setting.equals(this.defaultsMap.get(key))) {
                    return false;
                }
                settingCopy = setting.copy();
                this.settingsMap.put(key, settingCopy);
            }
            if (this.saveOnPut) {
                try {
                    this.save();
                }
                catch (IOException | InvalidPathException e) {
                    File file = this.getPreferenceFile();
                    try {
                        file = file.getAbsoluteFile();
                    }
                    catch (SecurityException ex) {
                        Logging.trace(ex);
                    }
                    Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to persist preferences to ''{0}''", file), e);
                }
            }
        }
        this.firePreferenceChanged(key, settingOld, settingCopy);
        return true;
    }

    public synchronized Setting<?> getSetting(String key, Setting<?> def) {
        return this.getSetting(key, def, Setting.class);
    }

    @Override
    public synchronized <T extends Setting<?>> T getSetting(String key, T def, Class<T> klass) {
        Setting prop;
        CheckParameterUtil.ensureParameterNotNull(key);
        CheckParameterUtil.ensureParameterNotNull(def);
        Setting oldDef = (Setting)this.defaultsMap.get(key);
        if (oldDef != null && oldDef.isNew() && oldDef.getValue() != null && def.getValue() != null && !def.equals(oldDef)) {
            Logging.info("Defaults for " + key + " differ: " + def + " != " + this.defaultsMap.get(key));
        }
        if (def.getValue() != null || oldDef == null) {
            Setting<?> defCopy = def.copy();
            defCopy.setTime(System.currentTimeMillis() / 1000L);
            defCopy.setNew(true);
            this.defaultsMap.put(key, defCopy);
        }
        if (klass.isInstance(prop = (Setting)this.settingsMap.get(key))) {
            return (T)prop;
        }
        return def;
    }

    @Override
    public Set<String> getKeySet() {
        return Collections.unmodifiableSet(this.settingsMap.keySet());
    }

    @Override
    public Map<String, Setting<?>> getAllSettings() {
        return new TreeMap(this.settingsMap);
    }

    public Map<String, Setting<?>> getAllDefaults() {
        return new TreeMap(this.defaultsMap);
    }

    public Collection<String> getPluginSites() {
        return this.getList("pluginmanager.sites", Collections.singletonList(Config.getUrls().getJOSMWebsite() + "/pluginicons%<?plugins=>"));
    }

    public Collection<String> getOnlinePluginSites() {
        ArrayList<String> pluginSites = new ArrayList<String>(this.getPluginSites());
        pluginSites.removeIf(NetworkManager::isOffline);
        return pluginSites;
    }

    public void setPluginSites(Collection<String> sites) {
        this.putList("pluginmanager.sites", new ArrayList<String>(sites));
    }

    public synchronized String toXML(boolean nopass) {
        return this.toXML(this.settingsMap.entrySet(), nopass, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toXML(Collection<Map.Entry<String, Setting<?>>> settings, boolean nopass, boolean defaults) {
        try (StringWriter sw = new StringWriter();){
            String string;
            try (PreferencesWriter prefWriter = new PreferencesWriter(new PrintWriter(sw), nopass, defaults);){
                prefWriter.write(settings);
                sw.flush();
                string = sw.toString();
            }
            return string;
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
    }

    private void removeAndUpdateObsolete(int loadedVersion) {
        Logging.trace("Update obsolete preference keys for version {0}", Integer.toString(loadedVersion));
        for (Map.Entry<String, String> e2 : UPDATE_PREF_KEYS.entrySet()) {
            String oldkey = e2.getKey();
            String newkey = e2.getValue();
            if (!this.settingsMap.containsKey(oldkey)) continue;
            Setting value = (Setting)this.settingsMap.remove(oldkey);
            this.settingsMap.putIfAbsent(newkey, value);
            Logging.info(I18n.tr("Updated preference setting {0} to {1}", oldkey, newkey));
        }
        Logging.trace("Remove obsolete preferences for version {0}", Integer.toString(loadedVersion));
        for (String key : OBSOLETE_PREF_KEYS) {
            if (this.settingsMap.containsKey(key)) {
                this.settingsMap.remove(key);
                Logging.info(I18n.tr("Removed preference setting {0} since it is no longer used", key));
            }
            if (!this.defaultsMap.containsKey(key)) continue;
            this.defaultsMap.remove(key);
            Logging.info(I18n.tr("Removed preference default {0} since it is no longer used", key));
            this.modifiedDefault = true;
        }
        for (String key : OBSOLETE_PREF_KEYS_START) {
            this.settingsMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(key)).collect(Collectors.toSet()).forEach(e -> {
                String k = (String)e.getKey();
                if (!KEEP_PREF_KEYS.contains(k)) {
                    this.settingsMap.remove(k);
                    Logging.info(I18n.tr("Removed preference setting {0} since it is no longer used", k));
                }
            });
            this.defaultsMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(key)).collect(Collectors.toSet()).forEach(e -> {
                String k = (String)e.getKey();
                if (!KEEP_PREF_KEYS.contains(k)) {
                    this.defaultsMap.remove(k);
                    Logging.info(I18n.tr("Removed preference default {0} since it is no longer used", k));
                    this.modifiedDefault = true;
                }
            });
        }
        if (!this.getBoolean("preferences.reset.draw.rawgps.lines")) {
            this.putBoolean("preferences.reset.draw.rawgps.lines", true);
            this.putInt("draw.rawgps.lines", -1);
        }
        if (this.modifiedDefault) {
            try {
                this.saveDefaults();
                Logging.info(I18n.tr("Saved updated default preferences.", new Object[0]));
            }
            catch (IOException ex) {
                Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to save default preferences.", new Object[0]), ex);
            }
            this.modifiedDefault = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableSaveOnPut(boolean enable) {
        Preferences preferences = this;
        synchronized (preferences) {
            this.saveOnPut = enable;
        }
    }
}

