/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public class UDPDiscoveryReceiver
implements Runnable,
IShutdownObserver {
    private static final Log log = LogManager.getLog(UDPDiscoveryReceiver.class);
    private final byte[] mBuffer = new byte[65536];
    private MulticastSocket mSocket;
    private static final int maxPoolSize = 2;
    private final ExecutorService pooledExecutor;
    private final AtomicInteger cnt = new AtomicInteger(0);
    private final UDPDiscoveryService service;
    private final InetAddress multicastAddress;
    private boolean shutdown = false;

    public UDPDiscoveryReceiver(UDPDiscoveryService service, String multicastInterfaceString, String multicastAddressString, int multicastPort) throws IOException {
        this.service = service;
        this.multicastAddress = InetAddress.getByName(multicastAddressString);
        this.pooledExecutor = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 2, 2, 0, PoolConfiguration.WhenBlockedPolicy.DISCARDOLDEST, 2), "JCS-UDPDiscoveryReceiver-", 1);
        log.info("Constructing listener, [{0}:{1}]", this.multicastAddress, multicastPort);
        this.createSocket(multicastInterfaceString, this.multicastAddress, multicastPort);
    }

    private void createSocket(String multicastInterfaceString, InetAddress multicastAddress, int multicastPort) throws IOException {
        try {
            this.mSocket = new MulticastSocket(multicastPort);
            if (log.isInfoEnabled()) {
                log.info("Joining Group: [{0}]", multicastAddress);
            }
            NetworkInterface multicastInterface = null;
            multicastInterface = multicastInterfaceString != null ? NetworkInterface.getByName(multicastInterfaceString) : HostNameUtil.getMulticastNetworkInterface();
            if (multicastInterface != null) {
                log.info("Using network interface {0}", multicastInterface.getDisplayName());
                this.mSocket.setNetworkInterface(multicastInterface);
            }
            this.mSocket.joinGroup(multicastAddress);
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [{0}:{1}]", multicastAddress, multicastPort, e);
            throw e;
        }
    }

    public Object waitForMessage() throws IOException {
        DatagramPacket packet = new DatagramPacket(this.mBuffer, this.mBuffer.length);
        Object obj = null;
        try {
            log.debug("Waiting for message.");
            this.mSocket.receive(packet);
            log.debug("Received packet from address [{0}]", () -> packet.getSocketAddress());
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(this.mBuffer, 0, packet.getLength());
                 ObjectInputStreamClassLoaderAware objectStream = new ObjectInputStreamClassLoaderAware(byteStream, null);){
                obj = objectStream.readObject();
            }
            if (obj instanceof UDPDiscoveryMessage) {
                UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
                msg.setHost(packet.getAddress().getHostAddress());
                log.debug("Read object from address [{0}], object=[{1}]", packet.getSocketAddress(), obj);
            }
        }
        catch (Exception e) {
            log.error("Error receiving multicast packet", e);
        }
        return obj;
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (!this.shutdown) {
                    Object obj = this.waitForMessage();
                    this.cnt.incrementAndGet();
                    log.debug("{0} messages received.", () -> this.getCnt());
                    UDPDiscoveryMessage message = null;
                    try {
                        message = (UDPDiscoveryMessage)obj;
                        if (message != null) {
                            MessageHandler handler = new MessageHandler(message);
                            this.pooledExecutor.execute(handler);
                            log.debug("Passed handler to executor.");
                            continue block6;
                        }
                        log.warn("message is null");
                        continue block6;
                    }
                    catch (ClassCastException cce) {
                        log.warn("Received unknown message type", cce.getMessage());
                    }
                }
                break;
            }
            catch (IOException e) {
                log.error("Unexpected exception in UDP receiver.", e);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (InterruptedException e2) {
                    log.error("Problem sleeping", e2);
                    break;
                }
            }
        }
    }

    public void setCnt(int cnt) {
        this.cnt.set(cnt);
    }

    public int getCnt() {
        return this.cnt.get();
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            try {
                this.shutdown = true;
                this.mSocket.leaveGroup(this.multicastAddress);
                this.mSocket.close();
                this.pooledExecutor.shutdownNow();
            }
            catch (IOException e) {
                log.error("Problem closing socket");
            }
        }
    }

    public class MessageHandler
    implements Runnable {
        private UDPDiscoveryMessage message = null;

        public MessageHandler(UDPDiscoveryMessage message) {
            this.message = message;
        }

        @Override
        public void run() {
            if (this.message.getRequesterId() == CacheInfo.listenerId) {
                log.debug("Ignoring message sent from self");
            } else {
                log.debug("Process message sent from another");
                log.debug("Message = {0}", this.message);
                if (this.message.getHost() == null || this.message.getCacheNames() == null || this.message.getCacheNames().isEmpty()) {
                    log.debug("Ignoring invalid message: {0}", this.message);
                } else {
                    this.processMessage();
                }
            }
        }

        private void processMessage() {
            DiscoveredService discoveredService = new DiscoveredService();
            discoveredService.setServiceAddress(this.message.getHost());
            discoveredService.setCacheNames(this.message.getCacheNames());
            discoveredService.setServicePort(this.message.getPort());
            discoveredService.setLastHearFromTime(System.currentTimeMillis());
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REQUEST) {
                log.debug("Message is a Request Broadcast, will have the service handle it.");
                UDPDiscoveryReceiver.this.service.serviceRequestBroadcast();
                return;
            }
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REMOVE) {
                log.debug("Removing service from set {0}", discoveredService);
                UDPDiscoveryReceiver.this.service.removeDiscoveredService(discoveredService);
            } else {
                UDPDiscoveryReceiver.this.service.addOrUpdateService(discoveredService);
            }
        }
    }
}

