ITK Release 2.8
===============

This release covers the period March 15, 2006 through May 30, 2006.

Schedule
--------

  Release Number                   Start Date     End Date
  -------------------------------- -------------- --------------
  Last period for adding classes   May 1 2006     May 12 2006
  Feature freeze                   May 12 2006    May 26 2006
  CVS Tagging                      May 27, 2006   May 27, 2006
  Testing tarballs                 May 28, 2006   May 29, 2006
  Posting tarballs                 May 29 2006    May 30 2006

Adoption of CMake 2.2.3
-----------------------

ITK 2.8 requires the use of CMake 2.2.3.

It is recommended that when moving into CMake 2.2 from CMake 2.0, the
developer should start with a fresh build process.

New Features in this Release
----------------------------

-   Concept Checking
-   Explicit Instantiation

New Classes in this Release
---------------------------

    Code/Algorithms/itkThresholdMaximumConnectedComponentsImageFilter

    Code/BasicFilters/itkSignedMaurerDistanceMapImageFilter

    Code/Common/itkXMLFilterWatcher

    Code/SpatialObject/itkContourSpatialObject
    Code/SpatialObject/itkContourSpatialObjectPoint
    Code/SpatialObject/itkMetaContourConverter

    Code/Review/CMakeLists.txt
    Code/Review/d1ma
    Code/Review/d1mach.f
    Code/Review/d9gmit
    Code/Review/d9gmit.f
    Code/Review/d9lgic
    Code/Review/d9lgic.f
    Code/Review/d9lgit
    Code/Review/d9lgit.f
    Code/Review/d9lgmc
    Code/Review/d9lgmc.f
    Code/Review/dbetai
    Code/Review/dbetai.f
    Code/Review/dcsevl
    Code/Review/dcsevl.f
    Code/Review/dgami
    Code/Review/dgami.f
    Code/Review/dgamit
    Code/Review/dgamit.f
    Code/Review/dgamlm
    Code/Review/dgamlm.f
    Code/Review/dgamma
    Code/Review/dgamma.f
    Code/Review/dgamr
    Code/Review/dgamr.f
    Code/Review/d_int
    Code/Review/dlbeta
    Code/Review/dlbeta.f
    Code/Review/dlgams
    Code/Review/dlgams.f
    Code/Review/dlngam
    Code/Review/dlngam.f
    Code/Review/dlnrel
    Code/Review/dlnrel.f
    Code/Review/d_mod
    Code/Review/initds
    Code/Review/initds.f
    Code/Review/itkChiSquareDistribution
    Code/Review/itkGaussianDistribution
    Code/Review/itkProbabilityDistribution
    Code/Review/itkTDistribution
    Code/Review/xermsg

New Tests in this Release
-------------------------

    Testing/Code/Common/itkDifferenceImageFilterTest
    Testing/Code/Common/itkZeroFluxBoundaryConditionTest

    Testing/Code/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest
    Testing/Code/BasicFilters/itkVectorIndexSelectionCastImageFilterTest

    Testing/Code/Algorithms/itkThresholdMaximumConnectedComponentsImageFilterTest

    Testing/Code/Review/CMakeLists.txt
    Testing/Code/Review/itkChiSquareDistributionTest
    Testing/Code/Review/itkGaussianDistributionTest
    Testing/Code/Review/itkReviewHeaderTest
    Testing/Code/Review/itkReviewPrintTest
    Testing/Code/Review/itkReviewTests
    Testing/Code/Review/itkTDistributionTest

New Examples in this Release
----------------------------


    Examples/IO/ImageReadDicomSeriesWrite

    Examples/Registration/ModelToImageRegistration2

New Utilities in this Release
-----------------------------

    Utilities/Dart/BuildContinuousWithCTest.bat.in
    Utilities/Dart/BuildContinuousWithCTest.sh.in
    Utilities/KWStyle/ITKHeader
    Utilities/KWStyle/ITK.kws.xml.in
    Utilities/KWStyle/ITKOverwrite.txt
    Utilities/kwsys/auto_ptr.hxx.in
    Utilities/kwsys/DynamicLoader
    Utilities/kwsys/DynamicLoader.hxx.in
    Utilities/kwsys/Terminal
    Utilities/kwsys/Terminal.h.in
    Utilities/kwsys/testDynamicLoader
    Utilities/kwsys/testDynload
    Utilities/kwsys/testTerminal
    Utilities/MetaIO/metaContour
    Utilities/MetaIO/tests/testMeta10Contour

Changes in this Release
-----------------------


    CMakeLists.txt
        ENH: Updating the MINOR VERSION Number in preparation for release of ITK 2.8.
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.
        ENH: Borland compiler flags must now be set to prevent too many warnings. Ths is due to a CMake change in default flags for Borland.
        BUG: No quotes
        ENH: Forcing Concept checking to be always disabled for the Borland compiler.
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.
        ENH: Moving minor number to "7" after tagging for release ITK 2.6.

    ITKConfig.cmake.in
        ENH: Specify ITK_GDCM_DIR and ITK_USE_SYSTEM_GDCM in the export configuration so that projects using ITK know about it

    UseITK.cmake.in
        ENH: Allow ITK to be built against an installed version of GDCM with the ITK_USE_SYSTEM_GDCM option

    itkConfigure.h.in
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    itkGenerateITKConfig.cmake
        ENH: Allow ITK to be built against an installed version of GDCM with the ITK_USE_SYSTEM_GDCM option

    itkIncludeDirectories.cmake
        ENH: Do not add GDCM to the build tree if its ITK_USE_SYSTEM_GDCM is on

    CMake/CheckCPPDirective.cmake
        ENH: Allow ITK to be built against an installed version of GDCM with the ITK_USE_SYSTEM_GDCM option

    CMake/Attic/FindGDCM.cmake
        ENH: Remove confusing script that was written at the time where GDCM was build using autotools...

    Code/CMakeLists.txt

    Code/Algorithms/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/Algorithms/itkAntiAliasBinaryImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkBalloonForceFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkBayesianClassifierImageFilter

    Code/Algorithms/itkBayesianClassifierInitializationImageFilter

    Code/Algorithms/itkBinaryMask3DMeshSource
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkBinaryMedialNodeMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkBinaryMinMaxCurvatureFlowImageFilter
        ENH: adding concept-checking

    Code/Algorithms/itkBinaryPruningImageFilter
        STYLE: Updated filter description
        ENH: adding concept-checking

    Code/Algorithms/itkBinaryThinningImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkBioCell
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkBioGenome
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkCannySegmentationLevelSetFunction

    Code/Algorithms/itkCannySegmentationLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkCollidingFrontsImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkCorrelationCoefficientHistogramImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkCurvatureFlowImageFilter
        ENH: adding concept-checking

    Code/Algorithms/itkCurvatureRegistrationFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkCurvesLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkDeformableMesh3DFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkDeformableSimplexMesh3DBalloonForceFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkDeformableSimplexMesh3DFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkDeformableSimplexMesh3DGradientConstraintForceFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkEuclideanDistancePointMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkExtensionVelocitiesImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkFEMFiniteDifferenceFunctionLoad
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkFEMRegistrationFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkFastChamferDistanceImageFilter
        COMP: fixing a compile error

    Code/Algorithms/itkFastChamferDistanceImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkFastMarchingExtensionImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkFastMarchingImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkFastMarchingUpwindGradientImageFilter
        BUG: Fixed the TargetReached modes of the algorithm

    Code/Algorithms/itkFastMarchingUpwindGradientImageFilter
        BUG: Fixed the TargetReached modes of the algorithm

    Code/Algorithms/itkGradientVectorFlowImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkHistogramMatchingImageFilter
        ENH: adding concept-checking

    Code/Algorithms/itkImageKmeansModelEstimator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkImageToSpatialObjectMetric

    Code/Algorithms/itkImageToSpatialObjectMetr

    Code/Algorithms/itkImageToSpatialObjectRegistrationMethod

    Code/Algorithms/itkImageToSpatialObjectRegistrationMethod

    Code/Algorithms/itkIsoContourDistanceImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkIsoContourDistanceImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkIsolatedWatershedImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkKLMRegionGrowImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkKullbackLeiblerCompareHistogramImageToImageMetric
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkKullbackLeiblerCompareHistogramImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkLabelVotingImageFilter
        BUG: missing InputImageDimension.

    Code/Algorithms/itkMIRegistrationFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMRFImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkMRIBiasFieldCorrectionFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMRIBiasFieldCorrectionFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMattesMutualInformationImageToImageMetr
        BUG: Stop looking for points if using an image mask if we try 10 times more than the requested number (helps with mistakes using empty mask images)

    Code/Algorithms/itkMeanReciprocalSquareDifferencePointSetToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMeanSquareRegistrationFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMeanSquaresImageToImageMetric
        ENH: adding concept checking to a metric as an example

    Code/Algorithms/itkMinMaxCurvatureFlowFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMinMaxCurvatureFlowImageFilter

    Code/Algorithms/itkMultiResolutionImageRegistrationMethod
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMultiResolutionPyramidImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkMultiResolutionPyramidImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMutualInformationHistogramImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkMutualInformationImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkNCCRegistrationFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkNarrowBandCurvesLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkNarrowBandLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkNarrowBandThresholdSegmentationLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkNormalizedCorrelationImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkNormalizedCorrelationPointSetToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkNormalizedMutualInformationHistogramImageToImageMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkOtsuMultipleThresholdsImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkOtsuMultipleThresholdsImageFilter
        BUG: 2786. Adding types for managing thresholds expressed in RealType.

    Code/Algorithms/itkOtsuThresholdImageCalculator
        ENH: Added Region to calculator.

    Code/Algorithms/itkOtsuThresholdImageCalculator
        ENH: Added Region to calculator.

    Code/Algorithms/itkOtsuThresholdImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkRayCastInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkRecursiveMultiResolutionPyramidImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkReinitializeLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkSTAPLEImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkScalarImageKmeansImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkSegmentationLevelSetImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkSimplexMeshVolumeCalculator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkThresholdMaximumConnectedComponentsImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Code/Algorithms/itkThresholdMaximumConnectedComponentsImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Code/Algorithms/itkThresholdSegmentationLevelSetFunction
        STYLE: Cleaned up comments

    Code/Algorithms/itkUnaryMedialNodeMetr
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVectorThresholdSegmentationLevelSetFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVnlFFTComplexConjugateToRealImageFilter

    Code/Algorithms/itkVoronoiDiagram2DGenerator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVoronoiPartitioningImageFilter
        ENH: adding concept checking

    Code/Algorithms/itkVoronoiPartitioningImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVoronoiSegmentationImageFilter
        COMP: fixing compiler warnings

    Code/Algorithms/itkVoronoiSegmentationImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVoronoiSegmentationImageFilterBase
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkVoronoiSegmentationRGBImageFilter
        COMP: fixing compiler warnings

    Code/Algorithms/itkVoronoiSegmentationRGBImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Algorithms/itkWatershedImageFilter

    Code/Algorithms/itkWatershedSegmenter
        STYLE: Equations specified incorrectly

    Code/BasicFilters/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/BasicFilters/itkAbsImageFilter
        BUG: Signed concept is not required for AbsImageFilter
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    Code/BasicFilters/itkAbsoluteValueDifferenceImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkAccumulateImageFilter
        ENH: adding concept-checking
        ENH: adding more concept checking

    Code/BasicFilters/itkAcosImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkAdaptImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkAdaptiveHistogramEqualizationImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkAddImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkAndImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkAnisotropicDiffusionImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkApproximateSignedDistanceMapImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkAsinImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkAtan2ImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkAtanImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBSplineCenteredResampleImageFilterBase
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBSplineDecompositionImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkBSplineDecompositionImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBSplineDownsampleImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkBSplineDownsampleImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBSplineInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBSplineUpsampleImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkBSplineUpsampleImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBilateralImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkBilateralImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBinaryFunctorImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkBinaryMagnitudeImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBinaryMaskToNarrowBandPointSetFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBinaryMedianImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkBinaryMorphologyImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkBinaryThresholdImageFilter
        ENH: More verbose documentation
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    Code/BasicFilters/itkBinomialBlurImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkBloxBoundaryPointImageToBloxBoundaryProfileImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkBloxBoundaryPointImageToBloxBoundaryProfileImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkBoundedReciprocalImageFilter
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    Code/BasicFilters/itkCannyEdgeDetectionImageFilter
        ENH: checking for SameDimension and IsFloatingPoint concepts

    Code/BasicFilters/itkCastImageFilter
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    Code/BasicFilters/itkChangeLabelImageFilter
        ENH: begin introducing concept checking; introducing ITK_USE_CONCEPT_CHECKING CMake variable to determine whether concept checking is used

    Code/BasicFilters/itkClosingByReconstructionImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkComplexToImaginaryImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkComplexToModulusImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkComplexToPhaseImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkComplexToRealImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkCompose2DCovariantVectorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkCompose2DVectorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkCompose3DCovariantVectorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkCompose3DVectorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConfidenceConnectedImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConfidenceConnectedImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkConnectedComponentFunctorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConnectedThresholdImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConstantPadImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConstrainedValueAdditionImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkConstrainedValueDifferenceImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkContourDirectedMeanDistanceImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkContourMeanDistanceImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkCosImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkCropImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkCurvatureAnisotropicDiffusionImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDanielssonDistanceMapImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDerivativeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDifferenceOfGaussiansGradientImageFilter
        COMP: fixing compiler errors shown on cygwin

    Code/BasicFilters/itkDiffusionTensor3DReconstructionImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDilateObjectMorphologyImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDirectedHausdorffDistanceImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDiscreteGaussianImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDivideImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkDoubleThresholdImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkEdgePotentialImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkEigenAnalysis2DImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkEigenAnalysis2DImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkErodeObjectMorphologyImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkExpImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkExpNegativeImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkExpandImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkExpandImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkExtractImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientAnisotropicDiffusionImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientImageToBloxBoundaryPointImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkGradientMagnitudeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientMagnitudeRecursiveGaussianImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientNDAnisotropicDiffusionFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkGradientRecursiveGaussianImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGradientToMagnitudeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleConnectedClosingImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleConnectedOpeningImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleDilateImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleErodeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleFillholeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleFunctionDilateImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleFunctionErodeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleGeodesicDilateImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleGeodesicErodeImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleGrindPeakImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleMorphologicalClosingImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkGrayscaleMorphologicalOpeningImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHConcaveImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHConvexImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHMaximaImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHMinimaImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHardConnectedComponentImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHausdorffDistanceImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHessian3DToVesselnessMeasureImageFilter
        COMP: need StaticConstMacro for Borland.

    Code/BasicFilters/itkHessian3DToVesselnessMeasureImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkHessianRecursiveGaussianImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkHoughTransform2DCirclesImageFilter
        COMP: fixing compiler errors shown on cygwin

    Code/BasicFilters/itkHoughTransform2DCirclesImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkHoughTransform2DLinesImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkHoughTransform2DLinesImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkIntensityWindowingImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkInterpolateImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkInterpolateImagePointsFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkInverseDeformationFieldImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkInvertIntensityImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkIsolatedConnectedImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkIsolatedConnectedImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkJoinImageFilter
        COMP: missing typenames.

    Code/BasicFilters/itkJoinSeriesImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkLabelStatisticsImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkLabelStatisticsImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkLaplacianImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkLog10ImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkLogImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkMaskImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkMaskNegatedImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkMaskNeighborhoodOperatorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMatrixIndexSelectionImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMaximumImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMeanImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMedianImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkMinimumImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMinimumMaximumImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMirrorPadImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkModulusImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMorphologicalGradientImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkMultiplyImageFilter

    Code/BasicFilters/itkNaryAddImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkNaryFunctorImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkNaryMaximumImageFilter
        ENH: adding more concept checking

    Code/BasicFilters/itkNeighborhoodConnectedImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkNeighborhoodOperatorImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkNoiseImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkNonThreadedShrinkImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkNonThreadedShrinkImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkNormalizedCorrelationImageFilter
        COMP: fixing compilation error

    Code/BasicFilters/itkNormalizedCorrelationImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkNotImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkObjectMorphologyImageFilter
        COMP: fixing a typo that was causing a compiler error on the dashboard

    Code/BasicFilters/itkObjectMorphologyImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkOpeningByReconstructionImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkOrImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkOrientImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkParallelSparseFieldLevelSetImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkPolylineMask2DImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkPolylineMaskImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkRGBToLuminanceImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkReconstructionByDilationImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkReconstructionByErosionImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkRecursiveGaussianImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkReflectImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkRegionOfInterestImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkRelabelComponentImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkResampleImageFilter
        BUG: #2672 fixed. m_OutputOrigin type was incorrect.
        ENH: more concept-checking

    Code/BasicFilters/itkResampleImageFilter

    Code/BasicFilters/itkRescaleIntensityImageFilter

    Code/BasicFilters/itkScalarConnectedComponentImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkScalarToArrayCastImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkShiftScaleImageFilter

    Code/BasicFilters/itkShiftScaleInPlaceImageFilter

    Code/BasicFilters/itkShrinkImageFilter
        ENH: adding more concept-checking

    Code/BasicFilters/itkShrinkImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkSigmoidImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkSignedDanielssonDistanceMapImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSignedMaurerDistanceMapImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Code/BasicFilters/itkSignedMaurerDistanceMapImageFilter
        BUG: renamed functor to avoid conflict.

    Code/BasicFilters/itkSimilarityIndexImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSimpleContourExtractorImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSinImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkSmoothingRecursiveGaussianImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSobelEdgeDetectionImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSparseFieldFourthOrderLevelSetImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkSparseFieldLevelSetImageFilter
        STYLE: Cleaned up comments
        ENH: adding more concept-checking

    Code/BasicFilters/itkSparseFieldLevelSetImageFilter
        STYLE: Cleaned up comments

    Code/BasicFilters/itkSqrtImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkSquareImageFilter

    Code/BasicFilters/itkSquaredDifferenceImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkStatisticsImageFilter
        ENH: more concept-checking

    Code/BasicFilters/itkStatisticsImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkStreamingImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkSubtractImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkSymmetricEigenAnalysisImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkTanImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkTensorFractionalAnisotropyImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkTensorRelativeAnisotropyImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkTernaryFunctorImageFilter
        COMP: fixing a typo that was causing a compiler error on the dashboard

    Code/BasicFilters/itkTernaryMagnitudeImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkThresholdImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkThresholdLabelerImageFilter
        ENH: adding concept checking
        ENH: adding concept-checking
        BUG: 2786. Adding types for managing thresholds expressed in RealType.

    Code/BasicFilters/itkThresholdLabelerImageFilter
        BUG: 2786. Adding types for managing thresholds expressed in RealType.

    Code/BasicFilters/itkTileImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkTobogganImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkTwoOutputExampleImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorCastImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorConfidenceConnectedImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorConnectedComponentImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorCurvatureAnisotropicDiffusionImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorExpandImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorExpandImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkVectorGradientAnisotropicDiffusionImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorGradientMagnitudeImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorGradientMagnitudeImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkVectorIndexSelectionCastImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorNeighborhoodOperatorImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorResampleImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorResampleImageFilter
        COMP: Set threads to 1 if Borland.

    Code/BasicFilters/itkVectorRescaleIntensityImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVectorRescaleIntensityImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/BasicFilters/itkVotingBinaryHoleFillingImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkVotingBinaryImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkWarpImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkWarpVectorImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkWeightedAddImageFilter

    Code/BasicFilters/itkWhiteTopHatImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkWrapPadImageFilter
        ENH: adding concept-checking

    Code/BasicFilters/itkXorImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkZeroCrossingBasedEdgeDetectionImageFilter
        ENH: adding concept checking

    Code/BasicFilters/itkZeroCrossingImageFilter
        ENH: adding concept checking

    Code/Common/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkAbsImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).
        STYLE: fixed style

    Code/Common/itkAcosImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkAddImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkAddPixelAccessor
        STYLE: fixed style

    Code/Common/itkAffineTransform
        ENH: Explicit Instantiation Support
        STYLE: Fixed style
        STYLE: fixed style

    Code/Common/itkAffineTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkAnnulusOperator
        STYLE: Fixed style

    Code/Common/itkAnnulusOperator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkArray
        STYLE: fixed style

    Code/Common/itkArray
        STYLE: fixed style

    Code/Common/itkArray2D
        STYLE: fixed style

    Code/Common/itkAsinImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkAtanImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkAutoPointer
        STYLE: Fixed style

    Code/Common/itkAutoPointerDataObjectDecorator
        STYLE: fixed style

    Code/Common/itkAutoPointerDataObjectDecorator
        STYLE: fixed style

    Code/Common/itkAzimuthElevationToCartesianTransform
        STYLE: indentation.
        STYLE: Fixed style

    Code/Common/itkAzimuthElevationToCartesianTransform
        STYLE: Fixed style
        STYLE: fixed style

    Code/Common/itkBSplineDeformableTransform
        STYLE: Fixed style

    Code/Common/itkBSplineDeformableTransform
        STYLE: line length and indentation.
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkBSplineDerivativeKernelFunction
        STYLE: Fixed style

    Code/Common/itkBSplineInterpolationWeightFunction
        STYLE: Fixed style

    Code/Common/itkBSplineInterpolationWeightFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkBSplineKernelFunction
        STYLE: Fixed style

    Code/Common/itkBackwardDifferenceOperator
        STYLE: Fixed style

    Code/Common/itkBackwardDifferenceOperator
        STYLE: Fixed style

    Code/Common/itkBarrier
        STYLE: Fixed style

    Code/Common/itkBarrier
        STYLE: Fixed style

    Code/Common/itkBinaryBallStructuringElement
        STYLE: Fixed style

    Code/Common/itkBinaryBallStructuringElement
        STYLE: Fixed style

    Code/Common/itkBinaryCrossStructuringElement
        STYLE: Fixed style

    Code/Common/itkBinaryCrossStructuringElement
        STYLE: Fixed style

    Code/Common/itkBinaryThresholdImageFunction
        STYLE: Fixed style

    Code/Common/itkBinaryThresholdSpatialFunction
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryPointImage
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryPointImage
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryPointItem
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryPointItem
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryPointPixel
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfileImage
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfileImage
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfileItem
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfileItem
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfilePixel
        STYLE: Fixed style

    Code/Common/itkBloxBoundaryProfilePixel
        STYLE: Fixed style

    Code/Common/itkBloxCoreAtomImage
        COMP: Fixing template parameter

    Code/Common/itkBloxCoreAtomImage
        COMP: Fixing template parameter
        STYLE: Fixed style

    Code/Common/itkBloxCoreAtomPixel
        STYLE: Fixed style

    Code/Common/itkBloxCoreAtomPixel
        STYLE: Fixed style

    Code/Common/itkBloxImage
        STYLE: Fixed style

    Code/Common/itkBloxItem
        STYLE: Fixed style

    Code/Common/itkBloxPixel
        STYLE: Fixed style

    Code/Common/itkBluePixelAccessor
        STYLE: Fixed style

    Code/Common/itkBoundingBox
        STYLE: Fixed style

    Code/Common/itkBoundingBox
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkByteSwapper
        STYLE: Fixed style

    Code/Common/itkByteSwapper
        STYLE: Fixed style

    Code/Common/itkCellInterface
        STYLE: Fixed style

    Code/Common/itkCellInterface
        STYLE: Fixed style

    Code/Common/itkCellInterfaceVisitor
        STYLE: Fixed style

    Code/Common/itkCenteredAffineTransform
        STYLE: Fixed style

    Code/Common/itkCenteredAffineTransform
        STYLE: Fixed style

    Code/Common/itkCenteredEuler3DTransform
        STYLE: Fixed style

    Code/Common/itkCenteredEuler3DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkCenteredRigid2DTransform
        STYLE: Fixed style

    Code/Common/itkCenteredRigid2DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkCenteredSimilarity2DTransform
        STYLE: Fixed style

    Code/Common/itkCenteredSimilarity2DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkCenteredTransformInitializer
        STYLE: Fixed style

    Code/Common/itkCenteredTransformInitializer
        STYLE: Fixed style

    Code/Common/itkCenteredVersorTransformInitializer
        STYLE: Fixed style

    Code/Common/itkCenteredVersorTransformInitializer
        STYLE: Fixed style

    Code/Common/itkCentralDifferenceImageFunction
        STYLE: Fixed style

    Code/Common/itkCentralDifferenceImageFunction
        STYLE: Fixed style

    Code/Common/itkChainCodePath
        STYLE: Fixed style

    Code/Common/itkChainCodePa
        STYLE: Fixed style

    Code/Common/itkChainCodePath2D
        STYLE: Fixed style

    Code/Common/itkChainCodePath2D
        STYLE: Fixed style

    Code/Common/itkChildTreeIterator
        STYLE: Fixed style

    Code/Common/itkColorTable
        STYLE: Fixed style

    Code/Common/itkColorTable
        STYLE: Fixed style

    Code/Common/itkCommand
        STYLE: Fixed style

    Code/Common/itkComplexToImaginaryImageAdaptor
        STYLE: Fixed style

    Code/Common/itkComplexToModulusImageAdaptor
        STYLE: indentation.
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkComplexToPhaseImageAdaptor
        STYLE: Fixed style
        STYLE: Fixed style

    Code/Common/itkComplexToRealImageAdaptor
        STYLE: Fixed style

    Code/Common/itkConceptChecking
        COMP: fixing dashboard warnings about assignment between different types
        COMP: fixing typo
        ENH: adding a comment about why the argument to sizeof is not enclosed in ()'s
        COMP: #include for PixelTraits was missing.
        ENH: adding new concepts; modify some existing ones to accept multiple types

    Code/Common/itkConditionVariable
        STYLE: Fixed style

    Code/Common/itkConditionVariable
        STYLE: Fixed style

    Code/Common/itkConditionalConstIterator
        STYLE: Fixed style

    Code/Common/itkConditionalConstIterator
        STYLE: Fixed style

    Code/Common/itkConicShellInteriorExteriorSpatialFunction
        STYLE: Fixed style

    Code/Common/itkConicShellInteriorExteriorSpatialFunction
        STYLE: Fixed style

    Code/Common/itkConstNeighborhoodIterator
        STYLE: Fixed style

    Code/Common/itkConstNeighborhoodIterator
        STYLE: Fixed style

    Code/Common/itkConstShapedNeighborhoodIterator
        STYLE: Fixed style

    Code/Common/itkConstShapedNeighborhoodIterator
        STYLE: long lines.
        STYLE: Fixed style

    Code/Common/itkConstSliceIterator
        STYLE: Fixed style

    Code/Common/itkConstantBoundaryCondition
        BUG: #3151. Boundary conditions could access unactivated indices in shaped iterators."

    Code/Common/itkContinuousIndex
        STYLE: Fixed style

    Code/Common/itkCoreAtomImageToDistanceMatrixProcess
        STYLE: Fixed style

    Code/Common/itkCoreAtomImageToDistanceMatrixProcess
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkCorrespondenceDataStructure
        STYLE: Fixed style

    Code/Common/itkCorrespondenceDataStructureIterator
        STYLE: Fixed style

    Code/Common/itkCorrespondenceDataStructureIterator
        STYLE: Fixed style

    Code/Common/itkCorrespondingMedialNodeClique
        STYLE: Fixed style

    Code/Common/itkCosImageAdaptor
        STYLE: Fixed style

    Code/Common/itkCovariantVector
        BUG: Fix for bug 3152: Headers for compound pixel types now #include the appropriate NumericTraits specialization headers.

    Code/Common/itkCovariantVector
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkCreateObjectFunction
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkDefaultDynamicMeshTraits
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkDenseFiniteDifferenceImageFilter
        STYLE: Cleaned up comments

    Code/Common/itkDifferenceImageFilter

    Code/Common/itkDifferenceImageFilter

    Code/Common/itkDiffusionTensor3D
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkDirectory
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkDirectory
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkDynamicLoader
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkElasticBodyReciprocalSplineKernelTransform
        BUG: incorrect type macro

    Code/Common/itkEllipsoidInteriorExteriorSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkEquivalencyTable
        STYLE: spacing.

    Code/Common/itkEquivalencyTable
        STYLE: spacing.

    Code/Common/itkEuler3DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkExpImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkExpNegativeImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/Attic/itkExplicitInstantiations
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkFastMutexLock
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkFiniteCylinderSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkFixedArray
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkFixedArray
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkFloodFilledFunctionConditionalConstIterator
        STYLE: various.

    Code/Common/itkFloodFilledFunctionConditionalConstIterator
        STYLE: various.

    Code/Common/itkFloodFilledImageFunctionConditionalConstIterator
        STYLE: various.

    Code/Common/itkFloodFilledImageFunctionConditionalConstIterator
        STYLE: various.

    Code/Common/itkFloodFilledSpatialFunctionConditionalConstIterator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkFourierSeriesPa
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkFrustumSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkGaussianDerivativeSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkGaussianKernelFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkGaussianOperator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkGaussianSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkHexahedronCell

    Code/Common/itkHexahedronCell

    Code/Common/itkImage
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkImage
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkImageAdaptor
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkImageBase
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkImageBase
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkImageBoundaryCondition
        BUG: #3151. Boundary conditions could access unactivated indices in shaped iterators."

    Code/Common/itkImageFunction
        STYLE: spelling error.

    Code/Common/itkImageRegion
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkImageRegion
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkImageRegionMultidimensionalSplitter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkImageSource
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkImageToImageFilter
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkImportImageContainer
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/itkImportImageContainer
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkIndex
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkLandmarkBasedTransformInitializer
        ENH: Remove annoying warning macro. Not reason enough to throw a warning

    Code/Common/itkLevelSetFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkLightObject
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkLineConstIterator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkLinearInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkLog10ImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkLogImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkMacro
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkMahalanobisDistanceThresholdImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkMapContainer

    Code/Common/itkMapContainer

    Code/Common/itkMetaDataDictionary
        PERF: switch to using itk_hash_map

    Code/Common/itkMetaDataDictionary
        BUG: switching to itk_hash_map results in an api change (no operator->()). unrolling change.

    Code/Common/itkMetaDataObject
        PERF: Bypass the factory mechanism for MetaDataObject

    Code/Common/itkNumericTraits
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkNumericTraitsRGBPixel
        COMP: WrapITK requires numeric traits for itk::RGB_Pixel<unsigned short>

    Code/Common/itkNumericTraitsRGBPixel
        COMP: WrapITK requires numeric traits for itk::RGB_Pixel<unsigned short>

    Code/Common/itkNumericTraitsVectorPixel
        BUG: typo

    Code/Common/itkObject
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkObject
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkObjectFactoryBase
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkObjectFactoryBase
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkOrientedImage
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkPeriodicBoundaryCondition
        STYLE: removed debug statements.

    Code/Common/itkPhasedArray3DSpecialCoordinatesImage
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkPoint
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkPointLocator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkQuaternionRigidTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkRGBPixel
        BUG: Fix for bug 3152: Headers for compound pixel types now #include the appropriate NumericTraits specialization headers.

    Code/Common/itkRealTimeClock
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkRigid2DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkRigid3DPerspectiveTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkScaleLogarithmicTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkScaleSkewVersor3DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkSimilarity2DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkSimilarity3DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkSimpleFastMutexLock
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkSimpleFastMutexLock
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSimpleFilterWatcher
        ENH: allow new class access to private data.

    Code/Common/itkSimplexMeshGeometry
        STYLE: indentation.

    Code/Common/itkSinImageAdaptor
        STYLE: indentation.

    Code/Common/itkSize
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkSmartPointer
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSmartPointerForwardReference
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSmartPointerForwardReference
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSpecialCoordinatesImage
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkSqrtImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkSymmetricEllipsoidInteriorExteriorSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkSymmetricSecondRankTensor
        BUG: Fix for bug 3152: Headers for compound pixel types now #include the appropriate NumericTraits specialization headers.

    Code/Common/itkTanImageAdaptor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkThinPlateR2LogRSplineKernelTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkThinPlateR2LogRSplineKernelTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkTimeProbesCollectorBase

    Code/Common/itkTimeProbesCollectorBase

    Code/Common/itkTorusInteriorExteriorSpatialFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkTriangleCell
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkVariableLengthVector
        BUG: Fix for bug 3152: Headers for compound pixel types now #include the appropriate NumericTraits specialization headers.

    Code/Common/itkVariableLengthVector
        ENH: Add GetSquaredNorm method to class

    Code/Common/itkVector
        BUG: Fix for bug 3152: Headers for compound pixel types now #include the appropriate NumericTraits specialization headers.
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Code/Common/itkVector
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkVectorContainer

    Code/Common/itkVectorContainer

    Code/Common/itkVectorImage
        ENH: Make ImageBase the baseclass to avoid conflicting return types for the same function signature, with ImageBase
        BUG: Incorrect superclass typedef. Pointed out by Gaetan on the developers list.

    Code/Common/itkVectorImageToImageAdaptor
        BUG: The vector image returns a pixel created on the stack, not a reference to a pixel

    Code/Common/itkVectorLinearInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/Attic/itkVectorNearestNeighborInterpolateImageFunction
        BUG: obsolete file. All code is on .h file.

    Code/Common/itkVersor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkVersor
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkVersorRigid3DTransform
        STYLE: Fixed style

    Code/Common/itkVersorRigid3DTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkVersorTransform
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).
        STYLE: Fixed style

    Code/Common/itkVersorTransform
        STYLE: Fixed style

    Code/Common/itkVertexCell
        STYLE: Fixed style

    Code/Common/itkVertexCell
        STYLE: Fixed style

    Code/Common/itkVolumeSplineKernelTransform
        STYLE: Fixed style

    Code/Common/itkVolumeSplineKernelTransform
        STYLE: Fixed style

    Code/Common/itkWeakPointer
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/Common/itkWin32Header
        STYLE: Fixed style

    Code/Common/itkWin32OutputWindow
        STYLE: Fixed style

    Code/Common/itkWin32OutputWindow
        STYLE: Fixed style

    Code/Common/itkWindowedSincInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkWindowedSincInterpolateImageFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Common/itkWindows
        STYLE: Fixed style

    Code/Common/itkXMLFileOutputWindow
        STYLE: Fixed style

    Code/Common/itkXMLFilterWatcher
        STYLE: various.

    Code/Common/itkZeroFluxNeumannBoundaryCondition
        STYLE: Fixed style

    Code/Common/itkZeroFluxNeumannBoundaryCondition
        STYLE: Fixed style

    Code/Common/Templates/itkAffineTransform+-
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformD2
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformD2
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformD3
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformD3
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformF2
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformF2
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformF3
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkAffineTransformF3
        ENH: Explicit Instantiation Support

    Code/Common/Templates/itkFixedArray+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkFixedArray+double.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkFixedArray+double.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkFixedArray+float.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkFixedArray+float.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkFixedArrayF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImage+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+double.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+double.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+float.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+float.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+int.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+int.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+long.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+long.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+short.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+short.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_char.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_char.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_int.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_int.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_long.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_long.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_short.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImage+unsigned_short.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageBase+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageBase+2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageBase+3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageBase2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageBase2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageBase3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageBase3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageRegion+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageRegion+2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageRegion+3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageRegion2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageRegion2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageRegion3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageRegion3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSource+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+double.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+double.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+float.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+float.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+int.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+int.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+long.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+long.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+short.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+short.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_char.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_char.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_int.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_int.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_long.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_long.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_short.2--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImageSource+Image+unsigned_short.3--
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUC2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUC2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUC3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUC3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageSourceUS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUC2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUC2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUC3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUC3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUI2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUI3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUL2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUL3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUS2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImageUS3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainer+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.double-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.float-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.int-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.long-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.short-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.unsigned_char-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.unsigned_int-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.unsigned_long-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkImportImageContainer+unsigned_long.unsigned_short-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_D
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_D
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_F
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_F
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_I
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_I
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_L
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_L
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_S
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_S
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UC
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UC
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UI
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UI
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UL
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_UL
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_US
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkImportImageContainerUL_US
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPoint+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkPoint+double.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkPoint+double.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkPoint+float.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkPoint+float.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkPointF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVector+-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkVector+double.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkVector+double.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkVector+float.2-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/Attic/itkVector+float.3-
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorD2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorD3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorF2
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/Common/Templates/itkVectorF3
        ENH: Added names for explicit template instantiations.  Each instantiation of a template is given a name which is typedef-ed in a Templates namespace.  These named instantiations are useful for passing arguments to other instantiations and avoiding nested comma problems with macro arguments.  Also providing a header to import each instantiation.

    Code/IO/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/IO/itkAnalyzeImageIO
        ENH: throw exception if invalid dimension is specified.

    Code/IO/itkArchetypeSeriesFileNames
        ENH: Allow filenames that include special characters

    Code/IO/itkBrains2HeaderBase
        ENH: replaced ExceptionObject witk ExceptionMacro.

    Code/IO/itkBrains2MaskImageIO
        ENH: replaced ExceptionObject witk ExceptionMacro.

    Code/IO/itkGDCMImageIO
        BUG: PrintSelf defects.
        BUG: To much cached information is stored. Need to delete entire gdcm::File struct first.
        ENH: Do not need to reread header a second time. Instead retain a copy of the parsed DICOM header and pass internal gdcm structure to the pixel reader.
        STYLE: Remove old debug...
        ENH: When writing 3D Image, the code is correct to put proper Origin and Direction
        BUG: When writting 3D images, it allowed to access the 3d component of the ITK Spacing.
        ENH: Provide an helper function around the MetaDataDictionary. Make it more user oriented.

    Code/IO/itkGDCMImageIO
        PERF: Reduced the number of times the file is read to two.
        ENH: When writing 3D Image, the code is correct to put proper Origin and Direction

    Code/IO/itkGDCMSeriesFileNames
        BUG: PrintSelf defects.

    Code/IO/itkGDCMSeriesFileNames
        PERF: Reduced the number of times the file is read to two.

    Code/IO/itkIOCommon

    Code/IO/itkIOCommon

    Code/IO/itkImageIOFactory
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/IO/itkImageSeriesWriter
        ENH: better error checking on MetaDataDictonaryArray size.

    Code/IO/itkMetaImageIO
        COMP: fixed member object reference

    Code/IO/itkNiftiImageIO
        COMP: removed header include line for non-existent header

    Code/IO/itkPNGImageIO
        BUG: reader was not shifting data when it was encoded in the image.

    Code/IO/itkStimulateImageIOFactory
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/IO/itkTIFFImageIO
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Code/IO/itkVTKImageIO

    Code/Numerics/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/itkCumulativeGaussianCostFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/itkCumulativeGaussianOptimizer
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/itkFRPROptimizer

    Code/Numerics/itkFRPROptimizer

    Code/Numerics/itkMultipleValuedNonLinearVnlOptimizer
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/itkMultipleValuedNonLinearVnlOptimizer
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/itkMultipleValuedVnlCostFunctionAdaptor
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/itkMultipleValuedVnlCostFunctionAdaptor
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/itkOnePlusOneEvolutionaryOptimizer
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/itkSPSAOptimizer
        ENH: Using the MersenneTwisterRandomVariateGenerator rather than VNL

    Code/Numerics/itkSPSAOptimizer
        ENH: Using the MersenneTwisterRandomVariateGenerator rather than VNL

    Code/Numerics/itkSingleValuedNonLinearVnlOptimizer
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/itkSingleValuedVnlCostFunctionAdaptor
        ENH: Adding support for reporting Iteration events from the VNL optimizers.

    Code/Numerics/FEM/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/Numerics/FEM/itkFEMElement2DC0LinearQuadrilateral
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMElement2DC1Beam
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMElement3DC0LinearHexahedron
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMElement3DC0LinearTetrahedron
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMGenerateMe
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMImageMetricLoad
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMLoadImplementationGenericLandmarkLoad
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMSolverCrankNicolson
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/FEM/itkFEMSolverCrankNicolson
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkBackPropagationLayer
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkBackPropagationLayer
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkBatchSupervisedTrainingFunction

    Code/Numerics/NeuralNetworks/itkBatchSupervisedTrainingFunction
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkCompletelyConnectedWeightSet
        BUG: size of connectivity matrix was reversed compared to the weight matrix

    Code/Numerics/NeuralNetworks/itkErrorFunctionBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkGaussianRadialBasisFunction

    Code/Numerics/NeuralNetworks/itkIterativeSupervisedTrainingFunction

    Code/Numerics/NeuralNetworks/itkIterativeSupervisedTrainingFunction
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkLayerBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkLayerBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkLogSigmoidTransferFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkMeanSquaredErrorFunction
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkMeanSquaredErrorFunction
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkMultilayerNeuralNetworkBase
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkMultilayerNeuralNetworkBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkMultiquadricRadialBasisFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkNeuralNetworkObject
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkOneHiddenLayerBackPropagationNeuralNetwork
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkOneHiddenLayerBackPropagationNeuralNetwork
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkRBFBackPropagationLearningFunction
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkRBFLayer
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkRBFLayer
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkRBFNetwork

    Code/Numerics/NeuralNetworks/itkRBFNetwork
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkSigmoidTransferFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkSquaredDifferenceErrorFunction
        COMP: WinNT-bcc32 typename fixes

    Code/Numerics/NeuralNetworks/itkSquaredDifferenceErrorFunction
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkSymmetricSigmoidTransferFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkTanHTransferFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkTanSigmoidTransferFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/NeuralNetworks/itkTrainingFunctionBase

    Code/Numerics/NeuralNetworks/itkTrainingFunctionBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkTwoHiddenLayerBackPropagationNeuralNetwork

    Code/Numerics/NeuralNetworks/itkTwoHiddenLayerBackPropagationNeuralNetwork
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkWeightSetBase
        ENH: network topology can be set at runtime

    Code/Numerics/NeuralNetworks/itkWeightSetBase
        ENH: network topology can be set at runtime

    Code/Numerics/Statistics/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/Numerics/Statistics/itkEuclideanDistance
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkExpectationMaximizationMixtureModelEstimator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkGaussianDensityFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkGaussianGoodnessOfFitComponent
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkGaussianMixtureModelComponent
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkGoodnessOfFitFunctionBase
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkGreyLevelCooccurrenceMatrixTextureCoefficientsCalculator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkHistogramToEntropyImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkHistogramToLogProbabilityImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkListSampleToHistogramGenerator

    Code/Numerics/Statistics/itkLogLikelihoodGoodnessOfFitFunction
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkNormalVariateGenerator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkSampleToHistogramProjectionFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Numerics/Statistics/itkScalarImageToHistogramGenerator

    Code/Numerics/Statistics/itkScalarImageToHistogramGenerator

    Code/Patented/itkActiveShapeModelCalculator
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Patented/itkActiveShapeModelGradientSearchMethod
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Patented/itkSimpleFuzzyConnectednessRGBImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Patented/itkSimpleFuzzyConnectednessScalarImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Patented/itkVectorFuzzyConnectednessImageFilter
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/Review/CMakeLists.txt
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d1ma
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d1mach.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9gmit
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9gmit.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgic
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgic.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgit
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgit.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgmc
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d9lgmc.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d_int
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/d_mod
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dbetai
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dbetai.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dcsevl
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dcsevl.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgami
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgami.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamit
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamit.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamlm
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamlm.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamma
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamma.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamr
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dgamr.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlbeta
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlbeta.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlgams
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlgams.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlngam
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlngam.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlnrel
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/dlnrel.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/initds
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/initds.f
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/itkChiSquareDistribution
        STYLE: various.
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/Review/itkChiSquareDistribution
        STYLE: various.

    Code/Review/itkGaussianDistribution
        STYLE: various.

    Code/Review/itkGaussianDistribution
        STYLE: various.

    Code/Review/itkProbabilityDistribution
        STYLE: various.

    Code/Review/Attic/itkSignedMaurerDistanceMapImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: More fixes according to messages from KWStyle.

    Code/Review/Attic/itkSignedMaurerDistanceMapImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: More fixes according to messages from KWStyle.

    Code/Review/itkTDistribution
        STYLE: various.

    Code/Review/itkTDistribution
        STYLE: various.

    Code/Review/Attic/itkThresholdMaximumConnectedComponentsImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: various KWSTYLE issues.
        BUG: must use itkGetStaticConstMacro to access ImageDimension.
        COMP: "typename" keywords missing.

    Code/Review/Attic/itkThresholdMaximumConnectedComponentsImageFilter
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        ENH: Use SetMinimumObjectSize of the RelabelComponentImageFilter instead of calculating it separately.  This changes results slightly because previously the algorithm found all objects *greater* than the minimum object size, not *greater than or equal to* as RelabelComponentImageFilter does.  Also, we now use a MinimumMaximumImageCalculator to find the range of possible thresholds to speed up the binary search and ensure that the found threshold is in this range.
        STYLE: various KWSTYLE issues.
        BUG: mid point was not computed correctly.
        COMP: "typename" keywords missing.

    Code/Review/xermsg
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Code/SpatialObject/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Code/SpatialObject/itkArrowSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/SpatialObject/itkBlobSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/SpatialObject/itkContourSpatialObject
        COMP: Warning, removing const when returning enumeration
        ENH: First checkin

    Code/SpatialObject/itkContourSpatialObject
        ENH: Added support to attach a slice to a contour and display orientation
        ENH: First checkin

    Code/SpatialObject/itkContourSpatialObjectPoint
        ENH: First checkin

    Code/SpatialObject/itkContourSpatialObjectPoint
        ENH: First checkin

    Code/SpatialObject/itkCylinderSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/SpatialObject/itkGaussianSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/SpatialObject/itkMetaContourConverter
        ENH: First checkin

    Code/SpatialObject/itkMetaContourConverter
        ENH: Added support to attach a slice to a contour and display orientation

    Code/SpatialObject/itkMetaSceneConverter
        ENH: Added support for contours

    Code/SpatialObject/itkPolygonSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Code/SpatialObject/itkTubeSpatialObject
        STYLE:  Replaced math functions with vcl_ equivalent forms (i.e. sin with vcl_sin).

    Examples/DataRepresentation/Image/CMakeLists.txt
        COMP: Boland LME linker error.

    Examples/Filtering/BinaryThresholdImageFilter
        BUG: #2929. Writer template type was incorrect.

    Examples/Filtering/CMakeLists.txt
        COMP: Avoid Borland LME1518 linker error.
        BUG: fix last checkin.
        COMP: avoid Borland linker error.
        COMP: Borland linker errors.

    Examples/Filtering/FFTDirectInverse
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/FilteringExamples2
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/FilteringExamples4
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/FilteringExamples6
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/OtsuMultipleThresholdImageFilter
        ENH: Also write out the image thresholded between the upper threshold and the max intensity

    Examples/Filtering/OtsuThresholdImageFilter
        BUG: #2929. Writer template type was incorrect.

    Examples/Filtering/ResampleImageFilter
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter2
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter3
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter4
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter5
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter7
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleImageFilter8
        COMP: force a rebuild because of dependency problems.

    Examples/Filtering/ResampleOrientedImageFilter
        COMP: force a rebuild because of dependency problems.

    Examples/IO/CMakeLists.txt

    Examples/IO/DicomImageReadPrintTags
        ENH: Provide an helper function around the MetaDataDictionary. Make it more user oriented.

    Examples/IO/DicomSeriesReadImageWrite
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Examples/IO/ImageReadDicomSeriesWrite

    Examples/IO/ImageReadWrite
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Examples/IO/TransformReadWrite
        BUG: BSpline transform was not registered into the factory by default

    Examples/Iterators/CMakeLists.txt
        COMP: Remove tests from Borland to avoid linker errors.

    Examples/Patented/FuzzyConnectednessImageFilter
        ENH: Fixing typos indicated by Alex Chekholko via email.

    Examples/Patented/HybridSegmentationFuzzyVoronoi
        ENH: Fixing typos indicated by Alex Chekholko via email.

    Examples/Registration/BSplineWarping1
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/CMakeLists.txt
        ENH: Adding a nightly test for the ModelToImageRegistration2 example.

    Examples/Registration/DeformableRegistration4
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/DeformableRegistration6
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/DeformableRegistration7

    Examples/Registration/ImageRegistration12
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration13
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration14
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration5
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration6
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration7
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ImageRegistration9
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/ModelToImageRegistration1
        ENH: The metric was not using the interpolator for evaluating the image.

    Examples/Registration/ModelToImageRegistration2
        ENH: Adding the reader and the rasterization filter.

    Examples/Registration/MultiResImageRegistration2
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamples3
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamples4
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamples6
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamples7
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamples9
        COMP: force a rebuild because of dependency problems.

    Examples/Registration/RegistrationExamplesO2
        COMP: force a rebuild because of dependency problems.

    Examples/Statistics/CMakeLists.txt
        COMP: avoid borland linker error

    Examples/Statistics/ImageHistogram1

    Examples/Statistics/ImageHistogram2

    Examples/Visualization/CannyEdgeDetectionImageFilterConnectVTKITK.py
        ENH: Remove dos end of line

    Testing/Code/CMakeLists.txt

    Testing/Code/Algorithms/CMakeLists.txt
        BUG: added TEMP.

    Testing/Code/Algorithms/itkAlgorithmsTests4
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Code/Algorithms/itkFastMarchingUpwindGradientTest
        ENH: Test the TargetReached modes of the algorithm

    Testing/Code/Algorithms/itkHistogramImageToImageMetricTest
        ENH: initialize upper and lower bound.

    Testing/Code/Algorithms/itkThresholdMaximumConnectedComponentsImageFilterTest
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Code/BasicFilters/CMakeLists.txt
        BUG: itkSignedMaurerDistanceMapImageFilterTest.cxx entered twice.

    Testing/Code/BasicFilters/itkBasicFiltersPrintTest
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Testing/Code/BasicFilters/itkBasicFiltersPrintTest2
        COMP: force a rebuild because of dependency problems.

    Testing/Code/BasicFilters/itkBasicFiltersTests4
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilterTest
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Testing/Code/BasicFilters/itkDiffusionTensor3DReconstructionImageFilterTest
        STYLE: missing copyright.

    Testing/Code/BasicFilters/itkExpImageFilterAndAdaptorTest
        COMP: trying to track down failure on vs 7. Set threads to 1.

    Testing/Code/BasicFilters/itkMorphologicalGradientImageFilterTest
        STYLE: missing copyright.

    Testing/Code/BasicFilters/itkNormalizedCorrelationImageFilterTest
        COMP: force a rebuild because of dependency problems.

    Testing/Code/BasicFilters/itkRecursiveGaussianImageFiltersOnTensorsTest
        STYLE: missing copyright.

    Testing/Code/BasicFilters/itkResampleImageTest
        COMP: force a rebuild because of dependency problems.

    Testing/Code/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Code/BasicFilters/itkVectorIndexSelectionCastImageFilterTest

    Testing/Code/Common/CMakeLists.txt
        ENH: The DifferenceImageFilter was missing unit testing.

    Testing/Code/Common/itkCommonTests2
        ENH: The DifferenceImageFilter was missing unit testing.

    Testing/Code/Common/itkDifferenceImageFilterTest
        ENH: Fixing input connections to the DifferenceImageFilter.
        ENH: The DifferenceImageFilter was missing unit testing.

    Testing/Code/Common/itkFixedArrayTest
        ENH: Added explicit instantiation support framework to itkMacro.h.  See this header for details and documentation of the support macros.  Added option ITK_EXPLICIT_INSTANTIATION to itkConfigure.h because it is used to determine whether ITK provides explicit instantiations, which does not change outside the project.  Added instantiations of some common core types.  Removed old explicit instantiation beta code.

    Testing/Code/Common/itkPeriodicBoundaryConditionTest
        ENH: added new test.

    Testing/Code/Common/itkTimeProbesTest

    Testing/Code/Common/itkZeroFluxBoundaryConditionTest
        ENH: better testing of BC.

    Testing/Code/IO/itkBMPImageIOTest
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Testing/Code/IO/itkIOTests

    Testing/Code/IO/itkNiftiImageIOTest

    Testing/Code/IO/itkRawImageIOTest5
        COMP: warning.

    Testing/Code/IO/itkReadWriteSpatialObjectTest
        ENH: Added support to attach a slice to a contour and display orientation

    Testing/Code/IO/itkTIFFImageIOTest
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Testing/Code/Numerics/itkFRPROptimizerTest

    Testing/Code/Numerics/NeuralNetworks/NNetClassifierTest1
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/NNetClassifierTest2
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/NNetClassifierTest3
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/NNetClassifierTest4
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/QPropXORTest1
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/RBFTest1
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/XORTest1
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Numerics/NeuralNetworks/XORTest2
        ENH: changed to incorporate runtime network topology setting, including use of different MeasurementVectorTypes such as itk::Array

    Testing/Code/Review/CMakeLists.txt
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        ENH: Adding a second test for the itkThresholdMaximumConnectedComponentsImageFilter.
        ENH: Adding returns FAILURE in the catch blocks of the tries.

    Testing/Code/Review/itkChiSquareDistributionTest
        STYLE: various.
        ENH: Probability distribution library allowing for Student-t and Chi-Square pdf, cdf, and inverse cdf calculations.

    Testing/Code/Review/itkGaussianDistributionTest
        STYLE: various.

    Testing/Code/Review/itkReviewHeaderTest
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: various KWSTYLE issues.

    Testing/Code/Review/itkReviewPrintTest
        STYLE: various KWSTYLE issues.
        ENH: Support files for testing the classes that are under the review process.

    Testing/Code/Review/itkReviewTests
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: Fixed style
        COMP: Fixing the connections for the test driver.

    Testing/Code/Review/Attic/itkSignedMaurerDistanceMapImageFilterTest
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: removing new line at the end of the file. Signaled by KWStyle.

    Testing/Code/Review/itkTDistributionTest
        STYLE: various.

    Testing/Code/Review/Attic/itkThresholdMaximumConnectedComponentsImageFilterTest
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.
        STYLE: various KWSTYLE issues.
        ENH: Adding returns FAILURE in the catch blocks of the tries.

    Testing/Data/Baseline/Algorithms/OtsuMultipleThresholdsImageFilterTest.png

    Testing/Data/Baseline/Algorithms/itkThresholdMaximumConnectedComponentsImageFilterTest1.png
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/Algorithms/itkThresholdMaximumConnectedComponentsImageFilterTest2.png
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest1.mhd
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest1.zraw
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest2.mhd
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest2.zraw
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest3.mhd
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkSignedMaurerDistanceMapImageFilterTest3.zraw
        ENH: Moved code, tests and baselines from Review into Algorithms and BasicFilters.

    Testing/Data/Baseline/BasicFilters/itkVectorIndexSelectionCastImageFilterTest1.mha
        ENH: Baseline for the test itkVectorIndexSelectionCastImageFilterTest.

    Testing/Data/Baseline/BasicFilters/itkVectorIndexSelectionCastImageFilterTest2.mha
        ENH: Baseline for the test itkVectorIndexSelectionCastImageFilterTest.

    Testing/Data/Baseline/BasicFilters/itkVectorIndexSelectionCastImageFilterTest3.mha
        ENH: Baseline for the test itkVectorIndexSelectionCastImageFilterTest.

    Testing/Data/Baseline/Common/itkDifferenceImageFilterTest.png
        ENH: Baseline for the DifferenceImageFilterTest.

    Testing/Data/Baseline/Filtering/OtsuMultipleThresholdOutput002.png

    Testing/Data/Input/BrainSliceBinary.png
        ENH: Images needed for testing the Maurer distance map filter.

    Testing/Data/Input/CellsFluorescence1.png
        ENH: Input test image for the threshold maximum connected components filter test.

    Testing/Data/Input/CellsFluorescence2.png
        ENH: Input image for the ThresholdMaximumConnectedComponentsImageFilterTest2.

    Testing/Data/Input/LungSliceBinary.png
        ENH: Images needed for testing the Maurer distance map filter.

    Testing/Data/Input/SquareBinary201.png
        ENH: Images needed for testing the Maurer distance map filter.

    Utilities/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.
        ENH: Allow ITK to be built against an installed version of GDCM with the ITK_USE_SYSTEM_GDCM option

    Utilities/DICOMParser/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/Dart/BuildContinuousWithCTest.bat.in
        ENH: bat script to do a continous build with ctest.

    Utilities/Dart/BuildContinuousWithCTest.sh.in
        ENH: generate script to run ctest continuous build.

    Utilities/Dart/CMakeLists.txt
        ENH: bat script to do a continous build with ctest.

    Utilities/Doxygen/doxygen.config.in
        ENH: Fixing the names of the concept in the typedef.
        ENH: expanding the concept checking macro so it appears in the Doxygen documentation.

    Utilities/KWStyle/ITK.kws.xml.in
        ENH: Configurable file with the XML description of ITK coding style.

    Utilities/KWStyle/ITKHeader
        ENH: Template of the ITK header to be used for checking by KWStyle.

    Utilities/KWStyle/ITKOverwrite.txt
        ENH: File that define list of ITK files to exempt from code style checking.

    Utilities/MetaIO/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/MetaIO/metaArrow

    Utilities/MetaIO/metaArrow

    Utilities/MetaIO/metaBlob

    Utilities/MetaIO/metaBlob

    Utilities/MetaIO/metaCommand
        ENH: Remove unused termination tag

    Utilities/MetaIO/metaCommand
        ENH: Added support for Grid Application Description file. Fixed issues with parsing.

    Utilities/MetaIO/metaContour
        ENH: Added support to attach a slice to a contour and display orientation

    Utilities/MetaIO/metaContour
        ENH: Added support to attach a slice to a contour and display orientation

    Utilities/MetaIO/metaDTITube

    Utilities/MetaIO/metaDTITube

    Utilities/MetaIO/metaEllipse

    Utilities/MetaIO/metaEllipse

    Utilities/MetaIO/metaGaussian

    Utilities/MetaIO/metaGaussian

    Utilities/MetaIO/metaGroup

    Utilities/MetaIO/metaGroup

    Utilities/MetaIO/metaITKUtils

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImageUtils

    Utilities/MetaIO/metaImageUtils

    Utilities/MetaIO/metaLandmark

    Utilities/MetaIO/metaLandmark

    Utilities/MetaIO/metaLine

    Utilities/MetaIO/metaLine

    Utilities/MetaIO/metaMe

    Utilities/MetaIO/metaMesh

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaScene
        ENH: Added support for contours

    Utilities/MetaIO/metaScene

    Utilities/MetaIO/metaSurface

    Utilities/MetaIO/metaSurface

    Utilities/MetaIO/metaTransform

    Utilities/MetaIO/metaTransform

    Utilities/MetaIO/metaTube

    Utilities/MetaIO/metaTube

    Utilities/MetaIO/metaTubeGra

    Utilities/MetaIO/metaTubeGraph

    Utilities/MetaIO/metaTypes
        BUG: Wrong typedef for unsigned long type

    Utilities/MetaIO/metaUtils
        ENH: Added support for contours

    Utilities/MetaIO/metaUtils
        ENH: Added more debugging information when pixeltype cannot be converted

    Utilities/MetaIO/metaVesselTube

    Utilities/MetaIO/metaVesselTube

    Utilities/MetaIO/tests/CMakeLists.txt
        ENH: Added metaContour test

    Utilities/MetaIO/tests/testMeta10Contour
        ENH: First checkin

    Utilities/NrrdIO/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/expat/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/gdcm/CMakeLists.txt
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Utilities/gdcm/src/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/gdcm/src/gdcmBinEntry
        ENH: Big PHAT bug in gdcm... DT is ASCII

    Utilities/gdcm/src/gdcmDictSet
        BUG: resultPath could be empty, cannot access char -1 in an array

    Utilities/gdcm/src/gdcmDocEntry
        ENH: Big PHAT bug in gdcm... DT is ASCII

    Utilities/gdcm/src/gdcmDocument
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir
        ENH: Big PHAT bug in gdcm... DT is ASCII

    Utilities/gdcm/src/gdcmDocument
        ENH: Extract CanRead from code

    Utilities/gdcm/src/gdcmFile
        ENH: Apply patch to allow ITK to be build against a system GDCM lib. At same time apply a couple of changes I had in my local dir

    Utilities/gdcm/src/gdcmFileHelper
        ENH: Big PHAT bug in gdcm... DT is ASCII
        ENH: Properly set some default value: IOP (default to 100010), and Patient Orientation which is redundant...

    Utilities/gdcm/src/gdcmSerieHelper
        BUG: Fixed unitialized memory read

    Utilities/gdcm/src/gdcmVR
        COMP: intel compiler issue with sizeof a temporary
        ENH: Big PHAT bug in gdcm... DT is ASCII

    Utilities/itkjpeg/12/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/itkjpeg/16/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/itkjpeg/8/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/kwsys/CMakeLists.txt

        ENH: remove test on cygwin since it randomly fails
        ENH: Do not build the library if we are not doing Testing
        BUG: Trying to get testDynamicLoader to work on Solaris and SunOS, where current directory is not lookup when doing dlopen
        ENH: use CMAKE_DL_LIBS and not dl directly as it does not always exist
        ENH: Still more coverage of the DynamicLoader
        ENH: Compile DynamicLoader

    Utilities/kwsys/CommandLineArguments
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64

    Utilities/kwsys/Directory
        ENH: Use const char where it should have been. At same time fix Bug#2958
        ENH: add missing cmake depend hacks
        BUG: Need to reset internal structure in case of multiple calls to Load

    Utilities/kwsys/Directory.hxx.in
        ENH: Use const char where it should have been. At same time fix Bug#2958
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code).

    Utilities/kwsys/DynamicLoader
        ENH: remove warning
        BUG: Fix problem on MacOSX, by disabling part of the test.
        BUG: Fix for MINGW32
        ENH: Also look into data segment (consistant with other implementation)
        ENH: Make sure that we find the proper symbol and not the one that start with _. STYLE: Remove an old style cast
        STYLE: Minor style
        COMP: Fix compilation on MacOSX

    Utilities/kwsys/DynamicLoader.hxx.in
        COMP: Fix problem with namespace
        ENH: Add documentation on the problem with system wide path for looking up dynamic libraries. STYLE: Fix trailing white spaces
        ENH: Adding kwsys implementation for a DynamicLoader class. Copy from itkDynamicLoader, with patch from cmDynamicLoader

    Utilities/kwsys/Glob
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64
        STYLE: Make sure to use the proper cast.

    Utilities/kwsys/Glob.hxx.in
        ENH: Add support for relative paths and cleanup

    Utilities/kwsys/ProcessUNIX
        BUG: Do not leak global table of processes.
        BUG: Reverting previous change until it can be fixed on Cygwin.
        ENH: Enabling process tree killing on Cygwin.
        ENH: Enabled process tree killing on the SGI.
        ENH: Enabled process tree killing on HP-UX.
        ENH: Added implementation of process tree killing that runs "ps" to traverse the tree.

    Utilities/kwsys/ProcessWin32
        BUG: Fixed deadlock condition when grandchildren are running after the children exit.

    Utilities/kwsys/Registry
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64
        STYLE: Minor style

    Utilities/kwsys/Registry.hxx.in
        STYLE: Minor style

    Utilities/kwsys/RegularExpression
        STYLE: Make sure to use the proper cast.

    Utilities/kwsys/SystemTools
        ENH: search for program without extensions
        ENH: put the fix back in with abort
        COMP: Fixing the the build for windows.
        BUG: IsSubDirectory should use ComparePath to do platform-independent path comparison.
        ENH: performance improvments
        ENH: Improved implementation of FilesDiffer to avoid allocating enough memory for the entire file twice.  Instead using a block-at-a-time comparison.
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64
        ENH: Use const char where it should have been. At same time fix Bug#2958
        ENH: try to clean up the search for programs
        ENH: fix find program to look for .com and .exe correctly and not return files with no extension on windows
        ENH: Add trailing whitespace

    Utilities/kwsys/SystemTools.hxx.in

        ENH: Use const char where it should have been. At same time fix Bug#2958

    Utilities/kwsys/Terminal
        ENH: Added rxvt-unicode and cygwin terminals for color support.
        BUG: Fixed bug in check for vt100 assumption.
        ENH: Adding 'Terminal' component to hold support routines for dealing with interactive terminals.  Currently only a cfprintf function is provided to print color messages.

    Utilities/kwsys/Terminal.h.in
        ENH: Adding 'Terminal' component to hold support routines for dealing with interactive terminals.  Currently only a cfprintf function is provided to print color messages.

    Utilities/kwsys/auto_ptr.hxx.in
        COMP: Skip trying to use native auto_ptr implementation and just provide a conforming one.

    Utilities/kwsys/hashtable.hxx.in
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64

    Utilities/kwsys/testCommandLineArguments
        STYLE: Make sure to use the proper cast.

    Utilities/kwsys/testDynamicLoader
        ENH: add support for win64 for visual studio 2005 ide and nmake, also fix warnings produced by building for win64
        COMP: Fix warning
        ENH: Make test usable from command line
        BUG: Do the proper path
        BUG: Fix problem with  in the path
        ENH: Make sure that we find the proper symbol and not the one that start with _. STYLE: Remove an old style cast
        BUG: Make sure to have proper dependencies
        ENH: remove test temporarily
        ENH: Improve test coverage

    Utilities/kwsys/testDynload
        ENH: Cleanup DynamicLoader so that the symbols have more consistent names, start using dynamic loader from kwsys in CMake
        BUG: Remove comment
        ENH: Add a file to generate the lib

    Utilities/kwsys/testProcess
        ENH: Added test 8 to test grandchildren running after children exit.

    Utilities/kwsys/testSystemTools
        STYLE: Minor style

    Utilities/kwsys/testSystemTools.h.in
        BUG: Do the proper path
        BUG: Trying to get testDynamicLoader to work on Solaris and SunOS, where current directory is not lookup when doing dlopen

    Utilities/kwsys/testTerminal

    Utilities/nifti/fsliolib/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/nifti/niftilib/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/nifti/znzlib/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/openjpeg/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/png/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/tiff/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/vxl/core/vnl/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/vxl/core/vnl/vnl_matrix_fixed_ref

    Utilities/vxl/core/vnl/vnl_scalar_join_iterator
        BUG: wrong function signature

    Utilities/vxl/core/vnl/vnl_vector_fixed_ref

    Utilities/vxl/core/vnl/algo/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/vxl/v3p/netlib/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/vxl/vcl/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Utilities/zlib/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Wrapping/CSwig/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Wrapping/CSwig/SwigRuntime/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.

    Wrapping/CSwig/Tcl/CMakeLists.txt
        ENH: Adding ITK version number to the soname of shared libraries on linux.  This is a patch from Steve Robbins given in bug#3249.
