﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="Constants.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   Application Constants
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrakeWPF
{
    /// <summary>
    /// Application Constants
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// The appcast 64.
        /// </summary>
        public const string Appcast64 = "https://handbrake.fr/appcast.x86_64.xml";

        /// <summary>
        /// The appcast 32.
        /// </summary>
        public const string Appcast32 = "https://handbrake.fr/appcast.i386.xml";

        /// <summary>
        /// The appcast 32.
        /// </summary>
        public const string AppcastUnstable32 = "https://handbrake.fr/appcast_unstable.i386.xml";

        /// <summary>
        /// The appcast 32.
        /// </summary>
        public const string AppcastUnstable64 = "https://handbrake.fr/appcast_unstable.x86_64.xml";

        /// <summary>
        /// The any.
        /// </summary>
        public const string Any = "(Any)";

        /// <summary>
        /// The chapters.
        /// </summary>
        public const string Chapters = "{chapters}";

        /// <summary>
        /// The title.
        /// </summary>
        public const string Title = "{title}";

        /// <summary>
        /// The quality.
        /// </summary>
        public const string Quality = "{quality}";

        /// <summary>
        /// The quality.
        /// </summary>
        public const string Date = "{date}";

        /// <summary>
        /// The quality.
        /// </summary>
        public const string Time = "{time}";

        /// <summary>
        /// The bitrate.
        /// </summary>
        public const string Bitrate = "{bitrate}";
    }
}
